<?php
/* ==================================================
  Staff Post Type Functions
  ================================================== */
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
add_action('init', 'staff_register');
function staff_register() {
       $args_c = array(
    "label" => esc_html__('Staff Categories', "imithemes"),
    "singular_label" => esc_html__('Staff Category', "imithemes"),
    'public' => true,
    'hierarchical' => true,
    'show_ui' => true,
    'show_in_nav_menus' => true,
    'rewrite' => true,
    'query_var' => true,
	'show_admin_column' => true,
);
register_taxonomy('staff-category', 'staff', $args_c);
    $labels = array(
        'name' => esc_html__('Staff', 'imithemes'),
        'singular_name' => esc_html__('Staff', 'imithemes'),
        'all_items'=> esc_html__('Staff Members', 'imithemes'),
        'add_new' => esc_html__('Add New', 'imithemes'),
        'add_new_item' => esc_html__('Add New Staff', 'imithemes'),
        'edit_item' => esc_html__('Edit Staff', 'imithemes'),
        'new_item' => esc_html__('New Staff', 'imithemes'),
        'view_item' => esc_html__('View Staff', 'imithemes'),
        'search_items' => esc_html__('Search Staff', 'imithemes'),
        'not_found' => esc_html__('No staff have been added yet', 'imithemes'),
        'not_found_in_trash' => esc_html__('Nothing found in Trash', 'imithemes'),
        'parent_item_colon' => ''
    );
    $args = array(
        'labels' => $labels,
		'capability_type' => 'page',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_nav_menus' => false,
        'rewrite' => true,
        'supports' => array('title', 'editor', 'thumbnail', 'page-attributes','excerpt', 'author'),
		'menu_icon' => 'dashicons-businessman',
        'has_archive' => true,
    );
    register_post_type('staff', $args);
}
?>