<?php
/**
 * Describe child theme functions
 *
 * @package Editorialmag
 * @subpackage Editorialmag Lite
 * 
 */

/*-------------------------------------------------------------------------------------------------------------------------------*/
if ( ! function_exists( 'editorialmag_lite_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function editorialmag_lite_setup() {
    
    $editorialmag_lite_theme_info = wp_get_theme();
    $GLOBALS['editorialmag_lite_version'] = $editorialmag_lite_theme_info->get( 'Version' );
}
endif;

add_action( 'after_setup_theme', 'editorialmag_lite_setup' );

/*-------------------------------------------------------------------------------------------------------------------------------*/
/**
 * Managed the theme default color
 */
function editorialmag_lite_customize_register( $wp_customize ) {

		global $wp_customize;

        /**
          * Theme Primary Color
        */
        $wp_customize->add_section( 'editorialmag_lite_primary_theme_color', array(
          'title'    => esc_html__('Primary Color Options', 'editorialmag-lite'),
          'priority' => 3,
        ));

            $wp_customize->add_setting('editorialmag_lite_primary_theme_color_options', array(
                'default' => '#009cd6',
                'sanitize_callback' => 'sanitize_hex_color',        
            ));

            $wp_customize->add_control('editorialmag_lite_primary_theme_color_options', array(
                'type'     => 'color',
                'label'    => esc_html__('Primary Colors', 'editorialmag-lite'),
                'section'  => 'editorialmag_lite_primary_theme_color',
                'setting'  => 'editorialmag_lite_primary_theme_color_options',
            ));


        /**
         * Web Page Layout Settings
        */
        $wp_customize->add_section( 'editorialmag_lite_layout', array(
            'title'           => esc_html__('Web Page Layout Settings', 'editorialmag-lite'),
            'priority'        => 4,
        ));

            $wp_customize->add_setting('editorialmag_lite_layout_options', array(
                'default' => 'boxed',
                'sanitize_callback' => 'editorialmag_lite_layout',
            ));

            $wp_customize->add_control('editorialmag_lite_layout_options', array(
                'type' => 'radio',
                'label' => esc_html__('Choose Page Web Layout', 'editorialmag-lite'),
                'section' => 'editorialmag_lite_layout',
                'settings' => 'editorialmag_lite_layout_options',
                'choices' => array(
                    'boxed'     => esc_html__('Boxed Layout', 'editorialmag-lite'),
                    'fullwidth' => esc_html__('Fullwidth Layout', 'editorialmag-lite')
                )
            ));


        /**
         * Web page Layout Sanitization
        */
        function editorialmag_lite_layout($input) {
            $valid_keys = array( 
                'boxed'     => esc_html__('Boxed Layout', 'editorialmag-lite'),
                'fullwidth' => esc_html__('Fullwidth Layout', 'editorialmag-lite')
            );
            if ( array_key_exists( $input, $valid_keys ) ) {
                return $input;
            } else {
                return '';
            }
        }

	}

add_action( 'customize_register', 'editorialmag_lite_customize_register', 20 );


/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function editorialmag_lite_body_classes( $classes ) {
    
    /**
     * Web Page Layout Settings
    */
    
    if( get_theme_mod( 'editorialmag_lite_layout_options', 'boxed' ) == 'boxed') {
        $classes[] = 'boxed';
    }

    return $classes;
}
add_filter( 'body_class', 'editorialmag_lite_body_classes' );

/**
 * Enqueue child theme styles and scripts
*/

function editorialmag_lite_scripts() {
    
    global $editorialmag_lite_version;
    
    wp_dequeue_style( 'editorialmag-style' );

    wp_dequeue_style( 'editorialmag-responsive' );
    
	wp_enqueue_style( 'editorialmag-parent-style', get_template_directory_uri() . '/style.css', array(), esc_attr( $editorialmag_lite_version ) );

    wp_enqueue_style( 'editorialmag-parent-responsive', get_template_directory_uri() . '/assets/css/responsive.css', array(), esc_attr( $editorialmag_lite_version ) );

    wp_enqueue_style( 'editorialmag-lite-style', get_stylesheet_uri(), array(), esc_attr( $editorialmag_lite_version ) );
    
    
    $editorialmag_lite_primary_theme_color = get_theme_mod( 'editorialmag_lite_primary_theme_color_options', '#009cd6' );
    
    $output_css = '';
    

    $output_css .= ".sticky-menu, .header-bgimg .nav-wrap, .main-navigation .sub-menu, .main-navigation .children, .main-navigation ul li a::before, .search-form input[type='submit']:hover, input[type='submit']:hover, #emag-tags a:hover, .widget_tag_cloud .tagcloud a:hover, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current, .woocommerce-account .woocommerce-MyAccount-navigation ul li a, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .emag-timeline .emag-post-item:hover:after, .calendar_wrap caption, .scroll-to-top:hover, .page-numbers.current, .headertwo .nav-wrap .sparkle-wrapper, .news-ticker-title, .news-ticker .lSAction>div, .page-numbers:hover{ background-color: ". esc_attr( $editorialmag_lite_primary_theme_color ) ."}\n";

    $output_css .= "a:hover, .header-cart .icofont:hover, .caption-date > a, .news-comment.readmore:hover, .widget-contact-list .fa, .copyright-footer a, .news-comment.readmore:hover a, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce nav.woocommerce-pagination ul li .page-numbers, .woocommerce-account .woocommerce-MyAccount-navigation ul li.is-active a, .woocommerce-account .woocommerce-MyAccount-navigation ul li:hover a, .woocommerce-MyAccount-content a:hover, .woocommerce-MyAccount-content a:hover, .woocommerce-info:before, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce-message:before, .banner-caption .caption-date, .no-slide-ban-content .caption-date .posted-on a, .no-slide-ban-content .caption-date .byline a, .widget-contact-list .fa, .news-ticker .lSAction>div:hover, .widget-contact-list .fas, .error-404 .page-content a, .sparkle-author-details .author-designation{ color: ". esc_attr( $editorialmag_lite_primary_theme_color ) ."}\n";
    
    $output_css .= ".search-form input[type='submit']:hover, .bottom-footer .widget-title, .bottom-footer .section-title, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce nav.woocommerce-pagination ul li, .woocommerce-account .woocommerce-MyAccount-navigation ul li a, .woocommerce-account .woocommerce-MyAccount-navigation ul li.is-active a, .woocommerce-account .woocommerce-MyAccount-navigation ul li:hover a, .woocommerce-account .woocommerce-MyAccount-content, .woocommerce-info, .cart_totals h2, .cross-sells>h2, .woocommerce-billing-fields h3, .woocommerce-additional-fields h3, .related>h2, .upsells>h2, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .woocommerce-message, .emag-tabs-wdt .ui-state-active, .widget.emag_magazine_tabbed ul li.ui-state-active:last-child, .widget.emag_magazine_sidebar_category_tabs_posts ul li.ui-state-active:last-child, .page-numbers.current, .news-ticker .lSAction>div, .page-numbers:hover{ border-color: ". esc_attr( $editorialmag_lite_primary_theme_color ) ."}\n";

    $output_css .= ".news-ticker-title::after{ border-top: 2em solid ". esc_attr( $editorialmag_lite_primary_theme_color ) ."}\n";
        
    wp_add_inline_style( 'editorialmag-lite-style', $output_css );

}

add_action( 'wp_enqueue_scripts', 'editorialmag_lite_scripts', 20 );