<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Editorialmag
 */

$image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'editorialmag-large', true);

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="page-header">
		<?php the_title( '<h1 class="page-title"><span>', '</span></h1>' ); ?>
	</header><!-- .page-header -->

	<div class="entry-content">
		<?php if( has_post_thumbnail() ){ ?>
		    <figure class="nosidebar-image">
		        <img src="<?php echo esc_url( $image[0] ); ?>" alt="<?php the_title(); ?>">
		    </figure>
		<?php } ?>

		<?php
			the_content();

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'editorialmag' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<?php if ( get_edit_post_link() ) : ?>
		<footer class="entry-footer">
			<?php
				edit_post_link(
					sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__( 'Edit <span class="screen-reader-text">%s</span>', 'editorialmag' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						get_the_title()
					),
					'<span class="edit-link">',
					'</span>'
				);
			?>
		</footer><!-- .entry-footer -->
	<?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->
