<?php
/**
 * OCDI support.
 *
 * @package Editorialmag
 */

// Disable PT branding.
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

/**
 * OCDI after import.
 *
 * @since 1.0.0
 */
function editorialmag_ocdi_after_import() {

    // Assign navigation menu locations.
    $menu_location_details = array(
        'menu-1'  => 'Main Menu',
        'menu-2'  => 'Top Menu',
    );

    if ( ! empty( $menu_location_details ) ) {
        $navigation_settings = array();
        $current_navigation_menus = wp_get_nav_menus();
        if ( ! empty( $current_navigation_menus ) && ! is_wp_error( $current_navigation_menus ) ) {
            foreach ( $current_navigation_menus as $menu ) {
                foreach ( $menu_location_details as $location => $menu_slug ) {
                    if ( $menu->slug === $menu_slug ) {
                        $navigation_settings[ $location ] = $menu->term_id;
                    }
                }
            }
        }

        set_theme_mod( 'nav_menu_locations', $navigation_settings );
    }
}
add_action( 'pt-ocdi/after_import', 'editorialmag_ocdi_after_import' );


/**
 * Demo export/import
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Editorialmag
 */
if (!function_exists('editorialmag_ocdi_files')) :
    /**
     * OCDI files.
     *
     * @since 1.0.0
     *
     * @return array Files.
     */
    function editorialmag_ocdi_files() {

        return apply_filters( 'editorialmag_demo_import_files', array(
            
            array(
                'import_file_name'             => esc_html__( 'Editorialmag Demo', 'editorialmag' ),
                'local_import_file'            => trailingslashit( get_template_directory() ) . 'welcome/demo-data/editorialmag.xml',
                'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'welcome/demo-data/editorialmag.wie',
                'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'welcome/demo-data/editorialmag.dat',
                'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'welcome/css/editorialmag.jpg',
                'preview_url'                  => 'http://demo.sparklewpthemes.com/editorialmag/',
            ),

            array(
                'import_file_name'             => esc_html__( 'Magazine', 'editorialmag' ),
                'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'welcome/css/editorialmagpro.jpg',
                'preview_url'                  => 'http://demo.sparklewpthemes.com/editorialmagpro/',
            ),

            array(
                'import_file_name'             => esc_html__( 'Glamour', 'editorialmag' ),
                'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'welcome/css/glamour.jpg',
                'preview_url'                  => 'http://demo.sparklewpthemes.com/editorialmagpro/glamour/',
            ),

            array(
                'import_file_name'             => esc_html__( 'Sport', 'editorialmag' ),
                'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'welcome/css/sport.jpg',
                'preview_url'                  => 'http://demo.sparklewpthemes.com/editorialmagpro/sport/',
            ),

            array(
                'import_file_name'             => esc_html__( 'Technology', 'editorialmag' ),
                'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'welcome/css/tech.jpg',
                'preview_url'                  => 'http://demo.sparklewpthemes.com/editorialmagpro/tech/',
            ),

            array(
                'import_file_name'             => esc_html__( 'News', 'editorialmag' ),
                'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'welcome/css/news.jpg',
                'preview_url'                  => 'http://demo.sparklewpthemes.com/editorialmagpro/news/',
            )

        ));
    }
endif;
add_filter( 'pt-ocdi/import_files', 'editorialmag_ocdi_files');