<div class="getting-started-top-wrap clearfix">
	<div class="theme-steps-list">
		<div class="theme-steps">
			<h3><?php echo esc_html__('Step 1 - Create a new page with "Home Page" Template"', 'editorialmag'); ?></h3>
			<ol>
				<li><?php echo esc_html__('Create a new page (any title like Home )', 'editorialmag'); ?></li>
				<li><?php echo esc_html__('In right column, select "Editorialmag - FrontPage" for the option Page Attributes &gt; Template"', 'editorialmag'); ?></li>
				<li><?php echo esc_html__('Click on Publish', 'editorialmag'); ?></li>
			</ol>
		</div>

		<div class="theme-steps">
			<h3><?php echo esc_html__('Step 2 - Set "Your homepage displays" to "A Static Page"', 'editorialmag'); ?></h3>
			<ol>
				<li><?php echo esc_html__('Go to Appearance > Customize > Homepage Settings > Static Front Page', 'editorialmag'); ?></li>
				<li><?php echo esc_html__('Set "Your homepage displays" to "A Static Page"', 'editorialmag'); ?></li>
				<li><?php echo esc_html__('In "Home", select the page that you created in the step 1', 'editorialmag'); ?></li>
				<li><?php echo esc_html__('Click on Publish', 'editorialmag'); ?></li>
			</ol>

			<img src="<?php echo esc_url(get_template_directory_uri() .'/welcome/css/homepageset.png'); ?>" alt="<?php echo esc_html__('Enable Front Page', 'editorialmag'); ?>">
		</div>

	</div>

	<div class="theme-image">
		<h3><?php echo esc_html__('Import Sample Demo', 'editorialmag'); ?></h3>
		<img src="<?php echo esc_url(get_template_directory_uri(). '/screenshot.png'); ?>" alt="<?php echo esc_html__('Buzzstore Demo', 'editorialmag'); ?>">

		<div class="theme-import-demo">
			<?php 
			$editorialmag_demo_importer_slug = 'one-click-demo-import';
			$editorialmag_demo_importer_filename ='one-click-demo-import';
			$editorialmag_import_url = '#';

			if ( $this->editorialmag_check_installed_plugin( $editorialmag_demo_importer_slug, $editorialmag_demo_importer_filename ) && !$this->editorialmag_check_plugin_active_state( $editorialmag_demo_importer_slug, $editorialmag_demo_importer_filename ) ) :
				$editorialmag_import_class = 'button button-primary editorialmag-activate-plugin';
				$editorialmag_import_button_text = esc_html__('Activate Importer Plugin', 'editorialmag');
			elseif( $this->editorialmag_check_installed_plugin( $editorialmag_demo_importer_slug, $editorialmag_demo_importer_filename ) ) :
				$editorialmag_import_class = 'button button-primary';
				$editorialmag_import_button_text = esc_html__('Go to Importer Page >>', 'editorialmag');
				$editorialmag_import_url = admin_url('themes.php?page=pt-one-click-demo-import');
			else :
				$editorialmag_import_class = 'button button-primary editorialmag-install-plugin';
				$editorialmag_import_button_text = esc_html__('Install Importer Plugin', 'editorialmag');
			endif;
			?>

			<p><?php echo sprintf(esc_html__('You can import the demo data with just one click, We recommended to import the demo on a fresh WordPress install with install all theme recommended plugins Or you can reset the website using %s plugin.', 'editorialmag'), '<a target="_blank" href="https://wordpress.org/plugins/wordpress-reset/">WordPress Reset</a>'); ?></p>

			<p><?php echo sprintf(esc_html__('We recommend you backup your website content before attempting to import the demo so you can recover your website if something goes wrong. You can use %s plugin for it.', 'editorialmag'), '<a target="_blank" href="https://wordpress.org/plugins/wordpress-reset/">All in one migration</a>'); ?></p>

			<p><?php echo esc_html__('Click on the button below to install and activate demo importer plugin.', 'editorialmag'); ?></p>
			<a data-slug="<?php echo esc_attr($editorialmag_demo_importer_slug); ?>" data-filename="<?php echo esc_attr($editorialmag_demo_importer_filename); ?>" class="<?php echo esc_attr($editorialmag_import_class); ?>" href="<?php echo esc_url( $editorialmag_import_url ); ?>"><?php echo esc_html($editorialmag_import_button_text); ?></a>
		</div>
	</div>
</div>

<div class="getting-started-bottom-wrap">
	<h3><?php echo esc_html__('Check our premium demos. You might be interested in purchasing premium version.', 'editorialmag'); ?></h3>
	<p><?php echo esc_html__('Check out the all demo sites that you can create with the premium version of the Editorialmag Pro theme, These all demos you can easily imported with just one click in the premium version theme.', 'editorialmag'); ?></p>

	<div class="recomended-plugin-wrap clearfix">

		<div class="recom-plugin-wrap">
			<div class="plugin-img-wrap">
				<img src="<?php echo esc_url(get_template_directory_uri() .'/welcome/css/editorialmagpro.jpg'); ?>" alt="<?php echo esc_html__('Editorialmag Pro', 'editorialmag'); ?>">
			</div>

			<div class="plugin-title-install clearfix">
				<span class="title"><?php esc_html_e('Magazine','editorialmag'); ?></span>
				<span class="plugin-btn-wrapper">
					<a target="_blank" href="http://demo.sparklewpthemes.com/editorialmagpro/" class="button button-primary"><?php echo esc_html__('Preview', 'editorialmag'); ?></a>
				</span>
			</div>
		</div>

		<div class="recom-plugin-wrap">
			<div class="plugin-img-wrap">
				<img src="<?php echo esc_url(get_template_directory_uri() .'/welcome/css/glamour.jpg'); ?>" alt="<?php echo esc_html__('Editorialmag Pro Glamour Demo', 'editorialmag'); ?>">
			</div>

			<div class="plugin-title-install clearfix">
				<span class="title"><?php esc_html_e('Glamour','editorialmag'); ?></span>
				<span class="plugin-btn-wrapper">
					<a target="_blank" href="http://demo.sparklewpthemes.com/editorialmagpro/glamour/" class="button button-primary"><?php echo esc_html__('Preview', 'editorialmag'); ?></a>
				</span>
			</div>
		</div>

		<div class="recom-plugin-wrap">
			<div class="plugin-img-wrap">
				<img src="<?php echo esc_url(get_template_directory_uri() .'/welcome/css/sport.jpg'); ?>" alt="<?php echo esc_html__('Editorialmag Pro Sport Demo', 'editorialmag'); ?>">
			</div>

			<div class="plugin-title-install clearfix">
				<span class="title"><?php esc_html_e('Sport','editorialmag'); ?></span>
				<span class="plugin-btn-wrapper">
					<a target="_blank" href="http://demo.sparklewpthemes.com/editorialmagpro/sport/" class="button button-primary"><?php echo esc_html__('Preview', 'editorialmag'); ?></a>
				</span>
			</div>
		</div>

		<div class="recom-plugin-wrap">
			<div class="plugin-img-wrap">
				<img src="<?php echo esc_url(get_template_directory_uri() .'/welcome/css/tech.jpg'); ?>" alt="<?php echo esc_html__('Editorialmag Pro Technology Demo', 'editorialmag'); ?>">
			</div>

			<div class="plugin-title-install clearfix">
				<span class="title"><?php esc_html_e('Technology','editorialmag'); ?></span>
				<span class="plugin-btn-wrapper">
					<a target="_blank" href="http://demo.sparklewpthemes.com/editorialmagpro/tech/" class="button button-primary"><?php echo esc_html__('Preview', 'editorialmag'); ?></a>
				</span>
			</div>
		</div>


		<div class="recom-plugin-wrap">
			<div class="plugin-img-wrap">
				<img src="<?php echo esc_url(get_template_directory_uri() .'/welcome/css/news.jpg'); ?>" alt="<?php echo esc_html__('Editorialmag Pro News Demo', 'editorialmag'); ?>">
			</div>

			<div class="plugin-title-install clearfix">
				<span class="title"><?php esc_html_e('News','editorialmag'); ?></span>
				<span class="plugin-btn-wrapper">
					<a target="_blank" href="http://demo.sparklewpthemes.com/editorialmagpro/news/" class="button button-primary"><?php echo esc_html__('Preview', 'editorialmag'); ?></a>
				</span>
			</div>
		</div>

	</div>
</div>

<div class="upgrade-box">
	<div class="upgrade-box-text">
		<h3><?php echo esc_html__('Upgrade To Premium Version (Editorialmag Pro)', 'editorialmag'); ?></h3>
		<p><?php echo esc_html__('Editorialmag Pro theme you can create a beautiful website. if you want to unlock more possibilities then upgrade to premium version theme to create different various design layout magazines, blog websites pea as you want.', 'editorialmag'); ?></p>
		<p><?php echo esc_html__('Try the Premium version and check if it fits to your need or not.', 'editorialmag'); ?></p>
	</div>

	<a class="upgrade-button" href="https://sparklewpthemes.com/wordpress-themes/editorialmagpro/" target="_blank"><?php esc_html_e('Upgrade Now', 'editorialmag'); ?></a>
</div>