<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

$free_church_blog_style = explode('_', free_church_get_theme_option('blog_style'));
$free_church_columns = empty($free_church_blog_style[1]) ? 2 : max(2, $free_church_blog_style[1]);
$free_church_expanded = !free_church_sidebar_present() && free_church_is_on(free_church_get_theme_option('expand_content'));
$free_church_post_format = get_post_format();
$free_church_post_format = empty($free_church_post_format) ? 'standard' : str_replace('post-format-', '', $free_church_post_format);
$free_church_animation = free_church_get_theme_option('blog_animation');

?><div class="<?php free_church_show_layout($free_church_blog_style[0] == 'classic' ? 'column' : 'masonry_item masonry_item'); ?>-1_<?php echo esc_attr($free_church_columns); ?>"><article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_format_'.esc_attr($free_church_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($free_church_columns)
					. ' post_layout_'.esc_attr($free_church_blog_style[0]) 
					. ' post_layout_'.esc_attr($free_church_blog_style[0]).'_'.esc_attr($free_church_columns)
					); ?>
	<?php echo (!free_church_is_off($free_church_animation) ? ' data-animation="'.esc_attr(free_church_get_animation_classes($free_church_animation)).'"' : ''); ?>
	>

	<?php

	// Featured image
	free_church_show_post_featured( array( 'thumb_size' => free_church_get_thumb_size($free_church_blog_style[0] == 'classic'
													? (strpos(free_church_get_theme_option('body_style'), 'full')!==false 
															? ( $free_church_columns > 2 ? 'big' : 'huge' )
															: (	$free_church_columns > 2
																? ($free_church_expanded ? 'med' : 'small')
																: ($free_church_expanded ? 'big' : 'med')
																)
														)
													: (strpos(free_church_get_theme_option('body_style'), 'full')!==false 
															? ( $free_church_columns > 2 ? 'masonry-big' : 'full' )
															: (	$free_church_columns <= 2 && $free_church_expanded ? 'masonry-big' : 'masonry')
														)
								) ) );

	if ( !in_array($free_church_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('free_church_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('free_church_action_before_post_meta'); 

			// Post meta
			free_church_show_post_meta(array(
				'categories' => false,
				'date' => true,
				'edit' => $free_church_columns < 3,
				'seo' => false,
				'share' => false,
				'counters' => 'comments,likes',
				)
			);
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$free_church_show_learn_more = false;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($free_church_post_format, array('link', 'aside', 'status', 'quote'))) {
				the_content();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($free_church_post_format, array('link', 'aside', 'status', 'quote'))) {
			free_church_show_post_meta(array(
				'share' => false,
				'counters' => 'comments'
				)
			);
		}
		// More button
		if ( $free_church_show_learn_more ) {
			?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'free-church'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>