<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

$free_church_blog_style = explode('_', free_church_get_theme_option('blog_style'));
$free_church_columns = empty($free_church_blog_style[1]) ? 2 : max(2, $free_church_blog_style[1]);
$free_church_post_format = get_post_format();
$free_church_post_format = empty($free_church_post_format) ? 'standard' : str_replace('post-format-', '', $free_church_post_format);
$free_church_animation = free_church_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($free_church_columns).' post_format_'.esc_attr($free_church_post_format) ); ?>
	<?php echo (!free_church_is_off($free_church_animation) ? ' data-animation="'.esc_attr(free_church_get_animation_classes($free_church_animation)).'"' : ''); ?>
	>

	<?php
	$free_church_image_hover = free_church_get_theme_option('image_hover');
	// Featured image
	free_church_show_post_featured(array(
		'thumb_size' => free_church_get_thumb_size(strpos(free_church_get_theme_option('body_style'), 'full')!==false || $free_church_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $free_church_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $free_church_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>