<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

free_church_storage_set('blog_archive', true);

// Load scripts for 'Masonry' layout
if (substr(free_church_get_theme_option('blog_style'), 0, 7) == 'masonry') {
	wp_enqueue_script( 'classie', free_church_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
	wp_enqueue_script( 'imagesloaded' );
	wp_enqueue_script( 'masonry');
	wp_enqueue_script( 'free_church-gallery-script', free_church_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );
}

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$free_church_classes = 'posts_container '
						. (substr(free_church_get_theme_option('blog_style'), 0, 7) == 'classic' ? 'columns_wrap' : 'masonry_wrap');
	$free_church_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$free_church_sticky_out = is_array($free_church_stickies) && count($free_church_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($free_church_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$free_church_sticky_out) {
		if (free_church_get_theme_option('first_post_large') && !is_paged() && !in_array(free_church_get_theme_option('body_style'), array('fullwide', 'fullscreen'))) {
			the_post();
			get_template_part( 'content', 'excerpt' );
		}
		
		?><div class="<?php echo esc_attr($free_church_classes); ?>"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($free_church_sticky_out && !is_sticky()) {
			$free_church_sticky_out = false;
			?></div><div class="<?php echo esc_attr($free_church_classes); ?>"><?php
		}
		get_template_part( 'content', $free_church_sticky_out && is_sticky() ? 'sticky' : 'classic' );
	}
	
	?></div><?php

	free_church_show_pagination();

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>