<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('free_church_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'free_church_revslider_theme_setup9', 9 );
	function free_church_revslider_theme_setup9() {
		if (is_admin()) {
			add_filter( 'free_church_filter_tgmpa_required_plugins',	'free_church_revslider_tgmpa_required_plugins' );
		}
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'free_church_exists_revslider' ) ) {
	function free_church_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'free_church_revslider_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('free_church_filter_tgmpa_required_plugins',	'free_church_revslider_tgmpa_required_plugins');
	function free_church_revslider_tgmpa_required_plugins($list=array()) {
		if (in_array('revslider', free_church_storage_get('required_plugins'))) {
			$path = free_church_get_file_dir('plugins/revslider/revslider.zip');
			$list[] = array(
					'name' 		=> esc_html__('Revolution Slider', 'free-church'),
					'slug' 		=> 'revslider',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
					'required' 	=> false
			);
		}
		return $list;
	}
}
?>