<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

$free_church_sidebar_position = free_church_get_theme_option('sidebar_position');
if (free_church_sidebar_present()) {
	ob_start();
	$free_church_sidebar_name = free_church_get_theme_option('sidebar_widgets');
	free_church_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($free_church_sidebar_name) ) {
		dynamic_sidebar($free_church_sidebar_name);
	}
	$free_church_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($free_church_out)) {
		?>
		<div class="sidebar <?php echo esc_attr($free_church_sidebar_position); ?> widget_area<?php if (!free_church_is_inherit(free_church_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(free_church_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'free_church_action_before_sidebar' );
				free_church_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $free_church_out));
				do_action( 'free_church_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>