<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0.10
 */

// Copyright area
$free_church_footer_scheme =  free_church_is_inherit(free_church_get_theme_option('footer_scheme')) ? free_church_get_theme_option('color_scheme') : free_church_get_theme_option('footer_scheme');
$free_church_copyright_scheme = free_church_is_inherit(free_church_get_theme_option('copyright_scheme')) ? $free_church_footer_scheme : free_church_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($free_church_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php
				// Replace {{...}} and [[...]] on the <i>...</i> and <b>...</b>
				$free_church_copyright = free_church_prepare_macros(free_church_get_theme_option('copyright'));
                $free_church_copyright = str_replace(array('{{Y}}', '{Y}'), date('Y'), $free_church_copyright);
				if (!empty($free_church_copyright)) {
					// Replace {date_format} on the current date in the specified format
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $free_church_copyright, $free_church_matches)) {
						$free_church_copyright = str_replace($free_church_matches[1], date(str_replace(array('{', '}'), '', $free_church_matches[1])), $free_church_copyright);
					}
					// Display copyright
					echo wp_kses_data(nl2br($free_church_copyright));
				}
			?></div>
		</div>
	</div>
</div>
