<?php
/**
 * The template to display the featured image in the single post
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

if ( get_query_var('free_church_header_image')=='' && is_singular() && has_post_thumbnail() && in_array(get_post_type(), array('post', 'page')) )  {
	$free_church_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
	if (!empty($free_church_src[0])) {
		free_church_sc_layouts_showed('featured', true);
		?><div class="sc_layouts_featured with_image <?php echo esc_attr(free_church_add_inline_css_class('background-image:url('.esc_url($free_church_src[0]).');')); ?>"></div><?php
	}
}
?>