<?php
class Native_Church_Core_Features
{
    public function __construct()
    {
        if (current_user_can('edit_posts') && current_user_can('edit_pages')) {
            add_filter('mce_external_plugins', array($this, 'imic_add_tinymce_plugin'));
            add_filter('mce_buttons', array($this, 'imic_register_shortcode_button'));
        }
    }

    public function imic_register_shortcode_button($button)
    {
        array_push($button, 'separator', 'imicframework_shortcodes');
        return $button;
    }

    public function imic_add_tinymce_plugin($plugins)
    {
        $plugins['imicframework_shortcodes'] = NATIVECHURCH_CORE__PLUGIN_URL . 'shortcodes/imic-shortcodes/tinymce.editor.plugin.js';
        return $plugins;
    }
}
function nativechurch_core_initialize_features()
{
    new Native_Church_Core_Features;
}
add_action('init', 'nativechurch_core_initialize_features');

if (class_exists('Woocommerce')) {
    // Remove Woocommerce redirect setup page
    if (!function_exists('remove_class_filters')) {
        function remove_class_filters($tag, $class, $method)
        {
            $filters = $GLOBALS['wp_filter'][$tag];
            if (empty($filters)) {
                return;
            }
            foreach ($filters as $priority => $filter) {
                foreach ($filter as $identifier => $function) {
                    if (is_array($function) and is_a($function['function'][0], $class) and $method === $function['function'][1]) {
                        remove_filter(
                            $tag,
                            array($function['function'][0], $method),
                            $priority
                        );
                    }
                }
            }
        }
    }

    add_action('admin_init', 'disable_shop_redirect', 0);
    function disable_shop_redirect()
    {
        remove_class_filters(
            'admin_init',
            'WC_Admin',
            'admin_redirects'
        );
    }
}

add_action('init', 'imic_save_event');
if (!function_exists('imic_save_event')) {
    function imic_save_event()
    {
        //date_default_timezone_set('Antarctica/Troll');
        $query_string = $_SERVER['QUERY_STRING'];
        parse_str($query_string, $parsed_query);
        if (isset($parsed_query['action']) && isset($parsed_query['id']) && isset($parsed_query['key']) && $parsed_query['key'] == 'imic_save_event') {
            $id = $parsed_query['id'];
            $edate = $parsed_query['edate'];
            $action = $parsed_query['action'];
            $custom_post = get_post($id);
            $title = $custom_post->post_title;
            $contentraw = $custom_post->post_content;
            $content = wp_trim_words($contentraw, 50, '...');
            $imic_event_address = get_post_meta($id, 'imic_event_address', true);
            $eventStartTime = get_post_meta($id, 'imic_event_start_tm', true);
            $eventStartDate = get_post_meta($id, 'imic_event_start_dt', true);
            $eventEndTime = get_post_meta($id, 'imic_event_end_tm', true);
            $eventEndDate = get_post_meta($id, 'imic_event_end_dt', true);
            $random_name = substr(rand() . rand() . rand() . rand(), 0, 20);
            $user_tz = get_option('timezone_string');

            $schedule_date_start = $edate . ' ' . date_i18n('H:i', strtotime($eventStartTime));
            //$schedule_date_start->setTimeZone(new DateTimeZone('UTC'));
            $triggerOn_start = $schedule_date_start;
            $schedule_date_end = $edate . ' ' . date_i18n('H:i', strtotime($eventEndTime));
            //$schedule_date_end->setTimeZone(new DateTimeZone('UTC'));
            $triggerOn_end = $schedule_date_end;
            switch ($action) {
                case 'gcalendar':
                    $google_save_url = 'https://www.google.com/calendar/render?action=TEMPLATE';
                    $google_save_url .= '&dates=' . date_i18n("Ymd\THis", strtotime("$triggerOn_start"));
                    $google_save_url .= '/' . date_i18n("Ymd\THis", strtotime("$triggerOn_end"));
                    $google_save_url .= '&location=' . urlencode($imic_event_address);
                    $google_save_url .= '&text=' . urlencode($title);
                    //$google_save_url .= '&ctz=Antarctica/Troll';
                    $google_save_url .= '&details=' . urlencode($content);
                    wp_redirect($google_save_url);
                    exit;
                    break;
                case 'icalendar':
                    ob_start();
                    header("Content-Type: text/calendar; charset=utf-8");
                    header("Content-Disposition: inline; filename=addto_calendar_" . $random_name . ".ics");
                    $title = addslashes($title);
                    $title = str_replace(array(",", ":", ";"), array("\,", "\:", "\;"), $title);
                    $content = addslashes($content);
                    $content = str_replace(array(",", ":", ";"), array("\,", "\:", "\;"), $content);
                    $content = preg_replace('/\s+/', ' ', $content);
                    $imic_event_address = addslashes($imic_event_address);
                    $imic_event_address = str_replace(array(",", ":", ";"), array("\,", "\:", "\;"), $imic_event_address);
                    echo "BEGIN:VCALENDAR\n";
                    echo "VERSION:2.0\n";
                    echo "PRODID:Imitheme.com \n";
                    echo "BEGIN:VEVENT\n";
                    echo "UID:" . date_i18n('Ymd') . 'T' . date_i18n('His') . rand() . "\n";
                    echo "DTSTAMP;TZID=UTC:" . date_i18n('Ymd') . 'T' . date_i18n('His') . "\n";
                    echo "DTSTART;TZID=UTC:" . date_i18n("Ymd\THis", strtotime("$triggerOn_start")) . "\n";
                    echo "DTEND;TZID=UTC:" . date_i18n("Ymd\THis", strtotime("$triggerOn_end")) . "\n";
                    echo "SUMMARY:$title\n";
                    echo "LOCATION:$imic_event_address\n";
                    echo "DESCRIPTION:$content\n";
                    echo "END:VEVENT\n";
                    echo "END:VCALENDAR\n";
                    ob_flush();
                    exit;
                    break;
                case 'outlook':
                    ob_start();
                    header("Content-Type: text/calendar; charset=utf-8");
                    header("Content-Disposition: inline; filename=addto_calendar_" . $random_name . ".ics");
                    echo "BEGIN:VCALENDAR\n";
                    echo "VERSION:2.0\n";
                    echo "PRODID:Imitheme.com\n";
                    echo "BEGIN:VEVENT\n";
                    echo "UID:" . date_i18n('Ymd') . 'T' . date_i18n('His') . "-" . rand() . "\n";
                    echo "DTSTAMP:" . date_i18n('Ymd') . 'T' . date_i18n('His') . "\n";
                    echo "DTSTART:" . date_i18n("Ymd\THis", strtotime("$triggerOn_start")) . "\n";
                    echo "DTEND:" . date_i18n("Ymd\THis", strtotime("$triggerOn_end")) . "\n";
                    echo "SUMMARY:$title\n";
                    echo "LOCATION:$imic_event_address\n";
                    echo "DESCRIPTION: $content\n";
                    echo "END:VEVENT\n";
                    echo "END:VCALENDAR\n";
                    ob_flush();
                    exit;
                    break;
                case 'outlooklive':
                    $outlooklive_url = 'https://bay03.calendar.live.com/calendar/calendar.aspx?rru=addevent';
                    $outlooklive_url .= '&summary=' . urlencode($title);
                    $outlooklive_url .= '&location=' . urlencode($imic_event_address);
                    $outlooklive_url .= '&description=' . urlencode($content);
                    $outlooklive_url .= '&dtstart=' . date_i18n("Ymd\THis", strtotime("$eventStartDate $eventStartTime"));
                    $outlooklive_url .= '&dtend=' . date_i18n("Ymd\THis", strtotime("$eventEndDate $eventEndTime"));
                    wp_redirect($outlooklive_url);
                    exit;
                    break;
                case 'yahoo':
                    $yahoo_url = 'https://calendar.yahoo.com/?view=d&v=60&type=20';
                    $yahoo_url .= '&title=' . urlencode($title);
                    $yahoo_url .= '&in_loc=' . urlencode($imic_event_address);
                    $yahoo_url .= '&desc=' . urlencode($content);
                    $yahoo_url .= '&st=' . date_i18n("Ymd\THis", strtotime("$triggerOn_start"));
                    $yahoo_url .= '&et=' . date_i18n("Ymd\THis", strtotime("$triggerOn_end"));
                    wp_redirect($yahoo_url);
                    exit;
                    break;
            }
        }
    }
}

/* -------------------------------------------------------------------------------------
Add New Custom Menu Option
@since NativeChurch 1.6
------------------------------------------------------------------------------------- */
if (!class_exists('IMIC_Custom_Nav')) {
    class IMIC_Custom_Nav
    {
        public function add_nav_menu_meta_boxes()
        {
            add_meta_box(
                'mega_nav_link',
                esc_html__('Mega Menu', 'imithemes'),
                array($this, 'nav_menu_link'),
                'nav-menus',
                'side',
                'low'
            );
        }
        public function nav_menu_link()
        {
            global $_nav_menu_placeholder, $nav_menu_selected_id;
            $_nav_menu_placeholder = 0 > $_nav_menu_placeholder ? $_nav_menu_placeholder - 1 : -1;
            ?>
		<div id="posttype-wl-login" class="posttypediv">
			<div id="tabs-panel-wishlist-login" class="tabs-panel tabs-panel-active">
				<ul id="wishlist-login-checklist" class="categorychecklist form-no-clear">
					<li>
						<label class="menu-item-title">
							<input type="checkbox" class="menu-item-object-id" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-object-id]" value="<?php echo esc_attr($_nav_menu_placeholder); ?>"> <?php _e('Create Column', 'imithemes');?>
						</label>
						<input type="hidden" class="menu-item-db-id" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-db-id]" value="0">
						<input type="hidden" class="menu-item-object" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-object]" value="page">
						<input type="hidden" class="menu-item-parent-id" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-parent-id]" value="0">
						<input type="hidden" class="menu-item-type" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-type]" value="">
						<input type="hidden" class="menu-item-title" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-title]" value="<?php _e('Column', 'imithemes');?>">
						<input type="hidden" class="menu-item-classes" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-classes]" value="custom_mega_menu">
					</li>
				</ul>
			</div>
			<p class="button-controls">
				<span class="add-to-menu">
					<input type="submit" class="button-secondary submit-add-to-menu right" value="<?php _e('Add to Menu', 'imithemes');?>" name="add-post-type-menu-item" id="submit-posttype-wl-login">
					<span class="spinner"></span>
				</span>
			</p>
		</div>
	<?php
}
    }
}
$custom_nav = new IMIC_Custom_Nav;
add_action('admin_init', array($custom_nav, 'add_nav_menu_meta_boxes'));

/* -------------------------------------------------------------------------------------
Custom admin menu items
@since NativeChurch 1.0
------------------------------------------------------------------------------------- */
if (!function_exists('imic_admin_bar_menu')) {
    function imic_admin_bar_menu()
    {
        global $wp_admin_bar;
        if (current_user_can('manage_options')) {
            $theme_customizer = array(
                'id' => '2',
                'title' => esc_html__('Color Customizer', 'imithemes'),
                'href' => admin_url('/customize.php'),
                'meta' => array('target' => 'blank'),
            );
            $wp_admin_bar->add_menu($theme_customizer);
        }
    }
    add_action('admin_bar_menu', 'imic_admin_bar_menu', 99);
}

if (!function_exists('imic_audio_soundcloud')) {
    function imic_audio_soundcloud($url, $width = "100%", $height = 250)
    {
        $getValues = file_get_contents('http://soundcloud.com/oembed?format=js&url=' . $url . '&iframe=true');
        $decodeiFrame = substr($getValues, 1, -2);
        $jsonObj = json_decode($decodeiFrame);
        return str_replace('height="200"', 'height="250"', $jsonObj->html);
    }
}
//add_action('admin_init', 'adorechurch_core_initialize_features');
require_once NATIVECHURCH_CORE__PLUGIN_PATH . 'shortcodes/shortcodes.php';
require_once NATIVECHURCH_CORE__PLUGIN_PATH . 'meta-boxes/meta-box/meta-box.php';
require_once NATIVECHURCH_CORE__PLUGIN_PATH . 'meta-boxes/meta-box-show-hide/meta-box-show-hide.php';
require_once NATIVECHURCH_CORE__PLUGIN_PATH . 'meta-boxes/meta-box-conditional-logic/meta-box-conditional-logic.php';
require_once NATIVECHURCH_CORE__PLUGIN_PATH . 'meta-boxes/meta-box-group/meta-box-group.php';
if (!class_exists('ReduxFramework')) {
    include_once NATIVECHURCH_CORE__PLUGIN_PATH . 'imi-admin/theme-options/ReduxCore/framework.php';
}
if (is_admin()) {
    include_once NATIVECHURCH_CORE__PLUGIN_PATH . 'imi-admin/admin.php';
}

require_once NATIVECHURCH_CORE__PLUGIN_PATH . 'widgets/twitter_feeds/twitter_feeds.php';
//Podcast
require_once NATIVECHURCH_CORE__PLUGIN_PATH . 'podcasting/podcast-functions.php';
//Meta Boxes
require_once NATIVECHURCH_CORE__PLUGIN_PATH . 'meta-boxes/extra_category_field.php';
require_once NATIVECHURCH_CORE__PLUGIN_PATH . 'meta-boxes/term_color_picker.php';
//Custom Post Types
require_once NATIVECHURCH_CORE__PLUGIN_PATH . '/custom-post-types/gallery-type.php';
require_once NATIVECHURCH_CORE__PLUGIN_PATH . '/custom-post-types/staff-type.php';
require_once NATIVECHURCH_CORE__PLUGIN_PATH . '/custom-post-types/sermon-type.php';
$imic_options = get_option('imic_options');
$event_feature = (isset($imic_options['enable_event_feature'])) ? $imic_options['enable_event_feature'] : '1';
($event_feature == '1') ? require_once NATIVECHURCH_CORE__PLUGIN_PATH . '/custom-post-types/event-type.php' : '';
($event_feature == '1') ? require_once NATIVECHURCH_CORE__PLUGIN_PATH . 'meta-boxes/tickets_clone_fields.php' : '';
