<?php
/**
 * The style "default" of the Events
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_events');

if ($args['slider']) {
	?><div class="swiper-slide"><?php
} else if ($args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

?><div class="sc_events_classic_item"><?php

        // Featured image
        set_query_var('trx_addons_args_featured', apply_filters('trx_addons_filter_args_featured', array(
            'class' => 'sc_events_item_featured',
            'hover' => 'zoomin',
            'thumb_size' => trx_addons_get_thumb_size($args['columns'] > 2 ? 'big' : 'big')
        ), 'team-classic'));
        if (($fdir = trx_addons_get_file_dir('templates/tpl.featured.php')) != '') { include $fdir; }

    ?><div class="sc_events_classic_item_content">

         <div class="sc_events_item_title">
            <span class="sc_events_item_title"><?php the_title(); ?></span>
          </div>

        <?php

            // Event's date
            $date = tribe_get_start_date(null, true, 'l, ');
            if (empty($date)) $date = get_the_date('l');
            $time = tribe_get_start_time(null, 'h:i a');
            // Event's date
            ?><span class="sc_events_item_date_wrap"><span class="sc_events_item_date"><?php echo esc_html($date); ?><?php echo esc_html($time); ?></span></span>

            <div class="sc_events_item_description_address">
                <?php if ( tribe_address_exists() ) { ?>
                    <span class="sc_events_item_address">
                                        <?php echo tribe_get_full_address(); ?>
                                    </span>
                <?php } ?>
            </div>
            <div class="sc_events_item_excerpt_text">
        <?php
        if (has_excerpt()) {
            the_excerpt();
        }
            ?>
            </div>


    </div>
    </div><?php
if ($args['slider'] || $args['columns'] > 1) {
	?></div><?php
}?>