<?php
/**
 * The template to display the Sermons single page
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.4
 */

global $TRX_ADDONS_STORAGE;
$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);

get_header();

while ( have_posts() ) { the_post();
	?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'sermons_page itemscope' ); ?>
		itemscope itemtype="http://schema.org/Article">
		
		<section class="sermons_page_header">

			<?php
			// Image
			if ( !trx_addons_sc_layouts_showed('featured') && has_post_thumbnail() ) {
				?><div class="sermons_page_featured"><?php
					the_post_thumbnail( trx_addons_get_thumb_size('huge'), array(
								'alt' => get_the_title(),
								'itemprop' => 'image'
								)
							);
				?></div><?php
			}
			
			// Title
			if ( !trx_addons_sc_layouts_showed('title') ) {
				?><h2 class="sermons_page_title"><?php the_title(); ?></h2><?php
			}
			?>

		</section>
		<?php

		// Post content
		?><section class="sermons_page_content entry-content" itemprop="articleBody"><?php
			the_content( );
		?></section><!-- .entry-content --><?php


    if ((esc_attr($meta['sermons_video']) != false) && (esc_attr($meta['sermons_video']) != 'inherit' )) {

        echo do_shortcode('
        [trx_sc_popup id="popup-video-'.get_the_ID().'"]
            [trx_widget_video link='.esc_url($meta['sermons_video']).']
        [/trx_sc_popup]

        ');


    };
    if ((esc_attr($meta['sermons_audio']) != false) && (esc_attr($meta['sermons_audio']) != 'inherit' )) {

        echo do_shortcode('
        [trx_sc_popup id="popup-audio-'.get_the_ID().'"]
            [trx_widget_audio url='.esc_url($meta['sermons_audio']).']
        [/trx_sc_popup]

        ');


    };





	?>

    <div class='post_custom_fields'>


        <?php if ((esc_attr($meta['sermons_video']) != false) && (esc_attr($meta['sermons_video']) != 'inherit' )) { ?>
            <span class="post-custom_field-key">
                            <a href="#popup-video-<?php echo get_the_ID() ?>" class=" trx_addons_popup_link custom_field_link"><span class="icon_sc_sermon icon-video-camera"></span></a>
                        </span>
        <?php } else '' ?>



        <?php if ((esc_attr($meta['sermons_audio']) != false) && (esc_attr($meta['sermons_audio']) != 'inherit' )) { ?>
            <span class="post-custom_field-key">
                            <a href="#popup-audio-<?php echo get_the_ID() ?>" class=" trx_addons_popup_link custom_field_link"><span class="icon_sc_sermon icon-technology"></span></a>
                        </span>
        <?php } else '' ?>


        <?php if ((esc_attr($meta['sermons_cloud']) != false) && (esc_attr($meta['sermons_cloud']) != 'inherit' )) { ?>
            <span class='post-custom_field-key'><a href="<?php if ((esc_attr($meta['sermons_cloud']) != false) && (esc_attr($meta['sermons_cloud']) != 'inherit' )) {
                    print_r(esc_attr($meta['sermons_cloud']));
                } else '';
                ?>" download class="custom_field_link"><span class="icon_sc_sermon icon-technology-1"></span></a>
                        </span>
        <?php } else '' ?>

        <?php if ((esc_attr($meta['sermons_document']) != false) && (esc_attr($meta['sermons_document']) != 'inherit' )) { ?>
            <span class='post-custom_field-key'><a href="
                        <?php if ((esc_attr($meta['sermons_document']) != false) && (esc_attr($meta['sermons_document']) != 'inherit' )) {
                    print_r(esc_attr($meta['sermons_document']));
                } else '';
                ?>
                            " download class="custom_field_link"><span class="icon_sc_sermon icon-multimedia-2"></span></a>
                        </span>
        <?php } else '' ?>

    </div>


    </article><?php

	// If comments are open or we have at least one comment, load up the comment template.
	if ( comments_open() || get_comments_number() ) {
		comments_template();
	}
}

get_footer();
?>