<form method="post" action="options.php">
  <?php settings_fields(sanitize_key(QLWAPP_DOMAIN . '-group')); ?>
  <?php do_settings_sections(sanitize_key(QLWAPP_DOMAIN . '-group')); ?>
  <table class="form-table">
    <tbody>
      <tr>
        <th scope="row"><?php esc_html_e('Layout', 'wp-whatsapp-chat'); ?></th>
        <td>
          <select name="<?php echo esc_attr(QLWAPP_DOMAIN); ?>[button][layout]" class="qlwapp-select2">
            <option value="button" <?php selected($qlwapp['button']['layout'], 'button'); ?>><?php esc_html_e('Button', 'wp-whatsapp-chat'); ?></option>
            <option value="bubble" <?php selected($qlwapp['button']['layout'], 'bubble'); ?>><?php esc_html_e('Bubble', 'wp-whatsapp-chat'); ?></option>
          </select>
          <p class="description hidden"><?php esc_html_e('Switch to change the button layout.', 'wp-whatsapp-chat'); ?></p>
        </td>   
      </tr>      
      <tr>
        <th scope="row"><?php esc_html_e('Rounded', 'wp-whatsapp-chat'); ?></th>
        <td>
          <select name="<?php echo esc_attr(QLWAPP_DOMAIN); ?>[button][rounded]" class="qlwapp-select2">
            <option value="yes" <?php selected($qlwapp['button']['rounded'], 'yes'); ?>><?php esc_html_e('Add rounded border', 'wp-whatsapp-chat'); ?></option>
            <option value="no" <?php selected($qlwapp['button']['rounded'], 'no'); ?>><?php esc_html_e('Remove rounded border', 'wp-whatsapp-chat'); ?></option>
          </select>
          <p class="description hidden"><?php esc_html_e('Add rounded border to the button.', 'wp-whatsapp-chat'); ?></p>        
        </td>        
      </tr>
      <tr>
        <th scope="row"><?php esc_html_e('Position', 'wp-whatsapp-chat'); ?></th>
        <td>
          <select name="<?php echo esc_attr(QLWAPP_DOMAIN); ?>[button][position]" class="qlwapp-select2">  
            <option value="middle-left" <?php selected($qlwapp['button']['position'], 'middle-left'); ?>><?php esc_html_e('Middle Left', 'wp-whatsapp-chat'); ?></option>
            <option value="middle-right" <?php selected($qlwapp['button']['position'], 'middle-right'); ?>><?php esc_html_e('Middle Right', 'wp-whatsapp-chat'); ?></option>
            <option value="bottom-left" <?php selected($qlwapp['button']['position'], 'bottom-left'); ?>><?php esc_html_e('Bottom Left', 'wp-whatsapp-chat'); ?></option>
            <option value="bottom-right" <?php selected($qlwapp['button']['position'], 'bottom-right'); ?>><?php esc_html_e('Bottom Right', 'wp-whatsapp-chat'); ?></option>
          </select>
          <p class="description hidden"><?php esc_html_e('Switch to change the button position.', 'wp-whatsapp-chat'); ?></p>  
        </td>
      </tr>            
      <tr>
        <th scope="row"><?php esc_html_e('Icon', 'wp-whatsapp-chat'); ?></th>
        <td>
          <div class="submit qlwapp-premium-field">
            <?php submit_button(esc_html__('Add Icon', 'wp-whatsapp-chat'), 'secondary', null, false, array('id' => 'btn-add-icon')); ?>
            <p class="description hidden"><small><?php esc_html_e('This is a premium feature', 'wp-whatsapp-chat'); ?></small></p>    
          </div>
          <input type="text" name="<?php echo esc_attr(QLWAPP_DOMAIN); ?>[button][icon]" placeholder="<?php echo esc_html($this->defaults['button']['icon']); ?>" value="<?php echo esc_attr($qlwapp['button']['icon']); ?>" class="qlwapp-input"/>
        </td>
      </tr>      
      <!--<tr>
        <th scope="row"><?php esc_html_e('Discreet link', 'wp-whatsapp-chat'); ?></th>
        <td>
          <select name="<?php echo esc_attr(QLWAPP_DOMAIN); ?>[button][developer]" class="qlwapp-select2">
            <option value="yes" <?php selected($qlwapp['button']['developer'], 'yes'); ?>><?php esc_html_e('Show developer link', 'wp-whatsapp-chat'); ?></option>
            <option value="no" <?php selected($qlwapp['button']['developer'], 'no'); ?>><?php esc_html_e('Hide developer link', 'wp-whatsapp-chat'); ?></option>
          </select>
          <p class="description hidden"><?php esc_html_e('Leave a discrete link to developer to help and keep new updates and support.', 'wp-whatsapp-chat'); ?></p>        
        </td>        
      </tr>-->
      <tr>
        <th scope="row"><?php esc_html_e('Text', 'wp-whatsapp-chat'); ?></th>
        <td>
          <input type="text" name="<?php echo esc_attr(QLWAPP_DOMAIN . '[button][text]'); ?>" placeholder="<?php echo esc_html($this->defaults['button']['text']); ?>" value="<?php echo esc_attr($qlwapp['button']['text']); ?>" class="qlwapp-input"/>
          <p class="description hidden"><?php esc_html_e('Customize your text.', 'wp-whatsapp-chat'); ?></p>  
        </td>
      </tr>
      <tr>
        <th scope="row"><?php esc_html_e('Phone', 'wp-whatsapp-chat'); ?></th>
        <td>
          <input type="text" name="<?php echo esc_attr(QLWAPP_DOMAIN . '[button][phone]'); ?>" placeholder="<?php echo esc_html('+542215677768'); ?>" value="<?php echo esc_attr($qlwapp['button']['phone']); ?>" class="qlwapp-input" required="required"/>
          <p class="description hidden"><?php esc_html_e('Full phone number in international format.', 'wp-whatsapp-chat'); ?></p>  

        </td>
      </tr>
      <tr>
        <th scope="row"><?php esc_html_e('Message', 'wp-whatsapp-chat'); ?></th>  
        <td>
          <textarea maxlength="500" style="width:100%;height: 100px;padding: 8px;" name="<?php echo esc_attr(QLWAPP_DOMAIN); ?>[button][message]" placeholder="<?php echo esc_html($this->defaults['button']['message']); ?>" ><?php echo esc_html(trim($qlwapp['button']['message'])); ?></textarea>
          <p class="description hidden"><?php esc_html_e('Message that will automatically appear in the text field of a chat.', 'wp-whatsapp-chat'); ?></p>  
        </td>
      </tr>
      <tr>
        <th scope="row"><?php esc_html_e('Schedule', 'wp-whatsapp-chat'); ?></th>
        <td class="qlwapp-premium-field">
          <b><?php esc_html_e('From', 'wp-whatsapp-chat'); ?></b>
          <input type="time" name="<?php echo esc_attr(QLWAPP_DOMAIN . '[button][timefrom]'); ?>" placeholder="<?php echo esc_html($this->defaults['button']['timefrom']); ?>" value="<?php echo esc_html($qlwapp['button']['timefrom']); ?>" />
          <b><?php esc_html_e('To', 'wp-whatsapp-chat'); ?></b>
          <input type="time" name="<?php echo esc_attr(QLWAPP_DOMAIN . '[button][timeto]'); ?>" placeholder="<?php echo esc_html($this->defaults['button']['timeto']); ?>" value="<?php echo esc_html($qlwapp['button']['timeto']); ?>" />
          <p class="description hidden"><small><?php esc_html_e('This is a premium feature', 'wp-whatsapp-chat'); ?></small></p>    
        </td> 
      </tr> 
      <tr> 
        <th scope="row"><?php esc_html_e('Timezone', 'wp-whatsapp-chat'); ?></th> 
        <td  class="qlwapp-premium-field">
          <select name="<?php echo esc_attr(QLWAPP_DOMAIN . '[button][timezone]'); ?>" aria-describedby="timezone-description" required="" class="qlwapp-select2">
            <?php echo wp_timezone_choice($qlwapp['button']['timezone'], get_user_locale()); ?>
          </select> 
          <p class="description"><small><?php esc_html_e('Hide button if the user is out of the available hours.', 'wp-whatsapp-chat'); ?></small></p>
          <p class="description hidden"><small><?php esc_html_e('This is a premium feature', 'wp-whatsapp-chat'); ?></small></p>    
        </td>
      </tr> 
<!--      <tr>
        <th scope="row"><?php // esc_html_e('Timeout', 'wp-whatsapp-chat');    ?></th>
        <td  class="qlwapp-premium-field">
          <select name="<?php // echo esc_attr(QLWAPP_DOMAIN);    ?>[button][timeout]" class="qlwapp-select2">
            <option value="yes" <?php // selected($qlwapp['button']['timeout'], 'yes');    ?>><?php esc_html_e('Show the button as read only', 'wp-whatsapp-chat'); ?></option>
            <option value="no" <?php // selected($qlwapp['button']['timeout'], 'no');    ?>><?php esc_html_e('Do not show the button', 'wp-whatsapp-chat'); ?></option>
          </select> 
          <p class="description hidden"><small><?php //esc_html_e('This is a premium feature', 'wp-whatsapp-chat');    ?></small></p>    
        </td>        
      </tr> -->
    </tbody>
  </table>
  <?php submit_button() ?>
</form>