<?php 
$accesspresslite_options = accesspress_default_setting_value();
$accesspresslite_settings = get_option( 'accesspresslite_options', $accesspresslite_options );
$accesspresslite_layout = $accesspresslite_settings['accesspresslite_home_page_layout'];
$accesspresslite_welcome_post_id = $accesspresslite_settings['welcome_post'];
$accesspresslite_event_category = $accesspresslite_settings['event_cat'];
$featured_section_title = isset($accesspresslite_settings['featured_section_title']) ? $accesspresslite_settings['featured_section_title'] : "";
$featured_post1 = $accesspresslite_settings['featured_post1'];
$featured_post2 = $accesspresslite_settings['featured_post2'];
$featured_post3 = $accesspresslite_settings['featured_post3'];
$show_fontawesome_icon = $accesspresslite_settings['show_fontawesome'];
$testimonial_category = $accesspresslite_settings['testimonial_cat'];
$accesspresslite_featured_bar = $accesspresslite_settings['featured_bar'];
$accesspresslite_welcome_post_char = (isset($accesspresslite_settings['welcome_post_char']) ? $accesspresslite_settings['welcome_post_char'] : 650 );
$accesspresslite_show_event_number = (isset($accesspresslite_settings['show_event_number']) ? $accesspresslite_settings['show_event_number'] : 3 ) ;
$big_icons = $accesspresslite_settings['big_icons'];
$disable_event = $accesspresslite_settings['disable_event'];

if($disable_event == 1){
	$welcome_class = "full-width";
}else{
	$welcome_class = "";
}

if( $accesspresslite_layout !== 'Layout2') { ?>			
	<section id="top-section" class="ak-container">
	<div id="welcome-text" class="clearfix <?php echo esc_attr($welcome_class); ?>">
		<?php
				if(!empty($accesspresslite_welcome_post_id)){
				$posttype = get_post_type($accesspresslite_welcome_post_id);
				$postparam = ($posttype == 'page') ? 'page_id': 'p';
				$args = array(
					'post_type' => $posttype,
					$postparam => $accesspresslite_welcome_post_id
					);
				$query1 = new WP_Query( $args );
					while ($query1->have_posts()) : $query1->the_post(); ?>
						 	
						<?php 
						if( has_post_thumbnail() ){
						$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full', false ); 
						?>
						<figure class="welcome_left_content">
							<a href="<?php the_permalink(); ?>">
							<img src="<?php echo esc_url($image[0]); ?>" alt="<?php the_title(); ?>">
							</a>
						</figure>	
						<?php } ?>
	                    <div class="welcome_right_content <?php if( !has_post_thumbnail() ){echo 'welcome_fill_content';} ?>">
	    					<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
	    					<div  class="welcome-detail<?php if( !has_post_thumbnail() ){ echo " welcome-detail-full-width"; } ?>">
	    					
	    					<?php if($accesspresslite_settings['welcome_post_content'] == 0 || empty($accesspresslite_settings['welcome_post_content'])){ ?>
	    						<p><?php echo esc_html(accesspresslite_excerpt( get_the_content() , $accesspresslite_welcome_post_char )); ?></p>
	    						<?php if(!empty($accesspresslite_settings['welcome_post_readmore'])){?>
	    							<a href="<?php the_permalink(); ?>" class="read-more bttn"><?php echo esc_attr($accesspresslite_settings['welcome_post_readmore']); ?></a>
	    						<?php } 
	    					}else{ 
	    						the_content();
	    					} ?>
	    					
	    					</div>
	                    </div>
						
					<?php endwhile;	
					wp_reset_postdata(); 
					}
					
					?>
	</div>
	</section>

	<?php do_action('accesspresslite_call_to_action');?>

	<section id="mid-section" class="ak-container">
	<?php if($featured_section_title){ ?>
	<h2><?php echo esc_attr($featured_section_title); ?></h2>
	<?php }
	if(!empty($featured_post1) || !empty($featured_post2) || !empty($featured_post3)){
	    ?><div class="feature_wrap clearfix"><?php 
	    if(!empty($featured_post1)) { ?>
	    
			<div id="featured-post-1" class="featured-post <?php if($show_fontawesome_icon){echo 'icon_view_mod';} if($big_icons == 1){ echo ' big-icon'; } ?>">
				
				<?php
					$posttype = get_post_type($featured_post1);
					$postparam = ($posttype == 'page') ? 'page_id': 'p';
					$args = array(
						'post_type' => $posttype,
						$postparam => $featured_post1
					);
					$query2 = new WP_Query( $args );
					// the Loop
					while ($query2->have_posts()) : $query2->the_post(); 
						
						if( $show_fontawesome_icon == 0 ){
						?>
						<figure class="featured-image">
	                        <div class="featured-overlay">
	                            <?php 							
	    							if( has_post_thumbnail()){
	    							$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'featured-thumbnail', false ); 
	    							?>
	                                <a class="image_feature_lightbox" href="<?php echo esc_url($image[0]); ?>"><i class="fa fa-expand"></i></a>
	                            <?php }?>
	                			<a class="plus_fa_icon" href="<?php the_permalink(); ?>"><i class="fa font-icon-plus"></i></a>
	                		</div>
								<?php 							
								if( has_post_thumbnail()){
								$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'featured-thumbnail', false ); 
								?>
								<img src="<?php echo esc_url($image[0]); ?>" alt="<?php the_title(); ?>">
								<?php }else { ?>
								<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/demo/featured-fallback.jpg" alt="<?php the_title(); ?>">
								<?php } 
								?>
							
						</figure>
						<?php } ?>	

						<h4 class="<?php if($show_fontawesome_icon == 1){ echo 'has-icon'; }?>">
						<a href="<?php the_permalink(); ?>">
						<?php 
						if($show_fontawesome_icon == 1){ ?>

						<i class="fa <?php echo esc_attr($accesspresslite_settings['featured_post1_icon']) ?>"></i>
								
						<?php } ?>
	                    
						<span><?php the_title(); ?></span>
						</a>
						</h4>

						<div class="featured-content">
							<p><?php echo esc_html(accesspresslite_excerpt( get_the_content() , 260 )); ?></p>
						</div>
					<?php endwhile;
					wp_reset_postdata(); ?>
			
			</div>
		<?php }

		if(!empty($featured_post2)) { ?>
			<div id="featured-post-2" class="featured-post<?php if($show_fontawesome_icon){echo ' icon_view_mod';}if($big_icons == 1){ echo ' big-icon'; } ?>">
				
				<?php
					$posttype = get_post_type($featured_post2);
					$postparam = ($posttype == 'page') ? 'page_id': 'p';
					$args = array(
						'post_type' => $posttype,
						$postparam => $featured_post2
					);
					$query3 = new WP_Query( $args );
					// the Loop
					while ($query3->have_posts()) : $query3->the_post();
						
						if( $show_fontawesome_icon == 0 ){
						?>
						<figure class="featured-image">
							
	                        <div class="featured-overlay">
	                            <?php 							
	    							if( has_post_thumbnail()){
	    							$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'featured-thumbnail', false ); 
	    							?>
	                                <a class="image_feature_lightbox" href="<?php echo esc_url($image[0]); ?>"><i class="fa fa-expand"></i></a>
	                            <?php }?>
	                			<a class="plus_fa_icon" href="<?php the_permalink(); ?>"><i class="fa font-icon-plus"></i></a>
	                		</div>
								<?php 							
								if( has_post_thumbnail()){
								$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'featured-thumbnail', false ); 
								?>
								<img src="<?php echo esc_url($image[0]); ?>" alt="<?php the_title(); ?>">
								<?php }else { ?>
								<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/demo/featured-fallback.jpg" alt="<?php the_title(); ?>">
								<?php } 
								?>
							
						</figure>
						<?php } ?>	

						<h4 class="<?php if($show_fontawesome_icon == 1){ echo 'has-icon'; }?>">
						<a href="<?php the_permalink(); ?>">
						<?php 
						if($show_fontawesome_icon == 1){ ?>

						<i class="fa <?php echo esc_attr($accesspresslite_settings['featured_post2_icon']) ?>"></i>
								
						<?php } ?>
	                    
						<span><?php the_title(); ?></span>
						</a>
						</h4>

						<div class="featured-content">
							<p><?php echo esc_html(accesspresslite_excerpt( get_the_content() , 260 )); ?></p>
							
						</div>
					<?php endwhile;
					wp_reset_postdata(); ?>
			
			</div>
		<?php } 

		if(!empty($featured_post3)) { ?>
			<div id="featured-post-3" class="featured-post<?php if($show_fontawesome_icon){echo ' icon_view_mod';} if($big_icons == 1){ echo ' big-icon'; } ?>">
				<?php
					$posttype = get_post_type($featured_post3);
					$postparam = ($posttype == 'page') ? 'page_id': 'p';
					$args = array(
						'post_type' => $posttype,
						$postparam => $featured_post3
					);
					$query4 = new WP_Query( $args );
					// the Loop
					while ($query4->have_posts()) : $query4->the_post(); 
						if( $show_fontawesome_icon == 0 ){
						?>
						<figure class="featured-image">
							
	                        <div class="featured-overlay">
	                            <?php 							
	    							if( has_post_thumbnail()){
	    							$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'featured-thumbnail', false ); 
	    							?>
	                                <a class="image_feature_lightbox" href="<?php echo esc_url($image[0]); ?>"><i class="fa fa-expand"></i></a>
	                            <?php }?>
	                			<a class="plus_fa_icon" href="<?php the_permalink(); ?>"><i class="fa font-icon-plus"></i></a>
	                		</div>
								<?php 							
								if( has_post_thumbnail()){
								$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'featured-thumbnail', false ); 
								?>
								<img src="<?php echo esc_url($image[0]); ?>" alt="<?php the_title(); ?>">
								<?php }else { ?>
								<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/demo/featured-fallback.jpg" alt="<?php the_title(); ?>">
								<?php } 
								?>
							
						</figure>
						<?php } ?>	

						<h4 class="<?php if($show_fontawesome_icon == 1){ echo 'has-icon'; }?>">
						<?php 
						if($show_fontawesome_icon == 1){ ?>

						<a href="<?php the_permalink(); ?>"><i class="fa <?php echo esc_attr($accesspresslite_settings['featured_post3_icon']) ?>"></i></a>
								
						<?php } ?>
	                    
						<a href="<?php the_permalink(); ?>"><span><?php the_title(); ?></span></a>
						</h4>

						<div class="featured-content">
							<p><?php echo esc_html(accesspresslite_excerpt( get_the_content() , 260 )); ?></p>
							
						</div>
					<?php endwhile;
					wp_reset_postdata(); ?>
			
			</div>
		<?php } 
		?></div> <?php
		}?>
	</section>

	<?php if($disable_event != 1){ ?>
	<section id="event_section" >
	    <div class="ak-container" id="latest-events_template_two">
			<?php
			if(!empty($accesspresslite_event_category)){

	            $loop = new WP_Query( array(
	                'cat' => $accesspresslite_event_category,
	                'posts_per_page' => $accesspresslite_show_event_number,
	            )); ?>

	        <h2><a href="<?php echo esc_url(get_category_link($accesspresslite_event_category)); ?>"><?php echo esc_html(get_cat_name($accesspresslite_event_category)); ?></a></h2>
            <div class="event_mail_wraper clearfix">
    	        <?php while ($loop->have_posts()) : $loop->the_post(); ?>
    	        	<div class="event-list_two clearfix">
    	        		<figure class="event-thumbnail_two">
                            <div class="event-detail_two">
        		        		<h4 class="event-title_two">
        		        			<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        		        		</h4>
        
        		        		<div class="event-excerpt_two">
        		        			<?php echo esc_html(accesspresslite_excerpt( get_the_content() , 100 )); ?>
        		        		</div>
                                 <?php 
    						if($accesspresslite_settings['show_eventdate'] == 1){ ?>
    							<div class="event-date_two">
    							<span class="event-date-day_two"><?php echo get_the_date('j'); ?></span>
    							<span class="event-date-month_two"><?php echo get_the_date('M'); ?></span>
    							</div>
    						<?php
    						}?>
        	        		</div>
                           
    						<a href="<?php the_permalink(); ?>">
    						<?php 
    						if( has_post_thumbnail() ){
    						$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'template_two_event_home', false ); 
    						?>
    						<img src="<?php echo esc_url($image[0]); ?>" alt="<?php the_title(); ?>">
    						<?php } else { ?>
    						<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/demo/event-fallback.jpg" alt="<?php the_title(); ?>">
    						<?php } ?>
    						</a>
    					</figure>
    	        	</div>
    	        <?php endwhile; ?>
             </div>                
	        <?php wp_reset_postdata(); 

	        } ?>
	    </div>
	</section>
	<?php }
} 
?>

<?php if( $accesspresslite_layout !== 'Default' || empty($accesspresslite_layout) ){?>
<section id="ak-blog">
	<section class="ak-container" id="ak-blog-post">
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>

			<?php 
			while ( have_posts() ) : the_post(); 
			get_template_part( 'content' );
			endwhile;
			?>

			<?php accesspresslite_paging_nav(); ?>

		<?php else : ?>

			<?php get_template_part( 'content', 'none' ); ?>

		<?php endif; ?>
		<?php wp_reset_query();
		?>

		</main><!-- #main -->
	</div><!-- #primary -->
	
	<div id="secondary-right" class="widget-area right-sidebar sidebar">
		<?php if ( is_active_sidebar( 'blog-sidebar' ) ) : ?>
			<?php dynamic_sidebar( 'blog-sidebar' ); ?>
		<?php endif; ?>
	</div>
	</section>
</section>
<?php }
?>

<?php if($accesspresslite_featured_bar != 1){ ?>
<section id="bottom-section">
	<div class="ak-container">
        <div class="text-box">
		<?php if ( is_active_sidebar( 'textblock-1' ) ) : ?>
		  <?php dynamic_sidebar( 'textblock-1' ); ?>
		<?php endif; ?>	
		</div>
        
        <div class="thumbnail-gallery clearfix">
        <?php 
        $gallery_code = $accesspresslite_settings['gallery_code'];
        if ( is_active_sidebar( 'textblock-2' ) ) : ?>
		  <?php dynamic_sidebar( 'textblock-2' ); ?>
		<?php elseif(!empty($gallery_code)): ?>	
		<h3><?php esc_html_e('Gallery','accesspress-lite')?></h3>
        <?php 
        echo do_shortcode($gallery_code );
        endif; ?>	
		</div>        
        
		<div class="testimonial-slider-wrap">
		<?php 
		if ( is_active_sidebar( 'textblock-3' ) ) {
		  dynamic_sidebar( 'textblock-3' );
		}else{

		if(!empty($testimonial_category)) {	?>
 		<h3><?php echo esc_html(get_cat_name($testimonial_category)); ?></h3>
			<?php
				$loop2 = new WP_Query( array(
	                'cat' => $testimonial_category,
	                'posts_per_page' => 4,
	            )); ?>
	        <div class="testimonial-wrap_two">
		        <div class="testimonial-slider">
		        <?php while ($loop2->have_posts()) : $loop2->the_post(); ?>

		        	<div class="testimonial-single">
			        	<div class="testimonial-list clearfix">
                            <div class="image_title_content clearfix">
    			        		<div class="testimonial-thumbnail">
        			        		<?php 
                                    if(has_post_thumbnail()){
                                    the_post_thumbnail('thumbnail'); 
                                    }else{ ?>
                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/testimonial-dummy.jpg" alt="no-image"/>
                                    <?php }?>
    			        		</div>
                                <div class="testimoinal-client-name_two"><?php the_title(); ?></div>
                                <?php the_date('d F,y', '<span class="testimonial_date">', '</span>'); ?>                                
                            </div>
			        		<div class="testimonial-excerpt_two">
			        			<?php echo esc_html(accesspresslite_excerpt( get_the_content() , 140 )); ?>
			        		</div>
			        	</div>
					</div>
                <?php endwhile; ?>
				</div>
			</div>	         
	        
	        <?php wp_reset_postdata(); 
			} 
			}?>
		</div>
	</div>
</section>
<?php }