<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

$free_church_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$free_church_post_format = get_post_format();
$free_church_post_format = empty($free_church_post_format) ? 'standard' : str_replace('post-format-', '', $free_church_post_format);
$free_church_animation = free_church_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($free_church_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($free_church_post_format) ); ?>
	<?php echo (!free_church_is_off($free_church_animation) ? ' data-animation="'.esc_attr(free_church_get_animation_classes($free_church_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	free_church_show_post_featured(array(
		'thumb_size' => free_church_get_thumb_size($free_church_columns==1 ? 'big' : ($free_church_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($free_church_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			free_church_show_post_meta();
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>