/* global jQuery:false */
/* global FREE_CHURCH_STORAGE:false */

jQuery(document).ready(function() {
	"use strict";

	// Init Media manager variables
	FREE_CHURCH_STORAGE['media_id'] = '';
	FREE_CHURCH_STORAGE['media_frame'] = [];
	FREE_CHURCH_STORAGE['media_link'] = [];
	jQuery('.free_church_media_selector').on('click', function(e) {
		free_church_show_media_manager(this);
		e.preventDefault();
		return false;
	});
	
	// Hide empty meta-boxes
	jQuery('.postbox > .inside').each(function() {
		if (jQuery(this).html().length < 5) jQuery(this).parent().hide();
	});

	// Hide admin notice
	jQuery('#free_church_admin_notice .free_church_hide_notice').on('click', function(e) {
		jQuery('#free_church_admin_notice').slideUp();
		jQuery.post( FREE_CHURCH_STORAGE['ajax_url'], {'action': 'free_church_hide_admin_notice'}, function(response){});
		e.preventDefault();
		return false;
	});
	
	// TGMPA Source selector is changed
	jQuery('.tgmpa_source_file').on('change', function(e) {
		var chk = jQuery(this).parents('tr').find('>th>input[type="checkbox"]');
		if (chk.length == 1) {
			if (jQuery(this).val() != '')
				chk.attr('checked', 'checked');
			else
				chk.removeAttr('checked');
		}
	});
		
	// Add icon selector after the menu item classes field
	jQuery('.edit-menu-item-classes').each(function() {
		var icon = free_church_get_icon_class(jQuery(this).val());
		jQuery(this).after('<span class="free_church_list_icons_selector'+(icon ? ' '+icon : '')+'" title="'+FREE_CHURCH_STORAGE['icon_selector_msg']+'"></span>');
	});
	jQuery('.free_church_list_icons_selector').on('click', function(e) {
		var selector = jQuery(this);
		var input_id = selector.prev().attr('id');
		if (input_id === undefined) {
			input_id = ('free_church_icon_field_'+Math.random()).replace(/\./g, '');
			selector.prev().attr('id', input_id)
		}
		var in_menu = selector.parents('.menu-item-settings').length > 0;
		var list = in_menu ? jQuery('.free_church_list_icons') : selector.next('.free_church_list_icons');
		if (list.length > 0) {
			list.find('span.free_church_list_active').removeClass('free_church_list_active');
			var icon = free_church_get_icon_class(selector.attr('class'));
			if (icon != '') list.find('span[class*="'+icon+'"]').addClass('free_church_list_active');
			var pos = in_menu ? selector.offset() : selector.position();
			list.data('input_id', input_id).css({'left': pos.left-(in_menu ? 0 : list.outerWidth()-selector.width()-1), 'top': pos.top+(in_menu ? 0 : selector.height()+4)}).fadeIn();
		}
		e.preventDefault();
		return false;
	});
	jQuery('.free_church_list_icons span').on('click', function(e) {
		var list = jQuery(this).parent().fadeOut();
		var icon = free_church_alltrim(jQuery(this).attr('class').replace(/free_church_list_active/, ''));
		var input = jQuery('#'+list.data('input_id'));
		input.val(free_church_chg_icon_class(input.val(), icon)).trigger('change');
		var selector = input.next();
		selector.attr('class', free_church_chg_icon_class(selector.attr('class'), icon));
		e.preventDefault();
		return false;
	});

	// Standard WP Color Picker
	if (jQuery('.free_church_color_selector').length > 0) {
		jQuery('.free_church_color_selector').wpColorPicker({
			// you can declare a default color here,
			// or in the data-default-color attribute on the input
			//defaultColor: false,
	
			// a callback to fire whenever the color changes to a valid color
			change: function(e, ui){
				jQuery(e.target).val(ui.color).trigger('change');
			},
	
			// a callback to fire when the input is emptied or an invalid color
			clear: function(e) {
				jQuery(e.target).prev().trigger('change')
			},
	
			// hide the color picker controls on load
			//hide: true,
	
			// show a group of common colors beneath the square
			// or, supply an array of colors to customize further
			//palettes: true
		});
	}

	function free_church_chg_icon_class(classes, icon) {
		var chg = false;
		classes = free_church_alltrim(classes).split(' ');
		for (var i=0; i<classes.length; i++) {
			if (classes[i].indexOf('icon-') >= 0) {
				classes[i] = icon;
				chg = true;
				break;
			}
		}
		if (!chg) {
			if (classes.length == 1 && classes[0] == '')
				classes[0] = icon;
			else
				classes.push(icon);
		}
		return classes.join(' ');
	}

	function free_church_get_icon_class(classes) {
		var classes = free_church_alltrim(classes).split(' ');
		var icon = '';
		for (var i=0; i<classes.length; i++) {
			if (classes[i].indexOf('icon-') >= 0) {
				icon = classes[i];
				break;
			}
		}
		return icon;
	}

	function free_church_show_media_manager(el) {
		FREE_CHURCH_STORAGE['media_id'] = jQuery(el).attr('id');
		FREE_CHURCH_STORAGE['media_link'][FREE_CHURCH_STORAGE['media_id']] = jQuery(el);
		// If the media frame already exists, reopen it.
		if ( FREE_CHURCH_STORAGE['media_frame'][FREE_CHURCH_STORAGE['media_id']] ) {
			FREE_CHURCH_STORAGE['media_frame'][FREE_CHURCH_STORAGE['media_id']].open();
			return false;
		}
		// Create the media frame.
		FREE_CHURCH_STORAGE['media_frame'][FREE_CHURCH_STORAGE['media_id']] = wp.media({
			// Popup layout (if comment next row - hide filters and image sizes popups)
			frame: 'post',
			// Set the title of the modal.
			title: FREE_CHURCH_STORAGE['media_link'][FREE_CHURCH_STORAGE['media_id']].data('choose'),
			// Tell the modal to show only images.
			library: {
				type: FREE_CHURCH_STORAGE['media_link'][FREE_CHURCH_STORAGE['media_id']].data('type') ? FREE_CHURCH_STORAGE['media_link'][FREE_CHURCH_STORAGE['media_id']].data('type') : 'image'
			},
			// Multiple choise
			multiple: FREE_CHURCH_STORAGE['media_link'][FREE_CHURCH_STORAGE['media_id']].data('multiple')===true ? 'add' : false,
			// Customize the submit button.
			button: {
				// Set the text of the button.
				text: FREE_CHURCH_STORAGE['media_link'][FREE_CHURCH_STORAGE['media_id']].data('update'),
				// Tell the button not to close the modal, since we're
				// going to refresh the page when the image is selected.
				close: true
			}
		});
		// When an image is selected, run a callback.
		FREE_CHURCH_STORAGE['media_frame'][FREE_CHURCH_STORAGE['media_id']].on( 'insert select', function(selection) {
			// Grab the selected attachment.
			var field = jQuery("#"+FREE_CHURCH_STORAGE['media_link'][FREE_CHURCH_STORAGE['media_id']].data('linked-field')).eq(0);
			var attachment = null, attachment_url = '';
			if (FREE_CHURCH_STORAGE['media_link'][FREE_CHURCH_STORAGE['media_id']].data('multiple')===true) {
				FREE_CHURCH_STORAGE['media_frame'][FREE_CHURCH_STORAGE['media_id']].state().get('selection').map( function( att ) {
					attachment_url += (attachment_url ? "\n" : "") + att.toJSON().url;
				});
				var val = field.val();
				attachment_url = val + (val ? "\n" : '') + attachment_url;
			} else {
				attachment = FREE_CHURCH_STORAGE['media_frame'][FREE_CHURCH_STORAGE['media_id']].state().get('selection').first().toJSON();
				attachment_url = attachment.url;
				var sizes_selector = jQuery('.media-modal-content .attachment-display-settings select.size');
				if (sizes_selector.length > 0) {
					var size = free_church_get_listbox_selected_value(sizes_selector.get(0));
					if (size != '') attachment_url = attachment.sizes[size].url;
				}
			}
			field.val(attachment_url);
			if (attachment_url.indexOf('.jpg') > 0 || attachment_url.indexOf('.png') > 0 || attachment_url.indexOf('.gif') > 0) {
				var preview = field.siblings('.free_church_meta_box_field_preview');
				if (preview.length != 0) {
					if (preview.find('img').length == 0)
						preview.append('<img src="'+attachment_url+'">');
					else 
						preview.find('img').attr('src', attachment_url);
				} else {
					preview = field.siblings('img');
					if (preview.length != 0)
						preview.attr('src', attachment_url);
				}
			}
			field.trigger('change');
		});
		// Finally, open the modal.
		FREE_CHURCH_STORAGE['media_frame'][FREE_CHURCH_STORAGE['media_id']].open();
		return false;
	}

});