<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0.10
 */

// Footer sidebar
$free_church_footer_name = free_church_get_theme_option('footer_widgets');
$free_church_footer_present = !free_church_is_off($free_church_footer_name) && is_active_sidebar($free_church_footer_name);
if ($free_church_footer_present) { 
	free_church_storage_set('current_sidebar', 'footer');
	$free_church_footer_wide = free_church_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($free_church_footer_name) ) {
		dynamic_sidebar($free_church_footer_name);
	}
	$free_church_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($free_church_out)) {
		$free_church_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $free_church_out);
		$free_church_need_columns = true;	//or check: strpos($free_church_out, 'columns_wrap')===false;
		if ($free_church_need_columns) {
			$free_church_columns = max(0, (int) free_church_get_theme_option('footer_columns'));
			if ($free_church_columns == 0) $free_church_columns = min(6, max(1, substr_count($free_church_out, '<aside ')));
			if ($free_church_columns > 1)
				$free_church_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($free_church_columns).' widget ', $free_church_out);
			else
				$free_church_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($free_church_footer_wide) ? ' footer_fullwidth' : ''; ?>">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$free_church_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($free_church_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'free_church_action_before_sidebar' );
				free_church_show_layout($free_church_out);
				do_action( 'free_church_action_after_sidebar' );
				if ($free_church_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$free_church_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>