<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0.06
 */

$free_church_header_css = $free_church_header_image = '';
$free_church_header_video = free_church_get_header_video();
if (true || empty($free_church_header_video)) {
	$free_church_header_image = get_header_image();
	if (free_church_is_on(free_church_get_theme_option('header_image_override')) && apply_filters('free_church_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($free_church_cat_img = free_church_get_category_image()) != '')
				$free_church_header_image = $free_church_cat_img;
		} else if (is_singular() || free_church_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$free_church_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($free_church_header_image)) $free_church_header_image = $free_church_header_image[0];
			} else
				$free_church_header_image = '';
		}
	}
}

$free_church_header_id = str_replace('header-custom-', '', free_church_get_theme_option("header_style"));

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($free_church_header_id);
						echo !empty($free_church_header_image) || !empty($free_church_header_video) ? ' with_bg_image' : ' without_bg_image';
						if ($free_church_header_video!='') echo ' with_bg_video';
						if ($free_church_header_image!='') echo ' '.esc_attr(free_church_add_inline_css_class('background-image: url('.esc_url($free_church_header_image).');'));
						if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
						if (free_church_is_on(free_church_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
						?> scheme_<?php echo esc_attr(free_church_is_inherit(free_church_get_theme_option('header_scheme')) 
														? free_church_get_theme_option('color_scheme') 
														: free_church_get_theme_option('header_scheme'));
						?>"><?php

	// Background video
	if (!empty($free_church_header_video)) {
		get_template_part( 'templates/header-video' );
	}
		
	// Custom header's layout
	do_action('free_church_action_show_layout', $free_church_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );


		
?></header>