<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

$free_church_args = get_query_var('free_church_logo_args');

// Site logo
$free_church_logo_image  = free_church_get_logo_image(isset($free_church_args['type']) ? $free_church_args['type'] : '');
$free_church_logo_text   = free_church_is_on(free_church_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$free_church_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($free_church_logo_image) || !empty($free_church_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($free_church_logo_image)) {
			$free_church_attr = free_church_getimagesize($free_church_logo_image);
			echo '<img src="'.esc_url($free_church_logo_image).'" alt="'.esc_attr__('img', 'free-church').'"'.(!empty($free_church_attr[3]) ? sprintf(' %s', $free_church_attr[3]) : '').'>' ;
		} else {
			free_church_show_layout(free_church_prepare_macros($free_church_logo_text), '<span class="logo_text">', '</span>');
			free_church_show_layout(free_church_prepare_macros($free_church_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>