<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

// Page (category, tag, archive, author) title

if ( free_church_need_page_title() ) {
	free_church_sc_layouts_showed('title', true);
	free_church_sc_layouts_showed('postmeta', true);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title">
						<?php
						// Post meta on the single post
						if ( is_single() )  {
							?><div class="sc_layouts_title_meta"><?php
								free_church_show_post_meta(array(
									'date' => true,
									'categories' => true,
									'seo' => true,
									'share' => false,
									'counters' => 'views,comments,likes'
									)
								);
							?></div><?php
						}
						
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$free_church_blog_title = free_church_get_blog_title();
							$free_church_blog_title_text = $free_church_blog_title_class = $free_church_blog_title_link = $free_church_blog_title_link_text = '';
							if (is_array($free_church_blog_title)) {
								$free_church_blog_title_text = $free_church_blog_title['text'];
								$free_church_blog_title_class = !empty($free_church_blog_title['class']) ? ' '.$free_church_blog_title['class'] : '';
								$free_church_blog_title_link = !empty($free_church_blog_title['link']) ? $free_church_blog_title['link'] : '';
								$free_church_blog_title_link_text = !empty($free_church_blog_title['link_text']) ? $free_church_blog_title['link_text'] : '';
							} else
								$free_church_blog_title_text = $free_church_blog_title;
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr($free_church_blog_title_class); ?>"><?php
								$free_church_top_icon = free_church_get_category_icon();
								if (!empty($free_church_top_icon)) {
									$free_church_attr = free_church_getimagesize($free_church_top_icon);
									?><img src="<?php echo esc_url($free_church_top_icon); ?>" alt="'.esc_attr__('img', 'free-church').'" <?php if (!empty($free_church_attr[3])) free_church_show_layout($free_church_attr[3]);?>><?php
								}
								echo wp_kses_data($free_church_blog_title_text);
							?></h1>
							<?php
							if (!empty($free_church_blog_title_link) && !empty($free_church_blog_title_link_text)) {
								?><a href="<?php echo esc_url($free_church_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($free_church_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'free_church_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>