<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

// Header sidebar
$free_church_header_name = free_church_get_theme_option('header_widgets');
$free_church_header_present = !free_church_is_off($free_church_header_name) && is_active_sidebar($free_church_header_name);
if ($free_church_header_present) { 
	free_church_storage_set('current_sidebar', 'header');
	$free_church_header_wide = free_church_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($free_church_header_name) ) {
		dynamic_sidebar($free_church_header_name);
	}
	$free_church_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($free_church_widgets_output)) {
		$free_church_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $free_church_widgets_output);
		$free_church_need_columns = strpos($free_church_widgets_output, 'columns_wrap')===false;
		if ($free_church_need_columns) {
			$free_church_columns = max(0, (int) free_church_get_theme_option('header_columns'));
			if ($free_church_columns == 0) $free_church_columns = min(6, max(1, substr_count($free_church_widgets_output, '<aside ')));
			if ($free_church_columns > 1)
				$free_church_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($free_church_columns).' widget ', $free_church_widgets_output);
			else
				$free_church_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($free_church_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$free_church_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($free_church_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'free_church_action_before_sidebar' );
				free_church_show_layout($free_church_widgets_output);
				do_action( 'free_church_action_after_sidebar' );
				if ($free_church_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$free_church_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>