<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

$free_church_post_id    = get_the_ID();
$free_church_post_date  = free_church_get_date();
$free_church_post_title = get_the_title();
$free_church_post_link  = get_permalink();
$free_church_post_author_id   = get_the_author_meta('ID');
$free_church_post_author_name = get_the_author_meta('display_name');
$free_church_post_author_url  = get_author_posts_url($free_church_post_author_id, '');

$free_church_args = get_query_var('free_church_args_widgets_posts');
$free_church_show_date = isset($free_church_args['show_date']) ? (int) $free_church_args['show_date'] : 1;
$free_church_show_image = isset($free_church_args['show_image']) ? (int) $free_church_args['show_image'] : 1;
$free_church_show_author = isset($free_church_args['show_author']) ? (int) $free_church_args['show_author'] : 1;
$free_church_show_counters = isset($free_church_args['show_counters']) ? (int) $free_church_args['show_counters'] : 1;
$free_church_show_categories = isset($free_church_args['show_categories']) ? (int) $free_church_args['show_categories'] : 1;

$free_church_output = free_church_storage_get('free_church_output_widgets_posts');

$free_church_post_counters_output = '';
if ( $free_church_show_counters ) {
	$free_church_post_counters_output = '<span class="post_info_item post_info_counters">'
								. free_church_get_post_counters('comments')
							. '</span>';
}


$free_church_output .= '<article class="post_item with_thumb">';

if ($free_church_show_image) {
	$free_church_post_thumb = get_the_post_thumbnail($free_church_post_id, free_church_get_thumb_size('tiny'), array(
		'alt' => get_the_title()
	));
	if ($free_church_post_thumb) $free_church_output .= '<div class="post_thumb">' . ($free_church_post_link ? '<a href="' . esc_url($free_church_post_link) . '">' : '') . ($free_church_post_thumb) . ($free_church_post_link ? '</a>' : '') . '</div>';
}

$free_church_output .= '<div class="post_content">'
			. ($free_church_show_categories 
					? '<div class="post_categories">'
						. free_church_get_post_categories()
						. $free_church_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($free_church_post_link ? '<a href="' . esc_url($free_church_post_link) . '">' : '') . ($free_church_post_title) . ($free_church_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('free_church_filter_get_post_info', 
								'<div class="post_info">'
									. ($free_church_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($free_church_post_link ? '<a href="' . esc_url($free_church_post_link) . '" class="post_info_date">' : '') 
											. esc_html($free_church_post_date) 
											. ($free_church_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($free_church_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'free-church') . ' ' 
											. ($free_church_post_link ? '<a href="' . esc_url($free_church_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($free_church_post_author_name) 
											. ($free_church_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$free_church_show_categories && $free_church_post_counters_output
										? $free_church_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
free_church_storage_set('free_church_output_widgets_posts', $free_church_output);
?>