<?php
/**
 * The style "default" of the Events
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_events');

if ($args['slider']) {
	?><div class="swiper-slide"><?php
} else if ($args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

?><div class="sc_events_classic_top_item_left">

        <?php

            // Event's date
            $date = tribe_get_start_date(null, true, "d-M'y");
            if (empty($date)) $date = get_the_date('d-M');
            $date = explode('-', $date);
            $time = tribe_get_start_time(null, 'l h:i a');


        // Event's date
        ?><div class="sc_events_item_date_monts">
            <span class="sc_events_item_day"><?php echo esc_html($date[0]); ?></span>
                    <span class="sc_events_item_month"><?php echo esc_html($date[1]); ?></span>
            </div>

            <div class="sc_events_item_left">
                <span class="sc_events_item_time"><?php echo esc_html($time); ?></span>
                <span class="sc_events_item_title"><?php the_title(); ?></span>
            </div>

    </div>

    <div class="sc_events_classic_top_item_center">
        <?php if ( tribe_address_exists() ) { ?>
            <span class="sc_events_item_address">
			                    <?php echo tribe_get_full_address(); ?>
		                    </span>
        <?php } ?>
    </div>



    <div class="sc_events_classic_top_item_right sc_item_button">
        <a href="<?php echo esc_url(get_permalink()); ?>" class="sc_event_button_classic_top sc_button sc_button_default3 sc_button_size_large"><span><?php esc_html_e('Read more', 'trx_addons'); ?></span></a>
    </div>


<?php



if ($args['slider'] || $args['columns'] > 1) {
	?></div><?php
}?>