<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

$free_church_blog_style = explode('_', free_church_get_theme_option('blog_style'));
$free_church_columns = empty($free_church_blog_style[1]) ? 1 : max(1, $free_church_blog_style[1]);
$free_church_expanded = !free_church_sidebar_present() && free_church_is_on(free_church_get_theme_option('expand_content'));
$free_church_post_format = get_post_format();
$free_church_post_format = empty($free_church_post_format) ? 'standard' : str_replace('post-format-', '', $free_church_post_format);
$free_church_animation = free_church_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($free_church_columns).' post_format_'.esc_attr($free_church_post_format) ); ?>
	<?php echo (!free_church_is_off($free_church_animation) ? ' data-animation="'.esc_attr(free_church_get_animation_classes($free_church_animation)).'"' : ''); ?>
	>

	<?php
	// Add anchor
	if ($free_church_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.esc_attr(get_the_title()).'"]');
	}

	// Featured image
	free_church_show_post_featured( array(
											'class' => $free_church_columns == 1 ? 'trx-stretch-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => free_church_get_thumb_size(
																	strpos(free_church_get_theme_option('body_style'), 'full')!==false
																		? ( $free_church_columns > 1 ? 'huge' : 'original' )
																		: (	$free_church_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php
			do_action('free_church_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('free_church_action_before_post_meta');

			// Post meta
			$free_church_post_meta = free_church_show_post_meta(array(
									'categories' => false,
									'date' => true,
									'edit' => $free_church_columns == 1,
									'seo' => false,
									'share' => false,
									'counters' => $free_church_columns < 3 ? 'comments,likes' : '',
									'echo' => false
									)
								);
			free_church_show_layout($free_church_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$free_church_show_learn_more = !in_array($free_church_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($free_church_post_format, array('link', 'aside', 'status', 'quote'))) {
					the_content();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($free_church_post_format, array('link', 'aside', 'status', 'quote'))) {
				free_church_show_layout($free_church_post_meta);
			}
			// More button
			if ( $free_church_show_learn_more ) {
				?><p><a class="more-link sc_button sc_button_default2" href="<?php echo esc_url(get_permalink()); ?>"><span><?php esc_html_e('Read more', 'free-church'); ?><span></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>