<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

$free_church_post_format = get_post_format();
$free_church_post_format = empty($free_church_post_format) ? 'standard' : str_replace('post-format-', '', $free_church_post_format);
$free_church_full_content = free_church_get_theme_option('blog_content') != 'excerpt' || in_array($free_church_post_format, array('link', 'aside', 'status', 'quote'));
$free_church_animation = free_church_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($free_church_post_format) ); ?>
	<?php echo (!free_church_is_off($free_church_animation) ? ' data-animation="'.esc_attr(free_church_get_animation_classes($free_church_animation)).'"' : ''); ?>
	><?php

	// Featured image
    if ($free_church_post_format == 'audio') {
        free_church_show_post_featured(array('thumb_size' => free_church_get_thumb_size(strpos(free_church_get_theme_option('body_style'), 'full') !== false ? 'full' : 'big-avatar')));
    }
        else{
        free_church_show_post_featured(array( 'thumb_size' => free_church_get_thumb_size( strpos(free_church_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));
    }

    // Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php

            do_action('free_church_action_before_post_meta');

            // Post meta
            free_church_show_post_meta(array(
                    'categories' => false,
                    'date' => true,
                    'edit' => true,
                    'seo' => false,
                    'share' => false,
                    'counters' => 'comments,likes'	//comments,likes,views - comma separated in any combination
                )
            );


			do_action('free_church_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );


			?>
		</div><!-- .post_header --><?php
	}
	
	// Post content
	?><div class="post_content entry-content"><?php
		if ($free_church_full_content) {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'free-church' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'free-church' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$free_church_show_learn_more = !in_array($free_church_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($free_church_post_format, array('link', 'aside', 'status', 'quote'))) {
					the_content();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php
			// More button
			if ( $free_church_show_learn_more ) {
				?><p><a class="more-link sc_button sc_button_default2" href="<?php echo esc_url(get_permalink()); ?>"><span><?php esc_html_e('Read more', 'free-church'); ?></span></a></p><?php
			}

		}
	?></div><!-- .entry-content -->
</article>