<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

$free_church_blog_style = explode('_', free_church_get_theme_option('blog_style'));
$free_church_columns = empty($free_church_blog_style[1]) ? 2 : max(2, $free_church_blog_style[1]);
$free_church_post_format = get_post_format();
$free_church_post_format = empty($free_church_post_format) ? 'standard' : str_replace('post-format-', '', $free_church_post_format);
$free_church_animation = free_church_get_theme_option('blog_animation');
$free_church_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($free_church_columns).' post_format_'.esc_attr($free_church_post_format) ); ?>
	<?php echo (!free_church_is_off($free_church_animation) ? ' data-animation="'.esc_attr(free_church_get_animation_classes($free_church_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($free_church_image[1]) && !empty($free_church_image[2])) echo intval($free_church_image[1]) .'x' . intval($free_church_image[2]); ?>"
	data-src="<?php if (!empty($free_church_image[0])) echo esc_url($free_church_image[0]); ?>"
	>

	<?php
	$free_church_image_hover = 'icon';	//free_church_get_theme_option('image_hover');
	if (in_array($free_church_image_hover, array('icons', 'zoom'))) $free_church_image_hover = 'dots';
	// Featured image
	free_church_show_post_featured(array(
		'hover' => $free_church_image_hover,
		'thumb_size' => free_church_get_thumb_size( strpos(free_church_get_theme_option('body_style'), 'full')!==false || $free_church_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. free_church_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => false,
									'seo' => false,
									'share' => true,
									'counters' => 'comments',
									'echo' => false
									))
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'free-church') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>