<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('free_church_storage_get')) {
	function free_church_storage_get($var_name, $default='') {
		global $FREE_CHURCH_STORAGE;
		return isset($FREE_CHURCH_STORAGE[$var_name]) ? $FREE_CHURCH_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('free_church_storage_set')) {
	function free_church_storage_set($var_name, $value) {
		global $FREE_CHURCH_STORAGE;
		$FREE_CHURCH_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('free_church_storage_empty')) {
	function free_church_storage_empty($var_name, $key='', $key2='') {
		global $FREE_CHURCH_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($FREE_CHURCH_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($FREE_CHURCH_STORAGE[$var_name][$key]);
		else
			return empty($FREE_CHURCH_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('free_church_storage_isset')) {
	function free_church_storage_isset($var_name, $key='', $key2='') {
		global $FREE_CHURCH_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($FREE_CHURCH_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($FREE_CHURCH_STORAGE[$var_name][$key]);
		else
			return isset($FREE_CHURCH_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('free_church_storage_inc')) {
	function free_church_storage_inc($var_name, $value=1) {
		global $FREE_CHURCH_STORAGE;
		if (empty($FREE_CHURCH_STORAGE[$var_name])) $FREE_CHURCH_STORAGE[$var_name] = 0;
		$FREE_CHURCH_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('free_church_storage_concat')) {
	function free_church_storage_concat($var_name, $value) {
		global $FREE_CHURCH_STORAGE;
		if (empty($FREE_CHURCH_STORAGE[$var_name])) $FREE_CHURCH_STORAGE[$var_name] = '';
		$FREE_CHURCH_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('free_church_storage_get_array')) {
	function free_church_storage_get_array($var_name, $key, $key2='', $default='') {
		global $FREE_CHURCH_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($FREE_CHURCH_STORAGE[$var_name][$key]) ? $FREE_CHURCH_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($FREE_CHURCH_STORAGE[$var_name][$key][$key2]) ? $FREE_CHURCH_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('free_church_storage_set_array')) {
	function free_church_storage_set_array($var_name, $key, $value) {
		global $FREE_CHURCH_STORAGE;
		if (!isset($FREE_CHURCH_STORAGE[$var_name])) $FREE_CHURCH_STORAGE[$var_name] = array();
		if ($key==='')
			$FREE_CHURCH_STORAGE[$var_name][] = $value;
		else
			$FREE_CHURCH_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('free_church_storage_set_array2')) {
	function free_church_storage_set_array2($var_name, $key, $key2, $value) {
		global $FREE_CHURCH_STORAGE;
		if (!isset($FREE_CHURCH_STORAGE[$var_name])) $FREE_CHURCH_STORAGE[$var_name] = array();
		if (!isset($FREE_CHURCH_STORAGE[$var_name][$key])) $FREE_CHURCH_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$FREE_CHURCH_STORAGE[$var_name][$key][] = $value;
		else
			$FREE_CHURCH_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('free_church_storage_merge_array')) {
	function free_church_storage_merge_array($var_name, $key, $value) {
		global $FREE_CHURCH_STORAGE;
		if (!isset($FREE_CHURCH_STORAGE[$var_name])) $FREE_CHURCH_STORAGE[$var_name] = array();
		if ($key==='')
			$FREE_CHURCH_STORAGE[$var_name] = array_merge($FREE_CHURCH_STORAGE[$var_name], $value);
		else
			$FREE_CHURCH_STORAGE[$var_name][$key] = array_merge($FREE_CHURCH_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('free_church_storage_set_array_after')) {
	function free_church_storage_set_array_after($var_name, $after, $key, $value='') {
		global $FREE_CHURCH_STORAGE;
		if (!isset($FREE_CHURCH_STORAGE[$var_name])) $FREE_CHURCH_STORAGE[$var_name] = array();
		if (is_array($key))
			free_church_array_insert_after($FREE_CHURCH_STORAGE[$var_name], $after, $key);
		else
			free_church_array_insert_after($FREE_CHURCH_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('free_church_storage_set_array_before')) {
	function free_church_storage_set_array_before($var_name, $before, $key, $value='') {
		global $FREE_CHURCH_STORAGE;
		if (!isset($FREE_CHURCH_STORAGE[$var_name])) $FREE_CHURCH_STORAGE[$var_name] = array();
		if (is_array($key))
			free_church_array_insert_before($FREE_CHURCH_STORAGE[$var_name], $before, $key);
		else
			free_church_array_insert_before($FREE_CHURCH_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('free_church_storage_push_array')) {
	function free_church_storage_push_array($var_name, $key, $value) {
		global $FREE_CHURCH_STORAGE;
		if (!isset($FREE_CHURCH_STORAGE[$var_name])) $FREE_CHURCH_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($FREE_CHURCH_STORAGE[$var_name], $value);
		else {
			if (!isset($FREE_CHURCH_STORAGE[$var_name][$key])) $FREE_CHURCH_STORAGE[$var_name][$key] = array();
			array_push($FREE_CHURCH_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('free_church_storage_pop_array')) {
	function free_church_storage_pop_array($var_name, $key='', $defa='') {
		global $FREE_CHURCH_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($FREE_CHURCH_STORAGE[$var_name]) && is_array($FREE_CHURCH_STORAGE[$var_name]) && count($FREE_CHURCH_STORAGE[$var_name]) > 0) 
				$rez = array_pop($FREE_CHURCH_STORAGE[$var_name]);
		} else {
			if (isset($FREE_CHURCH_STORAGE[$var_name][$key]) && is_array($FREE_CHURCH_STORAGE[$var_name][$key]) && count($FREE_CHURCH_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($FREE_CHURCH_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('free_church_storage_inc_array')) {
	function free_church_storage_inc_array($var_name, $key, $value=1) {
		global $FREE_CHURCH_STORAGE;
		if (!isset($FREE_CHURCH_STORAGE[$var_name])) $FREE_CHURCH_STORAGE[$var_name] = array();
		if (empty($FREE_CHURCH_STORAGE[$var_name][$key])) $FREE_CHURCH_STORAGE[$var_name][$key] = 0;
		$FREE_CHURCH_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('free_church_storage_concat_array')) {
	function free_church_storage_concat_array($var_name, $key, $value) {
		global $FREE_CHURCH_STORAGE;
		if (!isset($FREE_CHURCH_STORAGE[$var_name])) $FREE_CHURCH_STORAGE[$var_name] = array();
		if (empty($FREE_CHURCH_STORAGE[$var_name][$key])) $FREE_CHURCH_STORAGE[$var_name][$key] = '';
		$FREE_CHURCH_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('free_church_storage_call_obj_method')) {
	function free_church_storage_call_obj_method($var_name, $method, $param=null) {
		global $FREE_CHURCH_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($FREE_CHURCH_STORAGE[$var_name]) ? $FREE_CHURCH_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($FREE_CHURCH_STORAGE[$var_name]) ? $FREE_CHURCH_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('free_church_storage_get_obj_property')) {
	function free_church_storage_get_obj_property($var_name, $prop, $default='') {
		global $FREE_CHURCH_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($FREE_CHURCH_STORAGE[$var_name]->$prop) ? $FREE_CHURCH_STORAGE[$var_name]->$prop : $default;
	}
}
?>