<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0
 */

free_church_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'classie', free_church_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'imagesloaded' );
wp_enqueue_script( 'masonry' );
wp_enqueue_script( 'free_church-gallery-script', free_church_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$free_church_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$free_church_sticky_out = is_array($free_church_stickies) && count($free_church_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$free_church_cat = free_church_get_theme_option('parent_cat');
	$free_church_post_type = free_church_get_theme_option('post_type');
	$free_church_taxonomy = free_church_get_post_type_taxonomy($free_church_post_type);
	$free_church_show_filters = free_church_get_theme_option('show_filters');
	$free_church_tabs = array();
	if (!free_church_is_off($free_church_show_filters)) {
		$free_church_args = array(
			'type'			=> $free_church_post_type,
			'child_of'		=> $free_church_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $free_church_taxonomy,
			'pad_counts'	=> false
		);
		$free_church_portfolio_list = get_terms($free_church_args);
		if (is_array($free_church_portfolio_list) && count($free_church_portfolio_list) > 0) {
			$free_church_tabs[$free_church_cat] = esc_html__('All', 'free-church');
			foreach ($free_church_portfolio_list as $free_church_term) {
				if (isset($free_church_term->term_id)) $free_church_tabs[$free_church_term->term_id] = $free_church_term->name;
			}
		}
	}
	if (count($free_church_tabs) > 0) {
		$free_church_portfolio_filters_ajax = true;
		$free_church_portfolio_filters_active = $free_church_cat;
		$free_church_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters free_church_tabs free_church_tabs_ajax">
			<ul class="portfolio_titles free_church_tabs_titles">
				<?php
				foreach ($free_church_tabs as $free_church_id=>$free_church_title) {
					?><li><a href="<?php echo esc_url(free_church_get_hash_link(sprintf('#%s_%s_content', $free_church_portfolio_filters_id, $free_church_id))); ?>" data-tab="<?php echo esc_attr($free_church_id); ?>"><?php echo esc_html($free_church_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$free_church_ppp = free_church_get_theme_option('posts_per_page');
			if (free_church_is_inherit($free_church_ppp)) $free_church_ppp = '';
			foreach ($free_church_tabs as $free_church_id=>$free_church_title) {
				$free_church_portfolio_need_content = $free_church_id==$free_church_portfolio_filters_active || !$free_church_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $free_church_portfolio_filters_id, $free_church_id)); ?>"
					class="portfolio_content free_church_tabs_content"
					data-blog-template="<?php echo esc_attr(free_church_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(free_church_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($free_church_ppp); ?>"
					data-post-type="<?php echo esc_attr($free_church_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($free_church_taxonomy); ?>"
					data-cat="<?php echo esc_attr($free_church_id); ?>"
					data-parent-cat="<?php echo esc_attr($free_church_cat); ?>"
					data-need-content="<?php echo (false===$free_church_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($free_church_portfolio_need_content) 
						free_church_show_portfolio_posts(array(
							'cat' => $free_church_id,
							'parent_cat' => $free_church_cat,
							'taxonomy' => $free_church_taxonomy,
							'post_type' => $free_church_post_type,
							'page' => 1,
							'sticky' => $free_church_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		free_church_show_portfolio_posts(array(
			'cat' => $free_church_cat,
			'parent_cat' => $free_church_cat,
			'taxonomy' => $free_church_taxonomy,
			'post_type' => $free_church_post_type,
			'page' => 1,
			'sticky' => $free_church_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>