<?php
/* Gutenberg support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'free_church_gutenberg_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'free_church_gutenberg_theme_setup9', 9 );
	function free_church_gutenberg_theme_setup9() {

		add_filter( 'free_church_filter_merge_styles', 'free_church_gutenberg_merge_styles' );
		add_filter( 'free_church_filter_merge_styles_responsive', 'free_church_gutenberg_merge_styles_responsive' );
		add_action( 'enqueue_block_editor_assets', 'free_church_gutenberg_editor_scripts' );

		if ( is_admin() ) {
			add_filter( 'free_church_filter_tgmpa_required_plugins', 'free_church_gutenberg_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'free_church_gutenberg_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('free_church_filter_tgmpa_required_plugins',	'free_church_gutenberg_tgmpa_required_plugins');
	function free_church_gutenberg_tgmpa_required_plugins( $list = array() ) {
		if ( free_church_storage_isset( 'required_plugins', 'gutenberg' ) ) {
			$list[] = array(
				'name'     => free_church_storage_get_array( 'required_plugins', 'gutenberg' ),
				'slug'     => 'gutenberg',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if Gutenberg is installed and activated
if ( ! function_exists( 'free_church_exists_gutenberg' ) ) {
	function free_church_exists_gutenberg() {
		return function_exists( 'register_block_type' );	// && function_exists( 'the_gutenberg_project' )
	}
}

// Return true if Gutenberg exists and current mode is preview
if ( ! function_exists( 'free_church_gutenberg_is_preview' ) ) {
	function free_church_gutenberg_is_preview() {
		return false;
	}
}

// Merge custom styles
if ( ! function_exists( 'free_church_gutenberg_merge_styles' ) ) {
	//Handler of the add_filter('free_church_filter_merge_styles', 'free_church_gutenberg_merge_styles');
	function free_church_gutenberg_merge_styles( $list ) {
		if ( free_church_exists_gutenberg() ) {
			$list[] = 'plugins/gutenberg/_gutenberg.scss';
		}
		return $list;
	}
}

// Merge responsive styles
if ( ! function_exists( 'free_church_gutenberg_merge_styles_responsive' ) ) {
	//Handler of the add_filter('free_church_filter_merge_styles_responsive', 'free_church_gutenberg_merge_styles_responsive');
	function free_church_gutenberg_merge_styles_responsive( $list ) {
		if ( free_church_exists_gutenberg() ) {
			$list[] = 'plugins/gutenberg/_gutenberg-responsive.scss';
		}
		return $list;
	}
}


// Load required styles and scripts for Gutenberg Editor mode
if ( ! function_exists( 'free_church_gutenberg_editor_scripts' ) ) {
	//Handler of the add_action( 'enqueue_block_editor_assets', 'free_church_gutenberg_editor_scripts');
	function free_church_gutenberg_editor_scripts() {
		if ( free_church_get_theme_setting( 'allow_gutenberg_blocks' ) ) {
			// Links to selected fonts
			$links = free_church_theme_fonts_links();
			if ( count( $links ) > 0 ) {
				foreach ( $links as $slug => $link ) {
					wp_enqueue_style( sprintf( 'free-church-font-%s', $slug ), $link, array(), null );
				}
			}
			// Font icons styles must be loaded before main stylesheet
			wp_enqueue_style( 'free-church-icons', free_church_get_file_url( 'css/font-icons/css/fontello-embedded.css' ), array(), null );
			// Editor styles
			wp_enqueue_style( 'free-church-gutenberg-preview', free_church_get_file_url( 'plugins/gutenberg/gutenberg-preview.css' ), array(), null );
		}
	}
}

// Save CSS with custom colors and fonts to the gutenberg-editor-style.css
if ( ! function_exists( 'free_church_gutenberg_save_css' ) ) {
	add_action( 'free_church_action_save_options', 'free_church_gutenberg_save_css', 30 );
	add_action( 'trx_addons_action_save_options', 'free_church_gutenberg_save_css', 30 );
	function free_church_gutenberg_save_css() {

		if ( ! free_church_get_theme_setting( 'allow_gutenberg_blocks' ) ) {
			return;
		}

		$msg = '/* ' . esc_html__( "ATTENTION! This file was generated automatically! Don't change it!!!", 'free-church' )
				. "\n----------------------------------------------------------------------- */\n";

		// Get main styles
		$css = free_church_fgc( free_church_get_file_dir( 'style.css' ) );

		// Append theme-vars styles
		$css .= free_church_customizer_get_css(
			array(
				'colors' => free_church_get_theme_setting( 'separate_schemes' ) ? false : null,
			)
		);
		
		// Append color schemes
		if ( free_church_get_theme_setting( 'separate_schemes' ) ) {
			$schemes = free_church_get_sorted_schemes();
			if ( is_array( $schemes ) ) {
				foreach ( $schemes as $scheme => $data ) {
					$css .= free_church_customizer_get_css(
						array(
							'fonts'  => false,
							'colors' => $data['colors'],
							'scheme' => $scheme,
						)
					);
				}
			}
		}

		// Add context class to each selector
		if ( function_exists( 'trx_addons_css_add_context' ) ) {
			$css = trx_addons_css_add_context($css, '.edit-post-visual-editor');
		}

		// Save styles to the file
		free_church_fpc( free_church_get_file_dir( 'plugins/gutenberg/gutenberg-preview.css' ), $msg . $css );
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( free_church_exists_gutenberg() ) {
	require_once BASEKIT_THEME_DIR . 'plugins/gutenberg/gutenberg-styles.php';
}
