<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('free_church_instagram_feed_theme_setup9')) {
	add_action( 'after_setup_theme', 'free_church_instagram_feed_theme_setup9', 9 );
	function free_church_instagram_feed_theme_setup9() {
		if (is_admin()) {
			add_filter( 'free_church_filter_tgmpa_required_plugins',		'free_church_instagram_feed_tgmpa_required_plugins' );
		}
	}
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'free_church_exists_instagram_feed' ) ) {
	function free_church_exists_instagram_feed() {
		return defined('SBIVER');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'free_church_instagram_feed_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('free_church_filter_tgmpa_required_plugins',	'free_church_instagram_feed_tgmpa_required_plugins');
	function free_church_instagram_feed_tgmpa_required_plugins($list=array()) {
		if (in_array('instagram-feed', free_church_storage_get('required_plugins')))
			$list[] = array(
					'name' 		=> esc_html__('Instagram Feed', 'free-church'),
					'slug' 		=> 'instagram-feed',
					'required' 	=> false
				);
		return $list;
	}
}
?>