<?php
/* ThemeREX Donations support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
if (!function_exists('free_church_trx_donations_theme_setup1')) {
	add_action( 'after_setup_theme', 'free_church_trx_donations_theme_setup1', 1 );
	function free_church_trx_donations_theme_setup1() {
		add_filter( 'free_church_filter_list_posts_types',	'free_church_trx_donations_list_post_types');
	}
}

// Theme init priorities:
// 3 - add/remove Theme Options elements
if (!function_exists('free_church_trx_donations_theme_setup3')) {
	add_action( 'after_setup_theme', 'free_church_trx_donations_theme_setup3', 3 );
	function free_church_trx_donations_theme_setup3() {
		if (free_church_exists_trx_donations()) {
		
			free_church_storage_merge_array('options', '', array(
				// Section 'Donations' - settings to show pages with Donations posts
				'donations' => array(
					"title" => esc_html__('Donations', 'free-church'),
					"desc" => wp_kses_data( __('Select parameters to display the donations pages', 'free-church') ),
					"type" => "section"
					),
				'expand_content_donations' => array(
					"title" => esc_html__('Expand content', 'free-church'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'free-church') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
				'header_style_donations' => array(
					"title" => esc_html__('Header style', 'free-church'),
					"desc" => wp_kses_data( __('Select style to display the site header on the donations pages', 'free-church') ),
					"std" => 'inherit',
					"options" => array(),
					"type" => "select"
					),
				'header_position_donations' => array(
					"title" => esc_html__('Header position', 'free-church'),
					"desc" => wp_kses_data( __('Select position to display the site header on the donations pages', 'free-church') ),
					"std" => 'inherit',
					"options" => array(),
					"type" => "select"
					),
				'header_widgets_donations' => array(
					"title" => esc_html__('Header widgets', 'free-church'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on the donations pages', 'free-church') ),
					"std" => 'hide',
					"options" => array(),
					"type" => "select"
					),
				'sidebar_widgets_donations' => array(
					"title" => esc_html__('Sidebar widgets', 'free-church'),
					"desc" => wp_kses_data( __('Select sidebar to show on the donations pages', 'free-church') ),
					"std" => 'hide',
					"options" => array(),
					"type" => "select"
					),
				'sidebar_position_donations' => array(
					"title" => esc_html__('Sidebar position', 'free-church'),
					"desc" => wp_kses_data( __('Select position to show sidebar on the donations pages', 'free-church') ),
					"refresh" => false,
					"std" => 'left',
					"options" => array(),
					"type" => "select"
					),
				'hide_sidebar_on_single_donations' => array(
					"title" => esc_html__('Hide sidebar on the single donation', 'free-church'),
					"desc" => wp_kses_data( __("Hide sidebar on the single donation's page", 'free-church') ),
					"std" => 0,
					"type" => "checkbox"
					),
				'widgets_above_page_donations' => array(
					"title" => esc_html__('Widgets above the page', 'free-church'),
					"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'free-church') ),
					"std" => 'hide',
					"options" => array(),
					"type" => "select"
					),
				'widgets_above_content_donations' => array(
					"title" => esc_html__('Widgets above the content', 'free-church'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'free-church') ),
					"std" => 'hide',
					"options" => array(),
					"type" => "select"
					),
				'widgets_below_content_donations' => array(
					"title" => esc_html__('Widgets below the content', 'free-church'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'free-church') ),
					"std" => 'hide',
					"options" => array(),
					"type" => "select"
					),
				'widgets_below_page_donations' => array(
					"title" => esc_html__('Widgets below the page', 'free-church'),
					"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'free-church') ),
					"std" => 'hide',
					"options" => array(),
					"type" => "select"
					),
				'footer_scheme_donations' => array(
					"title" => esc_html__('Footer Color Scheme', 'free-church'),
					"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'free-church') ),
					"std" => 'dark',
					"options" => array(),
					"type" => "select"
					),
				'footer_widgets_donations' => array(
					"title" => esc_html__('Footer widgets', 'free-church'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'free-church') ),
					"std" => 'footer_widgets',
					"options" => array(),
					"type" => "select"
					),
				'footer_columns_donations' => array(
					"title" => esc_html__('Footer columns', 'free-church'),
					"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'free-church') ),
					"dependency" => array(
						'footer_widgets_donations' => array('^hide')
					),
					"std" => 0,
					"options" => free_church_get_list_range(0,6),
					"type" => "select"
					),
				'footer_wide_donations' => array(
					"title" => esc_html__('Footer fullwide', 'free-church'),
					"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'free-church') ),
					"std" => 0,
					"type" => "checkbox"
					)
				)
			);
		}
	}
}

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('free_church_trx_donations_theme_setup9')) {
	add_action( 'after_setup_theme', 'free_church_trx_donations_theme_setup9', 9 );
	function free_church_trx_donations_theme_setup9() {
		
		if (free_church_exists_trx_donations()) {
			add_action( 'wp_enqueue_scripts', 								'free_church_trx_donations_frontend_scripts', 1100 );
			add_filter( 'free_church_filter_merge_styles',						'free_church_trx_donations_merge_styles' );
			add_filter( 'free_church_filter_get_css',							'free_church_trx_donations_get_css', 10, 4 );
			add_filter( 'free_church_filter_get_post_info',		 				'free_church_trx_donations_get_post_info');
			add_filter( 'free_church_filter_post_type_taxonomy',				'free_church_trx_donations_post_type_taxonomy', 10, 2 );
			if (!is_admin()) {
				add_filter( 'free_church_filter_detect_blog_mode',				'free_church_trx_donations_detect_blog_mode' );
				add_filter( 'free_church_filter_get_post_categories', 			'free_church_trx_donations_get_post_categories');
				add_action( 'free_church_action_before_post_meta',				'free_church_trx_donations_action_before_post_meta');
			}
		}
		if (is_admin()) {
			add_filter( 'free_church_filter_tgmpa_required_plugins',			'free_church_trx_donations_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'free_church_trx_donations_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('free_church_filter_tgmpa_required_plugins',	'free_church_trx_donations_tgmpa_required_plugins');
	function free_church_trx_donations_tgmpa_required_plugins($list=array()) {
		if (in_array('trx_donations', free_church_storage_get('required_plugins'))) {
			$path = free_church_get_file_dir('plugins/trx_donations/trx_donations.zip');
			$list[] = array(
					'name' 		=> esc_html__('ThemeREX Donations', 'free-church'),
					'slug' 		=> 'trx_donations',
					'version'	=> '1.4',
					'source'	=> !empty($path) ? $path : 'upload://trx_donations.zip',
					'required' 	=> false
			);
		}
		return $list;
	}
}



// Check if trx_donations installed and activated
if ( !function_exists( 'free_church_exists_trx_donations' ) ) {
	function free_church_exists_trx_donations() {
		return class_exists('TRX_DONATIONS');
	}
}

// Return true, if current page is any trx_donations page
if ( !function_exists( 'free_church_is_trx_donations_page' ) ) {
	function free_church_is_trx_donations_page() {
		$rez = false;
		if (free_church_exists_trx_donations()) {
			$rez = (is_single() && get_query_var('post_type') == TRX_DONATIONS::POST_TYPE) 
					|| is_post_type_archive(TRX_DONATIONS::POST_TYPE) 
					|| is_tax(TRX_DONATIONS::TAXONOMY);
		}
		return $rez;
	}
}

// Detect current blog mode
if ( !function_exists( 'free_church_trx_donations_detect_blog_mode' ) ) {
	//Handler of the add_filter( 'free_church_filter_detect_blog_mode', 'free_church_trx_donations_detect_blog_mode' );
	function free_church_trx_donations_detect_blog_mode($mode='') {
		if (free_church_is_trx_donations_page())
			$mode = 'donations';
		return $mode;
	}
}

// Return taxonomy for current post type
if ( !function_exists( 'free_church_trx_donations_post_type_taxonomy' ) ) {
	//Handler of the add_filter( 'free_church_filter_post_type_taxonomy',	'free_church_trx_donations_post_type_taxonomy', 10, 2 );
	function free_church_trx_donations_post_type_taxonomy($tax='', $post_type='') {
		if (free_church_exists_trx_donations() && $post_type == TRX_DONATIONS::POST_TYPE)
			$tax = TRX_DONATIONS::TAXONOMY;
		return $tax;
	}
}

// Show categories of the current product
if ( !function_exists( 'free_church_trx_donations_get_post_categories' ) ) {
	//Handler of the add_filter( 'free_church_filter_get_post_categories', 		'free_church_trx_donations_get_post_categories');
	function free_church_trx_donations_get_post_categories($cats='') {
		if ( free_church_exists_trx_donations() && get_post_type()==TRX_DONATIONS::POST_TYPE ) {
			$cats = free_church_get_post_terms(', ', get_the_ID(), TRX_DONATIONS::TAXONOMY);
		}
		return $cats;
	}
}

// Add 'donation' to the list of the supported post-types
if ( !function_exists( 'free_church_trx_donations_list_post_types' ) ) {
	//Handler of the add_filter( 'free_church_filter_list_posts_types', 'free_church_trx_donations_list_post_types');
	function free_church_trx_donations_list_post_types($list=array()) {
		if (free_church_exists_trx_donations())
			$list[TRX_DONATIONS::POST_TYPE] = esc_html__('Donations', 'free-church');
		return $list;
	}
}

// Show price of the current product in the widgets and search results
if ( !function_exists( 'free_church_trx_donations_get_post_info' ) ) {
	//Handler of the add_filter( 'free_church_filter_get_post_info', 'free_church_trx_donations_get_post_info');
	function free_church_trx_donations_get_post_info($post_info='') {
		if (free_church_exists_trx_donations()) {
			if (get_post_type()==TRX_DONATIONS::POST_TYPE) {
				// Goal and raised
				$goal = get_post_meta( get_the_ID(), 'trx_donations_goal', true );
				if (!empty($goal)) {
					$raised = get_post_meta( get_the_ID(), 'trx_donations_raised', true );
					if (empty($raised)) $raised = 0;
					$manual = get_post_meta( get_the_ID(), 'trx_donations_manual', true );
					$plugin = TRX_DONATIONS::get_instance();
					$post_info .= '<div class="post_info post_meta post_donation_info">'
										. '<span class="post_info_item post_meta_item post_donation_item post_donation_goal">'
											. '<span class="post_info_label post_meta_label post_donation_label">' . esc_html__('Group goal:', 'free-church') . '</span>'
											. ' ' 
											. '<span class="post_info_number post_meta_number post_donation_number">' . trim($plugin->get_money($goal)) . '</span>'
										. '</span>'
										. '<span class="post_info_item post_meta_item post_donation_item post_donation_raised">'
											. '<span class="post_info_label post_meta_label post_donation_label">' . esc_html__('Raised:', 'free-church') . '</span>'
											. ' '
											. '<span class="post_info_number post_meta_number post_donation_number">' . trim($plugin->get_money($raised+$manual)) . ' (' . round(($raised+$manual)*100/$goal, 2) . '%)' . '</span>'
										. '</span>'
									. '</div>';
				}
			}
		}
		return $post_info;
	}
}

// Show price of the current product in the search results streampage
if ( !function_exists( 'free_church_trx_donations_action_before_post_meta' ) ) {
	//Handler of the add_action( 'free_church_action_before_post_meta', 'free_church_trx_donations_action_before_post_meta');
	function free_church_trx_donations_action_before_post_meta() {
		free_church_show_layout(free_church_trx_donations_get_post_info());
	}
}
	
// Enqueue trx_donations custom styles
if ( !function_exists( 'free_church_trx_donations_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'free_church_trx_donations_frontend_scripts', 1100 );
	function free_church_trx_donations_frontend_scripts() {
		if (free_church_is_on(free_church_get_theme_option('debug_mode')) && free_church_get_file_dir('plugins/trx_donations/trx_donations.css')!='')
			wp_enqueue_style( 'free_church-trx_donations',  free_church_get_file_url('plugins/trx_donations/trx_donations.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'free_church_trx_donations_merge_styles' ) ) {
	//Handler of the add_filter('free_church_filter_merge_styles', 'free_church_trx_donations_merge_styles');
	function free_church_trx_donations_merge_styles($list) {
		$list[] = 'plugins/trx_donations/trx_donations.css';
		return $list;
	}
}

// Return text for the "I agree ..." checkbox
if ( ! function_exists( 'free_church_trx_donations_privacy_text' ) ) {
    //Handler of the add_filter( 'trx_donations_filter_privacy_text', 'free_church_trx_donations_privacy_text' );
    function free_church_trx_donations_privacy_text( $text='' ) {
        return free_church_get_privacy_text();
    }
}

// Add plugin-specific styles to the color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'free_church_trx_donations_get_css' ) ) {
	//Handler of the add_filter( 'free_church_filter_get_css', 'free_church_trx_donations_get_css', 10, 4 );
	function free_church_trx_donations_get_css($css, $colors, $fonts, $scheme='') {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS
CSS;
		}

		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS
			.sc_donations.sc_donations_style_excerpt .sc_donations_descr{
			     color: {$colors['text_light']};
			}
			.post_info_donations .post_raised{
			    color: {$colors['text_hover']};
			}
			.post_info_donations .middle{
			    background-color: {$colors['input_bd_hover']};
			}
			.post_info_donations .middle{
			    background-color: {$colors['input_bd_hover']};
			}
			.post_info_donations .middle > span{
			    background-color: {$colors['text_link']};
			}



CSS;
		}
		
		return $css;
	}
}
?>