<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage FREE_CHURCH
 * @since FREE_CHURCH 1.0.10
 */

// Logo
if (free_church_is_on(free_church_get_theme_option('logo_in_footer'))) {
	$free_church_logo_image = '';
	if (free_church_get_retina_multiplier(2) > 1)
		$free_church_logo_image = free_church_get_theme_option( 'logo_footer_retina' );
	if (empty($free_church_logo_image)) 
		$free_church_logo_image = free_church_get_theme_option( 'logo_footer' );
	$free_church_logo_text   = get_bloginfo( 'name' );
	if (!empty($free_church_logo_image) || !empty($free_church_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($free_church_logo_image)) {
					$free_church_attr = free_church_getimagesize($free_church_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($free_church_logo_image).'" class="logo_footer_image" alt="'.esc_attr__('img', 'free-church').'"'.(!empty($free_church_attr[3]) ? sprintf(' %s', $free_church_attr[3]) : '').'></a>' ;
				} else if (!empty($free_church_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($free_church_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>