DROP TABLE IF EXISTS wpy4_actionscheduler_actions;

CREATE TABLE `wpy4_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=197 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS wpy4_actionscheduler_claims;

CREATE TABLE `wpy4_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS wpy4_actionscheduler_groups;

CREATE TABLE `wpy4_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS wpy4_actionscheduler_logs;

CREATE TABLE `wpy4_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS wpy4_commentmeta;

CREATE TABLE `wpy4_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS wpy4_comments;

CREATE TABLE `wpy4_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS wpy4_layerslider;

CREATE TABLE `wpy4_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `slug` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT '0',
  `schedule_end` int(10) NOT NULL DEFAULT '0',
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wpy4_layerslider VALUES("1", "1", "home", "", "{\"properties\":{\"sliderVersion\":\"6.0.1\",\"title\":\"home\",\"new\":true},\"layers\":[[]]}", "1569904220", "1569904220", "0", "0", "0", "0");

DROP TABLE IF EXISTS wpy4_links;

CREATE TABLE `wpy4_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


DROP TABLE IF EXISTS wpy4_options;

CREATE TABLE `wpy4_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=281237 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wpy4_options VALUES("1", "siteurl", "http://www.heavenlykey.org", "yes");
INSERT INTO wpy4_options VALUES("2", "home", "http://www.heavenlykey.org", "yes");
INSERT INTO wpy4_options VALUES("3", "blogname", "Endtime Non-denominational Evangelistic Movement", "yes");
INSERT INTO wpy4_options VALUES("4", "blogdescription", "“ EARNESTLY CONTEND FOR THE FAITH WHICH WAS ONCE DELIVERED UNTO THE SAINTS &quot; JUDE 3", "yes");
INSERT INTO wpy4_options VALUES("5", "users_can_register", "0", "yes");
INSERT INTO wpy4_options VALUES("6", "admin_email", "alldaywow247@gmail.com", "yes");
INSERT INTO wpy4_options VALUES("7", "start_of_week", "1", "yes");
INSERT INTO wpy4_options VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO wpy4_options VALUES("9", "use_smilies", "1", "yes");
INSERT INTO wpy4_options VALUES("10", "require_name_email", "1", "yes");
INSERT INTO wpy4_options VALUES("11", "comments_notify", "1", "yes");
INSERT INTO wpy4_options VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO wpy4_options VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO wpy4_options VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO wpy4_options VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO wpy4_options VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO wpy4_options VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO wpy4_options VALUES("18", "default_category", "1", "yes");
INSERT INTO wpy4_options VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO wpy4_options VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO wpy4_options VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO wpy4_options VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO wpy4_options VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO wpy4_options VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO wpy4_options VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO wpy4_options VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO wpy4_options VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO wpy4_options VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO wpy4_options VALUES("29", "rewrite_rules", "a:239:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:10:\"gallery/?$\";s:27:\"index.php?post_type=gallery\";s:40:\"gallery/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=gallery&feed=$matches[1]\";s:35:\"gallery/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=gallery&feed=$matches[1]\";s:27:\"gallery/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=gallery&paged=$matches[1]\";s:8:\"staff/?$\";s:25:\"index.php?post_type=staff\";s:38:\"staff/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=staff&feed=$matches[1]\";s:33:\"staff/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=staff&feed=$matches[1]\";s:25:\"staff/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=staff&paged=$matches[1]\";s:8:\"event/?$\";s:25:\"index.php?post_type=event\";s:38:\"event/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:33:\"event/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:25:\"event/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=event&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"sermons-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?sermons-category=$matches[1]&feed=$matches[2]\";s:52:\"sermons-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?sermons-category=$matches[1]&feed=$matches[2]\";s:33:\"sermons-category/([^/]+)/embed/?$\";s:49:\"index.php?sermons-category=$matches[1]&embed=true\";s:45:\"sermons-category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?sermons-category=$matches[1]&paged=$matches[2]\";s:27:\"sermons-category/([^/]+)/?$\";s:38:\"index.php?sermons-category=$matches[1]\";s:52:\"sermons-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?sermons-tag=$matches[1]&feed=$matches[2]\";s:47:\"sermons-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?sermons-tag=$matches[1]&feed=$matches[2]\";s:28:\"sermons-tag/([^/]+)/embed/?$\";s:44:\"index.php?sermons-tag=$matches[1]&embed=true\";s:40:\"sermons-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?sermons-tag=$matches[1]&paged=$matches[2]\";s:22:\"sermons-tag/([^/]+)/?$\";s:33:\"index.php?sermons-tag=$matches[1]\";s:57:\"sermons-speakers/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?sermons-speakers=$matches[1]&feed=$matches[2]\";s:52:\"sermons-speakers/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?sermons-speakers=$matches[1]&feed=$matches[2]\";s:33:\"sermons-speakers/([^/]+)/embed/?$\";s:49:\"index.php?sermons-speakers=$matches[1]&embed=true\";s:45:\"sermons-speakers/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?sermons-speakers=$matches[1]&paged=$matches[2]\";s:27:\"sermons-speakers/([^/]+)/?$\";s:38:\"index.php?sermons-speakers=$matches[1]\";s:35:\"sermons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"sermons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"sermons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"sermons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"sermons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"sermons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"sermons/([^/]+)/embed/?$\";s:40:\"index.php?sermons=$matches[1]&embed=true\";s:28:\"sermons/([^/]+)/trackback/?$\";s:34:\"index.php?sermons=$matches[1]&tb=1\";s:36:\"sermons/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?sermons=$matches[1]&paged=$matches[2]\";s:43:\"sermons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?sermons=$matches[1]&cpage=$matches[2]\";s:32:\"sermons/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?sermons=$matches[1]&page=$matches[2]\";s:24:\"sermons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"sermons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"sermons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"sermons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"sermons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"sermons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"ocean_posts_slider/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"ocean_posts_slider/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"ocean_posts_slider/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"ocean_posts_slider/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"ocean_posts_slider/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"ocean_posts_slider/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"ocean_posts_slider/([^/]+)/embed/?$\";s:51:\"index.php?ocean_posts_slider=$matches[1]&embed=true\";s:39:\"ocean_posts_slider/([^/]+)/trackback/?$\";s:45:\"index.php?ocean_posts_slider=$matches[1]&tb=1\";s:47:\"ocean_posts_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?ocean_posts_slider=$matches[1]&paged=$matches[2]\";s:54:\"ocean_posts_slider/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?ocean_posts_slider=$matches[1]&cpage=$matches[2]\";s:43:\"ocean_posts_slider/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?ocean_posts_slider=$matches[1]&page=$matches[2]\";s:35:\"ocean_posts_slider/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"ocean_posts_slider/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"ocean_posts_slider/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"ocean_posts_slider/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"ocean_posts_slider/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"ocean_posts_slider/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"gallery-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?gallery-category=$matches[1]&feed=$matches[2]\";s:52:\"gallery-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?gallery-category=$matches[1]&feed=$matches[2]\";s:33:\"gallery-category/([^/]+)/embed/?$\";s:49:\"index.php?gallery-category=$matches[1]&embed=true\";s:45:\"gallery-category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?gallery-category=$matches[1]&paged=$matches[2]\";s:27:\"gallery-category/([^/]+)/?$\";s:38:\"index.php?gallery-category=$matches[1]\";s:35:\"gallery/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"gallery/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"gallery/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"gallery/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"gallery/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"gallery/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"gallery/([^/]+)/embed/?$\";s:40:\"index.php?gallery=$matches[1]&embed=true\";s:28:\"gallery/([^/]+)/trackback/?$\";s:34:\"index.php?gallery=$matches[1]&tb=1\";s:48:\"gallery/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?gallery=$matches[1]&feed=$matches[2]\";s:43:\"gallery/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?gallery=$matches[1]&feed=$matches[2]\";s:36:\"gallery/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?gallery=$matches[1]&paged=$matches[2]\";s:43:\"gallery/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?gallery=$matches[1]&cpage=$matches[2]\";s:32:\"gallery/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?gallery=$matches[1]&page=$matches[2]\";s:24:\"gallery/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"gallery/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"gallery/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"gallery/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"gallery/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"gallery/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"staff-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?staff-category=$matches[1]&feed=$matches[2]\";s:50:\"staff-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?staff-category=$matches[1]&feed=$matches[2]\";s:31:\"staff-category/([^/]+)/embed/?$\";s:47:\"index.php?staff-category=$matches[1]&embed=true\";s:43:\"staff-category/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?staff-category=$matches[1]&paged=$matches[2]\";s:25:\"staff-category/([^/]+)/?$\";s:36:\"index.php?staff-category=$matches[1]\";s:33:\"staff/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"staff/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"staff/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"staff/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"staff/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"staff/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"staff/([^/]+)/embed/?$\";s:38:\"index.php?staff=$matches[1]&embed=true\";s:26:\"staff/([^/]+)/trackback/?$\";s:32:\"index.php?staff=$matches[1]&tb=1\";s:46:\"staff/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?staff=$matches[1]&feed=$matches[2]\";s:41:\"staff/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?staff=$matches[1]&feed=$matches[2]\";s:34:\"staff/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?staff=$matches[1]&paged=$matches[2]\";s:41:\"staff/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?staff=$matches[1]&cpage=$matches[2]\";s:30:\"staff/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?staff=$matches[1]&page=$matches[2]\";s:22:\"staff/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"staff/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"staff/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"staff/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"staff/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"staff/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"event-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?event-category=$matches[1]&feed=$matches[2]\";s:50:\"event-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?event-category=$matches[1]&feed=$matches[2]\";s:31:\"event-category/([^/]+)/embed/?$\";s:47:\"index.php?event-category=$matches[1]&embed=true\";s:43:\"event-category/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?event-category=$matches[1]&paged=$matches[2]\";s:25:\"event-category/([^/]+)/?$\";s:36:\"index.php?event-category=$matches[1]\";s:33:\"event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"event/([^/]+)/embed/?$\";s:38:\"index.php?event=$matches[1]&embed=true\";s:26:\"event/([^/]+)/trackback/?$\";s:32:\"index.php?event=$matches[1]&tb=1\";s:46:\"event/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:41:\"event/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:34:\"event/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&paged=$matches[2]\";s:41:\"event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&cpage=$matches[2]\";s:30:\"event/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?event=$matches[1]&page=$matches[2]\";s:22:\"event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=17&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO wpy4_options VALUES("30", "hack_file", "0", "yes");
INSERT INTO wpy4_options VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO wpy4_options VALUES("32", "moderation_keys", "", "no");
INSERT INTO wpy4_options VALUES("33", "active_plugins", "a:10:{i:0;s:39:\"advanced-wp-reset/advanced-wp-reset.php\";i:1;s:19:\"jetpack/jetpack.php\";i:2;s:27:\"js_composer/js_composer.php\";i:3;s:35:\"litespeed-cache/litespeed-cache.php\";i:4;s:41:\"mega-addons-for-visual-composer/index.php\";i:5;s:39:\"nativechurch-core/nativechurch-core.php\";i:6;s:41:\"ocean-posts-slider/ocean-posts-slider.php\";i:7;s:33:\"post-slider-wd/post-slider-wd.php\";i:8;s:23:\"wordfence/wordfence.php\";i:9;s:34:\"wp-clone-by-wp-academy/wpclone.php\";}", "yes");
INSERT INTO wpy4_options VALUES("34", "category_base", "", "yes");
INSERT INTO wpy4_options VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO wpy4_options VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO wpy4_options VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO wpy4_options VALUES("38", "default_email_category", "1", "yes");
INSERT INTO wpy4_options VALUES("39", "recently_edited", "a:3:{i:0;s:76:\"/home/oheifer1/heavenlykey.org/wp-content/themes/accesspress-lite/footer.php\";i:2;s:75:\"/home/oheifer1/heavenlykey.org/wp-content/themes/accesspress-lite/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO wpy4_options VALUES("40", "template", "accesspress-lite", "yes");
INSERT INTO wpy4_options VALUES("41", "stylesheet", "accesspress-lite", "yes");
INSERT INTO wpy4_options VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO wpy4_options VALUES("43", "blacklist_keys", "", "no");
INSERT INTO wpy4_options VALUES("44", "comment_registration", "0", "yes");
INSERT INTO wpy4_options VALUES("45", "html_type", "text/html", "yes");
INSERT INTO wpy4_options VALUES("46", "use_trackback", "0", "yes");
INSERT INTO wpy4_options VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO wpy4_options VALUES("48", "db_version", "47018", "yes");
INSERT INTO wpy4_options VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO wpy4_options VALUES("50", "upload_path", "", "yes");
INSERT INTO wpy4_options VALUES("51", "blog_public", "1", "yes");
INSERT INTO wpy4_options VALUES("52", "default_link_category", "2", "yes");
INSERT INTO wpy4_options VALUES("53", "show_on_front", "page", "yes");
INSERT INTO wpy4_options VALUES("54", "tag_base", "", "yes");
INSERT INTO wpy4_options VALUES("55", "show_avatars", "1", "yes");
INSERT INTO wpy4_options VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO wpy4_options VALUES("57", "upload_url_path", "", "yes");
INSERT INTO wpy4_options VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO wpy4_options VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO wpy4_options VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO wpy4_options VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO wpy4_options VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO wpy4_options VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO wpy4_options VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO wpy4_options VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO wpy4_options VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO wpy4_options VALUES("67", "image_default_size", "", "yes");
INSERT INTO wpy4_options VALUES("68", "image_default_align", "", "yes");
INSERT INTO wpy4_options VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO wpy4_options VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO wpy4_options VALUES("71", "thread_comments", "1", "yes");
INSERT INTO wpy4_options VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO wpy4_options VALUES("73", "page_comments", "0", "yes");
INSERT INTO wpy4_options VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO wpy4_options VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO wpy4_options VALUES("76", "comment_order", "asc", "yes");
INSERT INTO wpy4_options VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("78", "widget_categories", "a:3:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("79", "widget_text", "a:11:{i:1;a:0:{}i:3;a:4:{s:5:\"title\";s:22:\"Online Christian Radio\";s:4:\"text\";s:245:\"<a href=\"https://radio.dclm.org/\" target=\"_blank\" rel=\"noopener\"><img class=\"wp-image-101 aligncenter\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/724aef_d0b3ac04f4f345cfbc8d247ddbee2533.gif\" alt=\"\" width=\"206\" height=\"188\" /></a>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:6;a:4:{s:5:\"title\";s:13:\"ONLINE GIVING\";s:4:\"text\";s:528:\"Partnership - PAYING YOUR TITHES, OFFERINGS, AND DONATIONS INTO THIS MINISTRY “Give and it shall be given back to you…” (Luke 11:35).

<a href=\"https://paystack.com/pay/hekem\" target=\"_blank\" rel=\"noopener\"><img class=\"alignnone size-medium wp-image-193\" src=\"http://www.heavenlykey.org/wp-content/uploads/2020/06/payment-300x100.gif\" alt=\"\" width=\"300\" height=\"100\" /></a>
<h3><a href=\"https://paystack.com/pay/hekem\" target=\"_blank\" rel=\"noopener noreferrer\">ONLINE CARD PAYMENT/TRANSFER CLICK HERE </a></h3>
&nbsp;\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:7;a:4:{s:5:\"title\";s:22:\"Are you rapture ready?\";s:4:\"text\";s:391:\"<strong>                     1 Corinthians 15:52</strong>

In a moment, in the twinkling of an eye, at the last trump: for the trumpet shall sound, and the dead shall be raised incorruptible, and we shall be changed.<img class=\"size-medium wp-image-137 aligncenter\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/tenor-300x224.gif\" alt=\"\" width=\"300\" height=\"224\" />\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:8;a:4:{s:5:\"title\";s:18:\"Biblical Teachings\";s:4:\"text\";s:2754:\"<strong><a class=\"row-title\" href=\"http://www.heavenlykey.org/wp-admin/term.php?taxonomy=category&amp;tag_ID=3&amp;post_type=post&amp;wp_http_referer=%2Fwp-admin%2Fedit-tags.php%3Ftaxonomy%3Dcategory\" aria-label=\"“Salvation, Deliverance &amp; Freedom from Sin” (Edit)\">Salvation, Deliverance &amp; Freedom from Sin</a></strong>

<strong><a class=\"row-title\" href=\"http://www.heavenlykey.org/wp-admin/term.php?taxonomy=category&amp;tag_ID=4&amp;post_type=post&amp;wp_http_referer=%2Fwp-admin%2Fedit-tags.php%3Ftaxonomy%3Dcategory\" aria-label=\"“Sanctification, Holiness &amp; Righteousness” (Edit)\">Sanctification, Holiness &amp; Righteousness</a></strong>

<strong><a class=\"row-title\" href=\"http://www.heavenlykey.org/wp-admin/term.php?taxonomy=category&amp;tag_ID=5&amp;post_type=post&amp;wp_http_referer=%2Fwp-admin%2Fedit-tags.php%3Ftaxonomy%3Dcategory\" aria-label=\"“The Baptism of the Holy Ghost &amp; Fire” (Edit)\">The Baptism of the Holy Ghost &amp; Fire</a></strong>

<strong><a class=\"row-title\" href=\"http://www.heavenlykey.org/wp-admin/term.php?taxonomy=category&amp;tag_ID=6&amp;post_type=post&amp;wp_http_referer=%2Fwp-admin%2Fedit-tags.php%3Ftaxonomy%3Dcategory\" aria-label=\"“Restitution and Encouragement” (Edit)\">Restitution and Encouragement</a></strong>

<strong><a class=\"row-title\" href=\"http://www.heavenlykey.org/wp-admin/term.php?taxonomy=category&amp;tag_ID=8&amp;post_type=post&amp;wp_http_referer=%2Fwp-admin%2Fedit-tags.php%3Ftaxonomy%3Dcategory\" aria-label=\"“Miracles, Signs, and Wonders” (Edit)\">Miracles, Signs, and Wonders</a></strong>

<strong><a class=\"row-title\" href=\"http://www.heavenlykey.org/wp-admin/term.php?taxonomy=category&amp;tag_ID=7&amp;post_type=post&amp;wp_http_referer=%2Fwp-admin%2Fedit-tags.php%3Ftaxonomy%3Dcategory\" aria-label=\"“Faith and Prayer” (Edit)\">Faith and Prayer</a></strong>

<strong><a class=\"row-title\" href=\"http://www.heavenlykey.org/wp-admin/term.php?taxonomy=category&amp;tag_ID=9&amp;post_type=post&amp;wp_http_referer=%2Fwp-admin%2Fedit-tags.php%3Ftaxonomy%3Dcategory\" aria-label=\"“Eschatology, False Prophets and Teachers” (Edit)\">Eschatology, False Prophets and Teachers</a></strong>

<strong><a class=\"row-title\" href=\"http://www.heavenlykey.org/wp-admin/term.php?taxonomy=category&amp;tag_ID=10&amp;post_type=post&amp;wp_http_referer=%2Fwp-admin%2Fedit-tags.php%3Ftaxonomy%3Dcategory\" aria-label=\"“Bible Stories and Questions” (Edit)\">Bible Stories and Questions</a></strong>

<strong><a class=\"row-title\" href=\"http://www.heavenlykey.org/wp-admin/term.php?taxonomy=category&amp;tag_ID=1&amp;post_type=post&amp;wp_http_referer=%2Fwp-admin%2Fedit-tags.php%3Ftaxonomy%3Dcategory\" aria-label=\"“General” (Edit)\">General</a></strong>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:9;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:265:\"<a href=\"https://www.facebook.com/heavenlykey/\" target=\"_blank\" rel=\"noopener\"><img class=\"size-medium wp-image-166 aligncenter\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/FB-Page-Like-logo-300x192-300x192.jpg\" alt=\"\" width=\"300\" height=\"192\" /></a>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:10;a:4:{s:5:\"title\";s:6:\"Part 3\";s:4:\"text\";s:202:\"<iframe width=\"523\" height=\"392\" src=\"https://www.youtube.com/embed/gtYc0c_VrRg\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:12;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:71:\"<strong>Apostolic warning on false prophet, doctrines and hope</strong>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:13;a:4:{s:5:\"title\";s:26:\"Taking Christ to the world\";s:4:\"text\";s:424:\"<a href=\"http://www.heavenlykey.org/partnership/\" target=\"_blank\" rel=\"noopener\"><strong>Click Here to support  our  Vision  of  taking  Christ  to  the  World</strong></a><a href=\"http://www.heavenlykey.org/partnership/\" target=\"_blank\" rel=\"noopener\"><img class=\"wp-image-171 aligncenter\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/Onlinve-Giving-300x144.jpg\" alt=\"\" width=\"252\" height=\"121\" /></a>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:14;a:4:{s:5:\"title\";s:33:\"Top Recommended Holiness Churches\";s:4:\"text\";s:718:\"<strong>But</strong> the hour cometh, and now is, when the true worshippers shall worship the Father in spirit and in truth: for the Father seeketh such to worship him.
<h3 class=\"LC20lb\"> 1. Deeper Christian Life Ministry - <a href=\"https://dclm.org/\" target=\"_blank\" rel=\"noopener\">Click Here</a></h3>
<h3 class=\"LC20lb\">2. Apostolic Faith Church - <a href=\"http://apostolicfaithweca.org/\" target=\"_blank\" rel=\"noopener\">Click Here</a></h3>
We encounrage you to join and worship with any of these churches as we pursue true Holiness to make Heaven at last

<strong>If there are Holiness churches that need to be included please contact us for verification </strong>

&nbsp;
<h3 class=\"LC20lb\"></h3>
&nbsp;\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("81", "uninstall_plugins", "a:5:{s:39:\"advanced-wp-reset/advanced-wp-reset.php\";s:13:\"DBR_uninstall\";s:52:\"click-to-chat-for-whatsapp/prev/inc/class-ht-ccw.php\";a:2:{i:0;s:15:\"HT_CCW_Register\";i:1;s:9:\"uninstall\";}s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:21:\"wpa_wpclone_uninstall\";}", "no");
INSERT INTO wpy4_options VALUES("82", "timezone_string", "", "yes");
INSERT INTO wpy4_options VALUES("83", "page_for_posts", "34", "yes");
INSERT INTO wpy4_options VALUES("84", "page_on_front", "17", "yes");
INSERT INTO wpy4_options VALUES("85", "default_post_format", "0", "yes");
INSERT INTO wpy4_options VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO wpy4_options VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO wpy4_options VALUES("88", "site_icon", "11", "yes");
INSERT INTO wpy4_options VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO wpy4_options VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO wpy4_options VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO wpy4_options VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO wpy4_options VALUES("93", "initial_db_version", "44719", "yes");
INSERT INTO wpy4_options VALUES("94", "wpy4_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:121:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:29:\"manage_instagram_feed_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:38:\"vc_access_rules_post_types/cpt_layouts\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:38:\"vc_access_rules_post_types/cpt_layouts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:13:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:38:\"vc_access_rules_post_types/cpt_layouts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:8:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:38:\"vc_access_rules_post_types/cpt_layouts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:5:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:38:\"vc_access_rules_post_types/cpt_layouts\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:4:{s:4:\"read\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:38:\"vc_access_rules_post_types/cpt_layouts\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:95:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:38:\"vc_access_rules_post_types/cpt_layouts\";b:1;}}s:10:\"registrant\";a:2:{s:4:\"name\";s:16:\"Event Registrant\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:0;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO wpy4_options VALUES("95", "fresh_site", "0", "yes");
INSERT INTO wpy4_options VALUES("96", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("97", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("98", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("99", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("100", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("101", "sidebars_widgets", "a:13:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"left-sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"right-sidebar\";a:6:{i:0;s:7:\"text-14\";i:1;s:13:\"custom_html-2\";i:2;s:6:\"text-7\";i:3;s:6:\"text-3\";i:4;s:12:\"categories-3\";i:5;s:6:\"text-6\";}s:13:\"event-sidebar\";a:0:{}s:12:\"blog-sidebar\";a:0:{}s:8:\"footer-1\";a:3:{i:0;s:6:\"text-9\";i:1;s:13:\"media_video-5\";i:2;s:19:\"blog_subscription-2\";}s:8:\"footer-2\";a:4:{i:0;s:7:\"text-12\";i:1;s:13:\"media_video-2\";i:2;s:13:\"media_video-3\";i:3;s:7:\"text-10\";}s:8:\"footer-3\";a:1:{i:0;s:6:\"text-8\";}s:8:\"footer-4\";a:2:{i:0;s:7:\"text-13\";i:1;s:15:\"media_gallery-2\";}s:11:\"textblock-1\";a:0:{}s:11:\"textblock-2\";a:0:{}s:11:\"textblock-3\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO wpy4_options VALUES("320", "category7_image_term_id", "", "yes");
INSERT INTO wpy4_options VALUES("322", "category8_image_term_id", "", "yes");
INSERT INTO wpy4_options VALUES("324", "category9_image_term_id", "", "yes");
INSERT INTO wpy4_options VALUES("309", "category1_image_term_id", "", "yes");
INSERT INTO wpy4_options VALUES("312", "category3_image_term_id", "", "yes");
INSERT INTO wpy4_options VALUES("314", "category4_image_term_id", "", "yes");
INSERT INTO wpy4_options VALUES("25845", "category_children", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("102", "cron", "a:19:{i:1595619531;a:1:{s:27:\"litespeed_task_imgoptm_pull\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1595619566;a:2:{s:19:\"litespeed_task_ccss\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:19:\"litespeed_task_lqip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1595619640;a:2:{s:22:\"jetpack_sync_full_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}s:17:\"jetpack_sync_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1595620909;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1595622034;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1595622895;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1595622900;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1595625641;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1595625702;a:1:{s:24:\"jp_purge_transients_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1595626500;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1595631708;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1595631709;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1595631721;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1595639566;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1595865600;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1595871000;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"d33a7a907c6df8b490510307cf0d31f4\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1595871000;}}}}i:1596063620;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1596130200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"aba52474841383740a239f90f8156971\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1596130200;}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO wpy4_options VALUES("103", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("104", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("105", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("106", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("107", "widget_media_gallery", "a:2:{i:2;a:7:{s:5:\"title\";s:0:\"\";s:3:\"ids\";a:5:{i:0;i:11;i:1;i:167;i:2;i:168;i:3;i:169;i:4;i:170;}s:7:\"columns\";i:3;s:4:\"size\";s:9:\"thumbnail\";s:9:\"link_type\";s:4:\"post\";s:14:\"orderby_random\";b:0;s:4:\"type\";s:11:\"rectangular\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("108", "widget_media_video", "a:4:{i:2;a:11:{s:7:\"preload\";s:8:\"metadata\";s:4:\"loop\";b:0;s:7:\"content\";s:0:\"\";s:3:\"mp4\";s:0:\"\";s:3:\"m4v\";s:0:\"\";s:4:\"webm\";s:0:\"\";s:3:\"ogv\";s:0:\"\";s:3:\"flv\";s:0:\"\";s:13:\"attachment_id\";i:0;s:3:\"url\";s:28:\"https://youtu.be/pLiKRi4w-kw\";s:5:\"title\";s:6:\"Part 1\";}i:3;a:11:{s:7:\"preload\";s:8:\"metadata\";s:4:\"loop\";b:0;s:7:\"content\";s:0:\"\";s:3:\"mp4\";s:0:\"\";s:3:\"m4v\";s:0:\"\";s:4:\"webm\";s:0:\"\";s:3:\"ogv\";s:0:\"\";s:3:\"flv\";s:0:\"\";s:13:\"attachment_id\";i:0;s:3:\"url\";s:28:\"https://youtu.be/jnfwuSeG6wk\";s:5:\"title\";s:6:\"Part 2\";}i:5;a:11:{s:7:\"preload\";s:8:\"metadata\";s:4:\"loop\";b:0;s:7:\"content\";s:0:\"\";s:3:\"mp4\";s:0:\"\";s:3:\"m4v\";s:0:\"\";s:4:\"webm\";s:0:\"\";s:3:\"ogv\";s:0:\"\";s:3:\"flv\";s:0:\"\";s:13:\"attachment_id\";i:0;s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=YrPTb0NP88c\";s:5:\"title\";s:46:\"Holiness God\'s Condition for Dwelling With Him\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("109", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("110", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("111", "widget_custom_html", "a:2:{i:2;a:2:{s:5:\"title\";s:17:\"SPIRITUAL CAUTION\";s:7:\"content\";s:729:\"<strong style=\"color: red;\">There are many Church members, Elders, Bishops, Reverends, Pastors, Evangelist, Missionaries, Preachers, Presidents, Governors, Senators, Kings and others in great agony in Hell Fire right now because of their hardiness of heart to the gospel call unto Salvation & little mistakes. It will be a great mistake for you to neglect this privilege and reach hell before knowing that our message is true. We need to serve & walk with God in Fear, living with other Christians in unity,  also the Bible should be our ultimate Guard & we should beware of fake Bibles, Preachers, Doctrines & Churches that will lead us to Hell Fire. God is not a respecter of any person, Where will you spend Eternity?</strong>\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("113", "recovery_keys", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("121", "theme_mods_twentynineteen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1567638138;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO wpy4_options VALUES("380", "ls-latest-version", "6.11.1", "yes");
INSERT INTO wpy4_options VALUES("139", "envato_market_version", "2.0.0", "yes");
INSERT INTO wpy4_options VALUES("140", "redux_version_upgraded_from", "3.6.8", "yes");
INSERT INTO wpy4_options VALUES("141", "widget_adorechurch_core_twitter_feeds", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("142", "envato_market_installed_version", "2.0.0", "yes");
INSERT INTO wpy4_options VALUES("143", "envato_market_state", "install", "yes");
INSERT INTO wpy4_options VALUES("163", "accesspresslite_plugin_installed_notif", "1", "yes");
INSERT INTO wpy4_options VALUES("25191", "vc_save_data", "a:26:{s:6:\"banner\";s:2:\"on\";s:3:\"ihe\";s:2:\"on\";s:11:\"price_table\";s:2:\"on\";s:13:\"advance_price\";s:2:\"on\";s:8:\"info_box\";s:2:\"on\";s:11:\"advance_btn\";s:2:\"on\";s:9:\"team_prof\";s:2:\"on\";s:7:\"counter\";s:2:\"on\";s:8:\"flip_box\";s:2:\"on\";s:8:\"timeline\";s:2:\"on\";s:9:\"countdown\";s:2:\"on\";s:13:\"creative_link\";s:2:\"on\";s:10:\"text_typer\";s:2:\"on\";s:11:\"social_icon\";s:2:\"on\";s:5:\"popup\";s:2:\"on\";s:18:\"interactive_banner\";s:2:\"on\";s:9:\"info_list\";s:2:\"on\";s:12:\"google_trend\";s:2:\"on\";s:7:\"tooltip\";s:2:\"on\";s:11:\"testimonial\";s:2:\"on\";s:12:\"adv_carousel\";s:2:\"on\";s:7:\"heading\";s:2:\"on\";s:13:\"highlight_box\";s:2:\"on\";s:8:\"img_swap\";s:2:\"on\";s:9:\"accordion\";s:2:\"on\";s:11:\"info_circle\";s:2:\"on\";}", "yes");
INSERT INTO wpy4_options VALUES("26098", "ls-store-last-updated", "1569903418", "yes");
INSERT INTO wpy4_options VALUES("26099", "ls-store-data", "a:2:{s:12:\"last_updated\";s:10:\"2017-12-22\";s:7:\"sliders\";a:67:{s:20:\"catering-xmas-slider\";a:7:{s:8:\"released\";s:10:\"2017-12-22\";s:4:\"name\";s:25:\"Catering Christmas Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:29:\"premium,new,static,text,blend\";s:3:\"url\";s:72:\"https://layerslider.kreaturamedia.com/sliders/catering-christmas-slider/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/catering-xmas-slider.jpg\";}s:20:\"discover-the-details\";a:7:{s:8:\"released\";s:10:\"2017-12-19\";s:4:\"name\";s:20:\"Discover the Details\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:50:\"premium,new,loop,parallax,blendmode,specialeffects\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/discover-the-details/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/discover-the-details.jpg\";}s:10:\"rainforest\";a:7:{s:8:\"released\";s:10:\"2017-12-17\";s:4:\"name\";s:10:\"Rainforest\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:48:\"premium,new,loop,filter,blendmode,specialeffects\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/rainforest/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/rainforest.jpg\";}s:30:\"ecommerce-global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-12-15\";s:4:\"name\";s:30:\"eCommerce Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:23:\"premium,new,experiments\";s:3:\"url\";s:77:\"https://layerslider.kreaturamedia.com/sliders/ecommerce-global-hover-example/\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/ecommerce-global-hover-example.jpg\";}s:20:\"3d-canyon-experience\";a:7:{s:8:\"released\";s:10:\"2017-12-13\";s:4:\"name\";s:20:\"3D Canyon Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:37:\"premium,new,parallax,experiments,text\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/3d-canyon-experience/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/3d-canyon-experience.jpg\";}s:14:\"discount-popup\";a:7:{s:8:\"released\";s:10:\"2017-12-10\";s:4:\"name\";s:14:\"Discount Popup\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:21:\"premium,premium,popup\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/discount-popup/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/discount-popup.jpg\";}s:14:\"vintage-photos\";a:7:{s:8:\"released\";s:10:\"2017-12-08\";s:4:\"name\";s:14:\"Vintage Photos\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:47:\"premium,new,fullsize,loop,filter,specialeffects\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/vintage-photos/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/vintage-photos.jpg\";}s:18:\"social-share-popup\";a:7:{s:8:\"released\";s:10:\"2017-12-06\";s:4:\"name\";s:18:\"Social Share Popup\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:21:\"premium,new,popup,api\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/social-share-popup/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/social-share-popup.jpg\";}s:8:\"aquarium\";a:7:{s:8:\"released\";s:10:\"2017-12-04\";s:4:\"name\";s:8:\"Aquarium\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:59:\"premium,new,parallax,loop,filter,experiments,specialeffects\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/aquarium/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/aquarium.jpg\";}s:16:\"what-is-the-time\";a:7:{s:8:\"released\";s:10:\"2017-08-25\";s:4:\"name\";s:17:\"What is the time?\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:51:\"premium,new,parallax,text,blendmode,experiments,api\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/what-is-the-time/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/what-is-the-time.jpg\";}s:18:\"personal-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-23\";s:4:\"name\";s:18:\"Personal Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:58:\"premium,new,fullsize,fullwidth,landing,text,parallax,packs\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/personal-page-pack/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/personal-page-pack.jpg\";}s:19:\"marketing-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-21\";s:4:\"name\";s:19:\"Marketing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:65:\"premium,new,fullsize,fullwidth,landing,parallax,static,loop,packs\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/marketing-page-pack/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/marketing-page-pack.jpg\";}s:14:\"dynamic-slider\";a:7:{s:8:\"released\";s:10:\"2017-08-18\";s:4:\"name\";s:14:\"Dynamic Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:36:\"premium,new,fullwidth,landing,static\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/dynamic-slider/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/dynamic-slider.jpg\";}s:14:\"colorful-cases\";a:7:{s:8:\"released\";s:10:\"2017-08-16\";s:4:\"name\";s:14:\"Colorful Cases\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:47:\"premium,new,text,loop,parallax,static,blendmode\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/colorful-cases/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/colorful-cases.jpg\";}s:16:\"beauty-shop-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-14\";s:4:\"name\";s:16:\"Beauty Shop PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:40:\"premium,new,fullwidth,text,landing,packs\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/beauty-shop-pack/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/beauty-shop-pack.jpg\";}s:16:\"popup-guide-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Guide Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:31:\"premium,new,popup,parallax,text\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/popup-guide-demo/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-guide-demo.jpg\";}s:18:\"popup-welcome-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Welcome Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:31:\"premium,new,popup,parallax,text\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/popup-welcome-demo/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-welcome-demo.jpg\";}s:22:\"popup-transparent-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:22:\"Popup Transparent Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:31:\"premium,new,popup,parallax,loop\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/sliders/popup-transparent-demo/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-transparent-demo.jpg\";}s:18:\"popup-sidebar-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Sidebar Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:40:\"premium,popup,experiments,blendmode,text\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/popup-sidebar-demo/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-sidebar-demo.jpg\";}s:19:\"popup-photo-gallery\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:19:\"Popup Photo Gallery\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:26:\"premium,new,popup,kenburns\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/popup-photo-gallery/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-photo-gallery.jpg\";}s:16:\"popup-modal-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Modal Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:24:\"premium,new,popup,static\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/popup-modal-demo/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-modal-demo.jpg\";}s:18:\"popup-infobar-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Infobar Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:34:\"premium,new,popup,experiments,text\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/popup-infobar-demo/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-infobar-demo.jpg\";}s:24:\"popup-fullsize-desk-demo\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:24:\"Popup Fullsize Desk Demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:47:\"premium,new,popup,experiments,fullsize,parallax\";s:3:\"url\";s:71:\"https://layerslider.kreaturamedia.com/sliders/popup-fullsize-desk-demo/\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-fullsize-desk-demo.jpg\";}s:18:\"conversation-popup\";a:7:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Conversation Popup\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:29:\"premium,new,popup,experiments\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/conversation-popup/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/conversation-popup.jpg\";}s:20:\"global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-05-02\";s:4:\"name\";s:20:\"Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.4.0\";s:6:\"groups\";s:52:\"premium,new,experiments,specialeffects,parallax,text\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/global-hover-example/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/global-hover-example.jpg\";}s:10:\"gastronomy\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:10:\"Gastronomy\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:28:\"premium,kenburns,filter,text\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/gastronomy/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/gastronomy.jpg\";}s:13:\"police-lights\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:13:\"Police Lights\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:46:\"premium,specialeffects,loop,blendmode,parallax\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/police-lights/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/police-lights.jpg\";}s:16:\"beautiful-sunset\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Beautiful Sunset\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:37:\"premium,specialeffects,loop,blendmode\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/beautiful-sunset/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/beautiful-sunset.jpg\";}s:23:\"blend-mode-experiment-1\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:23:\"Blend Mode Experiment 1\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:63:\"premium,specialeffects,text,blendmode,experiments,loop,parallax\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/sliders/blend-mode-experiment-1/\";s:7:\"preview\";s:84:\"https://repository.kreaturamedia.com/v4/sliders/packages/blend-mode-experiment-1.jpg\";}s:16:\"flying-banners-2\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Flying Banners 2\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:40:\"premium,parallax,specialeffects,fullsize\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/flying-banners-2/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/flying-banners-2.jpg\";}s:14:\"layerslider-v6\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:14:\"LayerSlider v6\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.6\";s:6:\"groups\";s:68:\"premium,specialeffects,parallax,fullsize,landing,loop,text,media,api\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/layerslider-v6/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/layerslider-v6.jpg\";}s:16:\"flying-banners-1\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:16:\"Flying Banners 1\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:38:\"free,parallax,loop,text,specialeffects\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/flying-banners-1/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/flying-banners-1.jpg\";}s:18:\"anniversary-slider\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:18:\"Anniversary Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:40:\"free,parallax,experiments,specialeffects\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/anniversary-slider/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/anniversary-slider.jpg\";}s:7:\"origami\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:7:\"Origami\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:47:\"premium,experiments,specialeffects,3dtransition\";s:3:\"url\";s:54:\"https://layerslider.kreaturamedia.com/sliders/origami/\";s:7:\"preview\";s:68:\"https://repository.kreaturamedia.com/v4/sliders/packages/origami.jpg\";}s:17:\"origami-buildings\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:17:\"Origami Buildings\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:56:\"premium,experiments,specialeffects,kenburns,3dtransition\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/origami-buildings/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/origami-buildings.jpg\";}s:17:\"autumn-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:17:\"Autumn Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:45:\"experiments,free,loop,parallax,specialeffects\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/autumn-experiment/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/autumn-experiment.jpg\";}s:28:\"features-parallax-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:32:\"Features | A Parallax Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:40:\"experiments,free,parallax,specialeffects\";s:3:\"url\";s:75:\"https://layerslider.kreaturamedia.com/sliders/features-parallax-experiment/\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/features-parallax-experiment.jpg\";}s:16:\"furniture-slider\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:16:\"Furniture Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:33:\"fullwidth,parallax,premium,static\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/furniture-slider/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/furniture-slider.jpg\";}s:15:\"room-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:15:\"Room Experiment\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.6\";s:6:\"groups\";s:65:\"api,experiments,media,parallax,premium,specialeffects,static,text\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/room-experiment/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/room-experiment.jpg\";}s:11:\"drag-n-drop\";a:6:{s:4:\"name\";s:11:\"Drag & Drop\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:37:\"premium,fullwidth,specialeffects,text\";s:3:\"url\";s:58:\"https://layerslider.kreaturamedia.com/sliders/drag-n-drop/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/drag-n-drop.jpg\";}s:10:\"headphones\";a:6:{s:4:\"name\";s:10:\"Headphones\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:14:\"premium,static\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/headphones/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/headphones.jpg\";}s:14:\"play-by-scroll\";a:6:{s:4:\"name\";s:19:\"Play By Scroll demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:66:\"premium,fullsize,text,experiments,specialeffects,playbyscroll,loop\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/play-by-scroll/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/play-by-scroll.jpg\";}s:3:\"sky\";a:6:{s:4:\"name\";s:14:\"Sky Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:63:\"premium,fullwidth,text,experiments,parallax,specialeffects,loop\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/sky-experience/\";s:7:\"preview\";s:64:\"https://repository.kreaturamedia.com/v4/sliders/packages/sky.jpg\";}s:9:\"halloween\";a:6:{s:4:\"name\";s:16:\"Happy Halloween!\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:35:\"free,fullsize,text,experiments,loop\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/happy-halloween/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/halloween.jpg\";}s:15:\"creative-agency\";a:6:{s:4:\"name\";s:6:\"Agency\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:49:\"premium,fullsize,kenburns,parallax,landing,filter\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/creative-agency/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/creative-agency.jpg\";}s:18:\"interactive-slider\";a:6:{s:4:\"name\";s:18:\"Interactive Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:47:\"premium,fullsize,parallax,kenburns,text,landing\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/interactive-slider/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/interactive-slider.jpg\";}s:9:\"ecommerce\";a:6:{s:4:\"name\";s:9:\"eCommerce\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:56:\"https://layerslider.kreaturamedia.com/sliders/ecommerce/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/ecommerce.jpg\";}s:17:\"landing-page-pack\";a:6:{s:4:\"name\";s:17:\"Landing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:54:\"premium,fullsize,fullwidth,landing,parallax,text,packs\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/landing-page/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-page-pack.jpg\";}s:6:\"hiking\";a:6:{s:4:\"name\";s:6:\"Hiking\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:53:\"https://layerslider.kreaturamedia.com/sliders/hiking/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/hiking.jpg\";}s:12:\"movie-slider\";a:6:{s:4:\"name\";s:12:\"Movie Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/movie-slider/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/movie-slider.jpg\";}s:12:\"photo-studio\";a:6:{s:4:\"name\";s:12:\"Photo Studio\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:62:\"premium,fullsize,filter,text,parallax,specialeffects,blendmode\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/photo-studio/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/photo-studio.jpg\";}s:5:\"shoes\";a:6:{s:4:\"name\";s:5:\"Shoes\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:35:\"premium,fullwidth,parallax,carousel\";s:3:\"url\";s:52:\"https://layerslider.kreaturamedia.com/sliders/shoes/\";s:7:\"preview\";s:66:\"https://repository.kreaturamedia.com/v4/sliders/packages/shoes.jpg\";}s:11:\"mini-cooper\";a:6:{s:4:\"name\";s:18:\"Mini Cooper Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:40:\"premium,fullsize,parallax,specialeffects\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/mini-cooper-slider/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/mini-cooper.jpg\";}s:4:\"xmas\";a:6:{s:4:\"name\";s:16:\"Merry Christmas!\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:60:\"premium,parallax,filter,experiments,specialeffects,text,loop\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/merry-christmas/\";s:7:\"preview\";s:65:\"https://repository.kreaturamedia.com/v4/sliders/packages/xmas.jpg\";}s:5:\"clock\";a:6:{s:4:\"name\";s:32:\"Vintage Clock | shows valid time\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:37:\"premium,fullsize,api,experiments,loop\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/vintage-clock/\";s:7:\"preview\";s:66:\"https://repository.kreaturamedia.com/v4/sliders/packages/clock.jpg\";}s:8:\"car-show\";a:6:{s:4:\"name\";s:8:\"Car Show\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:38:\"premium,fullwidth,experiments,api,loop\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/car-show/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/car-show.jpg\";}s:8:\"carousel\";a:6:{s:4:\"name\";s:8:\"Carousel\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:13:\"free,carousel\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/carousel/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/carousel.jpg\";}s:14:\"fancy-parallax\";a:6:{s:4:\"name\";s:21:\"Fancy Parallax Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:26:\"premium,fullwidth,parallax\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/parallax-slider/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/fancy-parallax.jpg\";}s:13:\"simple-slider\";a:6:{s:4:\"name\";s:13:\"Simple Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:4:\"free\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/simple-slider/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/simple-slider.jpg\";}s:12:\"image-slider\";a:6:{s:4:\"name\";s:12:\"Image Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:4:\"free\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/image-slideshow/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/image-slider.jpg\";}s:19:\"client-testimonials\";a:6:{s:4:\"name\";s:19:\"Client Testimonials\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/client-testimonials/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/client-testimonials.jpg\";}s:8:\"fixed-bg\";a:6:{s:4:\"name\";s:16:\"Fixed Background\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:23:\"premium,fullwidth,media\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/fixed-background/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/fixed-bg.jpg\";}s:22:\"dynamic-content-slider\";a:6:{s:4:\"name\";s:22:\"Dynamic Content Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:4:\"free\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/sliders/dynamic-content-slider/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/dynamic-content-slider.jpg\";}s:6:\"old-3d\";a:6:{s:4:\"name\";s:14:\"LayerSlider v4\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:23:\"free,3dtransition,media\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/3d-demo-slider/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/old-3d.jpg\";}s:2:\"v5\";a:6:{s:4:\"name\";s:14:\"LayerSlider v5\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:19:\"free,parallax,media\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/layerslider-v5/\";s:7:\"preview\";s:63:\"https://repository.kreaturamedia.com/v4/sliders/packages/v5.jpg\";}s:12:\"video-slider\";a:6:{s:4:\"name\";s:12:\"Video Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:10:\"free,media\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/video-slider/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/video-slider.jpg\";}s:6:\"resort\";a:6:{s:4:\"name\";s:6:\"Resort\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:17:\"premium,fullwidth\";s:3:\"url\";s:54:\"https://layerslider.kreaturamedia.com/sliders/restort/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/resort.jpg\";}}}", "no");
INSERT INTO wpy4_options VALUES("25243", "widget_wdpslider", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("25244", "wdps_admin_notice", "a:1:{s:15:\"two_week_review\";a:2:{s:5:\"start\";s:10:\"10/15/2019\";s:3:\"int\";i:14;}}", "yes");
INSERT INTO wpy4_options VALUES("347", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:22:\"alldaywow247@gmail.com\";s:7:\"version\";s:5:\"5.4.2\";s:9:\"timestamp\";i:1591830129;}", "no");
INSERT INTO wpy4_options VALUES("393", "jetpack_activated", "1", "yes");
INSERT INTO wpy4_options VALUES("243686", "jetpack_connection_active_plugins", "a:1:{s:7:\"jetpack\";a:1:{s:4:\"name\";s:7:\"Jetpack\";}}", "yes");
INSERT INTO wpy4_options VALUES("396", "jetpack_activation_source", "a:2:{i:0;s:8:\"featured\";i:1;N;}", "yes");
INSERT INTO wpy4_options VALUES("397", "jetpack_options", "a:10:{s:7:\"version\";s:16:\"8.6.1:1591910989\";s:11:\"old_version\";s:16:\"7.7.3:1574205127\";s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;s:2:\"id\";i:147679448;s:6:\"public\";i:1;s:11:\"master_user\";i:1;s:14:\"last_heartbeat\";i:1595539268;s:16:\"first_admin_view\";b:1;s:21:\"publicize_connections\";a:1:{s:8:\"facebook\";a:2:{i:22901833;a:10:{s:7:\"user_id\";s:1:\"1\";s:8:\"provider\";s:21:\"facebook:249643311490\";s:6:\"issued\";s:19:\"2016-07-17 21:32:43\";s:7:\"expires\";b:0;s:11:\"external_id\";s:16:\"1503204836653788\";s:13:\"external_name\";s:0:\"\";s:16:\"external_display\";s:17:\"Evangelist Ochuko\";s:13:\"refresh_token\";s:0:\"\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"22901833\";s:8:\"token_id\";s:8:\"14989470\";s:7:\"blog_id\";s:9:\"147679448\";s:7:\"user_id\";s:1:\"0\";s:4:\"meta\";a:5:{s:12:\"display_name\";s:34:\"Heavenly Key Evangelistic Movement\";s:13:\"facebook_page\";s:15:\"257552591001029\";s:14:\"follower_count\";i:1995;s:4:\"link\";s:40:\"https://www.facebook.com/257552591001029\";s:16:\"external_user_id\";s:1:\"1\";}}}i:20339507;a:10:{s:7:\"user_id\";s:1:\"4\";s:8:\"provider\";s:21:\"facebook:249643311490\";s:6:\"issued\";s:19:\"2018-06-16 20:30:57\";s:7:\"expires\";b:0;s:11:\"external_id\";s:16:\"1503204836653788\";s:13:\"external_name\";s:0:\"\";s:16:\"external_display\";s:23:\"Evangelist A O Emmanuel\";s:13:\"refresh_token\";s:0:\"\";s:4:\"type\";s:6:\"access\";s:15:\"connection_data\";a:5:{s:2:\"id\";s:8:\"20339507\";s:8:\"token_id\";s:8:\"20450077\";s:7:\"blog_id\";s:9:\"147679448\";s:7:\"user_id\";s:1:\"4\";s:4:\"meta\";a:5:{s:14:\"follower_count\";i:1482;s:4:\"link\";s:205:\"https://www.facebook.com/app_scoped_user_id/YXNpZADpBWEZAIYkh4ZAThpY0NHa1YyaXRLeDhWdVc1VmFBRk9XdTNxTk1EYjRkTmJCb2I0MVlKUnNabXZAtNlJNNU5PNXloOS1HOF9VR1RhOUNsM01iOFZAZAMm5tQmdMRlVUcnRiLUx2X1FCVWlYXzlMZAzEZD/\";s:12:\"display_name\";s:23:\"Evangelist A O Emmanuel\";s:16:\"facebook_profile\";b:1;s:16:\"external_user_id\";s:1:\"4\";}}}}}}", "yes");
INSERT INTO wpy4_options VALUES("398", "jetpack_sync_settings_disable", "0", "yes");
INSERT INTO wpy4_options VALUES("399", "do_activate", "0", "yes");
INSERT INTO wpy4_options VALUES("147", "imic_options", "a:124:{s:18:\"enable_maintenance\";i:0;s:16:\"switch-thumbnail\";i:1;s:16:\"enable_backtotop\";i:1;s:17:\"space-before-head\";s:0:\"\";s:17:\"space-before-body\";s:0:\"\";s:17:\"switch-responsive\";i:1;s:17:\"switch-zoom-pinch\";i:0;s:11:\"site_layout\";s:4:\"wide\";s:10:\"site_width\";s:4:\"1040\";s:26:\"content_padding_dimensions\";a:3:{s:11:\"padding-top\";s:4:\"50px\";s:14:\"padding-bottom\";s:4:\"50px\";s:5:\"units\";s:2:\"px\";}s:18:\"content_min_height\";s:3:\"400\";s:18:\"content_wide_width\";s:1:\"0\";s:13:\"header_layout\";s:1:\"1\";s:16:\"header3_textarea\";s:0:\"\";s:17:\"header_wide_width\";s:1:\"0\";s:18:\"header_area_height\";i:80;s:23:\"header_background_alpha\";a:2:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";d:0.8000000000000000444089209850062616169452667236328125;}s:19:\"enable-header-stick\";i:1;s:30:\"sticky_header_background_alpha\";a:2:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";d:0.8000000000000000444089209850062616169452667236328125;}s:15:\"social-facebook\";s:25:\"https://www.facebook.com/\";s:14:\"social-twitter\";s:20:\"https://twitter.com/\";s:16:\"social-pinterest\";s:26:\"https://www.pinterest.com/\";s:17:\"social-googleplus\";s:25:\"https://www.google.co.in/\";s:14:\"social-youtube\";s:19:\"http://youtube.com/\";s:16:\"social-instagram\";s:21:\"http://instagram.com/\";s:12:\"social-vimeo\";s:17:\"http://vimeo.com/\";s:8:\"site-rss\";s:32:\"http://www.heavenlykey.org/feed/\";s:19:\"header_social_links\";a:21:{s:18:\"fa-facebook-square\";s:8:\"facebook\";s:17:\"fa-twitter-square\";s:7:\"twitter\";s:12:\"fa-pinterest\";s:9:\"pinterest\";s:14:\"fa-google-plus\";s:6:\"google\";s:10:\"fa-youtube\";s:7:\"youtube\";s:12:\"fa-instagram\";s:9:\"instagram\";s:15:\"fa-vimeo-square\";s:5:\"vimeo\";s:6:\"fa-rss\";s:3:\"rss\";s:11:\"fa-dribbble\";s:8:\"dribbble\";s:10:\"fa-dropbox\";s:7:\"dropbox\";s:12:\"fa-bitbucket\";s:9:\"bitbucket\";s:9:\"fa-flickr\";s:6:\"flickr\";s:13:\"fa-foursquare\";s:10:\"foursquare\";s:9:\"fa-github\";s:6:\"github\";s:9:\"fa-gittip\";s:6:\"gittip\";s:11:\"fa-linkedin\";s:8:\"linkedin\";s:12:\"fa-pagelines\";s:9:\"pagelines\";s:8:\"fa-skype\";s:14:\"Enter Skype ID\";s:9:\"fa-tumblr\";s:6:\"tumblr\";s:5:\"fa-vk\";s:2:\"vk\";s:11:\"fa-envelope\";s:19:\"Enter Email Address\";}s:12:\"header_image\";a:1:{s:3:\"url\";s:0:\"\";}s:20:\"slider_behind_header\";i:1;s:11:\"logo_upload\";a:1:{s:3:\"url\";s:80:\"http://www.heavenlykey.org/wp-content/themes/NativeChurch/assets/images/logo.png\";}s:13:\"logo_alt_text\";s:4:\"Logo\";s:23:\"custom_admin_login_logo\";a:1:{s:3:\"url\";s:80:\"http://www.heavenlykey.org/wp-content/themes/NativeChurch/assets/images/logo.png\";}s:14:\"custom_favicon\";a:1:{s:3:\"url\";s:83:\"http://www.heavenlykey.org/wp-content/themes/NativeChurch/assets/images/favicon.ico\";}s:11:\"iphone_icon\";a:1:{s:3:\"url\";s:88:\"http://www.heavenlykey.org/wp-content/themes/NativeChurch/assets/images/apple-iphone.png\";}s:18:\"iphone_icon_retina\";a:1:{s:3:\"url\";s:95:\"http://www.heavenlykey.org/wp-content/themes/NativeChurch/assets/images/apple-iphone-retina.png\";}s:9:\"ipad_icon\";a:1:{s:3:\"url\";s:86:\"http://www.heavenlykey.org/wp-content/themes/NativeChurch/assets/images/apple-ipad.png\";}s:16:\"ipad_icon_retina\";a:1:{s:3:\"url\";s:93:\"http://www.heavenlykey.org/wp-content/themes/NativeChurch/assets/images/apple-ipad-retina.png\";}s:27:\"navigation_background_alpha\";a:2:{s:5:\"color\";s:7:\"#F8F7F3\";s:5:\"alpha\";i:1;}s:30:\"main_dropdown_background_alpha\";a:2:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";i:1;}s:25:\"main_menu_dropdown_border\";a:3:{s:12:\"border-color\";s:7:\"#f8f7f3\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-width\";s:3:\"1px\";}s:16:\"mobile_menu_icon\";a:2:{s:9:\"font-size\";s:4:\"18px\";s:5:\"color\";s:7:\"#5e5e5e\";}s:16:\"mobile_menu_text\";s:0:\"\";s:15:\"enable-top-menu\";i:1;s:29:\"top_dropdown_background_alpha\";a:2:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";i:1;}s:24:\"top_menu_dropdown_border\";a:3:{s:12:\"border-color\";s:7:\"#f8f7f3\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-width\";s:3:\"1px\";}s:17:\"footer_wide_width\";s:1:\"0\";s:13:\"footer_layout\";s:1:\"4\";s:27:\"top_footer_background_alpha\";a:1:{s:16:\"background-color\";s:7:\"#F8F7F3\";}s:14:\"footer_padding\";a:3:{s:11:\"padding-top\";s:4:\"50px\";s:14:\"padding-bottom\";s:4:\"50px\";s:5:\"units\";s:2:\"px\";}s:23:\"top_footer_widgets_typo\";a:1:{s:5:\"color\";s:7:\"#333333\";}s:24:\"top_footer_widget_border\";a:3:{s:12:\"border-color\";s:7:\"#ECEAE4\";s:12:\"border-style\";s:5:\"solid\";s:12:\"border-width\";s:3:\"1px\";}s:21:\"footer_copyright_text\";s:19:\"All Rights Reserved\";s:19:\"footer_social_links\";a:21:{s:11:\"fa-facebook\";s:8:\"Facebook\";s:10:\"fa-twitter\";s:7:\"Twitter\";s:12:\"fa-pinterest\";s:9:\"Pinterest\";s:14:\"fa-google-plus\";s:4:\"Plus\";s:10:\"fa-youtube\";s:7:\"Youtube\";s:12:\"fa-instagram\";s:9:\"Instagram\";s:15:\"fa-vimeo-square\";s:5:\"Vimeo\";s:6:\"fa-rss\";s:3:\"Rss\";s:11:\"fa-dribbble\";s:8:\"dribbble\";s:10:\"fa-dropbox\";s:7:\"dropbox\";s:12:\"fa-bitbucket\";s:9:\"bitbucket\";s:9:\"fa-flickr\";s:6:\"flickr\";s:13:\"fa-foursquare\";s:10:\"foursquare\";s:9:\"fa-github\";s:6:\"github\";s:9:\"fa-gittip\";s:6:\"gittip\";s:11:\"fa-linkedin\";s:8:\"linkedin\";s:12:\"fa-pagelines\";s:9:\"pagelines\";s:8:\"fa-skype\";s:14:\"Enter Skype ID\";s:9:\"fa-tumblr\";s:6:\"tumblr\";s:5:\"fa-vk\";s:2:\"vk\";s:11:\"fa-envelope\";s:19:\"Enter Email Address\";}s:30:\"bottom_footer_background_alpha\";a:1:{s:16:\"background-color\";s:7:\"#ECEAE4\";}s:18:\"copyrights_padding\";a:3:{s:11:\"padding-top\";s:4:\"20px\";s:14:\"padding-bottom\";s:4:\"20px\";s:5:\"units\";s:2:\"px\";}s:30:\"footer_social_background_alpha\";a:2:{s:5:\"color\";s:7:\"#999999\";s:5:\"alpha\";i:1;}s:36:\"footer_social_background_hover_alpha\";a:2:{s:5:\"color\";s:7:\"#666666\";s:5:\"alpha\";i:1;}s:29:\"footer_social_link_dimensions\";a:2:{s:5:\"width\";s:2:\"25\";s:6:\"height\";s:2:\"25\";}s:23:\"footer_social_link_typo\";a:2:{s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"25px\";}s:16:\"sidebar_position\";s:1:\"1\";s:12:\"post_sidebar\";s:0:\"\";s:12:\"page_sidebar\";s:0:\"\";s:13:\"event_sidebar\";s:0:\"\";s:13:\"cause_sidebar\";s:0:\"\";s:14:\"sermon_sidebar\";s:0:\"\";s:13:\"staff_sidebar\";s:0:\"\";s:15:\"bbpress_sidebar\";s:0:\"\";s:16:\"theme_color_type\";s:1:\"0\";s:18:\"theme_color_scheme\";s:10:\"color1.css\";s:20:\"body_font_typography\";a:4:{s:11:\"font-family\";s:6:\"Roboto\";s:11:\"font-backup\";s:0:\"\";s:12:\"word-spacing\";s:3:\"0px\";s:14:\"letter-spacing\";s:3:\"0px\";}s:23:\"heading_font_typography\";a:4:{s:11:\"font-family\";s:16:\"Roboto Condensed\";s:11:\"font-backup\";s:0:\"\";s:12:\"word-spacing\";s:3:\"0px\";s:14:\"letter-spacing\";s:3:\"0px\";}s:29:\"metatext_date_font_typography\";a:4:{s:11:\"font-family\";s:7:\"Volkhov\";s:11:\"font-backup\";s:0:\"\";s:12:\"word-spacing\";s:3:\"0px\";s:14:\"letter-spacing\";s:3:\"0px\";}s:14:\"switch_sharing\";i:1;s:13:\"sharing_style\";s:1:\"0\";s:13:\"sharing_color\";s:1:\"0\";s:10:\"share_icon\";a:9:{i:1;s:1:\"1\";i:2;s:1:\"1\";i:3;s:1:\"1\";i:4;s:1:\"1\";i:5;s:1:\"1\";i:6;s:1:\"1\";i:7;s:1:\"1\";i:8;s:1:\"1\";i:9;s:1:\"0\";}s:16:\"share_post_types\";a:6:{i:1;s:1:\"1\";i:2;s:1:\"1\";i:3;s:1:\"1\";i:4;s:1:\"1\";i:5;s:1:\"1\";i:6;s:1:\"1\";}s:18:\"facebook_share_alt\";s:17:\"Share on Facebook\";s:17:\"twitter_share_alt\";s:5:\"Tweet\";s:16:\"google_share_alt\";s:16:\"Share on Google+\";s:16:\"tumblr_share_alt\";s:14:\"Post to Tumblr\";s:19:\"pinterest_share_alt\";s:6:\"Pin it\";s:16:\"reddit_share_alt\";s:16:\"Submit to Reddit\";s:18:\"linkedin_share_alt\";s:17:\"Share on Linkedin\";s:15:\"email_share_alt\";s:5:\"Email\";s:12:\"vk_share_alt\";s:11:\"Share on vk\";s:15:\"switch_lightbox\";i:0;s:17:\"prettyphoto_theme\";s:10:\"pp_default\";s:19:\"prettyphoto_opacity\";d:0.5;s:17:\"prettyphoto_title\";i:0;s:22:\"prettyphoto_opt_resize\";b:1;s:26:\"podcast_itunes_cover_image\";a:1:{s:3:\"url\";s:81:\"http://www.heavenlykey.org/wp-content/themes/NativeChurch/assets/images/cover.png\";}s:27:\"podcast_itunes_top_category\";s:23:\"Religion & Spirituality\";s:27:\"podcast_itunes_sub_category\";s:12:\"Christianity\";s:23:\"podcast_itunes_feed_url\";s:50:\"http://www.heavenlykey.org/feed/?post_type=sermons\";s:20:\"calendar_header_view\";i:1;s:20:\"calendar_event_limit\";s:1:\"4\";s:19:\"calendar_month_name\";s:85:\"January,February,March,April,May,June,July,August,September,October,November,December\";s:25:\"calendar_month_name_short\";s:47:\"Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec\";s:17:\"calendar_day_name\";s:56:\"Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday\";s:23:\"calendar_day_name_short\";s:27:\"Sun,Mon,Tue,Wed,Thu,Fri,Sat\";s:14:\"calendar_today\";s:5:\"Today\";s:14:\"calendar_month\";s:5:\"Month\";s:13:\"calendar_week\";s:4:\"Week\";s:12:\"calendar_day\";s:3:\"Day\";s:11:\"event_feeds\";s:1:\"1\";s:15:\"google_feed_key\";s:0:\"\";s:14:\"google_feed_id\";s:0:\"\";s:19:\"event_default_color\";s:0:\"\";s:21:\"recurring_event_color\";s:0:\"\";s:20:\"enable_event_feature\";s:1:\"1\";s:14:\"recurring_icon\";i:1;s:17:\"event_google_icon\";i:1;s:22:\"event_google_open_link\";i:1;s:15:\"countdown_timer\";s:1:\"0\";s:12:\"event_tm_opt\";s:1:\"0\";s:12:\"event_dt_opt\";s:1:\"0\";s:22:\"switch_staff_read_more\";i:0;s:15:\"staff_read_more\";s:1:\"0\";s:20:\"staff_read_more_text\";s:9:\"Read more\";s:21:\"switch_sermon_filters\";i:1;s:10:\"custom_css\";s:26:\"#header{
margin: 0 auto;
}\";s:9:\"custom_js\";s:39:\"jQuery(document).ready(function(){

});\";}", "yes");
INSERT INTO wpy4_options VALUES("125", "current_theme", "AccessPress Lite", "yes");
INSERT INTO wpy4_options VALUES("126", "theme_mods_NativeChurch", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1567642513;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"main-sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:15:\"contact-sidebar\";a:0:{}s:13:\"inner-sidebar\";a:0:{}s:15:\"sermons-sidebar\";a:0:{}s:13:\"event-sidebar\";a:0:{}s:20:\"single-event-sidebar\";a:0:{}s:12:\"post-sidebar\";a:0:{}s:14:\"footer-sidebar\";a:0:{}}}}", "yes");
INSERT INTO wpy4_options VALUES("127", "theme_switched", "", "yes");
INSERT INTO wpy4_options VALUES("128", "run_once", "a:1:{s:8:\"do_stuff\";b:1;}", "yes");
INSERT INTO wpy4_options VALUES("129", "widget_upcoming_events", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("130", "widget_latest_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("131", "widget_selected_post", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("132", "widget_custom_category", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("133", "widget_recent_sermons", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("134", "widget_sermon_speakers", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("135", "widget_advertisement", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("136", "widget_featured_event", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("137", "revslider-valid", "1", "yes");
INSERT INTO wpy4_options VALUES("148", "imic_options-transients", "a:2:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1567638170;}", "yes");
INSERT INTO wpy4_options VALUES("149", "nativechurch_dynamic_css", ".content{padding-bottom:50px;}.navigation, .header-style2 .main-menu-wrapper{background-color:#F8F7F3;}.navigation > ul > li ul{background-color:#ffffff;}.navigation > ul > li.megamenu > ul:before, .navigation > ul > li ul:before{border-bottom-color:#ffffff;}.navigation > ul > li ul li ul:before{border-right-color:#ffffff;}.navigation > ul > li > ul li > a{border-bottom:#f8f7f3;border-bottom:solid;border-bottom:1px;}.top-navigation > li ul{background-color:#ffffff;}.top-navigation > li.megamenu > ul:before, .top-navigation > li ul:before{border-bottom-color:#ffffff;}.top-navigation > li ul li ul:before{border-right-color:#ffffff;}.top-navigation > li > ul li > a{border-bottom:#f8f7f3;border-bottom:solid;border-bottom:1px;}.site-footer{background-color:#F8F7F3;}.site-footer{padding-top:50px;padding-bottom:50px;}.site-footer .widgettitle{color:#333333;}.site-footer-bottom{background-color:#ECEAE4;}.site-footer-bottom{padding-top:20px;padding-bottom:20px;}.site-footer-bottom .social-icons a{background-color:#999999;}.site-footer-bottom .social-icons a:hover{background-color:#666666;}.site-footer-bottom .social-icons a{width:25;height:25;}h1,h2,h3,h4,h5,h6,body,.event-item .event-detail h4,.site-footer-bottom{font-family:Roboto;word-spacing:0px;letter-spacing:0px;}h4,.title-note,.btn,.top-navigation,.navigation,.notice-bar-title strong,.timer-col #days, .timer-col #hours, .timer-col #minutes, .timer-col #seconds,.event-date,.event-date .date,.featured-sermon .date,.page-header h1,.timeline > li > .timeline-badge span,.woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit, .woocommerce #content input.button, .woocommerce-page a.button, .woocommerce-page button.button, .woocommerce-page input.button, .woocommerce-page #respond input#submit, .woocommerce-page #content input.button{font-family:Roboto Condensed;word-spacing:0px;letter-spacing:0px;}blockquote p,.cursive,.meta-data,.fact{font-family:Volkhov;word-spacing:0px;letter-spacing:0px;}", "yes");
INSERT INTO wpy4_options VALUES("150", "nativechurch_dynamic_fonts", "a:2:{s:6:\"family\";s:0:\"\";s:6:\"subset\";s:0:\"\";}", "yes");
INSERT INTO wpy4_options VALUES("162", "theme_mods_accesspress-lite", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:18:\"custom_css_post_id\";i:-1;s:12:\"header_image\";s:13:\"remove-header\";s:16:\"header_textcolor\";s:6:\"000000\";}", "yes");
INSERT INTO wpy4_options VALUES("183", "accesspresslite_options", "a:74:{s:29:\"accesspresslite_home_template\";s:12:\"template_two\";s:14:\"template_color\";s:7:\"#ed6a31\";s:30:\"accesspresslite_webpage_layout\";s:9:\"Fullwidth\";s:11:\"show_search\";i:1;s:12:\"media_upload\";s:62:\"http://www.heavenlykey.org/wp-content/uploads/2019/09/logo.jpg\";s:11:\"header_text\";s:38:\"Call us : 2347067092254, 2348176443398\";s:14:\"menu_alignment\";s:4:\"Left\";s:9:\"event_cat\";s:1:\"0\";s:15:\"testimonial_cat\";s:1:\"0\";s:13:\"portfolio_cat\";s:1:\"0\";s:16:\"footer_copyright\";s:34:\"Heavenly Key Evangelistic Movement\";s:32:\"accesspresslite_home_page_layout\";s:7:\"Default\";s:11:\"action_text\";s:70:\"Check Our AccessPress Pro Theme - A premium version of AccessPres Lite\";s:15:\"action_btn_text\";s:9:\"Check Now\";s:15:\"action_btn_link\";s:49:\"http://accesspressthemes.com/accesspresslite-pro/\";s:12:\"welcome_post\";s:1:\"0\";s:17:\"welcome_post_char\";i:650;s:21:\"welcome_post_readmore\";s:9:\"Read More\";s:17:\"show_event_number\";i:3;s:22:\"featured_section_title\";s:13:\"Feature Posts\";s:14:\"featured_post1\";s:1:\"0\";s:19:\"featured_post1_icon\";s:0:\"\";s:14:\"featured_post2\";s:1:\"0\";s:19:\"featured_post2_icon\";s:0:\"\";s:14:\"featured_post3\";s:1:\"0\";s:19:\"featured_post3_icon\";s:0:\"\";s:22:\"featured_post_readmore\";s:9:\"Read More\";s:12:\"gallery_code\";s:0:\"\";s:14:\"slider_options\";s:15:\"cat_post_slider\";s:7:\"slider1\";s:1:\"0\";s:7:\"slider2\";s:1:\"0\";s:7:\"slider3\";s:1:\"0\";s:7:\"slider4\";s:1:\"0\";s:10:\"slider_cat\";s:1:\"1\";s:11:\"show_slider\";s:2:\"no\";s:17:\"slider_show_pager\";s:3:\"no1\";s:20:\"slider_show_controls\";s:4:\"yes2\";s:11:\"slider_mode\";s:5:\"slide\";s:11:\"slider_auto\";s:4:\"yes3\";s:12:\"slider_speed\";i:500;s:12:\"slider_pause\";i:4000;s:14:\"slider_caption\";s:4:\"yes4\";s:30:\"leftsidebar_show_latest_events\";i:1;s:29:\"leftsidebar_show_testimonials\";i:1;s:31:\"rightsidebar_show_latest_events\";i:1;s:30:\"rightsidebar_show_testimonials\";i:1;s:13:\"view_all_text\";s:8:\"View All\";s:24:\"accesspresslite_facebook\";s:36:\"https://www.facebook.com/heavenlykey\";s:23:\"accesspresslite_twitter\";s:0:\"\";s:21:\"accesspresslite_gplus\";s:0:\"\";s:23:\"accesspresslite_youtube\";s:56:\"https://www.youtube.com/channel/UCA8qJ1nJ_9WBZFROlrBXOyA\";s:25:\"accesspresslite_pinterest\";s:0:\"\";s:24:\"accesspresslite_linkedin\";s:0:\"\";s:22:\"accesspresslite_flickr\";s:49:\"https://api.whatsapp.com/send?phone=2348176443398\";s:21:\"accesspresslite_vimeo\";s:0:\"\";s:27:\"accesspresslite_stumbleupon\";s:51:\"https://www.facebook.com/evangelistemmanueloadiohwo\";s:25:\"accesspresslite_instagram\";s:0:\"\";s:27:\"accesspresslite_sound_cloud\";s:0:\"\";s:21:\"accesspresslite_skype\";s:0:\"\";s:22:\"accesspresslite_tumblr\";s:0:\"\";s:23:\"accesspresslite_myspace\";s:0:\"\";s:19:\"accesspresslite_rss\";s:0:\"\";s:10:\"custom_css\";s:0:\"\";s:24:\"template_option_selected\";s:3:\"yes\";s:17:\"responsive_design\";i:0;s:16:\"show_fontawesome\";i:0;s:9:\"big_icons\";i:0;s:13:\"disable_event\";i:0;s:29:\"leftsidebar_show_social_links\";i:0;s:30:\"rightsidebar_show_social_links\";i:0;s:18:\"show_social_header\";i:0;s:12:\"featured_bar\";i:0;s:20:\"welcome_post_content\";i:0;s:14:\"show_eventdate\";i:0;}", "yes");
INSERT INTO wpy4_options VALUES("232", "WPLANG", "", "yes");
INSERT INTO wpy4_options VALUES("326", "category10_image_term_id", "", "yes");
INSERT INTO wpy4_options VALUES("316", "category5_image_term_id", "", "yes");
INSERT INTO wpy4_options VALUES("318", "category6_image_term_id", "", "yes");
INSERT INTO wpy4_options VALUES("283", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO wpy4_options VALUES("28898", "disabled_likes", "0", "yes");
INSERT INTO wpy4_options VALUES("46541", "wordfence_ls_version", "1.0.5", "yes");
INSERT INTO wpy4_options VALUES("46542", "wordfence_version", "7.4.7", "yes");
INSERT INTO wpy4_options VALUES("46543", "wordfence_case", "1", "yes");
INSERT INTO wpy4_options VALUES("46544", "wordfence_installed", "1", "yes");
INSERT INTO wpy4_options VALUES("46545", "wordfenceActivated", "1", "yes");
INSERT INTO wpy4_options VALUES("46548", "wf_plugin_act_error", "", "yes");
INSERT INTO wpy4_options VALUES("25685", "widget_blog_subscription", "a:2:{i:2;a:7:{s:5:\"title\";s:27:\"Subscribe to Blog via Email\";s:21:\"subscribe_placeholder\";s:13:\"Email Address\";s:16:\"subscribe_button\";s:9:\"Subscribe\";s:15:\"success_message\";s:136:\"Success! An email was just sent to confirm your subscription. Please find the email now and click \'Confirm Follow\' to start subscribing.\";s:22:\"show_subscribers_total\";b:0;s:26:\"show_only_email_and_button\";b:0;s:14:\"subscribe_text\";s:99:\"Enter your email address to subscribe to this blog and receive notifications of new posts by email.\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("25656", "sharing-options", "a:1:{s:6:\"global\";a:5:{s:12:\"button_style\";s:9:\"icon-text\";s:13:\"sharing_label\";s:31:\"HELP TO SPREAD THE WORD ABROAD:\";s:10:\"open_links\";s:4:\"same\";s:4:\"show\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:7:\"gallery\";}s:6:\"custom\";a:0:{}}}", "yes");
INSERT INTO wpy4_options VALUES("25233", "wdps_fv022", "1", "no");
INSERT INTO wpy4_options VALUES("25234", "wdps_version", "1.0.59", "no");
INSERT INTO wpy4_options VALUES("25824", "open_graph_protocol_site_type", "", "yes");
INSERT INTO wpy4_options VALUES("25825", "facebook_admins", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("25826", "jetpack-twitter-cards-site-tag", "", "yes");
INSERT INTO wpy4_options VALUES("25249", "wdps_subscribe_done", "1", "yes");
INSERT INTO wpy4_options VALUES("245682", "litespeed.conf.object-non_persistent_groups", "a:4:{i:0;s:7:\"comment\";i:1;s:6:\"counts\";i:2;s:7:\"plugins\";i:3;s:13:\"wc_session_id\";}", "yes");
INSERT INTO wpy4_options VALUES("245680", "litespeed.conf.purge-hook_all", "a:10:{i:0;s:12:\"switch_theme\";i:1;s:18:\"wp_create_nav_menu\";i:2;s:18:\"wp_update_nav_menu\";i:3;s:18:\"wp_delete_nav_menu\";i:4;s:11:\"create_term\";i:5;s:10:\"edit_terms\";i:6;s:11:\"delete_term\";i:7;s:8:\"add_link\";i:8;s:9:\"edit_link\";i:9;s:11:\"delete_link\";}", "yes");
INSERT INTO wpy4_options VALUES("25658", "post_by_email_address1", "kefa696seso@post.wordpress.com", "yes");
INSERT INTO wpy4_options VALUES("25659", "jetpack_last_connect_url_check", "1579778974", "no");
INSERT INTO wpy4_options VALUES("25669", "tiled_galleries", "1", "yes");
INSERT INTO wpy4_options VALUES("25688", "gravatar_disable_hovercards", "enabled", "yes");
INSERT INTO wpy4_options VALUES("245817", "litespeed-cache-conf.bk", "a:127:{s:7:\"version\";s:7:\"2.9.9.2\";s:12:\"radio_select\";i:1;s:12:\"auto_upgrade\";b:0;s:4:\"news\";b:0;s:13:\"purge_upgrade\";b:1;s:10:\"cache_priv\";b:1;s:15:\"cache_commenter\";b:1;s:10:\"cache_rest\";b:1;s:16:\"cache_page_login\";b:1;s:10:\"timed_urls\";a:0:{}s:15:\"timed_urls_time\";s:0:\"\";s:13:\"cache_favicon\";b:1;s:15:\"cache_resources\";b:1;s:18:\"mobileview_enabled\";b:0;s:16:\"mobileview_rules\";a:7:{i:0;s:6:\"Mobile\";i:1;s:7:\"Android\";i:2;s:5:\"Silk/\";i:3;s:6:\"Kindle\";i:4;s:10:\"BlackBerry\";i:5;s:10:\"Opera Mini\";i:6;s:10:\"Opera Mobi\";}s:12:\"cache_object\";b:0;s:17:\"cache_object_kind\";b:0;s:17:\"cache_object_host\";s:9:\"localhost\";s:17:\"cache_object_port\";s:5:\"11211\";s:17:\"cache_object_life\";s:3:\"360\";s:23:\"cache_object_persistent\";b:1;s:18:\"cache_object_admin\";b:1;s:23:\"cache_object_transients\";b:1;s:18:\"cache_object_db_id\";i:0;s:17:\"cache_object_user\";s:0:\"\";s:17:\"cache_object_pswd\";s:0:\"\";s:13:\"cache_browser\";b:0;s:17:\"cache_browser_ttl\";i:2592000;s:12:\"login_cookie\";s:0:\"\";s:19:\"check_advancedcache\";b:1;s:23:\"use_http_for_https_vary\";b:0;s:17:\"debug_disable_all\";b:0;s:5:\"debug\";i:0;s:9:\"admin_ips\";a:1:{i:0;s:9:\"127.0.0.1\";}s:11:\"debug_level\";b:0;s:13:\"log_file_size\";i:3;s:9:\"heartbeat\";b:1;s:12:\"debug_cookie\";b:0;s:10:\"collaps_qs\";b:0;s:11:\"log_filters\";b:0;s:10:\"public_ttl\";i:604800;s:11:\"private_ttl\";i:1800;s:14:\"front_page_ttl\";i:604800;s:8:\"feed_ttl\";i:1;s:7:\"403_ttl\";i:3600;s:7:\"404_ttl\";i:3600;s:7:\"500_ttl\";i:3600;s:13:\"purge_by_post\";s:22:\"A.F.H.M.PGS.PGSRP.PT.T\";s:11:\"excludes_qs\";a:0:{}s:12:\"excludes_cat\";a:0:{}s:12:\"excludes_tag\";a:0:{}s:13:\"instant_click\";b:0;s:10:\"css_minify\";b:0;s:17:\"css_inline_minify\";b:0;s:11:\"css_combine\";b:0;s:21:\"css_combined_priority\";b:0;s:9:\"css_http2\";b:0;s:11:\"css_exclude\";a:0:{}s:9:\"js_minify\";b:0;s:16:\"js_inline_minify\";b:0;s:10:\"js_combine\";b:0;s:20:\"js_combined_priority\";b:0;s:8:\"js_http2\";b:0;s:10:\"js_exclude\";a:0:{}s:12:\"optimize_ttl\";i:604800;s:11:\"html_minify\";b:0;s:10:\"optm_qs_rm\";b:0;s:15:\"optm_ggfonts_rm\";b:0;s:14:\"optm_css_async\";b:0;s:13:\"optm_ccss_gen\";b:1;s:15:\"optm_ccss_async\";b:1;s:21:\"optm_css_async_inline\";b:1;s:13:\"optm_js_defer\";b:0;s:13:\"optm_emoji_rm\";b:0;s:19:\"optm_exclude_jquery\";b:1;s:18:\"optm_ggfonts_async\";b:0;s:13:\"optm_max_size\";d:1.1999999999999999555910790149937383830547332763671875;s:15:\"optm_rm_comment\";b:0;s:3:\"cdn\";b:0;s:7:\"cdn_ori\";a:0:{}s:11:\"cdn_exclude\";a:0:{}s:17:\"cdn_remote_jquery\";b:0;s:8:\"cdn_quic\";b:0;s:14:\"cdn_quic_email\";s:0:\"\";s:12:\"cdn_quic_key\";s:0:\"\";s:14:\"cdn_cloudflare\";b:0;s:20:\"cdn_cloudflare_email\";s:0:\"\";s:18:\"cdn_cloudflare_key\";s:0:\"\";s:19:\"cdn_cloudflare_name\";s:0:\"\";s:19:\"cdn_cloudflare_zone\";s:0:\"\";s:14:\"media_img_lazy\";b:0;s:26:\"media_img_lazy_placeholder\";s:0:\"\";s:22:\"media_placeholder_resp\";b:0;s:28:\"media_placeholder_resp_color\";s:7:\"#cfd4db\";s:28:\"media_placeholder_resp_async\";b:1;s:17:\"media_iframe_lazy\";b:0;s:23:\"media_img_lazyjs_inline\";b:0;s:15:\"media_optm_auto\";b:0;s:15:\"media_optm_cron\";b:1;s:14:\"media_optm_ori\";b:1;s:17:\"media_rm_ori_bkup\";b:0;s:15:\"media_optm_webp\";b:0;s:19:\"media_optm_lossless\";b:0;s:15:\"media_optm_exif\";b:0;s:18:\"media_webp_replace\";b:0;s:25:\"media_webp_replace_srcset\";b:0;s:4:\"hash\";s:32:\"Gfcc0XcUvgf7bkTrMSYLNF33QYWOnpZX\";s:15:\"nocache_cookies\";a:0:{}s:18:\"nocache_useragents\";a:0:{}s:21:\"crawler_include_posts\";b:1;s:21:\"crawler_include_pages\";b:1;s:20:\"crawler_include_cats\";b:1;s:20:\"crawler_include_tags\";b:1;s:20:\"crawler_excludes_cpt\";a:0:{}s:19:\"crawler_order_links\";s:9:\"date_desc\";s:14:\"crawler_usleep\";i:500;s:20:\"crawler_run_duration\";i:400;s:20:\"crawler_run_interval\";i:600;s:22:\"crawler_crawl_interval\";i:302400;s:15:\"crawler_threads\";i:3;s:18:\"crawler_load_limit\";i:1;s:17:\"crawler_domain_ip\";s:0:\"\";s:22:\"crawler_custom_sitemap\";s:0:\"\";s:19:\"crawler_cron_active\";b:0;s:11:\"esi_enabled\";b:0;s:17:\"esi_cached_admbar\";b:1;s:19:\"esi_cached_commform\";b:1;}", "yes");
INSERT INTO wpy4_options VALUES("245686", "litespeed.conf.cdn-ori_dir", "a:3:{i:0;s:10:\"wp-content\";i:1;s:11:\"wp-includes\";i:2;s:5:\"/min/\";}", "yes");
INSERT INTO wpy4_options VALUES("245688", "litespeed.conf.cache", "1", "yes");
INSERT INTO wpy4_options VALUES("245689", "litespeed.conf.hash", "Gfcc0XcUvgf7bkTrMSYLNF33QYWOnpZX", "yes");
INSERT INTO wpy4_options VALUES("25692", "wpcom_publish_posts_with_markdown", "1", "yes");
INSERT INTO wpy4_options VALUES("25694", "wpcom_publish_comments_with_markdown", "1", "yes");
INSERT INTO wpy4_options VALUES("25847", "category11_image_term_id", "", "yes");
INSERT INTO wpy4_options VALUES("202309", "jetpack_protect_error", "Invalid API Key", "no");
INSERT INTO wpy4_options VALUES("281174", "_site_transient_timeout_envato_market_themes", "1595621980", "no");
INSERT INTO wpy4_options VALUES("281175", "_site_transient_envato_market_themes", "a:4:{s:9:\"purchased\";a:0:{}s:6:\"active\";a:0:{}s:9:\"installed\";a:0:{}s:7:\"install\";a:0:{}}", "no");
INSERT INTO wpy4_options VALUES("280460", "jetpack_active_plan", "a:8:{s:10:\"product_id\";i:2002;s:12:\"product_slug\";s:12:\"jetpack_free\";s:12:\"product_name\";s:12:\"Jetpack Free\";s:18:\"product_name_short\";s:4:\"Free\";s:7:\"expired\";b:0;s:13:\"user_is_owner\";b:0;s:7:\"is_free\";b:1;s:8:\"features\";a:2:{s:6:\"active\";a:2:{i:0;s:7:\"akismet\";i:1;s:14:\"send-a-message\";}s:9:\"available\";a:13:{s:7:\"akismet\";a:6:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";}s:18:\"vaultpress-backups\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:25:\"vaultpress-backup-archive\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:24:\"vaultpress-storage-space\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:29:\"vaultpress-automated-restores\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:15:\"simple-payments\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:8:\"calendly\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:9:\"opentable\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:14:\"send-a-message\";a:6:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";}s:7:\"support\";a:6:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";}s:14:\"premium-themes\";a:2:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";}s:28:\"vaultpress-security-scanning\";a:2:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";}s:9:\"polldaddy\";a:2:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";}}}}", "yes");
INSERT INTO wpy4_options VALUES("244138", "fs_gdpr", "a:1:{s:2:\"u1\";a:1:{s:8:\"required\";b:0;}}", "yes");
INSERT INTO wpy4_options VALUES("262", "recently_activated", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("263", "ls-plugin-version", "6.1.0", "yes");
INSERT INTO wpy4_options VALUES("264", "ls-db-version", "6.0.0", "yes");
INSERT INTO wpy4_options VALUES("265", "ls-installed", "0", "yes");
INSERT INTO wpy4_options VALUES("266", "ls-google-fonts", "a:4:{i:0;a:2:{s:5:\"param\";s:28:\"Lato:100,300,regular,700,900\";s:5:\"admin\";b:0;}i:1;a:2:{s:5:\"param\";s:13:\"Open+Sans:300\";s:5:\"admin\";b:0;}i:2;a:2:{s:5:\"param\";s:20:\"Indie+Flower:regular\";s:5:\"admin\";b:0;}i:3;a:2:{s:5:\"param\";s:22:\"Oswald:300,regular,700\";s:5:\"admin\";b:0;}}", "yes");
INSERT INTO wpy4_options VALUES("267", "ls-date-installed", "1567646059", "yes");
INSERT INTO wpy4_options VALUES("269", "ocean-posts-slider-version", "1.0.13", "yes");
INSERT INTO wpy4_options VALUES("270", "ocean-social-sharing-version", "1.0.15", "yes");
INSERT INTO wpy4_options VALUES("275", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO wpy4_options VALUES("273", "widget_layerslider_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpy4_options VALUES("274", "vc_version", "5.5.4", "yes");
INSERT INTO wpy4_options VALUES("341", "layerslider_update_info", "O:8:\"stdClass\":5:{s:5:\"basic\";O:8:\"stdClass\":11:{s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"plugin\";s:27:\"LayerSlider/layerslider.php\";s:7:\"version\";s:6:\"6.11.1\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:3:\"url\";s:38:\"https://layerslider.kreaturamedia.com/\";s:7:\"package\";s:0:\"\";s:8:\"requires\";s:3:\"3.5\";s:6:\"tested\";s:5:\"5.4.1\";s:12:\"requires_php\";s:5:\"5.3.0\";s:14:\"upgrade_notice\";s:304:\"This is a massive update that is intended to maximize compatibility with the latest version of WordPress and other popular plugins. It also includes important security patches, new features, bug fixes, and a whole lot of important changes under the hood. Updating to this version is a MUST for everybody.\";}s:4:\"full\";O:8:\"stdClass\":21:{s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"homepage\";s:72:\"http://kreaturamedia.com/layerslider-responsive-wordpress-slider-plugin/\";s:5:\"p_url\";s:46:\"https://layerslider.kreaturamedia.com/pricing/\";s:7:\"version\";s:6:\"6.11.1\";s:12:\"last_updated\";s:10:\"2020-04-01\";s:8:\"requires\";s:3:\"3.5\";s:6:\"tested\";s:5:\"5.4.1\";s:12:\"requires_php\";s:5:\"5.3.0\";s:6:\"rating\";s:2:\"95\";s:11:\"num_ratings\";i:3147;s:14:\"upgrade_notice\";a:3:{s:6:\"stable\";s:304:\"This is a massive update that is intended to maximize compatibility with the latest version of WordPress and other popular plugins. It also includes important security patches, new features, bug fixes, and a whole lot of important changes under the hood. Updating to this version is a MUST for everybody.\";s:4:\"beta\";s:304:\"This is a massive update that is intended to maximize compatibility with the latest version of WordPress and other popular plugins. It also includes important security patches, new features, bug fixes, and a whole lot of important changes under the hood. Updating to this version is a MUST for everybody.\";s:4:\"edge\";s:304:\"This is a massive update that is intended to maximize compatibility with the latest version of WordPress and other popular plugins. It also includes important security patches, new features, bug fixes, and a whole lot of important changes under the hood. Updating to this version is a MUST for everybody.\";}s:6:\"author\";s:80:\"<a href=\"http://codecanyon.net/user/kreatura\" target=\"_blank\">Kreatura Media</a>\";s:3:\"url\";s:38:\"https://layerslider.kreaturamedia.com/\";s:8:\"external\";b:1;s:9:\"file_name\";s:10:\"plugin.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:8:\"sections\";a:3:{s:9:\"changelog\";s:343:\"<p style=\"text-align: justify;\">
	<a href=\"https://layerslider.kreaturamedia.com/release-log/\" target=\"_blank\">Click here to see the release log.</a> Don’t forget, the release log and all product-related news are also integrated right into LayerSlider. Look for the “LayerSlider News” section at the bottom of its main admin screen.
</p>\";s:12:\"installation\";s:563:\"<p style=\"text-align: justify;\">
	Updating the plugin won’t touch your sliders or settings. New versions always have backward compatibility. You don’t have to worry about losing your work. Not sure how to update? Check the <a href=\"https://layerslider.kreaturamedia.com/documentation/#updating\" target=\"_blank\">Updating</a> section of our online documentation.
</p>

<p style=\"text-align: justify;\">
	If you’re experiencing unwanted changes, it is always a good idea to check your settings since there are probably new options to control those changes.
</p>\";s:3:\"faq\";s:607:\"<p style=\"text-align: justify;\">
	Please visit our <a href=\"https://layerslider.kreaturamedia.com/help/\" target=\"_blank\">Help</a> page, where you can find all sorts of useful assets like <a href=\"https://layerslider.kreaturamedia.com/faq/\" target=\"_blank\">FAQs</a>, <a href=\"https://layerslider.kreaturamedia.com/documentation/\" target=\"_blank\">online documentation</a>, <a href=\"https://layerslider.kreaturamedia.com/documentation/#troubleshooting\" target=\"_blank\">troubleshooting</a>, and <a href=\"https://layerslider.kreaturamedia.com/documentation/#support\" target=\"_blank\">support</a> information.
</p>\";}s:4:\"slug\";s:11:\"LayerSlider\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";}s:15:\"_latest_version\";s:6:\"6.11.1\";s:14:\"_not_activated\";b:1;s:7:\"checked\";i:1591919709;}", "yes");
INSERT INTO wpy4_options VALUES("1589", "jetpack_next_sync_time_sync", "1595478952", "yes");
INSERT INTO wpy4_options VALUES("601", "jetpack_updates_sync_checksum", "a:3:{s:14:\"update_plugins\";i:3543325603;s:13:\"update_themes\";i:1685444538;s:11:\"update_core\";i:710052249;}", "yes");
INSERT INTO wpy4_options VALUES("244135", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:42:\"the-events-calendar/common/vendor/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:5:\"2.3.2\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1591919748;s:11:\"plugin_path\";s:43:\"the-events-calendar/the-events-calendar.php\";}}s:7:\"abspath\";s:31:\"/home/oheifer1/heavenlykey.org/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:43:\"the-events-calendar/the-events-calendar.php\";s:8:\"sdk_path\";s:42:\"the-events-calendar/common/vendor/freemius\";s:7:\"version\";s:5:\"2.3.2\";s:13:\"in_activation\";b:1;s:9:\"timestamp\";i:1591919748;}}", "yes");
INSERT INTO wpy4_options VALUES("244136", "fs_debug_mode", "", "yes");
INSERT INTO wpy4_options VALUES("244137", "fs_accounts", "a:5:{s:21:\"id_slug_type_path_map\";a:1:{i:3069;a:3:{s:4:\"slug\";s:19:\"the-events-calendar\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:43:\"the-events-calendar/the-events-calendar.php\";}}s:11:\"plugin_data\";a:1:{s:19:\"the-events-calendar\";a:15:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:43:\"the-events-calendar/the-events-calendar.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1591919748;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.3.2\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:7:\"5.1.2.1\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:19:\"www.heavenlykey.org\";s:9:\"server_ip\";s:14:\"129.205.113.50\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1591919748;s:7:\"version\";s:7:\"5.1.2.1\";}s:15:\"prev_is_premium\";b:0;}}s:13:\"file_slug_map\";a:1:{s:43:\"the-events-calendar/the-events-calendar.php\";s:19:\"the-events-calendar\";}s:7:\"plugins\";a:1:{s:19:\"the-events-calendar\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:12:\"premium_slug\";s:27:\"the-events-calendar-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:43:\"the-events-calendar/the-events-calendar.php\";s:7:\"version\";s:7:\"5.1.2.1\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_e32061abc28cfedf231f3e5c4e626\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3069\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;}}s:9:\"unique_id\";s:32:\"e3d9f4b990bda5ec761635c4ffca2e59\";}", "yes");
INSERT INTO wpy4_options VALUES("407", "jetpack_available_modules", "a:1:{s:5:\"8.6.1\";a:42:{s:8:\"carousel\";s:3:\"1.5\";s:13:\"comment-likes\";s:3:\"5.1\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:9:\"copy-post\";s:3:\"7.0\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:16:\"google-analytics\";s:3:\"4.5\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:11:\"lazy-images\";s:5:\"5.6.0\";s:5:\"likes\";s:3:\"2.2\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"masterbar\";s:3:\"4.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"photon-cdn\";s:3:\"6.6\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:6:\"search\";s:3:\"5.0\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";s:21:\"woocommerce-analytics\";s:3:\"8.4\";s:7:\"wordads\";s:5:\"4.5.0\";}}", "yes");
INSERT INTO wpy4_options VALUES("408", "jetpack_log", "a:1:{i:0;a:4:{s:4:\"time\";i:1567718380;s:7:\"user_id\";i:1;s:7:\"blog_id\";b:0;s:4:\"code\";s:8:\"register\";}}", "no");
INSERT INTO wpy4_options VALUES("409", "jetpack_tos_agreed", "1", "yes");
INSERT INTO wpy4_options VALUES("410", "jetpack_secrets", "a:1:{s:19:\"jetpack_authorize_1\";a:3:{s:8:\"secret_1\";s:32:\"n0m0izG2qNMT7riBjlvm6aKTsTY5jVjv\";s:8:\"secret_2\";s:32:\"g5LzK5RvrKNUE9yYsiOCguRaKuLTgjAY\";s:3:\"exp\";i:1579786175;}}", "no");
INSERT INTO wpy4_options VALUES("412", "jetpack_private_options", "a:2:{s:10:\"blog_token\";s:65:\"sAuiGqtuEGDz$ZDG5rNMqDhxlZUO6S%d.(Wo)^p9uaQ96Uxeh9Icoz4W#1T)U84S1\";s:11:\"user_tokens\";a:1:{i:1;s:67:\"spxvj^910jlFmiy7ei3v8P96$!811pL0.#n6fqMg4k0fYO$$4DrYFqqAvQ()Mu9Zs.1\";}}", "yes");
INSERT INTO wpy4_options VALUES("415", "jetpack_unique_connection", "a:3:{s:9:\"connected\";i:1;s:12:\"disconnected\";i:0;s:7:\"version\";s:5:\"3.6.1\";}", "yes");
INSERT INTO wpy4_options VALUES("416", "jetpack_sync_settings_max_queue_size", "1000", "yes");
INSERT INTO wpy4_options VALUES("417", "jetpack_sync_settings_max_queue_lag", "900", "yes");
INSERT INTO wpy4_options VALUES("418", "jetpack_sync_full__started", "1567718434", "no");
INSERT INTO wpy4_options VALUES("419", "jetpack_sync_full__params", "a:4:{s:7:\"options\";b:1;s:9:\"functions\";b:1;s:9:\"constants\";b:1;s:5:\"users\";a:1:{i:0;i:1;}}", "no");
INSERT INTO wpy4_options VALUES("420", "jetpack_sync_full_config", "a:4:{s:9:\"constants\";b:1;s:9:\"functions\";b:1;s:7:\"options\";b:1;s:5:\"users\";a:1:{i:0;i:1;}}", "no");
INSERT INTO wpy4_options VALUES("421", "jetpack_sync_full_enqueue_status", "a:4:{s:9:\"constants\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:9:\"functions\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:7:\"options\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:5:\"users\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}}", "no");
INSERT INTO wpy4_options VALUES("425", "jetpack_sync_settings_dequeue_max_bytes", "500000", "yes");
INSERT INTO wpy4_options VALUES("426", "jetpack_sync_settings_upload_max_bytes", "600000", "yes");
INSERT INTO wpy4_options VALUES("427", "jetpack_sync_settings_upload_max_rows", "500", "yes");
INSERT INTO wpy4_options VALUES("428", "jetpack_sync_settings_sync_wait_time", "10", "yes");
INSERT INTO wpy4_options VALUES("429", "jetpack_sync_settings_sync_wait_threshold", "5", "yes");
INSERT INTO wpy4_options VALUES("430", "jetpack_sync_settings_enqueue_wait_time", "10", "yes");
INSERT INTO wpy4_options VALUES("431", "jetpack_sync_settings_queue_max_writes_sec", "100", "yes");
INSERT INTO wpy4_options VALUES("432", "jetpack_sync_settings_post_types_blacklist", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("433", "jetpack_sync_settings_taxonomies_blacklist", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("434", "jetpack_sync_settings_render_filtered_content", "0", "yes");
INSERT INTO wpy4_options VALUES("435", "jetpack_sync_settings_post_meta_whitelist", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("436", "jetpack_sync_settings_comment_meta_whitelist", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("437", "jetpack_sync_settings_max_enqueue_full_sync", "100", "yes");
INSERT INTO wpy4_options VALUES("438", "jetpack_sync_settings_max_queue_size_full_sync", "1000", "yes");
INSERT INTO wpy4_options VALUES("439", "jetpack_sync_settings_sync_via_cron", "1", "yes");
INSERT INTO wpy4_options VALUES("440", "jetpack_sync_settings_cron_sync_time_limit", "30", "yes");
INSERT INTO wpy4_options VALUES("441", "jetpack_sync_settings_known_importers", "a:6:{s:16:\"Blogger_Importer\";s:7:\"blogger\";s:13:\"LJ_API_Import\";s:11:\"livejournal\";s:9:\"MT_Import\";s:2:\"mt\";s:10:\"RSS_Import\";s:3:\"rss\";s:20:\"WC_Tax_Rate_Importer\";s:12:\"woo-tax-rate\";s:9:\"WP_Import\";s:9:\"wordpress\";}", "yes");
INSERT INTO wpy4_options VALUES("446", "jetpack_sync_full__queue_finished", "1567718434", "yes");
INSERT INTO wpy4_options VALUES("523", "trusted_ip_header", "", "no");
INSERT INTO wpy4_options VALUES("503", "jetpack_testimonial", "0", "yes");
INSERT INTO wpy4_options VALUES("451", "jetpack_active_modules", "a:19:{i:0;s:12:\"contact-form\";i:1;s:21:\"enhanced-distribution\";i:2;s:8:\"json-api\";i:3;s:5:\"notes\";i:4;s:7:\"protect\";i:5;s:5:\"stats\";i:6;s:18:\"verification-tools\";i:7;s:10:\"photon-cdn\";i:8;s:6:\"photon\";i:9;s:13:\"tiled-gallery\";i:10;s:8:\"comments\";i:11;s:13:\"subscriptions\";i:12;s:19:\"gravatar-hovercards\";i:13;s:8:\"markdown\";i:14;s:13:\"comment-likes\";i:15;s:10:\"sharedaddy\";i:16;s:13:\"post-by-email\";i:17;s:9:\"publicize\";i:18;s:21:\"woocommerce-analytics\";}", "yes");
INSERT INTO wpy4_options VALUES("460", "jetpack_protect_key", "e48dc43a4cfaddd29e07d88ce283ab70f0b73b8b", "no");
INSERT INTO wpy4_options VALUES("513", "verification_services_codes", "0", "yes");
INSERT INTO wpy4_options VALUES("515", "stats_options", "a:7:{s:9:\"admin_bar\";b:1;s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:11:\"count_roles\";a:0:{}s:7:\"blog_id\";i:147679448;s:12:\"do_not_track\";b:1;s:10:\"hide_smile\";b:1;s:7:\"version\";s:1:\"9\";}", "yes");
INSERT INTO wpy4_options VALUES("497", "jetpack_sync_full__options_sent", "1", "no");
INSERT INTO wpy4_options VALUES("498", "jetpack_sync_full__options_sent_total", "-1", "no");
INSERT INTO wpy4_options VALUES("499", "jetpack_sync_full__users_sent", "1", "no");
INSERT INTO wpy4_options VALUES("500", "jetpack_sync_full__users_sent_total", "1", "no");
INSERT INTO wpy4_options VALUES("501", "jetpack_sync_full__finished", "1567718436", "no");
INSERT INTO wpy4_options VALUES("492", "jetpack_sync_full__send_started", "1567718436", "no");
INSERT INTO wpy4_options VALUES("493", "jetpack_sync_full__constants_sent", "1", "no");
INSERT INTO wpy4_options VALUES("494", "jetpack_sync_full__constants_sent_total", "-1", "no");
INSERT INTO wpy4_options VALUES("495", "jetpack_sync_full__functions_sent", "1", "no");
INSERT INTO wpy4_options VALUES("496", "jetpack_sync_full__functions_sent_total", "-1", "no");
INSERT INTO wpy4_options VALUES("489", "jetpack_next_sync_time_full-sync-enqueue", "1595619519", "yes");
INSERT INTO wpy4_options VALUES("490", "jpsq_full_sync_checkout", "0:0", "no");
INSERT INTO wpy4_options VALUES("491", "jetpack_callables_sync_checksum", "a:34:{s:18:\"wp_max_upload_size\";i:869269328;s:15:\"is_main_network\";i:734881840;s:13:\"is_multi_site\";i:734881840;s:17:\"main_network_site\";i:223946885;s:8:\"site_url\";i:223946885;s:8:\"home_url\";i:223946885;s:16:\"single_user_site\";i:734881840;s:7:\"updates\";i:1288648336;s:28:\"has_file_system_write_access\";i:4261170317;s:21:\"is_version_controlled\";i:734881840;s:10:\"taxonomies\";i:2711374896;s:10:\"post_types\";i:2778870743;s:18:\"post_type_features\";i:9919482;s:10:\"shortcodes\";i:2650938612;s:27:\"rest_api_allowed_post_types\";i:2544842423;s:32:\"rest_api_allowed_public_metadata\";i:223132457;s:24:\"sso_is_two_step_required\";i:734881840;s:26:\"sso_should_hide_login_form\";i:734881840;s:18:\"sso_match_by_email\";i:4261170317;s:21:\"sso_new_user_override\";i:734881840;s:29:\"sso_bypass_default_login_form\";i:734881840;s:10:\"wp_version\";i:2592268601;s:11:\"get_plugins\";i:3277286925;s:24:\"get_plugins_action_links\";i:3085251417;s:14:\"active_modules\";i:589524882;s:16:\"hosting_provider\";i:769900095;s:6:\"locale\";i:110763218;s:13:\"site_icon_url\";i:3246442850;s:5:\"roles\";i:2269670675;s:8:\"timezone\";i:3808505409;s:24:\"available_jetpack_blocks\";i:1846135113;s:13:\"paused_themes\";i:223132457;s:14:\"paused_plugins\";i:223132457;s:26:\"main_network_site_wpcom_id\";i:1330329420;}", "no");
INSERT INTO wpy4_options VALUES("479", "jetpack_constants_sync_checksum", "a:20:{s:16:\"EMPTY_TRASH_DAYS\";i:2473281379;s:17:\"WP_POST_REVISIONS\";i:4261170317;s:26:\"AUTOMATIC_UPDATER_DISABLED\";i:634125391;s:7:\"ABSPATH\";i:3713347718;s:14:\"WP_CONTENT_DIR\";i:2966974643;s:9:\"FS_METHOD\";i:634125391;s:18:\"DISALLOW_FILE_EDIT\";i:634125391;s:18:\"DISALLOW_FILE_MODS\";i:634125391;s:19:\"WP_AUTO_UPDATE_CORE\";i:634125391;s:22:\"WP_HTTP_BLOCK_EXTERNAL\";i:634125391;s:19:\"WP_ACCESSIBLE_HOSTS\";i:634125391;s:16:\"JETPACK__VERSION\";i:2805492143;s:12:\"IS_PRESSABLE\";i:634125391;s:15:\"DISABLE_WP_CRON\";i:634125391;s:17:\"ALTERNATE_WP_CRON\";i:634125391;s:20:\"WP_CRON_LOCK_TIMEOUT\";i:3994858278;s:11:\"PHP_VERSION\";i:1581579137;s:15:\"WP_MEMORY_LIMIT\";i:3065409971;s:19:\"WP_MAX_MEMORY_LIMIT\";i:1474498405;s:8:\"WP_DEBUG\";i:734881840;}", "yes");
INSERT INTO wpy4_options VALUES("480", "jetpack_sync_https_history_main_network_site_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO wpy4_options VALUES("481", "jetpack_sync_https_history_site_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO wpy4_options VALUES("482", "jetpack_sync_https_history_home_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO wpy4_options VALUES("280840", "_transient_timeout_jetpack_is_single_user", "1595631272", "no");
INSERT INTO wpy4_options VALUES("280841", "_transient_jetpack_is_single_user", "2", "no");
INSERT INTO wpy4_options VALUES("485", "jpsq_sync_checkout", "0:0", "no");
INSERT INTO wpy4_options VALUES("488", "jetpack_plugin_api_action_links", "a:6:{s:19:\"jetpack/jetpack.php\";a:3:{s:7:\"Jetpack\";s:58:\"http://www.heavenlykey.org/wp-admin/admin.php?page=jetpack\";s:8:\"Settings\";s:68:\"http://www.heavenlykey.org/wp-admin/admin.php?page=jetpack#/settings\";s:7:\"Support\";s:67:\"http://www.heavenlykey.org/wp-admin/admin.php?page=jetpack-debugger\";}s:35:\"litespeed-cache/litespeed-cache.php\";a:1:{s:8:\"Settings\";s:66:\"http://www.heavenlykey.org/wp-admin/admin.php?page=litespeed-cache\";}s:41:\"mega-addons-for-visual-composer/index.php\";a:1:{s:18:\"Upgrade To Premium\";s:29:\"https://1.envato.market/02aNL\";}s:33:\"post-slider-wd/post-slider-wd.php\";a:1:{s:10:\"Deactivate\";s:126:\"http://www.heavenlykey.org/wp-admin/plugins.php?action=deactivate&plugin=post-slider-wd/post-slider-wd.php&_wpnonce=003e794469\";}s:23:\"wordfence/wordfence.php\";a:1:{s:18:\"Upgrade To Premium\";s:48:\"https://www.wordfence.com/zz12/wordfence-signup/\";}s:27:\"js_composer/js_composer.php\";a:1:{s:8:\"Settings\";s:61:\"http://www.heavenlykey.org/wp-admin/admin.php?page=vc-general\";}}", "yes");
INSERT INTO wpy4_options VALUES("532", "stats_cache", "a:2:{s:32:\"f0891727199965c643b6bca63b33cc63\";a:1:{i:1595618322;a:1:{i:0;a:4:{s:7:\"post_id\";s:2:\"17\";s:10:\"post_title\";s:0:\"\";s:14:\"post_permalink\";s:27:\"http://www.heavenlykey.org/\";s:5:\"views\";s:1:\"1\";}}}s:32:\"e982a9311143d5afa64dbac2de154793\";a:1:{i:1595618322;a:0:{}}}", "yes");
INSERT INTO wpy4_options VALUES("281005", "_transient_timeout_jetpack_jitm_08bf9098d9a6d34d4ed513637a6cb8c", "1595607911", "no");
INSERT INTO wpy4_options VALUES("281006", "_transient_jetpack_jitm_08bf9098d9a6d34d4ed513637a6cb8c", "a:1:{s:18:\"last_response_time\";i:1595607611;}", "no");
INSERT INTO wpy4_options VALUES("281008", "_transient_timeout_settings_errors", "1595607886", "no");
INSERT INTO wpy4_options VALUES("281157", "_transient_timeout_jetpack_jitm_81a186f524288fc8fe73c5a17401a14", "1595618623", "no");
INSERT INTO wpy4_options VALUES("281158", "_transient_jetpack_jitm_81a186f524288fc8fe73c5a17401a14", "a:1:{s:18:\"last_response_time\";i:1595618322;}", "no");
INSERT INTO wpy4_options VALUES("280993", "_site_transient_timeout_community-events-9597ba538e48c6fecec51d95b318131f", "1595650802", "no");
INSERT INTO wpy4_options VALUES("280994", "_site_transient_community-events-9597ba538e48c6fecec51d95b318131f", "a:3:{s:9:\"sandboxed\";b:0;s:8:\"location\";a:1:{s:2:\"ip\";s:13:\"129.205.124.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO wpy4_options VALUES("280995", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1595650803", "no");
INSERT INTO wpy4_options VALUES("280996", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"News –  – WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jul 2020 23:16:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.5-beta3-48594\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:60:\"
		
		
		
		
		
				
		
		

					
										
					
		
		
			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.5 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jul 2020 17:51:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8706\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:324:\"WordPress 5.5 Beta 3 is now available! This software is still in development,so it’s not recommended to run this version on a production site. Consider setting up a test site to play with the new version. You can test WordPress 5.5 Beta 3 in two ways: Try the WordPress Beta Tester plugin (choose the “bleeding [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3876:\"
<p>WordPress 5.5 Beta 3 is now available!</p>



<p id=\"block-81bd56b9-ea44-43ad-ab36-a5ae78b54375\"><strong>This software is still in development,</strong>so it’s not recommended to run this version on a production site. Consider setting up a test site to play with the new version.</p>



<p id=\"block-7cc1bbc6-17f9-44c5-8f67-da4e3059ad69\">You can test WordPress 5.5 Beta 3 in two ways:</p>



<ul id=\"block-4840af57-f44b-4d9f-aa64-c6a452392e42\"><li>Try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (choose the “bleeding edge nightlies” option)</li><li>Or <a href=\"https://wordpress.org/wordpress-5.5-beta3.zip\">download the beta here</a> (zip).</li></ul>



<p id=\"block-a40528cb-eb3b-4c8a-8f5e-aa700f1ba086\">WordPress 5.5 is slated for release on <a href=\"https://make.wordpress.org/core/5-5/\">August 11th, 2020</a>, and <strong>we need your help to get there</strong>!</p>



<p>Thank you to all of the contributors who tested the <a href=\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-2/\">beta 2</a> development release and gave feedback. Testing for bugs is a critical part of polishing every release and a great way to contribute to WordPress. </p>



<h2 id=\"block-15d6d57f-905d-4a47-9f66-839468a5375a\">Some highlights</h2>



<p id=\"block-85da84ec-c841-42f9-8d3b-1a4537a61d10\">Since <a href=\"https://wordpress.org/news/2020/02/wordpress-5-4-beta-2/\">beta 2</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=07%2F15%2F2020..07%2F21%2F2020&amp;milestone=5.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">43 bugs</a> have been fixed. Here are a few changes in beta 3:</p>



<ul><li>Plugin and theme versions are now shared in the emails when automatically updated (see <a href=\"https://core.trac.wordpress.org/ticket/50350\">#50350</a>).</li><li>REST API routes without a <code>permission_callback</code> now trigger a <code>_doing_it_wrong()</code> warning (see <a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/50075\">#50075</a>).</li><li>Over 23 Gutenberg changes and updates (see <a href=\"https://github.com/WordPress/gutenberg/pull/24068\">#24068</a> and <a href=\"https://core.trac.wordpress.org/ticket/50712\">#50712</a>).</li><li>A bug with the new import and export database Dashicons has been fixed (see <a href=\"https://core.trac.wordpress.org/ticket/49913\">#49913</a>).</li></ul>



<h2 id=\"block-76156b2b-0a52-4502-b585-6cbe9481f55b\">Developer notes</h2>



<p id=\"block-3fe5e264-0a95-4f12-9a18-0cb9dc5955d1\">WordPress 5.5 has lots of refinements to polish the developer experience. To keep up, subscribe to the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> and pay special attention to the <a href=\"https://make.wordpress.org/core/tag/5-5+dev-notes/\">developers’ notes</a> for updates on those and other changes that could affect your products.</p>



<h2 id=\"block-bc89fd56-47b0-439f-8e2c-4a642c80a616\">How to Help</h2>



<p id=\"block-3ff83a77-8b54-4061-ae2d-45fc984cbd76\">Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help translate WordPress into more than 100 languages</a>!</p>



<p id=\"block-9d871099-ec49-446c-8322-9e49b7498c10\">If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. We’d love to hear from you!</p>



<p id=\"block-bd71c1d3-39d9-4b2a-8193-3486497b45fd\">If you’re comfortable writing a reproducible bug report, <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>, where you can also find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"8706\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"
		
		
		
		
		
				
		
		

					
										
					
		
		
			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.5 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Jul 2020 17:24:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8681\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"WordPress 5.5 Beta 2 is now available! This software is still in development,&#160;so it’s not recommended to run this version on a production site. Consider setting up a test site to play with the new version. You can test WordPress 5.5 beta 2 in two ways: Try the&#160;WordPress Beta Tester&#160;plugin (choose the “bleeding edge nightlies” [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4552:\"
<p id=\"block-000046ff-d8e6-40a8-9869-2dd39e50f270\"><br>WordPress 5.5 Beta 2 is now available!</p>



<p id=\"block-81bd56b9-ea44-43ad-ab36-a5ae78b54375\"><strong><strong>This software is still in development,</strong>&nbsp;</strong>so it’s not recommended to run this version on a production site. Consider setting up a test site to play with the new version.</p>



<p id=\"block-7cc1bbc6-17f9-44c5-8f67-da4e3059ad69\">You can test WordPress 5.5 beta 2 in two ways:</p>



<ul id=\"block-4840af57-f44b-4d9f-aa64-c6a452392e42\"><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option)</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.5-beta2.zip\">download the beta here</a>&nbsp;(zip).</li></ul>



<p id=\"block-a40528cb-eb3b-4c8a-8f5e-aa700f1ba086\">WordPress 5.5 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-5/\">August 11th, 2020</a>, and <strong>we need your help to get there</strong>!</p>



<p>Thank you to all of the contributors that tested the <a href=\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-1/\">beta 1</a> development release and provided feedback. Testing for bugs is an important part of polishing each release and a great way to contribute to WordPress. Here are some of the changes since beta 1 to pay close attention to while testing.</p>



<h2 id=\"block-15d6d57f-905d-4a47-9f66-839468a5375a\">Some highlights</h2>



<p id=\"block-85da84ec-c841-42f9-8d3b-1a4537a61d10\">Since <a href=\"https://wordpress.org/news/2020/02/wordpress-5-4-beta-1/\">beta 1</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=07%2F08%2F2020..07%2F14%2F2020&amp;milestone=5.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">48 bugs</a> have been fixed. Here is a summary of a few changes included in beta 2:</p>



<ul><li>19 additional bugs have been fixed in the block editor (see <a href=\"https://github.com/WordPress/gutenberg/pull/23903\">#23903</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/23905\">#23905</a>).</li><li>The Dashicons icon font has been updated (see <a href=\"https://core.trac.wordpress.org/ticket/49913\">#49913</a>).</li><li>Broken widgets stemming from changes in Beta 1 have been fixed (see <a href=\"https://core.trac.wordpress.org/ticket/50609\">#50609</a>).</li><li>Query handling when counting revisions has been improved (see <a href=\"https://core.trac.wordpress.org/ticket/34560\">#34560</a>).</li><li>An alternate, expanded view was added for <code>wp_list_table</code> (see <a href=\"https://core.trac.wordpress.org/ticket/49715\">#49715</a>).</li><li>Some adjustments were made to the handling of default terms for custom taxonomies (see <a href=\"https://core.trac.wordpress.org/ticket/43517\">#43517</a>)</li></ul>



<p>Several updates have been made to the block editor. For details, see <a href=\"https://github.com/WordPress/gutenberg/pull/23903\">#23903</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/23905\">#23905</a>.</p>



<h2 id=\"block-76156b2b-0a52-4502-b585-6cbe9481f55b\">Developer notes</h2>



<p id=\"block-3fe5e264-0a95-4f12-9a18-0cb9dc5955d1\">WordPress 5.5 has lots of refinements to polish the developer experience. To keep up, subscribe to the&nbsp;<a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>&nbsp;and pay special attention to the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5-5+dev-notes/\">developers’ notes</a>&nbsp;for updates on those and other changes that could affect your products.</p>



<h2 id=\"block-bc89fd56-47b0-439f-8e2c-4a642c80a616\">How to Help</h2>



<p id=\"block-3ff83a77-8b54-4061-ae2d-45fc984cbd76\">Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help us translate WordPress into more than 100 languages</a>!</p>



<p id=\"block-9d871099-ec49-446c-8322-9e49b7498c10\">If you think you’ve found a bug, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you!</p>



<p id=\"block-bd71c1d3-39d9-4b2a-8193-3486497b45fd\">If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>,&nbsp;where you can also find a list of&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"8681\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:60:\"
		
		
		
		
		
				
		
		

					
										
					
		
		
			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.5 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Jul 2020 21:49:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8624\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"WordPress 5.5 Beta 1 is now available for testing! This software is still in development,&#160;so it&#8217;s not recommended to run this version on a production site. Consider setting up a test site to play with the new version. You can test the WordPress 5.5 beta in two ways: Try the&#160;WordPress Beta Tester&#160;plugin (choose the “bleeding [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9616:\"
<p>WordPress 5.5 Beta 1 is now available for testing!</p>



<p><strong>This software is still in development,</strong>&nbsp;so it&#8217;s not recommended to run this version on a production site. Consider setting up a test site to play with the new version.</p>



<p>You can test the WordPress 5.5 beta in two ways:</p>



<ul><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option)</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.5-beta1.zip\">download the beta here&nbsp;(zip)</a>.</li></ul>



<p>The current target for final release is August 11, 2020. This is only <strong>five weeks away</strong>. Your help is needed to ensure this release is tested properly.</p>



<p>Testing for bugs is an important part of polishing the release during the beta stage and a great way to contribute. Here are some of the big changes and features to pay close attention to while testing.</p>



<h2><strong>Block editor: features and improvements</strong></h2>



<p>WordPress 5.5 will include ten releases of the Gutenberg plugin, bringing with it a long list of exciting new features. Here are just a few:</p>



<ul><li><strong>Inline image editing &#8211; </strong>Crop, rotate, and zoom photos inline right from image blocks.</li><li><strong>Block patterns</strong> &#8211; Building elaborate pages can be a breeze with new block patterns. Several are included by default.</li><li><strong>Device previews</strong> &#8211; See how your content will look to users on many different screen sizes. </li><li><strong>End block overwhelm</strong>. The new block inserter panel displays streamlined categories and collections. As a bonus, it supports patterns and integrates with the new block directory right out of the box.</li><li><strong>Discover, install, and insert third-party blocks</strong> from your editor using the new block directory.</li><li>A better, <strong>smoother editing experience </strong>with:&nbsp;<ul><li>Refined drag-and-drop</li><li>Block movers that you can see and grab</li><li>Parent block selection</li><li>Contextual focus highlights</li><li>Multi-select formatting lets you change a bunch of blocks at once&nbsp;</li><li>Ability to copy and relocate blocks easily</li><li>And, better performance</li></ul></li><li><strong>An expanded design toolset for themes.</strong></li><li>Now <strong>add backgrounds and gradients</strong> to more kinds of blocks, like groups, columns, media &amp; text</li><li>And <strong>support for more types of measurements</strong> &#8212; not just pixels. Choose ems, rems, percentages, vh, vw, and more! Plus, adjust line heights while typing, turning writing and typesetting into the seamless act.</li></ul>



<p>In all, WordPress 5.5 brings more than 1,500 useful improvements to the block editor experience.&nbsp;</p>



<p>To see all of the features for each release in detail check out the release posts: <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v7.5.0\">7.5</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v7.6.0\">7.6</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v7.7.0\">7.7</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v7.8.0\">7.8</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v7.9.0\">7.9</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v8.0.0\">8.0</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v8.1.0\">8.1</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v8.2.0\">8.2</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v8.3.0\">8.3</a>, and <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v8.4.0\">8.4</a>.</p>



<h2><strong>Wait! There’s more!</strong></h2>



<h3><strong>XML sitemaps</strong></h3>



<p><a href=\"https://make.wordpress.org/core/2020/06/10/merge-announcement-extensible-core-sitemaps/\">XML Sitemaps are now included in WordPress</a> and enabled by default. Sitemaps are essential to search engines discovering the content on your website. Your site&#8217;s home page, posts, pages, custom post types, and more will be included to improve your site&#8217;s visibility.</p>



<h3><strong>Auto-updates for plugins and themes</strong></h3>



<p><a href=\"https://make.wordpress.org/core/tag/core-auto-updates/\">WordPress 5.5 also brings auto-updates for plugins and themes</a>. Easily control which plugins and themes keep themselves up to date on their own. It&#8217;s always recommended that you run the latest versions of all plugins and themes. The addition of this feature makes that easier than ever!</p>



<h3><strong>Lazy-loading images</strong></h3>



<p><a href=\"https://make.wordpress.org/core/2020/04/08/lazy-loading-of-images-is-in-core/\">WordPress 5.5 will include native support for lazy-loaded images</a> utilizing new browser standards. With lazy-loading, images will not be sent to users until they approach the viewport. This saves bandwidth for everyone (users, hosts, ISPs), makes it easier for those with slower internet speeds to browse the web, saves electricity, and more.</p>



<h3><strong>Better accessibility</strong></h3>



<p>With every release, WordPress works hard to improve accessibility. Version 5.5 is no different and packs a parcel of accessibility fixes and enhancements. Take a look:</p>



<ul><li>List tables now come with extensive, alternate view modes.</li><li>Link-list widgets can now be converted to HTML5 navigation blocks.</li><li>Copying links in media screens and modal dialogs can now be done with a simple click of a button.</li><li>Disabled buttons now actually look disabled.</li><li>Meta boxes can now be moved with the keyboard.</li><li>A custom logo on the front page no longer links to the front page.</li><li>Assistive devices can now see status messages in the Image Editor.</li><li>The shake animation indicating a login failure now respects the user&#8217;s choices in the <code>prefers-reduced-motion</code> media query.</li><li>Redundant <code>Error:</code> prefixes have been removed from error notices.</li></ul>



<h2><strong>Miscellaneous Changes</strong></h2>



<ul><li>Plugins and themes can now be updated by uploading a ZIP file.</li><li><a href=\"https://make.wordpress.org/core/2020/06/26/wordpress-5-5-better-fine-grained-control-of-redirect_guess_404_permalink/\">More finely grained control of redirect_guess_404_permalink()</a>.</li><li><a href=\"https://make.wordpress.org/core/2020/07/01/external-library-updates-in-wordpress-5-5-call-for-testing/\">Several packaged external libraries have been updated</a>, including PHPMailer, SimplePie, Twemoji, Masonry, and more!</li></ul>



<p>Keep your eyes on the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/5-5+dev-notes/\">5.5-related developer notes</a> in the coming weeks, breaking down these and other changes in greater detail.</p>



<p>So far, contributors have fixed more than <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=5.5&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">360 tickets in WordPress 5.5</a>, including <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;status=reopened&amp;type=enhancement&amp;milestone=5.5&amp;or&amp;status=closed&amp;status=reopened&amp;type=feature+request&amp;milestone=5.5&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;col=changetime&amp;col=keywords&amp;order=changetime\">157 new features and enhancements</a>, and more bug fixes are on the way.</p>



<h2><strong>How You Can Help</strong></h2>



<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help translate WordPress into more than 100 languages</a>!</p>



<p>If you think you’ve found a bug, please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. We would love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. That’s also where you can find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>



<p class=\"has-small-font-size\"><em>Props to <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>, <a href=\'https://profiles.wordpress.org/yvettesonneveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>yvettesonneveld</a>, <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a>, and <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a> for compiling/writing this post, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a> for editing/proof reading, and <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, and <a href=\'https://profiles.wordpress.org/andreamiddleton/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>andreamiddleton</a> for final review.</em></p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"8624\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		

					
										
					
		
		
			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: June 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2020/07/the-month-in-wordpress-june-2020/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Jul 2020 05:52:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8614\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:353:\"June was an exciting month for WordPress! Major changes are coming to the Gutenberg plugin, and WordCamp Europe brought the WordPress community closer together. Read on to learn more and to get all the latest updates.&#160; WordPress 5.4.2 released We said hello to WordPress 5.4.2 on June 10. This security and maintenance release features 17 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7872:\"
<p>June was an exciting month for WordPress! Major changes are coming to the Gutenberg plugin, and WordCamp Europe brought the WordPress community closer together. Read on to learn more and to get all the latest updates.&nbsp;</p>



<hr class=\"wp-block-separator\" />



<h2>WordPress 5.4.2 released</h2>



<p>We said hello to WordPress 5.4.2 on June 10. This security and maintenance release features 17 fixes and 4 enhancements, so we recommend that you update your sites immediately. To download WordPress 5.4.2, visit your Dashboard, click on <strong>Updates</strong>, then <strong>Update Now</strong>, or download the latest version directly from WordPress.org. For more information, visit <a href=\"https://wordpress.org/news/2020/06/wordpress-5-4-2-security-and-maintenance-release/\">this post</a>, review the <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=5.4.2&amp;order=priority\">full list of changes on Trac</a>, or check out the <a href=\"https://wordpress.org/support/wordpress-version/version-5-4-2/\">HelpHub documentation page</a> for <a href=\"https://wordpress.org/support/wordpress-version/version-5-4-2/\">version 5.4.2</a>. WordPress 5.4.2 is a short-cycle maintenance release. The next major release will be <a href=\"https://make.wordpress.org/core/5-5/\">version 5.5</a>, <a href=\"https://wordpress.org/about/roadmap/\">planned for August 2020</a>. <br><br>Want to get involved in building WordPress Core? Follow<a href=\"https://make.wordpress.org/core/\"> the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>



<h2>Gutenberg 8.3 and 8.4</h2>



<p>The core team launched Gutenberg <a href=\"https://make.wordpress.org/core/2020/06/11/whats-new-in-gutenberg-11-june/\">8.3</a> and <a href=\"https://make.wordpress.org/core/2020/06/24/whats-new-in-gutenberg-24-june/\">8.4</a> this month, paving the way for some exciting block editor features. Version 8.3 introduced enhancements like a reorganized, more intuitive set of block categories, a parent block selector, an experimental spacing control, and user-controlled link color options. Version 8.4 comes with new image-editing tools and the ability to edit options for multiple blocks.  The block directory search feature that was previously available as an experimental feature, is now enabled for all Gutenberg installations. For full details on the latest versions on these Gutenberg releases, visit these posts about <a href=\"https://make.wordpress.org/core/2020/06/11/whats-new-in-gutenberg-11-june/\">8.3</a> and <a href=\"https://make.wordpress.org/core/2020/06/24/whats-new-in-gutenberg-24-june/\">8.4</a>.</p>



<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the #core-editor channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>



<h2>WordPress Bumps Minimum Recommended PHP Version to 7.2</h2>



<p>In a major update, WordPress <a href=\"https://meta.trac.wordpress.org/changeset/9959\">has bumped</a> the minimum PHP recommendation to 7.2. The ServeHappy API has been updated to set the minimum acceptable PHP version to 7.2, while the WordPress downloads page recommends 7.3 or newer. Previously, the ServeHappy dashboard widget was showing the upgrade notice to users of PHP 5.6 or lower. This decision comes <a href=\"https://meta.trac.wordpress.org/ticket/5257\">after discussions with the core Site Health team and the Hosting team</a>, both of which recommended that the upgrade notice be shown to users of PHP &lt;=7.1.</p>



<h2>WordCamp Europe 2020 Moved Online</h2>



<p>Following the success of a remote WordCamp Spain, <a href=\"https://2020.europe.wordcamp.org/\">WordCamp Europe</a> was held fully online from June 4 to 6. The event drew a record 8,600 signups from people based in 138 countries, along with 2,500 signups for contributor day. WCEU Online also showcased 33 speakers and 40 sponsors, in addition to a Q&amp;A with Matt Mullenweg. You can find the videos of the event in WordPress.tv by <a href=\"https://wordpress.tv/event/wordcamp-europe-2020/\">following this link</a>, or you can catch the<a href=\"https://www.youtube.com/channel/UCaYQGYDpXpU4A17kxN-AgJQ\"> live stream recording of the entire event from the WP Europe YouTube Channel</a>.</p>



<p>Want to get involved with the Community team? <a href=\"https://make.wordpress.org/community/\">Follow the Community blog here</a>, or join them in the #community-events channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. To organize a Meetup or WordCamp, <a href=\"https://make.wordpress.org/community/handbook/virtual-events/welcome/applying-for-a-virtual-event/\">visit the handbook page</a>.&nbsp;</p>



<hr class=\"wp-block-separator\" />



<h2>Further Reading:</h2>



<ul><li>Josepha Haden (<a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>), the executive director of the WordPress project, <a href=\"https://wordpress.org/news/2020/06/equity-and-the-power-of-community/\">published a post </a>that highlights resources on how the global WordPress community can focus on equity to help dismantle racial, societal, and systemic injustice.&nbsp;</li><li>PHP, the primary programming language in which WordPress is written, celebrated its <a href=\"https://wptavern.com/php-marks-25-years\">25th anniversary</a> this month!</li><li>The Community team is<a href=\"https://make.wordpress.org/community/2020/06/18/pending-update-for-the-code-of-conduct/#comment-28294\"> updating the WordCamp code of conduct</a> to address discrimination based on age, caste, social class, and other identifying characteristics.</li><li>The WordPress Core team is promoting more inclusive language by <a href=\"https://make.wordpress.org/core/2020/06/18/proposal-update-all-git-repositories-to-use-main-instead-of-master/\">updating all git repositories to use `trunk` instead of `master`</a>. Additionally, the team proposes to <a href=\"https://make.wordpress.org/core/2020/06/24/proposal-rename-invalid-worksforme-and-wontfix-ticket-resolutions/\">rename&nbsp; “invalid,” “worksforme,” and “wontfix” ticket resolutions </a>to “not-applicable,” “not-reproducible” or “cannot-reproduce,” and “not-implemented,” respectively.&nbsp;</li><li>The Documentation team is working on an external linking policy and has <a href=\"https://make.wordpress.org/docs/2020/06/15/external-linking-policy-trusted-sources/\">started a discussion</a> on how to allow linking to trusted sources to benefit users.&nbsp;</li><li>The Core team has put up a proposal to <a href=\"https://make.wordpress.org/core/2020/06/10/merge-announcement-extensible-core-sitemaps/\">merge extensible core sitemaps to WordPress core</a> in the 5.5 release. The feature is currently available as a <a href=\"https://wordpress.org/plugins/core-sitemaps/\">feature plugin</a>.</li><li><a href=\"https://2020.denver.wordcamp.org/\">WordCamp Denver</a> was held online May 26–27. The event sold over 2,400 tickets and featured 27 speakers and 20 sponsors. You can catch the recorded live stream on the <a href=\"https://2020.denver.wordcamp.org/watch-now/\">event site</a>.</li><li>The Core team is working on <a href=\"https://make.wordpress.org/core/2020/06/29/updating-jquery-version-shipped-with-wordpress/\">updating the version of jQuery</a> used in WordPress core.</li></ul>



<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"8614\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:76:\"
		
		
					
		
		
		
				
		
		

					
										
					
					
			
		
		
			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 5.4.2 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2020/06/wordpress-5-4-2-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wordpress.org/news/2020/06/wordpress-5-4-2-security-and-maintenance-release/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Jun 2020 19:19:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8592\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"WordPress 5.4.2 is now available! This security and maintenance release features 23 fixes and enhancements. Plus, it adds a number of security fixes—see the list below. These bugs affect WordPress versions 5.4.1 and earlier; version 5.4.2 fixes them, so you’ll want to upgrade. If you haven’t yet updated to 5.4, there are also updated versions [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6827:\"
<p>WordPress 5.4.2 is now available!</p>



<p>This security and maintenance release features 23 fixes and enhancements. Plus, it adds a number of security fixes—see the list below.</p>



<p>These bugs affect WordPress versions 5.4.1 and earlier; version 5.4.2 fixes them, so you’ll want to upgrade.</p>



<p>If you haven’t yet updated to 5.4, there are also updated versions of 5.3 and earlier that fix the bugs for you.</p>



<h3><strong>Security Updates</strong></h3>



<p>WordPress versions 5.4 and earlier are affected by the following bugs, which are fixed in version 5.4.2. If you haven’t yet updated to 5.4, there are also updated versions of 5.3 and earlier that fix the security issues.</p>



<ul><li>Props to Sam Thomas (jazzy2fives) for finding an XSS issue where authenticated users with low privileges are able to add JavaScript to posts in the block editor.</li><li>Props to Luigi &#8211; (<a href=\"https://www.gubello.me/\">gubello.me</a>) for discovering an XSS issue where authenticated users with upload permissions are able to add JavaScript to media files.</li><li>Props to Ben Bidner of the WordPress Security Team for finding an open redirect issue in <em>wp_validate_redirect()</em>.</li><li>Props to <a href=\"http://apapedulimu.click\">Nrimo Ing Pandum</a> for finding an authenticated XSS issue via theme uploads.</li><li>Props to <a href=\"https://blog.ripstech.com/authors/simon-scannell\">Simon Scannell of RIPS Technologies</a> for finding an issue where <em>set-screen-option</em> can be misused by plugins leading to privilege escalation.</li><li>Props to <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> for discovering an issue where comments from password-protected posts and pages could be displayed under certain conditions.</li></ul>



<p>Thank you to all of the reporters for&nbsp;<a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">privately disclosing the vulnerabilities</a>. This gave the security team time to fix the vulnerabilities before WordPress sites could be attacked.</p>



<p>One maintenance update was also deployed to versions 5.1, 5.2 and 5.3. See the <a href=\"https://make.wordpress.org/core/2020/06/09/wordpress-5-4-2-prevent-unmoderated-comments-from-search-engine-indexation/\">related developer note</a> for more information.</p>



<p>You can browse the&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=5.4.2&amp;order=priority\">full list of changes on Trac</a>.</p>



<p>For more info, browse the full list of changes on Trac or check out the Version&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-5-4-2/\">5.4.2 documentation page</a>.</p>



<p>WordPress 5.4.2 is a short-cycle maintenance release. The next major release will be&nbsp;<a href=\"https://make.wordpress.org/core/5-5/\">version 5.5</a>.</p>



<p>You can download WordPress 5.4.2 from the button at the top of this page, or visit your<strong>&nbsp;Dashboard → Updates</strong>&nbsp;and click&nbsp;<strong>Update Now</strong>.</p>



<p>If you have sites that support automatic background updates, they’ve already started the update process.</p>



<h3>Thanks and props!</h3>



<p>In addition to the security researchers mentioned above, thank you to everyone who helped make WordPress 5.4.2 happen:</p>



<p><a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/argentite\">argentite</a>, <a href=\"https://profiles.wordpress.org/asif2bd\">M Asif Rahman</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/bdcstr\">bdcstr</a>, <a href=\"https://profiles.wordpress.org/delowardev\">Delowar Hossain</a>, <a href=\"https://profiles.wordpress.org/dhrrob\">Rob Migchels</a>, <a href=\"https://profiles.wordpress.org/donmhico\">donmhico</a>, <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/finomeno\">finomeno</a>, <a href=\"https://profiles.wordpress.org/garethgillman\">garethgillman</a>, <a href=\"https://profiles.wordpress.org/giorgio25b\">Giorgio25b</a>, <a href=\"https://profiles.wordpress.org/gma992\">Gabriel Maldonado</a>, <a href=\"https://profiles.wordpress.org/h71\">Hector F</a>, <a href=\"https://profiles.wordpress.org/ianbelanger\">Ian Belanger</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/imath\">Mathieu Viet</a>, <a href=\"https://profiles.wordpress.org/javiercasares\">Javier Casares</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/jonkolbert\">jonkolbert</a>, <a href=\"https://profiles.wordpress.org/jonoaldersonwp\">Jono Alderson</a>, <a href=\"https://profiles.wordpress.org/joyously\">Joy</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/kjellr\">Kjell Reigstad</a>, <a href=\"https://profiles.wordpress.org/kthmd\">KT</a>, <a href=\"https://profiles.wordpress.org/markusthiel\">markusthiel</a>, <a href=\"https://profiles.wordpress.org/mayankmajeji\">Mayank Majeji</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/mislavjuric\">mislavjuric</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/nikhilbhansi\">Nikhil Bhansi</a>, <a href=\"https://profiles.wordpress.org/oakesjosh\">oakesjosh</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/passoniate\">Arslan Ahmed</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/samful\">Sam Fullalove</a>, <a href=\"https://profiles.wordpress.org/schlessera\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/skarabeq\">skarabeq</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/skithund\">Toni Viemerö</a>, <a href=\"https://profiles.wordpress.org/suzylah\">suzylah</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/utz119\">TeBenachi</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a> and <a href=\"https://profiles.wordpress.org/yuhin\">yuhin</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wordpress.org/news/2020/06/wordpress-5-4-2-security-and-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"8592\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"
		
		
		
		
		
				
		
		

					
										
					
		
		
			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Equity and the Power of Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2020/06/equity-and-the-power-of-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Jun 2020 17:59:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8590\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:350:\"Over the past week, I’ve been thinking a lot about George Floyd, Breonna Taylor, and Ahmaud Arbery. I have been thinking about white supremacy, the injustice that Black women and men are standing up against across the world, and all the injustices I can’t know, and don’t see.&#160; The WordPress mission is to democratize publishing, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2535:\"
<p>Over the past week, I’ve been thinking a lot about George Floyd, Breonna Taylor, and Ahmaud Arbery. I have been thinking about white supremacy, the injustice that Black women and men are standing up against across the world, and all the injustices I can’t know, and don’t see.&nbsp;</p>



<p>The WordPress mission is to democratize publishing, and to me, that has always meant more than the freedom to express yourself. Democratizing publishing means giving voices to the voiceless and amplifying those speaking out against injustice. It means learning things that we otherwise wouldn’t. To me, it means that every voice has the ability to be heard, regardless of race, wealth, power, and opportunity. WordPress is a portal to commerce; it is a canvas for identity, and a catalyst for change.</p>



<p>While WordPress as an open source project may not be capable of refactoring unjust judicial systems or overwriting structural inequality, this does not mean that we, the WordPress community, are powerless. WordPress can&#8217;t dismantle white supremacy, but the WordPress community can invest in underrepresented groups (whose experiences cannot be substituted for) and hire them equitably. WordPress can&#8217;t eradicate prejudice, but the WordPress community can hold space for marginalized voices in our community.</p>



<p>There is a lot of racial, societal, and systemic injustice to fight. At times, change may seem impossible, and certainly, it’s been too slow. But I know in my heart that the WordPress community is capable of changing the world. </p>



<p>If you would like to learn more about how to make a difference in your own community, here are a few resources I’ve gathered from WordPressers just like you.</p>



<ul><li><a href=\"https://href.li/?http://www.socialjusticetoolbox.com/\">Social Justice Toolbox</a></li><li><a href=\"http://antiracismforbeginners.com/\">Anti-racism resource list</a></li><li>An open source <a href=\"https://guidetoallyship.com/\">Guide to Allyship</a></li><li><a href=\"https://allienimmons.com/how-to-be-a-wordpress-ally/\">How to be a WordPress Ally</a></li><li><a href=\"https://www.highsnobiety.com/p/black-lives-matter-europe/\">Supporting Black Lives Matter in Europe</a></li><li><a href=\"https://feminisminindia.com/2019/06/03/colourism-fairness-india/\">Cost of Colourism in India</a> </li><li><a href=\"https://www.ted.com/talks/verna_myers_how_to_overcome_our_biases_walk_boldly_toward_them?language=en\">Overcoming Biases by Walking Toward Them</a> </li></ul>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"8590\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		

					
										
					
		
		
			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"The Month in WordPress: May 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2020/06/the-month-in-wordpress-may-2020/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Jun 2020 07:36:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8585\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"May was an action-packed month for WordPress! WordPress organizers are increasingly moving WordCamps online, and contributors are taking big steps towards Full Site Editing with Gutenberg. To learn more and get all the latest updates, read on.&#160; Gutenberg 8.1 and 8.2 Gutenberg 8.1 was released on May 13, followed quickly by Gutenberg 8.2 on May [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Angela Jin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10242:\"
<p>May was an action-packed month for WordPress! WordPress organizers are increasingly moving WordCamps online, and contributors are taking big steps towards Full Site Editing with Gutenberg. To learn more and get all the latest updates, read on.&nbsp;</p>



<hr class=\"wp-block-separator\" />



<h2>Gutenberg 8.1 and 8.2</h2>



<p>Gutenberg <a href=\"https://make.wordpress.org/core/2020/05/13/whats-new-in-gutenberg-13-may/\">8.1</a> was released on May 13, followed quickly by Gutenberg <a href=\"https://make.wordpress.org/core/2020/05/27/whats-new-in-gutenberg-27-may/\">8.2</a> on May 27.&nbsp;</p>



<ul><li>8.1 added new block pattern features making it easier to insert desired patterns, along with a new pattern. It also added a button to&nbsp; collapsed block actions for copying the selected block, which will help touchscreen users or users who don’t use keyboard shortcuts.&nbsp;</li><li>8.2 introduced block pattern categories and a `viewportWidth` property that will be particularly useful for large block patterns. There is also a new content alignment feature, and enhancements to improve the writing experience.&nbsp;</li></ul>



<p>Both releases include a number of new APIs, enhancements, bug fixes, experiments, new documentation, improvement to code quality, and more! To learn the latest, visit the announcement posts for <a href=\"https://make.wordpress.org/core/2020/05/13/whats-new-in-gutenberg-13-may/\">Gutenberg 8.1</a> and <a href=\"https://make.wordpress.org/core/2020/05/27/whats-new-in-gutenberg-27-may/\">Gutenberg 8.2</a>.</p>



<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the #core-editor channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>



<h2>Gutenberg Phase 2: Steps Towards Full Site Editing</h2>



<p>Contributors are currently working hard on <a href=\"https://wordpress.org/about/roadmap/\">Phase 2 of Gutenberg</a>! Where Phase 1 introduced the new block editor with WordPress 5.0, Phase 2 sees more customization and includes one of the biggest Gutenberg projects: Full Site Editing (FSE). At the moment, <a href=\"https://make.wordpress.org/core/2020/05/13/wordpress-5-5-planning-roundup/\">work on WordPress 5.5 has been initiated</a> and contributors decided to include <a href=\"https://make.wordpress.org/core/2020/05/29/editor-features-for-wordpress-5-5/\">basic functionality for Full Site Editing</a> in this release. FSE hopes to streamline the site creation and building process in WordPress using a block-based approach. There’s a lot of conversation and new information about FSE, so communication around the project is very important. On May 28th, a conversation was held in the #core-customize channel to discuss <a href=\"https://make.wordpress.org/core/2020/05/20/join-a-discussion-about-full-site-editing-and-the-future-of-the-customizer/\">FSE and the future of the Customizer</a>. To help everyone track the latest information, <a href=\"https://make.wordpress.org/core/2020/05/20/ways-to-keep-up-with-full-site-editing-fse/\">this post</a> summarizes ways to keep up with FSE.</p>



<p>Want to get involved with Gutenberg and FSE?&nbsp; Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core-editor channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. You can also check the FSE <a href=\"https://href.li/?https://github.com/WordPress/gutenberg/pulls?q=is%3Aopen+is%3Apr+label%3A%22%5BFeature%5D+Full+Site+Editing%22\">pull requests</a> and <a href=\"https://href.li/?https://github.com/WordPress/gutenberg/issues?q=is%3Aopen+is%3Aissue+label%3A%22%5BFeature%5D+Full+Site+Editing%22\">issues</a> on GitHub.</p>



<h2>Theme Review Team Rebranding</h2>



<p>Representatives of the Themes Review Team have decided to update their team name to “Themes Team.” This decision reflects changes that the block editor brings to the landscape of themes with the Full Site Editing project. The team has always been involved in projects beyond reviewing WordPress.org themes and lately, the team has been contributing more to themes in general &#8212; including open-source packages, contributions to Full Site Editing, the Twenty Twenty theme, and more. You can read more about the name change in the <a href=\"https://make.wordpress.org/themes/2020/05/12/meeting-notes-tuesday-12-may-2020/\">team’s meeting notes</a>.</p>



<p>Want to get involved with the Themes Team? <a href=\"https://make.wordpress.org/themes/\">Follow the Themes blog here</a>, or join them in the #themereview channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>



<h2>Online WordCamp Program Announced</h2>



<p>To assist organizers with moving their WordCamps online, the WordPress Community team has prepared a <a href=\"https://make.wordpress.org/community/handbook/virtual-events/\">new set of guidelines for online WordCamps</a>. The Community Team will cover <a href=\"https://make.wordpress.org/community/handbook/virtual-events/online-wordcamp-cost-guidelines-and-the-budget-review-process/\">online production and captioning costs</a> associated with any online WordCamp without the need for local sponsorship. The team also <a href=\"https://make.wordpress.org/community/handbook/virtual-events/welcome/new-guidelines-for-virtual-events-in-2020/\">updated its guidelines</a> to cover the regional focus of online events, and modified the <a href=\"https://make.wordpress.org/community/handbook/virtual-events/online-code-of-conduct/\">code of conduct</a> to cater to the new format. <a href=\"https://central.wordcamp.org/schedule/\">The WordCamp schedule</a> has also been updated to indicate whether an event is taking place online or not. You can find resources, tools, and information about online WordPress events in our <a href=\"https://make.wordpress.org/community/handbook/virtual-events/\">Online Events Handbook</a>. They have also prepared a <a href=\"https://make.wordpress.org/community/handbook/wordcamp-organizer/in-person-events-during-covid-19/\">new set of guidelines for in-person events</a> taking place in 2020, in the light of COVID-19 challenges.&nbsp;</p>



<p>Want to get involved with the Community team? <a href=\"https://make.wordpress.org/community/\">Follow the Community blog here</a>, or join them in the #community-events channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. To organize a Meetup or WordCamp, <a href=\"https://make.wordpress.org/community/handbook/virtual-events/welcome/applying-for-a-virtual-event/\">visit the handbook page</a>.&nbsp;</p>



<h2>BuddyPress 6.0.0 “iovine’s”</h2>



<p>On May 13th, <a href=\"https://buddypress.org/2020/05/buddypress-6-0-0/\">BuddyPress 6.0.0, known as “iovine’s,” was released</a>. This release includes two new blocks for the WordPress Editor: Members and Groups. It also saw the completion of the BP REST API, adding the six remaining endpoints, and the move or local avatar management to the Members component. Beyond that, 6.0.0 includes more than 80 changes, made possible by 42 contributors.&nbsp;</p>



<p>Want to download this latest version of BuddyPress? <a href=\"https://buddypress.org/2020/05/buddypress-6-0-0/\">Get it here</a>.&nbsp; You can also help by <a href=\"https://translate.wordpress.org/projects/wp-plugins/buddypress/dev/\">translating BuddyPress into another language</a> or letting the team know of any issues you find in the <a href=\"https://buddypress.org/support/\">support forums</a>.</p>



<h2>WordCamp Spain Online Concludes Successfully</h2>



<p>WordPress Meetup organizers in Spain joined hands to organize <a href=\"https://2020.spain.wordcamp.org/\">WordCamp Spain online </a>from May 6 to 9, which proved to be a huge success. The event had more than 5,500 attendees, 60 speakers, and 16 sponsors. Over 200 people from around the world participated in the <a href=\"https://2020.spain.wordcamp.org/2020/05/14/asi-fue-contributor-day/\">Contributor Day</a>. Matt Mullenweg <a href=\"https://wordpress.tv/2020/05/09/matias-ventura-matt-mullenweg-matt-y-wordpress/\">hosted an AMA for the participants</a>, facilitated by Mattias Ventura’s on-the-spot Spanish translation.&nbsp;</p>



<p>If you missed the event, you can watch<a href=\"https://wordpress.tv/event/wordcamp-spain-2020/\"> videos from WordCamp Spain online at WordPress.TV</a>. Want to organize a regional WordCamp? <a href=\"https://make.wordpress.org/community/handbook/virtual-events/\">Learn more about that here</a>!</p>



<hr class=\"wp-block-separator\" />



<h2>Further Reading:</h2>



<ul><li>WordPress <a href=\"https://ma.tt/2020/05/celebrate-seventeen/\">celebrated its 17th anniversary</a> on May 27, 2020! WordPress lovers all across the world <a href=\"https://twitter.com/hashtag/WP17?src=hashtag_click\">participated in online meetups</a> to celebrate the 17th birthday of their favorite open-source software.&nbsp;</li><li>The WordCamp Asia team has published <a href=\"https://2021.asia.wordcamp.org/2020/05/11/wordcamp-asia-2021-call-for-organisers/\">a call for organizers</a> for the January 2021 event &#8212; the call will close on June 8.</li><li>PHP and core version checks are coming into WordPress. This feature will prevent end-users from installing or activating a theme that is incompatible with their current version of PHP or WordPress. The change that has <a href=\"https://core.trac.wordpress.org/changeset/47819\">already been merged to core</a> is slated to land in WordPress 5.5.</li><li>The 2020 WordPress release squads <a href=\"https://make.wordpress.org/core/2020/05/29/2020-wordpress-release-squads/\">have been announced</a>.</li><li>Don’t forget that <a href=\"https://make.wordpress.org/community/handbook/virtual-events/\">WordCamp Europe Online</a> is happening on June 4-6, 2020.</li></ul>



<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"8585\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		

					
										
					
		
		
			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"The Month in WordPress: April 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2020/05/the-month-in-wordpress-april-2020/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 May 2020 09:31:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8571\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"April continued to be a challenging time for the WordPress community, with many under stay-at-home recommendations. However, it was also an exciting month in which we created new ways to connect with and inspire each other! This month, amazing contributors moved more WordCamps online and shipped new releases for WordPress and Gutenberg. For the latest, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Angela Jin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8195:\"
<p>April continued to be a challenging time for the WordPress community, with many under stay-at-home recommendations. However, it was also an exciting month in which we created new ways to connect with and inspire each other! This month, amazing contributors moved more WordCamps online and shipped new releases for WordPress and Gutenberg. For the latest, read on. </p>



<hr class=\"wp-block-separator\" />



<h2>WordPress 5.4.1 released</h2>



<p>On April 24th,&nbsp; <a href=\"https://make.wordpress.org/core/2020/04/24/wordpress-5-4-1-rc1/\">WordPress 5.4.1 Release Candidate 1</a> (RC1) was released for testing, quickly followed by the official <a href=\"https://wordpress.org/news/2020/04/wordpress-5-4-1/\">release of WordPress 5.4.1</a> on April 29th. This security release features 17 bug fixes and seven security fixes, so we recommend updating your sites immediately. To download WordPress 5.4.1, visit your Dashboard, click on Updates, then Update Now, or download the latest version directly from WordPress.org. For more information, visit <a href=\"https://wordpress.org/news/2020/04/wordpress-5-4-1/\">this post</a>, review the <a href=\"https://core.trac.wordpress.org/query?milestone=5.4.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">full list of changes on Trac</a>, or check out the <a href=\"https://wordpress.org/support/wordpress-version/version-5-4-1/\">version 5.4.1 HelpHub documentation page</a>.</p>



<p>Want to get involved in building WordPress Core? Follow<a href=\"https://make.wordpress.org/core/\"> the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>



<h2>Gutenberg 7.9 and 8.0 released</h2>



<p>It was another exciting month for Gutenberg, with the release of <a href=\"https://make.wordpress.org/core/2020/04/15/whats-new-in-gutenberg-15-april/\">7.9</a> and <a href=\"https://make.wordpress.org/core/2020/04/29/whats-new-in-gutenberg-29-april/\">8.0</a>! Version 7.9 brought new block design tools, three new patterns, and improved block markup. Gutenberg 8.0 continued to refine the new block patterns feature, with additional options for inline formatting, and extending the functionality of the Code Editor. In addition to these new features, both releases included new enhancements and APIs, along with a number of bug fixes, performance improvements, some experiments, and more! You can read all the details about the latest Gutenberg releases in the announcement posts for <a href=\"https://make.wordpress.org/core/2020/04/15/whats-new-in-gutenberg-15-april/\">7.9</a> and <a href=\"https://make.wordpress.org/core/2020/04/29/whats-new-in-gutenberg-29-april/\">8.0</a>.&nbsp;</p>



<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the #core-editor channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>



<h2>BuddyPress 6.0.0</h2>



<p><a href=\"https://buddypress.org/2020/04/buddypress-6-0-0-beta2/\">BuddyPress 6.0.0-beta2</a> was released for testing in mid-April, leading to the <a href=\"https://buddypress.org/2020/04/buddypress-6-0-0-release-candidate/\">BuddyPress 6.0.0 Release Candidate</a>, announced on April 29. This is an important step before&nbsp; the final release of BuddyPress 6.0.0, which is slated for Thursday, May 14. Changes and new features in this release include moving the profile photo and user cover image under the BP Members component, and a new BP Rest API. Additionally, this release will introduce the first round of BuddyPress Blocks! Last, but not least, BuddyPress 6.0.0 will require at least PHP 5.6 and WordPress 4.8.&nbsp;</p>



<p>Want to get involved? <a href=\"https://buddypress.org/2020/04/buddypress-6-0-0-release-candidate/\">Test the 6.0.0-RC here</a>! You can also help by <a href=\"https://translate.wordpress.org/projects/wp-plugins/buddypress/dev/\">translating BuddyPress into another language</a>, or let the team know of any issues you find, either in <a href=\"https://buddypress.org/support\">the support forums</a> and/or in their <a href=\"https://buddypress.trac.wordpress.org/\">development tracker</a>.&nbsp;</p>



<h2>WordCamp US goes online, apply to speak!</h2>



<p>WordCamp US will <a href=\"https://2020.us.wordcamp.org/2020/04/30/wordcamp-us-will-be-virtually-awesome/\">take place online due to the COVID-19 pandemic</a>. The event still runs from October 27-29, 2020, and will be free to anyone who wishes to attend. The team plans to offer&nbsp; what WCUS has historically brought to the community in person: sessions and workshops, Contributor Day, a hallway track, and of course, State of the Word.&nbsp;</p>



<p>Interested in speaking at WCUS? The <a href=\"https://2020.us.wordcamp.org/2020/03/16/call-for-speakers-is-now-open/\">Call for Speakers</a> is still open! You can apply to speak on the <a href=\"https://2020.wcus-speakers.org/\">speaker application site</a> until May 31, 2020 at 11:59 pm CDT (UTC-5).&nbsp;</p>



<p>Additionally, the <a href=\"https://2020.us.wordcamp.org/2020/03/23/call-for-cities-for-wcus-2021-2022/\">Call for Cities is also open</a>. If your community is interested in hosting WordCamp US in 2021 &amp; 2022, please <a href=\"https://wordcampcentral.survey.fm/wcus-2021-2022\">fill out this application</a>.&nbsp;</p>



<p>For the latest information about WordCamp US, sign up for updates on the <a href=\"https://2020.us.wordcamp.org/\">website</a>, or follow <a href=\"https://www.facebook.com/WordCampUSA/\">Facebook</a>, <a href=\"https://twitter.com/WordCampUS\">Twitter</a>, or <a href=\"https://www.instagram.com/wordcampus/?hl=en\">Instagram</a>.&nbsp;</p>



<h2>WordCamp Europe 2020 goes virtual&nbsp;</h2>



<p>Last month, WordCamp Europe decided to postpone its Porto event to 2021. This April, the WCEU organizing team announced that the <a href=\"https://2020.europe.wordcamp.org/2020/04/06/wordcamp-europe-2020-is-moving-online/\">2020 WordCamp will be online</a>! WordCamp Europe 2020 Online will take place from June 4-6, 2020, and tickets will be free. There will be a <a href=\"https://make.wordpress.org/updates/2020/04/15/wordcamp-europe-2020-contributor-day-update/\">virtual Contributor Day</a> on June 4, and then two half days of live-streamed talks and workshops. To participate, get your free ticket <a href=\"https://2020.europe.wordcamp.org/tickets/\">here</a>.&nbsp;</p>



<p>To get the latest news for WordCamp Europe 2020 Online, follow on <a href=\"https://www.facebook.com/WCEurope/\">Facebook</a>, <a href=\"https://twitter.com/wceurope?lang=en\">Twitter</a>, <a href=\"https://www.linkedin.com/company/wordcampeurope/\">LinkedIn</a>, or on <a href=\"https://www.instagram.com/wceurope/?hl=en\">Instagram</a>.&nbsp;</p>



<hr class=\"wp-block-separator\" />



<h2>Further Reading</h2>



<ul><li><a href=\"https://make.wordpress.org/core/2020/04/08/wordpress-5-5-call-for-tickets/\">The WordPress 5.5 release cycle has officially been kicked off with a Call for Tickets</a>.</li><li><a href=\"https://make.wordpress.org/themes/2020/04/03/proposal-github-theme-review/\">Read the proposal for a new GitHub Theme review process.</a>.</li><li><a href=\"https://wordpress.tv/event/wpblocktalk-april-2020/\">Did you miss WPBlockTalk, or want to watch that really interesting session again? All talks are available on WordPress.tv!</a></li><li><a href=\"https://make.wordpress.org/core/2020/04/01/feature-plugin-proposal-wp-consent-api/\">The Core team has introduced a proposal for a new Consent API as a feature plugin</a>.</li><li><a href=\"https://make.wordpress.org/updates/2020/04/30/quarterly-updates-q1-2020/\">All WordPress contribution teams have reported on their recent work in the first quarterly update of 2020</a>.</li></ul>



<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"8571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"
		
		
		
		
		
				
		
		

					
										
					
		
		
			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"WordPress 5.4.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2020/04/wordpress-5-4-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Apr 2020 19:56:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8553\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"WordPress 5.4.1 is now available! This security and maintenance release features 17 bug fixes in addition to 7 security fixes. Because this is a security release, it is recommended that you update your sites immediately. All versions since WordPress 3.7 have also been updated. WordPress 5.4.1 is a short-cycle security and maintenance release. The next [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7029:\"
<p>WordPress 5.4.1 is now available!</p>



<p>This security and maintenance release features 17 <a href=\"https://core.trac.wordpress.org/query?milestone=5.4.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priorityhttps://core.trac.wordpress.org/query?milestone=5.4.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">bug fixes</a> in addition to 7 security fixes. Because this is a <strong>security release</strong>, it is recommended that you update your sites immediately. All versions since WordPress 3.7 have also been updated.</p>



<p>WordPress 5.4.1 is a short-cycle security and maintenance release. The next major release will be version 5.5.</p>



<p>You can download WordPress 5.4.1 by downloading from WordPress.org, or visit your Dashboard → Updates and click Update Now.</p>



<p>If you have sites that support automatic background updates, they’ve already started the update process.</p>



<h3>Security Updates</h3>



<p>Seven security issues affect WordPress versions 5.4 and earlier. If you haven’t yet updated to 5.4, all WordPress versions since 3.7 have also been updated to fix the following security issues:</p>



<ul><li>Props to <a href=\"https://hackerone.com/hijibiji\">Muaz Bin Abdus Sattar</a> and <a href=\"https://hackerone.com/dyennez\">Jannes</a> who both independently reported an issue where password reset tokens were not properly invalidated.</li><li>Props to <a href=\"https://github.com/ka1n4t\">ka1n4t</a> for finding an issue where certain private posts can be viewed unauthenticated.</li><li>Props to <a href=\"https://evanricafort.com/\">Evan Ricafort</a> for discovering an XSS issue in the Customizer</li><li>Props to Ben Bidner from the WordPress Security Team who discovered an XSS issue in the search block.</li><li>Props to Nick Daugherty from <a href=\"https://wpvip.com\">WordPress VIP</a> / WordPress Security Team who discovered an XSS issue in <code>wp-object-cache</code>.</li><li>Props to Ronnie Goodrich (<a href=\"https://hackerone.com/kahoots\">Kahoots</a>) and <a href=\"http://pentestusa.com/\">Jason Medeiros</a> who independently reported an XSS issue in file uploads.</li><li>Props to <a href=\"https://weston.ruter.net/\">Weston Ruter</a> for fixing a stored XSS vulnerability in the WordPress customizer.</li><li>Additionally, an authenticated XSS issue in the block editor was discovered by Nguyen The Duc (<a href=\"https://twitter.com/ducnt_\">ducnt</a>) in WordPress 5.4 RC1 and RC2. It was fixed in 5.4 RC5. We wanted to be sure to give credit and thank them for all of their work in making WordPress more secure.</li></ul>



<p>Thank you to all of the reporters for <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">privately disclosing the vulnerabilities</a>. This gave the security team time to fix the vulnerabilities before WordPress sites could be attacked.</p>



<p>For more information, browse the <a href=\"https://core.trac.wordpress.org/query?milestone=5.4.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">full list of changes</a> on Trac, or check out the <a href=\"https://wordpress.org/support/wordpress-version/version-5-4-1/\">version 5.4.1 HelpHub documentation page</a>.</p>



<p>In addition to the security researchers mentioned above, thank you to everyone who helped make WordPress 5.4.1 happen:</p>



<p><a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/aduth/\">Andrew Duthie</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a>, <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten/\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/dhrrob/\">DhrRob</a>, <a href=\"https://profiles.wordpress.org/dono12/\">Dono12</a>, <a href=\"https://profiles.wordpress.org/dudo/\">dudo</a>, <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a>, <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/markrh/\">MarkRH</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/nickdaugherty/\">Nick Daugherty</a>, <a href=\"https://profiles.wordpress.org/noahtallen/\">noahtallen</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/pikamander2/\">pikamander2</a>, <a href=\"https://profiles.wordpress.org/r-a-y/\">r-a-y</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sorenbronsted/\">Søren Brønsted</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/isabel_brison/\">tellthemachines</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/treecutter/\">treecutter</a>, and <a href=\"https://profiles.wordpress.org/yohannp/\">yohannp</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"8553\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:76:\"
		
		
					
		
		
		
				
		
		

					
										
					
					
			
		
		
			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"People of WordPress: Mario Peshev\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2020/04/people-of-wordpress-mario-peshev/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wordpress.org/news/2020/04/people-of-wordpress-mario-peshev/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Apr 2020 00:57:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"heropress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8536\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:158:\"In the April edition of our \"People of WordPress\" series, you\'ll find out how Mario Peshev went from self-taught developer to teaching basic digital literacy.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Yvette Sonneveld\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:12168:\"
<p><em>You’ve probably heard that WordPress is open source software, and may know that it’s created and run by volunteers. Enthusiasts share many examples of how WordPress has changed people’s lives for the better. In this monthly series, we share some of those lesser-known, amazing stories.</em></p>



<h2><strong>Computer science in the nineties</strong></h2>



<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img loading=\"lazy\" width=\"200\" height=\"200\" src=\"https://i2.wp.com/wordpress.org/news/files/2020/04/25de575216d3743f80181b2dca2cd7d9.jpeg?resize=200%2C200&#038;ssl=1\" alt=\"\" class=\"wp-image-8539\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2020/04/25de575216d3743f80181b2dca2cd7d9.jpeg?w=200&amp;ssl=1 200w, https://i2.wp.com/wordpress.org/news/files/2020/04/25de575216d3743f80181b2dca2cd7d9.jpeg?resize=150%2C150&amp;ssl=1 150w\" sizes=\"(max-width: 200px) 100vw, 200px\" data-recalc-dims=\"1\" /><figcaption>Mario Peshev</figcaption></figure></div>



<p>Mario has been hooked on computers ever since he&nbsp;got his first one in 1996. He started with digging into MS-DOS and Windows 3.1 first and learned tons by trial and error. Following that adventure, Mario built his first HTML site in 1999. He found development so exciting that he spent day and night learning QBasic and started working at the local PC game club. Mario got involved with several other things related to website administration (translating security bulletins, setting up simple sites, etc) and soon found the technology field was full of activities he really enjoyed.</p>



<h2><strong>The Corporate Lifestyle</strong></h2>



<p>Mario started studying programming including an intensive high-level course for C#, Java development, and software engineering, and eventually got a job in a corporate environment. He soon became a team lead there, managing all the planning and paperwork for their projects.</p>



<p>But he continued freelancing on the side. He grew his own network of technical experts through attending, volunteering at, and organizing conferences. He also ran a technical forum and regularly spoke at universities and enterprise companies.</p>



<h2><strong>Remote Working and Business Opportunity</strong></h2>



<p>The combination of a high workload and a daily three-hour-long commute made Mario’s life difficult. Many of his friends were still studying, traveling or unemployed. The blissful and calm lives they lived seemed like a fairy tale to him. And even while both his managers and his clients were abroad, he was unable to obtain permission to work remotely.&nbsp;</p>



<p>So Mario decided to leave his job and start freelancing full time. But he found he faced a massive challenge.&nbsp;</p>



<p>He discovered Java projects were pretty large and required an established team of people working together in an office. All job opportunities were on-site, and some even required relocation abroad. Certified Java programmers weren’t being hired on a remote basis.&nbsp;</p>



<p>As Mario had some PHP experience from previous jobs, he used this to start his freelance career. For his projects, he used both plain PHP and PHP frameworks like CakePHP and CodeIgniter.&nbsp;</p>



<p>For a while, Mario accepted work using commonly known platforms including Joomla, Drupal, and WordPress. In addition, he worked on PHP, Java, Python and some C# projects for a couple of years, after which he decided to switch to WordPress completely.</p>



<h2><strong>Building products</strong></h2>



<p>One of his projects involved a technically challenging charity backed by several international organizations. Unexpected shortages in the team put him in the technical lead position. As a result, Mario found himself planning the next phases, meeting with the client regularly, and renegotiating the terms. The team completed the project successfully, and after the launch, a TV campaign led millions of visitors to the website.</p>



<p>As a result of the successful launch, this client invited Mario to participate in more WordPress projects, including building a custom framework.</p>



<blockquote class=\"wp-block-quote\"><p><em>“I wasn’t that acquainted with WordPress back then. For me, a conventional person trained in architectural design patterns and best practices, WordPress seemed like an eccentric young hipster somewhere on the line between insane and genius at the same time. I had to spend a couple of months learning WordPress from the inside out.”</em></p><cite>Mario Peshev</cite></blockquote>



<p>As his interest in WordPress grew, Mario stopped delivering other custom platforms, and converted clients to WordPress.&nbsp;</p>



<h2><strong>European Community</strong></h2>



<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"2560\" height=\"1440\" src=\"https://i2.wp.com/wordpress.org/news/files/2020/04/20191001_144227-scaled.jpg?fit=632%2C356&amp;ssl=1\" alt=\"Mario presenting to an audience\" class=\"wp-image-8546\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2020/04/20191001_144227-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i2.wp.com/wordpress.org/news/files/2020/04/20191001_144227-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2020/04/20191001_144227-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2020/04/20191001_144227-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2020/04/20191001_144227-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2020/04/20191001_144227-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2020/04/20191001_144227-scaled.jpg?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2020/04/20191001_144227-scaled.jpg?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" /><figcaption>Mario presenting at a WordCamp</figcaption></figure>



<p>For Mario, one of the key selling points of WordPress was the international openness. He had previously been involved with other open source communities, some of which were US-focused. He felt they were more reliant on meeting people in person. With events only taking place in the US, this made building relationships much harder for people living in other countries.</p>



<p>While the WordPress project started out in the US, the WordPress community quickly globalized. Dozens of WordCamps and hundreds of Meetup events take place around the globe every year.&nbsp; All of these events bring a wide variety of people sharing their enthusiasm for WordPress together.</p>



<p>For Mario, the birth of WordCamp Europe was something magical. The fact that hundreds, and later on thousands, of people from all over the world gathered around the topic of WordPress speaks for itself. Mario has been involved with organizing WordCamp Europe twice (in 2014 and 2015).&nbsp;</p>



<blockquote class=\"wp-block-quote\"><p><em>“There’s nothing like meeting WordPress enthusiasts and professionals from more than 50 countries brainstorming and working together at a WordCamp. You simply have to be there to understand how powerful it all is.”</em></p><cite>Mario Peshev</cite></blockquote>



<h2><strong>Growing businesses and teams</strong></h2>



<p>A key WordPress benefit is its popularity – an ever growing project currently powering <a href=\"https://w3techs.com/technologies/details/cm-wordpress\">more than 35% of the Internet [2020].</a> It’s popular enough to be a de facto standard for websites, platforms, e-commerce and blogs.&nbsp;</p>



<p>WordPress has a low barrier to entry. You can achieve a lot without being an expert, meaning most people can start gaining experience without having to spend years learning how to code. That also makes it easier to build businesses and teams.</p>



<blockquote class=\"wp-block-quote\"><p><em>“Being able to use a tool that is user-friendly, not overly complicated and easily extensible makes introducing it to team members faster and easier. It requires less time for adjustment, and as a result makes a team stronger and faster. The fact that this tool is cost-effective also allows more startups to enter the market. It requires&nbsp; less time and investments to launch an MVP. This boosts the entire ecosystem.”</em></p><cite>Mario Peshev</cite></blockquote>



<h2><strong>Helping Others</strong></h2>



<p>Mario also introduced WordPress to children and young people. He taught them how to use WordPress as a tool for homework and class assignments. By using WordPress, they were able to learn the basics of designing themes, developing plugins, marketing statistics, social media, copywriting, and so much more. This approachable introduction to the software meant technical skills were not needed.</p>



<p>He was also part of a team of volunteers who helped a group of young people living at a foster home struggling to provide for themselves. The team taught the basic digital literacy skills necessary in the modern workplace and potentially pay for their rent and basic needs. This included working with Microsoft Word, Excel and WordPress, as well as some basic design and marketing skills. </p>



<blockquote class=\"wp-block-quote\"><p><em>“When you look at that from another perspective, a platform that could save lives &#8211; literally &#8211; and change the world for better is worth contributing to, in any possible manner.”</em></p><cite>Mario Peshev</cite></blockquote>



<h2><strong>Contributing to the WordPress community</strong></h2>



<p>From the core team to supporting and organizing WordCamps, Mario has long been an active contributor to the global WordPress project. He is passionate about the connections fostered by people who are involved in building both the WordPress software and the community around it.</p>



<blockquote class=\"wp-block-quote\"><p><em>“The WordPress community consists of people of all race and color, living all around the world, working as teachers, developers, bloggers, designers, business owners. Let’s work together to help each other. Let’s stick together and show&nbsp; the world WordPress can help make it a better place.”</em></p><cite>Mario Peshev</cite></blockquote>



<h2><strong>Contributors</strong></h2>



<p>Thanks to Alison Rothwell (<a href=\'https://profiles.wordpress.org/wpfiddlybits/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wpfiddlybits</a>), Yvette Sonneveld (<a href=\'https://profiles.wordpress.org/yvettesonneveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>yvettesonneveld</a>), Abha Thakor (<a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>), Josepha Haden (<a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>) and Topher DeRosia (<a href=\'https://profiles.wordpress.org/topher1kenobe/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>topher1kenobe</a>). Thank you to Mario Peshev (<a href=\'https://profiles.wordpress.org/nofearinc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nofearinc</a>) for sharing his #ContributorStory.</p>



<div class=\"wp-block-image\"><figure class=\"alignleft size-large\"><img loading=\"lazy\" width=\"180\" height=\"135\" src=\"https://i1.wp.com/wordpress.org/news/files/2020/03/heropress_logo_180.png?resize=180%2C135&#038;ssl=1\" alt=\"HeroPress logo\" class=\"wp-image-8409\" data-recalc-dims=\"1\" /></figure></div>



<p><em>This post is based on </em><a href=\"https://heropress.com/essays/wordpress-gave-perfect-identity/\"><em>an article originally published on HeroPress.com</em></a><em>, a community initiative created by </em><a href=\"https://profiles.wordpress.org/topher1kenobe/\"><em>Topher DeRosia</em></a><em>. HeroPress highlights people in the WordPress community who have overcome barriers and whose stories would otherwise go unheard.</em></p>



<p><em>Meet more WordPress community members over at </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>!</em></p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2020/04/people-of-wordpress-mario-peshev/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"12\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"8536\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"
	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"
	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 24 Jul 2020 16:20:02 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 21 Jul 2020 23:16:53 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20130911083210\";}", "no");
INSERT INTO wpy4_options VALUES("46612", "wa_btn", "a:6:{s:3:\"top\";s:2:\"on\";s:3:\"btm\";s:2:\"on\";s:5:\"posts\";s:2:\"on\";s:5:\"pages\";s:3:\"off\";s:8:\"homepage\";s:3:\"off\";s:8:\"tracking\";s:3:\"off\";}", "yes");
INSERT INTO wpy4_options VALUES("46666", "ht_ccw_ga", "a:3:{s:11:\"ga_category\";s:26:\"Click to Chat for WhatsApp\";s:9:\"ga_action\";s:5:\"Click\";s:8:\"ga_label\";s:7:\"{{url}}\";}", "yes");
INSERT INTO wpy4_options VALUES("46667", "ht_ccw_fb", "a:7:{s:13:\"fb_event_name\";s:19:\"Click to Chat Event\";s:7:\"p1_name\";s:8:\"Category\";s:7:\"p2_name\";s:6:\"Action\";s:7:\"p3_name\";s:5:\"Label\";s:8:\"p1_value\";s:13:\"Click to Chat\";s:8:\"p2_value\";s:5:\"Click\";s:8:\"p3_value\";s:7:\"{{url}}\";}", "yes");
INSERT INTO wpy4_options VALUES("46668", "ccw_plugin_details", "a:1:{s:7:\"version\";s:5:\"1.7.2\";}", "yes");
INSERT INTO wpy4_options VALUES("46669", "ht_ctc_chat_options", "a:3:{s:6:\"number\";s:0:\"\";s:10:\"pre_filled\";s:0:\"\";s:14:\"call_to_action\";s:11:\"WhatsApp us\";}", "yes");
INSERT INTO wpy4_options VALUES("46664", "ccw_options", "a:21:{s:6:\"enable\";s:1:\"2\";s:9:\"enable_sc\";s:1:\"2\";s:11:\"return_type\";s:4:\"chat\";s:6:\"number\";s:13:\"2348176443398\";s:7:\"initial\";s:0:\"\";s:8:\"group_id\";s:0:\"\";s:5:\"style\";s:1:\"9\";s:11:\"stylemobile\";s:1:\"3\";s:8:\"position\";s:1:\"1\";s:17:\"position-1_bottom\";s:4:\"10px\";s:16:\"position-1_right\";s:4:\"10px\";s:17:\"position-2_bottom\";s:4:\"10px\";s:15:\"position-2_left\";s:4:\"10px\";s:14:\"position-3_top\";s:4:\"10px\";s:15:\"position-3_left\";s:4:\"10px\";s:14:\"position-4_top\";s:4:\"10px\";s:16:\"position-4_right\";s:4:\"10px\";s:17:\"input_placeholder\";s:21:\"WhatsApp us Live Chat\";s:17:\"list_hideon_pages\";s:0:\"\";s:15:\"list_hideon_cat\";s:0:\"\";s:9:\"shortcode\";s:12:\"chat with us\";}", "yes");
INSERT INTO wpy4_options VALUES("46665", "ccw_options_cs", "a:52:{s:13:\"s1_text_color\";s:7:\"#9e9e9e\";s:21:\"s1_text_color_onfocus\";s:7:\"#26a69a\";s:15:\"s1_border_color\";s:7:\"#9e9e9e\";s:23:\"s1_border_color_onfocus\";s:7:\"#26a69a\";s:19:\"s1_submit_btn_color\";s:7:\"#26a69a\";s:33:\"s1_submit_btn_text_and_icon_color\";s:7:\"#ffffff\";s:8:\"s1_width\";s:4:\"auto\";s:11:\"s1_btn_text\";s:6:\"Submit\";s:13:\"s2_text_color\";s:7:\"initial\";s:21:\"s2_text_color_onhover\";s:7:\"initial\";s:13:\"s2_decoration\";s:7:\"initial\";s:21:\"s2_decoration_onhover\";s:7:\"initial\";s:12:\"s3_icon_size\";s:4:\"34px\";s:12:\"s3_icon_type\";s:3:\"png\";s:13:\"s4_text_color\";s:18:\"rgba(0, 0, 0, 0.6)\";s:19:\"s4_background_color\";s:7:\"#e4e4e4\";s:8:\"s5_color\";s:7:\"#25D366\";s:14:\"s5_hover_color\";s:7:\"#00e51e\";s:12:\"s5_icon_size\";s:4:\"24px\";s:8:\"s6_color\";s:7:\"#ffffff\";s:14:\"s6_hover_color\";s:4:\"#000\";s:12:\"s6_icon_size\";s:4:\"24px\";s:26:\"s6_circle_background_color\";s:7:\"#25D366\";s:32:\"s6_circle_background_hover_color\";s:7:\"#00e51e\";s:16:\"s6_circle_height\";s:4:\"48px\";s:15:\"s6_circle_width\";s:4:\"48px\";s:14:\"s6_line_height\";s:4:\"48px\";s:8:\"s7_color\";s:7:\"#ffffff\";s:14:\"s7_hover_color\";s:4:\"#000\";s:12:\"s7_icon_size\";s:4:\"24px\";s:23:\"s7_box_background_color\";s:7:\"#25D366\";s:29:\"s7_box_background_hover_color\";s:7:\"#00e51e\";s:13:\"s7_box_height\";s:4:\"48px\";s:12:\"s7_box_width\";s:4:\"48px\";s:14:\"s7_line_height\";s:4:\"48px\";s:13:\"s8_text_color\";s:7:\"#ffffff\";s:19:\"s8_background_color\";s:7:\"#26a69a\";s:13:\"s8_icon_color\";s:7:\"#ffffff\";s:21:\"s8_text_color_onhover\";s:7:\"#ffffff\";s:27:\"s8_background_color_onhover\";s:7:\"#26a69a\";s:21:\"s8_icon_color_onhover\";s:7:\"#ffffff\";s:13:\"s8_icon_float\";s:5:\"right\";s:10:\"s8_1_width\";s:0:\"\";s:12:\"s9_icon_size\";s:4:\"48px\";s:22:\"s99_img_height_desktop\";s:4:\"99px\";s:21:\"s99_img_width_desktop\";s:0:\"\";s:21:\"s99_img_height_mobile\";s:4:\"50px\";s:20:\"s99_img_width_mobile\";s:0:\"\";s:15:\"s99_desktop_img\";s:0:\"\";s:14:\"s99_mobile_img\";s:0:\"\";s:10:\"an_on_load\";s:12:\"no-animation\";s:11:\"an_on_hover\";s:15:\"ccw-no-hover-an\";}", "yes");
INSERT INTO wpy4_options VALUES("47762", "sharing-services", "a:2:{s:7:\"visible\";a:0:{}s:6:\"hidden\";a:11:{i:0;s:7:\"twitter\";i:1;s:8:\"facebook\";i:2;s:5:\"print\";i:3;s:8:\"linkedin\";i:4;s:6:\"reddit\";i:5;s:6:\"tumblr\";i:6;s:9:\"pinterest\";i:7;s:6:\"pocket\";i:8;s:8:\"telegram\";i:9;s:16:\"jetpack-whatsapp\";i:10;s:5:\"skype\";}}", "yes");
INSERT INTO wpy4_options VALUES("48261", "wordfence_syncAttackDataAttempts", "0", "no");
INSERT INTO wpy4_options VALUES("48262", "wordfence_syncingAttackData", "0", "no");
INSERT INTO wpy4_options VALUES("48264", "wordfence_lastSyncAttackData", "1595609120", "no");
INSERT INTO wpy4_options VALUES("238001", "db_upgraded", "", "yes");
INSERT INTO wpy4_options VALUES("245732", "litespeed.conf.crawler-inc_tags", "1", "yes");
INSERT INTO wpy4_options VALUES("245733", "litespeed.conf.crawler-exc_cpt", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("47325", "sharedaddy_disable_resources", "0", "yes");
INSERT INTO wpy4_options VALUES("281153", "_transient_timeout_jetpack_scan_state", "1595620118", "no");
INSERT INTO wpy4_options VALUES("281154", "_transient_jetpack_scan_state", "O:8:\"stdClass\":4:{s:5:\"state\";s:11:\"unavailable\";s:7:\"threats\";N;s:9:\"has_cloud\";b:0;s:6:\"reason\";s:23:\"missing_scan_capability\";}", "no");
INSERT INTO wpy4_options VALUES("279891", "_site_transient_timeout_php_check_a5907c2ea4d6fbd7e531b3aa7734f0e4", "1596064573", "no");
INSERT INTO wpy4_options VALUES("279892", "_site_transient_php_check_a5907c2ea4d6fbd7e531b3aa7734f0e4", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:0;s:13:\"is_acceptable\";b:0;}", "no");
INSERT INTO wpy4_options VALUES("281204", "_transient_timeout_jetpack_idc_allowed", "1595622276", "no");
INSERT INTO wpy4_options VALUES("281205", "_transient_jetpack_idc_allowed", "1", "no");
INSERT INTO wpy4_options VALUES("280543", "_transient_timeout_brute_use_math", "1595616417", "no");
INSERT INTO wpy4_options VALUES("280544", "_transient_brute_use_math", "1", "no");
INSERT INTO wpy4_options VALUES("281140", "_transient_timeout_wpcom_subscribers_total", "1595621145", "no");
INSERT INTO wpy4_options VALUES("281141", "_transient_wpcom_subscribers_total", "a:2:{s:6:\"status\";s:7:\"success\";s:5:\"value\";i:1997;}", "no");
INSERT INTO wpy4_options VALUES("281224", "_transient_timeout_jetpack_psh_status", "1595620278", "no");
INSERT INTO wpy4_options VALUES("281225", "_transient_jetpack_psh_status", "1", "no");
INSERT INTO wpy4_options VALUES("280966", "_transient_wfcredentialstatus_2", "068f6f47edc8d4c74af5ac001f80f315cb94d58f942c96e77d2618b33f356d1f2", "no");
INSERT INTO wpy4_options VALUES("281220", "_transient_timeout_jetpack_sync_last_checked_queue_state_sync", "1595619582", "no");
INSERT INTO wpy4_options VALUES("281221", "_transient_jetpack_sync_last_checked_queue_state_sync", "a:2:{i:0;i:0;i:1;i:0;}", "no");
INSERT INTO wpy4_options VALUES("280873", "_transient_timeout_wflginfl_00000000000000000000ffffa5163d0f", "1595609619", "no");
INSERT INTO wpy4_options VALUES("280874", "_transient_wflginfl_00000000000000000000ffffa5163d0f", "1", "no");
INSERT INTO wpy4_options VALUES("280968", "_transient_timeout_jetpack_a8c_data", "1595693995", "no");
INSERT INTO wpy4_options VALUES("280969", "_transient_jetpack_a8c_data", "a:4:{s:4:\"a12s\";i:1234;s:9:\"countries\";i:77;s:9:\"languages\";i:93;s:16:\"featured_plugins\";a:4:{i:0;s:11:\"woocommerce\";i:1;s:14:\"wp-super-cache\";i:2;s:14:\"wp-job-manager\";i:3;s:15:\"co-authors-plus\";}}", "no");
INSERT INTO wpy4_options VALUES("280970", "_transient_timeout_jetpack_https_test", "1595693995", "no");
INSERT INTO wpy4_options VALUES("280971", "_transient_jetpack_https_test", "1", "no");
INSERT INTO wpy4_options VALUES("280972", "_transient_timeout_jetpack_https_test_message", "1595693995", "no");
INSERT INTO wpy4_options VALUES("280973", "_transient_jetpack_https_test_message", "", "no");
INSERT INTO wpy4_options VALUES("280974", "_transient_timeout_jpp_headers_updated_recently", "1595693995", "no");
INSERT INTO wpy4_options VALUES("280975", "_transient_jpp_headers_updated_recently", "1", "no");
INSERT INTO wpy4_options VALUES("280976", "_site_transient_timeout_browser_5fa42a5ced972bb6d5ae8800e98bebfb", "1596212395", "no");
INSERT INTO wpy4_options VALUES("280977", "_site_transient_browser_5fa42a5ced972bb6d5ae8800e98bebfb", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"84.0.4147.89\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO wpy4_options VALUES("265008", "litespeed.admin_display._summary", "a:5:{s:11:\"new_version\";i:1592123782;s:5:\"score\";i:1592469382;s:22:\"new_version.last_check\";i:1595607595;s:13:\"new_version.v\";s:5:\"3.2.4\";s:16:\"score.last_check\";i:1594079636;}", "yes");
INSERT INTO wpy4_options VALUES("280987", "_transient_is_multi_author", "1", "yes");
INSERT INTO wpy4_options VALUES("281160", "_site_transient_timeout_envato_market_plugins", "1595621983", "no");
INSERT INTO wpy4_options VALUES("281155", "_transient_timeout_jetpack_rewind_state", "1595620119", "no");
INSERT INTO wpy4_options VALUES("281156", "_transient_jetpack_rewind_state", "O:8:\"stdClass\":4:{s:6:\"reason\";s:18:\"host_not_supported\";s:5:\"state\";s:11:\"unavailable\";s:12:\"last_updated\";s:29:\"2020-07-24T19:18:38.368+00:00\";s:9:\"has_cloud\";b:0;}", "no");
INSERT INTO wpy4_options VALUES("245390", "lscwp_whm_install", "whm_install", "yes");
INSERT INTO wpy4_options VALUES("244391", "wpfc_settings", "a:7:{s:18:\"wpfc_text_fb_appid\";s:15:\"252570702704235\";s:24:\"wpfc_text_comments_count\";s:2:\"10\";s:20:\"wpfc_text_data_width\";s:0:\"\";s:28:\"wpfc_option_data_colorscheme\";s:5:\"light\";s:24:\"wpfc_option_data_orderby\";s:6:\"social\";s:23:\"wpfc_option_data_locale\";s:5:\"en_US\";s:24:\"wpfc_checkbox_post_types\";a:19:{s:4:\"post\";s:5:\"post \";s:8:\"revision\";s:9:\"revision \";s:13:\"nav_menu_item\";s:14:\"nav_menu_item \";s:10:\"custom_css\";s:11:\"custom_css \";s:19:\"customize_changeset\";s:20:\"customize_changeset \";s:12:\"oembed_cache\";s:13:\"oembed_cache \";s:12:\"user_request\";s:13:\"user_request \";s:8:\"wp_block\";s:9:\"wp_block \";s:7:\"sermons\";s:8:\"sermons \";s:18:\"ocean_posts_slider\";s:19:\"ocean_posts_slider \";s:13:\"vc4_templates\";s:14:\"vc4_templates \";s:8:\"feedback\";s:9:\"feedback \";s:12:\"vc_grid_item\";s:13:\"vc_grid_item \";s:7:\"gallery\";s:8:\"gallery \";s:5:\"staff\";s:6:\"staff \";s:5:\"event\";s:6:\"event \";s:11:\"jp_mem_plan\";s:12:\"jp_mem_plan \";s:12:\"jp_pay_order\";s:13:\"jp_pay_order \";s:14:\"jp_pay_product\";s:15:\"jp_pay_product \";}}", "yes");
INSERT INTO wpy4_options VALUES("238000", "admin_email_lifespan", "1607503325", "yes");
INSERT INTO wpy4_options VALUES("281150", "_site_transient_timeout_theme_roots", "1595620117", "no");
INSERT INTO wpy4_options VALUES("281151", "_site_transient_theme_roots", "a:9:{s:12:\"NativeChurch\";s:7:\"/themes\";s:16:\"accesspress-lite\";s:7:\"/themes\";s:5:\"alone\";s:7:\"/themes\";s:5:\"deeds\";s:7:\"/themes\";s:11:\"free-church\";s:7:\"/themes\";s:7:\"oceanwp\";s:7:\"/themes\";s:14:\"twentynineteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "no");
INSERT INTO wpy4_options VALUES("245755", "litespeed.conf.cdn-exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245756", "litespeed.conf.cdn-remote_jq", "", "yes");
INSERT INTO wpy4_options VALUES("242916", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.4.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.4.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.4.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.4.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.4.2\";s:7:\"version\";s:5:\"5.4.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.3\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1595618380;s:15:\"version_checked\";s:5:\"5.4.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO wpy4_options VALUES("281164", "_transient_timeout_jetpack_jitm_c871ce1400a5554d7d520a2e066492e", "1595618639", "no");
INSERT INTO wpy4_options VALUES("281165", "_transient_jetpack_jitm_c871ce1400a5554d7d520a2e066492e", "a:2:{i:0;O:8:\"stdClass\":11:{s:7:\"content\";O:8:\"stdClass\":5:{s:7:\"message\";s:48:\"Back up your site before uploading a new plugin.\";s:4:\"icon\";s:7:\"jetpack\";s:4:\"list\";a:0:{}s:11:\"description\";s:101:\"New plugins can lead to unexpected changes. Ensure you can restore your site if something goes wrong.\";s:7:\"classes\";s:0:\"\";}s:3:\"CTA\";O:8:\"stdClass\":5:{s:7:\"message\";s:11:\"Get backups\";s:4:\"hook\";s:0:\"\";s:9:\"newWindow\";b:1;s:7:\"primary\";b:1;s:4:\"link\";s:0:\"\";}s:8:\"template\";s:7:\"default\";s:3:\"ttl\";i:300;s:2:\"id\";s:21:\"backup-plugin-install\";s:13:\"feature_class\";s:6:\"backup\";s:7:\"expires\";i:3628800;s:13:\"max_dismissal\";i:2;s:15:\"activate_module\";N;s:14:\"is_dismissible\";b:1;s:26:\"is_user_created_by_partner\";N;}s:18:\"last_response_time\";i:1595618339;}", "no");
INSERT INTO wpy4_options VALUES("281167", "_transient_timeout_jetpack_plugin_data", "1595704768", "no");
INSERT INTO wpy4_options VALUES("281168", "_transient_jetpack_plugin_data", "O:8:\"stdClass\":24:{s:4:\"name\";s:24:\"Jetpack by WordPress.com\";s:4:\"slug\";s:7:\"jetpack\";s:7:\"version\";s:5:\"8.7.1\";s:6:\"author\";s:44:\"<a href=\"https://jetpack.com\">Automattic</a>\";s:14:\"author_profile\";s:41:\"https://profiles.wordpress.org/automattic\";s:12:\"contributors\";a:101:{s:10:\"automattic\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/automattic\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/687b3bf96c41800814e3b93766444283?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Automattic\";}s:12:\"adamkheckler\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/adamkheckler\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c853a00c574118ef2bc49e3916f73ce3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:4:\"Adam\";}s:5:\"aduth\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/aduth\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/a7ce947b6c1e30a4857068628ada24e1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Andrew Duthie\";}s:5:\"akirk\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/akirk\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/cec9269f2c7f43871230ff701544d03f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"Alex Kirk\";}s:8:\"allendav\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/allendav\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/1fbe2cbf81d138800009924725439779?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Allen Snook\";}s:12:\"alternatekev\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/alternatekev\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/0875b2fe8e3fbb843ccaa9a171df3eb3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"alternatekev\";}s:4:\"andy\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/andy\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/35756b05226763c9539679ccec26a1c0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Andy Skelton\";}s:8:\"annezazu\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/annezazu\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/0eff7149d8c78b242f4652e9ceb8f798?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"annezazu\";}s:9:\"apeatling\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/apeatling\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/0939030c354e4efefe655fa5107fd888?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Andy Peatling\";}s:6:\"azaozz\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/azaozz\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/4e84843ebff0918d72ade21c6ee7b1e4?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Andrew Ozz\";}s:6:\"batmoo\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/batmoo\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/16aeda409d2a00b51ac4c5058a3a8435?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Mohammad Jangda\";}s:5:\"barry\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/barry\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/b0b357b291ac72bc7da81b4d74430fe6?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Barry\";}s:10:\"beaulebens\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/beaulebens\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/205e460b479e2e5b48aec07710c08d50?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Beau Lebens\";}s:8:\"blobaugh\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/blobaugh\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/f25f324a47a1efdf7a745e0b2e3c878f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:22:\"Ben Lobaugh (blobaugh)\";}s:5:\"brbrr\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/brbrr\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/00f6f6f5efff71cff63f48080b091496?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"brbrr\";}s:5:\"cainm\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/cainm\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/377c3dd307043ed31bbc3a1b54416532?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Michael Cain\";}s:4:\"cena\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/cena\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/9e1aa4efffca7b0e290651a8b8652f23?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:4:\"Cena\";}s:6:\"cfinke\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/cfinke\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/a1378d3f89a30d5daa8d7cca0bd80574?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Christopher Finke\";}s:15:\"chaselivingston\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/chaselivingston\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/78e4429c957d6570ae1bea73a53c61ee?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Chase Livingston\";}s:9:\"chellycat\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/chellycat\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/6f6b2c0b4d24e9ee0c8d5519405d80e7?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Michelle Langston\";}s:11:\"clickysteve\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/clickysteve\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/d32c5250fa45b147517f293235417136?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"clickysteve\";}s:7:\"csonnek\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/csonnek\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/561be467af56cefa58e02782b7ac7510?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"csonnek\";}s:15:\"danielbachhuber\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/danielbachhuber\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/a304ad0084a78fe52f6b93e00871754e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Daniel Bachhuber\";}s:11:\"davoraltman\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/davoraltman\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/16acbc88e7aa65104ed289d736cb9698?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Davor\";}s:12:\"daniloercoli\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/daniloercoli\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c6f539874bcd98210c786b4314488753?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"daniloercoli\";}s:8:\"delawski\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/delawski\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/20d358be60b5708a6a81d2cd168e6769?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Piotr Delawski\";}s:12:\"designsimply\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/designsimply\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/eed0e8d62f562daf038f182de7f1fd42?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"designsimply\";}s:4:\"dllh\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/dllh\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/bf6e5c80b9290ad30ace0a50e292268d?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:26:\"Daryl L. L. Houston (dllh)\";}s:10:\"drawmyface\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/drawmyface\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/4988305772319fb9bc8fce0a7acb3aa1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:3:\"Dan\";}s:6:\"dsmart\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/dsmart\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/b43fa2242b1ea9cc8618c6ceb2085f54?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Derek Smart\";}s:5:\"dzver\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/dzver\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/2addc7815c4783cfc7b9c81e4a34bfa7?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"dzver\";}s:8:\"ebinnion\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/ebinnion\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/e8d172977181f0f3e105a2f4553cccc2?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Eric Binnion\";}s:7:\"egregor\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/egregor\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/f48bdc9520a857e39bac2de25046c232?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:4:\"Echo\";}s:10:\"eliorivero\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/eliorivero\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/cb2e9e4d63e271d04ee4e5753d24586f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Elio Rivero\";}s:4:\"enej\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/enej\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7daee6cd5624d7c0562987b422106813?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Enej Bajgoric\";}s:6:\"eoigal\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/eoigal\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/72dd449e5e79e046c1c09ed8712b525a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Eoin Gallagher\";}s:14:\"erania-pinnera\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/erania-pinnera\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/94ea5fe7f174036e72ad87d9b71fd6e0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:4:\"Stef\";}s:8:\"ethitter\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/ethitter\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/9d6b3768833114ff0294ecbf51ab606c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Erick Hitter\";}s:6:\"gcorne\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/gcorne\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/5b02a5101f4a3f37631f1fd1ef4111a9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Gregory Cornelius\";}s:15:\"georgestephanis\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/georgestephanis\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/8c46364c1cdf20827ceb25f901cdc0aa?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"George Stephanis\";}s:7:\"gibrown\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/gibrown\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/915ee4efbd21f12b55b6362cf4f7c42f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:20:\"Greg Ichneumon Brown\";}s:10:\"goldsounds\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/goldsounds\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/a1675bd7a3e8c9d6540de217d168da14?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"goldsounds\";}s:3:\"hew\";a:3:{s:7:\"profile\";s:34:\"https://profiles.wordpress.org/hew\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/d5d395826be4645d2d7bc13aad97db83?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:3:\"Hew\";}s:9:\"hugobaeta\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/hugobaeta\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/0218e99cde7283d859ea46a21e744319?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Hugo Baeta\";}s:14:\"hypertextranch\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/hypertextranch\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/25e2ecf9b520e06d71e47ab083924300?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"hypertextranch\";}s:13:\"iammattthomas\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/iammattthomas\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/e6b19bb6ff09fcf884305e8fa41d698b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:20:\"Matt (Thomas) Miklic\";}s:7:\"iandunn\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/iandunn\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/d0e2ea89fb62350b1304c62eeeaf24b6?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"Ian Dunn\";}s:4:\"jblz\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/jblz\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/d30bee96f3769826fca389e15d81c51d?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Jeff Bowen\";}s:12:\"jeffgolenski\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/jeffgolenski\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/b3b97f6f025689b058de143b489ec268?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"jeffgolenski\";}s:7:\"jeherve\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/jeherve\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/93b13aced520a1a531e642b7c1c17bff?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Jeremy Herve\";}s:8:\"jenhooks\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/jenhooks\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/790618302648bd80fa8a55497dfd8ac8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"Jen H.\";}s:5:\"jenia\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/jenia\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/30845a8785e716017911fff45af5c9fe?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Jenia\";}s:13:\"jessefriedman\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/jessefriedman\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c4ce641ce5c4680349fa59eb8c2909cb?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"jessefriedman\";}s:3:\"jgs\";a:3:{s:7:\"profile\";s:34:\"https://profiles.wordpress.org/jgs\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/0ad9eb4e67bac47214cef94d46d1318f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:4:\"Greg\";}s:7:\"jkudish\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/jkudish\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/8fac9a834778de5a3b7b26fb28cff956?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Joey Kudish\";}s:6:\"jmdodd\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/jmdodd\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/6a7c997edea340616bcc6d0fe03f65dd?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Jennifer M. Dodd\";}s:7:\"joanrho\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/joanrho\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/89a58daeff648db179447dabba22004f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"joanrho\";}s:15:\"johnjamesjacoby\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/johnjamesjacoby\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7a2644fb53ae2f7bfd7143b504af396c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"John James Jacoby\";}s:7:\"jshreve\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/jshreve\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/9ea5b460afb2859968095ad3afe4804b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Justin Shreve\";}s:8:\"kbrownkd\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/kbrownkd\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/954855c9274f4ad2a2f79c82dde33678?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"kbrownkd\";}s:6:\"keoshi\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/keoshi\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/eac8e3135a186cb2176120c2ed71e644?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Filipe Varela\";}s:4:\"koke\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/koke\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/5b415e3c9c245e557af9f580eeb8760a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Jorge Bernal\";}s:7:\"kraftbj\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/kraftbj\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/6e238edcb0664c975ccb9e8e80abb307?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Brandon Kraft\";}s:12:\"lancewillett\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/lancewillett\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/47976847383b324bd35e228a91eb1a0f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Lance Willett\";}s:9:\"lschuyler\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/lschuyler\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/38d5bbe8cd50b492a02f889c55628fb3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Lisa Schuyler\";}s:7:\"macmanx\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/macmanx\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/190cf13c9cd358521085af13615382d5?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"James Huff\";}s:10:\"martinremy\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/martinremy\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/33b3e384f5a150015a5a981402983ca3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"martinremy\";}s:4:\"matt\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/matt\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/767fc9c115a1b989744c755db47feb60?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Matt Mullenweg\";}s:6:\"matveb\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/matveb\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/3f8389957d0c59bb0bd5433e86b53a19?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Matias Ventura\";}s:9:\"mattwiebe\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/mattwiebe\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/3f7cda86b0d471afad79a0b5423d1677?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Matt Wiebe\";}s:11:\"maverick3x6\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/maverick3x6\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/85e5d0140e8f88005ff5e88f8ab18b66?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Jeff Golenski\";}s:4:\"mcsf\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/mcsf\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7e89b8105f7e05afa2872e411d3f76ad?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Miguel Fonseca\";}s:8:\"mdawaffe\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/mdawaffe\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/94e778f51997baa3f47ecaca4e819090?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:24:\"Michael Adams (mdawaffe)\";}s:15:\"michael-arestad\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/michael-arestad\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/e8b4c8470f61ff15b9c98f7a1556c16b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Michael Arestad\";}s:8:\"migueluy\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/migueluy\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c2f03d35da02e6dced303b48e3c895ea?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Miguel Lezama\";}s:9:\"mikeyarce\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/mikeyarce\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/39640559442fe2250231aca4c0102d0c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Mikey Arce\";}s:4:\"mkaz\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/mkaz\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/fc45b574f01cde91f5d1603335ea77c3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:18:\"Marcus Kazmierczak\";}s:11:\"nancythanki\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/nancythanki\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/642411e0e1cd2d36a8a09570c457884a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Nancy\";}s:10:\"nickmomrik\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/nickmomrik\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/6b24381ebfed7b19ebec751322aa8cc1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Nick Momrik\";}s:8:\"obenland\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/obenland\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/1d185e40270139d70c2c50e7219b06ab?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Konstantin Obenland\";}s:6:\"oskosk\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/oskosk\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/5e1a8fd2bbd05c5cc3dec35e05d888c2?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:3:\"Osk\";}s:5:\"pento\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/pento\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/1ad9e5c98d81c6815a65dab5b6e1f669?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Gary Pendergast\";}s:11:\"professor44\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/professor44\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/0934fa64cc323b6a2e10dc37fc33fa64?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Jesse Friedman\";}s:14:\"rachelsquirrel\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/rachelsquirrel\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/6923d9b3ce6f8a9eb43abd605cf8b0e5?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"rachelsquirrel\";}s:6:\"rdcoll\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/rdcoll\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/8d7e1bdd8aa5db45c113d61bfd86086f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Rich Collier\";}s:10:\"ryancowles\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/ryancowles\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/4626de7797aada973c1fb22dfe0e5109?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Ryan Cowles\";}s:13:\"richardmuscat\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/richardmuscat\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/0011ac3115b33c6051d6706ca3adb47e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Richard Muscat\";}s:10:\"richardmtl\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/richardmtl\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/42a095bea6d1b31219392a065dd7d548?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Richard Archambault\";}s:13:\"roccotripaldi\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/roccotripaldi\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/a78c747ecc4e8d1936e8d33080ae1803?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Rocco Tripaldi\";}s:12:\"samhotchkiss\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/samhotchkiss\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/a8cae2d8534e900a162cf44414660e1f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Sam Hotchkiss\";}s:10:\"scarstocea\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/scarstocea\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/e7b26de48e76498cff880abca1eed8da?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Stefan Carstocea\";}s:9:\"scottsweb\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/scottsweb\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c887eb86967863cf7e9002277fa6f625?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Scott\";}s:7:\"sdquirk\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/sdquirk\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/6637858a5d4b31943507c637497d53c1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Stephen Quirk\";}s:7:\"simison\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/simison\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/b0dade512eb83bcfacff9af9ed8c5595?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Mikael Korpela\";}s:8:\"stephdau\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/stephdau\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/5b8d74a711e183850bd70ccdd440d15e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:25:\"Stephane Daury (stephdau)\";}s:8:\"tmoorewp\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/tmoorewp\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/9466b647a74493be4701076792be3f44?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"Tim Moore\";}s:5:\"tyxla\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/tyxla\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/cf58282ee2e95590510aaa24b734c186?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Marin Atanasov\";}s:12:\"viper007bond\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/viper007bond\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/b51d05d023485f5ef7bcd2a3b6dec207?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Alex Mills\";}s:5:\"westi\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/westi\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/5b3b5ce04dd402124aba53142b3e47f6?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Peter Westwood\";}s:5:\"yoavf\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/yoavf\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/ae98ec38ec28f129a33a424e5eba5769?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Yoav Farhi\";}s:7:\"zinigor\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/zinigor\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/0c4a76adae06042e5e6f39eaf3c2658a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Igor Zinovyev\";}}s:8:\"requires\";s:3:\"5.3\";s:6:\"tested\";s:5:\"5.4.2\";s:12:\"requires_php\";s:3:\"5.6\";s:6:\"rating\";i:78;s:7:\"ratings\";a:5:{i:5;i:954;i:4;i:132;i:3;i:78;i:2;i:66;i:1;i:283;}s:11:\"num_ratings\";i:1513;s:15:\"support_threads\";i:311;s:24:\"support_threads_resolved\";i:292;s:15:\"active_installs\";i:5000000;s:12:\"last_updated\";s:21:\"2020-07-14 1:58pm GMT\";s:5:\"added\";s:10:\"2011-01-20\";s:8:\"homepage\";s:19:\"https://jetpack.com\";s:13:\"download_link\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.8.7.1.zip\";s:11:\"screenshots\";a:4:{i:1;a:2:{s:3:\"src\";s:60:\"https://ps.w.org/jetpack/assets/screenshot-1.png?rev=2079476\";s:7:\"caption\";s:170:\"Keep hackers out with brute force attack protection, malware scanning, spam filtering, and downtime monitoring. Secure your site data with on-demand backups and restores.\";}i:2;a:2:{s:3:\"src\";s:60:\"https://ps.w.org/jetpack/assets/screenshot-2.png?rev=2079476\";s:7:\"caption\";s:107:\"Load pages faster, and serve your images and static files from our massive global content delivery network.\";}i:3;a:2:{s:3:\"src\";s:60:\"https://ps.w.org/jetpack/assets/screenshot-3.png?rev=2079476\";s:7:\"caption\";s:90:\"Customize your website with professionally-designed WordPress themes, blocks, and widgets.\";}i:4;a:2:{s:3:\"src\";s:60:\"https://ps.w.org/jetpack/assets/screenshot-4.png?rev=2079476\";s:7:\"caption\";s:81:\"Promote your newest posts, pages, and products across your social media channels.\";}}s:4:\"tags\";a:5:{s:6:\"backup\";s:6:\"backup\";s:7:\"jetpack\";s:7:\"jetpack\";s:13:\"related-posts\";s:13:\"related posts\";s:8:\"security\";s:8:\"security\";s:13:\"wordpress-com\";s:13:\"WordPress.com\";}s:8:\"versions\";a:146:{s:5:\"2.0.7\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.2.0.7.zip\";s:5:\"2.1.5\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.2.1.5.zip\";s:5:\"2.2.8\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.2.2.8.zip\";s:5:\"2.3.8\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.2.3.8.zip\";s:5:\"2.4.5\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.2.4.5.zip\";s:5:\"2.5.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.2.5.3.zip\";s:5:\"2.6.4\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.2.6.4.zip\";s:5:\"2.7.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.2.7.3.zip\";s:5:\"2.8.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.2.8.3.zip\";s:5:\"2.9.4\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.2.9.4.zip\";s:5:\"3.0.4\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.0.4.zip\";s:5:\"3.1.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.1.3.zip\";s:5:\"3.2.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.2.3.zip\";s:5:\"3.3.4\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.3.4.zip\";s:5:\"3.4.4\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.4.4.zip\";s:5:\"3.5.4\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.5.4.zip\";s:5:\"3.6.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.6.2.zip\";s:5:\"3.7.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.7.3.zip\";s:5:\"3.8.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.8.3.zip\";s:5:\"3.9.7\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.9.7.zip\";s:5:\"4.0.4\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.0.4.zip\";s:5:\"4.1.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.1.1.zip\";s:3:\"4.2\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.4.2.zip\";s:5:\"4.2.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.2.1.zip\";s:5:\"4.2.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.2.2.zip\";s:3:\"4.3\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.4.3.zip\";s:5:\"4.3.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.3.1.zip\";s:5:\"4.3.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.3.2.zip\";s:3:\"4.4\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.4.4.zip\";s:5:\"4.4.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.4.1.zip\";s:5:\"4.4.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.4.2.zip\";s:3:\"4.5\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.4.5.zip\";s:3:\"4.6\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.4.6.zip\";s:3:\"4.7\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.4.7.zip\";s:5:\"4.7.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.7.1.zip\";s:3:\"4.8\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.4.8.zip\";s:5:\"4.8.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.8.1.zip\";s:5:\"4.8.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.4.8.2.zip\";s:3:\"4.9\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.4.9.zip\";s:3:\"5.0\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.5.0.zip\";s:3:\"5.1\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.5.1.zip\";s:5:\"5.1.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.1.1.zip\";s:3:\"5.2\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.5.2.zip\";s:5:\"5.2.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.2.1.zip\";s:5:\"5.2.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.2.2.zip\";s:3:\"5.3\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.5.3.zip\";s:5:\"5.3.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.3.1.zip\";s:3:\"5.4\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.5.4.zip\";s:5:\"5.4.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.4.1.zip\";s:3:\"5.5\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.5.5.zip\";s:5:\"5.5.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.5.1.zip\";s:5:\"5.5.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.5.2.zip\";s:3:\"5.6\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.5.6.zip\";s:5:\"5.6.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.6.1.zip\";s:5:\"5.6.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.6.2.zip\";s:3:\"5.7\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.5.7.zip\";s:5:\"5.7.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.7.1.zip\";s:5:\"5.7.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.7.2.zip\";s:3:\"5.8\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.5.8.zip\";s:5:\"5.8.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.8.1.zip\";s:3:\"5.9\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.5.9.zip\";s:5:\"5.9.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.5.9.1.zip\";s:3:\"6.0\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.6.0.zip\";s:5:\"6.0.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.0.1.zip\";s:3:\"6.1\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.6.1.zip\";s:5:\"6.1.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.1.1.zip\";s:5:\"6.1.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.1.2.zip\";s:3:\"6.2\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.6.2.zip\";s:5:\"6.2.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.2.1.zip\";s:5:\"6.2.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.2.2.zip\";s:3:\"6.3\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.6.3.zip\";s:5:\"6.3.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.3.1.zip\";s:5:\"6.3.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.3.2.zip\";s:5:\"6.3.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.3.3.zip\";s:5:\"6.3.4\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.3.4.zip\";s:3:\"6.4\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.6.4.zip\";s:5:\"6.4.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.4.1.zip\";s:5:\"6.4.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.4.2.zip\";s:5:\"6.4.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.4.3.zip\";s:3:\"6.5\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.6.5.zip\";s:5:\"6.5.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.5.1.zip\";s:3:\"6.6\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.6.6.zip\";s:5:\"6.6.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.6.1.zip\";s:5:\"6.6.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.6.2.zip\";s:3:\"6.7\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.6.7.zip\";s:5:\"6.7.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.7.1.zip\";s:3:\"6.8\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.6.8.zip\";s:5:\"6.8.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.8.1.zip\";s:5:\"6.8.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.8.2.zip\";s:3:\"6.9\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.6.9.zip\";s:5:\"6.9.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.6.9.1.zip\";s:3:\"7.0\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.7.0.zip\";s:5:\"7.0.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.0.1.zip\";s:5:\"7.0.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.0.2.zip\";s:3:\"7.1\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.7.1.zip\";s:5:\"7.1.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.1.1.zip\";s:5:\"7.1.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.1.2.zip\";s:3:\"7.2\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.7.2.zip\";s:5:\"7.2.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.2.1.zip\";s:7:\"7.2.1.1\";s:58:\"https://downloads.wordpress.org/plugin/jetpack.7.2.1.1.zip\";s:5:\"7.2.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.2.2.zip\";s:3:\"7.3\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.7.3.zip\";s:7:\"7.3.0.1\";s:58:\"https://downloads.wordpress.org/plugin/jetpack.7.3.0.1.zip\";s:5:\"7.3.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.3.1.zip\";s:7:\"7.3.1.1\";s:58:\"https://downloads.wordpress.org/plugin/jetpack.7.3.1.1.zip\";s:5:\"7.3.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.3.2.zip\";s:3:\"7.4\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.7.4.zip\";s:5:\"7.4.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.4.1.zip\";s:5:\"7.4.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.4.2.zip\";s:3:\"7.5\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.7.5.zip\";s:7:\"7.5.0.1\";s:58:\"https://downloads.wordpress.org/plugin/jetpack.7.5.0.1.zip\";s:5:\"7.5.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.5.1.zip\";s:5:\"7.5.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.5.2.zip\";s:5:\"7.5.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.5.3.zip\";s:5:\"7.5.4\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.5.4.zip\";s:3:\"7.6\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.7.6.zip\";s:5:\"7.6.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.6.1.zip\";s:3:\"7.7\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.7.7.zip\";s:5:\"7.7.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.7.1.zip\";s:5:\"7.7.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.7.2.zip\";s:5:\"7.7.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.7.3.zip\";s:3:\"7.8\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.7.8.zip\";s:5:\"7.8.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.8.1.zip\";s:3:\"7.9\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.7.9.zip\";s:5:\"7.9.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.7.9.1.zip\";s:3:\"8.0\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.8.0.zip\";s:3:\"8.1\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.8.1.zip\";s:5:\"8.1.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.8.1.1.zip\";s:3:\"8.2\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.8.2.zip\";s:7:\"8.2.0.1\";s:58:\"https://downloads.wordpress.org/plugin/jetpack.8.2.0.1.zip\";s:5:\"8.2.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.8.2.1.zip\";s:5:\"8.2.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.8.2.2.zip\";s:5:\"8.2.3\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.8.2.3.zip\";s:3:\"8.3\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.8.3.zip\";s:3:\"8.4\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.8.4.zip\";s:5:\"8.4.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.8.4.1.zip\";s:5:\"8.4.2\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.8.4.2.zip\";s:3:\"8.5\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.8.5.zip\";s:3:\"8.6\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.8.6.zip\";s:5:\"8.6.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.8.6.1.zip\";s:3:\"8.7\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.8.7.zip\";s:8:\"8.7-beta\";s:59:\"https://downloads.wordpress.org/plugin/jetpack.8.7-beta.zip\";s:7:\"8.7.0.1\";s:58:\"https://downloads.wordpress.org/plugin/jetpack.8.7.0.1.zip\";s:5:\"8.7.1\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.8.7.1.zip\";s:9:\"8.8-alpha\";s:60:\"https://downloads.wordpress.org/plugin/jetpack.8.8-alpha.zip\";s:5:\"trunk\";s:50:\"https://downloads.wordpress.org/plugin/jetpack.zip\";}s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=1791404\";s:4:\"high\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=1791404\";}}", "no");
INSERT INTO wpy4_options VALUES("245767", "litespeed.conf.media-placeholder_resp_async", "1", "yes");
INSERT INTO wpy4_options VALUES("245768", "litespeed.conf.media-iframe_lazy", "", "yes");
INSERT INTO wpy4_options VALUES("245769", "litespeed.conf.media-lazyjs_inline", "", "yes");
INSERT INTO wpy4_options VALUES("245770", "litespeed.conf.img_optm-auto", "", "yes");
INSERT INTO wpy4_options VALUES("245771", "litespeed.conf.img_optm-cron", "1", "yes");
INSERT INTO wpy4_options VALUES("245772", "litespeed.conf.img_optm-ori", "1", "yes");
INSERT INTO wpy4_options VALUES("245760", "litespeed.conf.cdn-cloudflare_key", "", "yes");
INSERT INTO wpy4_options VALUES("245761", "litespeed.conf.cdn-cloudflare_name", "", "yes");
INSERT INTO wpy4_options VALUES("245762", "litespeed.conf.cdn-cloudflare_zone", "", "yes");
INSERT INTO wpy4_options VALUES("245763", "litespeed.conf.media-lazy", "", "yes");
INSERT INTO wpy4_options VALUES("245764", "litespeed.conf.media-lazy_placeholder", "", "yes");
INSERT INTO wpy4_options VALUES("245765", "litespeed.conf.media-placeholder_resp", "", "yes");
INSERT INTO wpy4_options VALUES("245766", "litespeed.conf.media-placeholder_resp_color", "#cfd4db", "yes");
INSERT INTO wpy4_options VALUES("244333", "wpdevart_comment_facebook_app_id", "252570702704235", "yes");
INSERT INTO wpy4_options VALUES("238673", "_transient_health-check-site-status-result", "{\"good\":\"7\",\"recommended\":\"8\",\"critical\":\"2\"}", "yes");
INSERT INTO wpy4_options VALUES("281001", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1595650803", "no");
INSERT INTO wpy4_options VALUES("281002", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1595607603", "no");
INSERT INTO wpy4_options VALUES("281003", "_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b", "1595650803", "no");
INSERT INTO wpy4_options VALUES("281004", "_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2020/07/wordpress-5-5-beta-3/\'>WordPress 5.5 Beta 3</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/revised-block-directory-guidelines-proposal-updates-wording-but-changes-little-else?utm_source=rss&#038;utm_medium=rss&#038;utm_campaign=revised-block-directory-guidelines-proposal-updates-wording-but-changes-little-else\'>WPTavern: Revised Block Directory Guidelines Proposal Updates Wording but Changes Little Else</a></li><li><a class=\'rsswidget\' href=\'https://buddypress.org/2020/07/buddypress-6-2-0-beta/\'>BuddyPress: BuddyPress 6.2.0 beta</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/google-delays-mobile-first-indexing-deadline-to-march-2021?utm_source=rss&#038;utm_medium=rss&#038;utm_campaign=google-delays-mobile-first-indexing-deadline-to-march-2021\'>WPTavern: Google Delays Mobile-First Indexing Deadline to March 2021</a></li></ul></div>", "no");
INSERT INTO wpy4_options VALUES("281009", "_transient_settings_errors", "a:1:{i:0;a:4:{s:7:\"setting\";s:7:\"general\";s:4:\"code\";s:16:\"settings_updated\";s:7:\"message\";s:15:\"Settings saved.\";s:4:\"type\";s:7:\"success\";}}", "no");
INSERT INTO wpy4_options VALUES("281010", "_transient_timeout_jetpack_jitm_9bd053c74b38dd08e2fe67b4fb0b3a9", "1595607945", "no");
INSERT INTO wpy4_options VALUES("281011", "_transient_jetpack_jitm_9bd053c74b38dd08e2fe67b4fb0b3a9", "a:1:{s:18:\"last_response_time\";i:1595607645;}", "no");
INSERT INTO wpy4_options VALUES("281162", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1595629134", "no");
INSERT INTO wpy4_options VALUES("281163", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4712;}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:4258;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2677;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2561;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:1967;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1815;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1794;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1486;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1479;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1477;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1453;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1439;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1435;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1305;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1210;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1198;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1139;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1129;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1099;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1002;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:887;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:886;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:879;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:876;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:789;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:789;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:781;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:776;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:769;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:751;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:732;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:721;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:718;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:699;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:692;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:663;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:661;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:659;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:657;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:649;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:632;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:628;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:598;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:587;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:586;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:580;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:578;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:574;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:561;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:553;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:553;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:549;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:542;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:538;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:531;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:526;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:522;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:518;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:517;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:510;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:508;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:503;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:494;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:491;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:479;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:478;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:472;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:452;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:443;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:438;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:434;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:433;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:431;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:430;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:423;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:421;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:416;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:411;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:409;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:406;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:399;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:398;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:394;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:388;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:382;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:381;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:380;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:378;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:377;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:377;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:373;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:370;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:363;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:363;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:360;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:351;}s:16:\"google-analytics\";a:3:{s:4:\"name\";s:16:\"google analytics\";s:4:\"slug\";s:16:\"google-analytics\";s:5:\"count\";i:348;}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";i:342;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:340;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:339;}}", "no");
INSERT INTO wpy4_options VALUES("281161", "_site_transient_envato_market_plugins", "a:4:{s:9:\"purchased\";a:0:{}s:6:\"active\";a:0:{}s:9:\"installed\";a:0:{}s:7:\"install\";a:0:{}}", "no");
INSERT INTO wpy4_options VALUES("281207", "_transient_timeout_jetpack_sync_constants_await", "1595622276", "no");
INSERT INTO wpy4_options VALUES("281208", "_transient_jetpack_sync_constants_await", "1595618676.61", "no");
INSERT INTO wpy4_options VALUES("280965", "_transient_timeout_wfcredentialstatus_2", "1595611193", "no");
INSERT INTO wpy4_options VALUES("280782", "_transient_timeout_wflginfl_00000000000000000000ffffb9dc6513", "1595596564", "no");
INSERT INTO wpy4_options VALUES("280783", "_transient_wflginfl_00000000000000000000ffffb9dc6513", "1", "no");
INSERT INTO wpy4_options VALUES("280805", "_transient_timeout_wflginfl_00000000000000000000ffff3ed2ac64", "1595598852", "no");
INSERT INTO wpy4_options VALUES("280806", "_transient_wflginfl_00000000000000000000ffff3ed2ac64", "10", "no");
INSERT INTO wpy4_options VALUES("280997", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1595650803", "no");
INSERT INTO wpy4_options VALUES("280998", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1595607603", "no");
INSERT INTO wpy4_options VALUES("280999", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1595650803", "no");
INSERT INTO wpy4_options VALUES("281000", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"
	
	
	
	




















































\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Revised Block Directory Guidelines Proposal Updates Wording but Changes Little Else\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=102315\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:231:\"https://wptavern.com/revised-block-directory-guidelines-proposal-updates-wording-but-changes-little-else?utm_source=rss&utm_medium=rss&utm_campaign=revised-block-directory-guidelines-proposal-updates-wording-but-changes-little-else\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6513:\"<p class=\"has-drop-cap\">Yesterday, Alex Shiels <a href=\"https://make.wordpress.org/plugins/2020/07/22/proposed-block-directory-guidelines/\">posted an update</a> to the <a href=\"https://github.com/WordPress/wporg-plugin-guidelines/pull/70/files#diff-bcf4c6e86251a8d088c6bd5800c476ff\">proposed guidelines</a> for the WordPress block directory. The document adds eight rules for plugin authors to follow if they plan to add their one-off blocks to the directory. The guidelines are additional requirements on top of the existing plugin directory guidelines.</p>



<p>While the wording and organization of the block guidelines received a revamp in comparison to the <a href=\"https://github.com/WordPress/wporg-plugin-guidelines/blob/87a9a17eca6d4b39a6bb4b1f2c8dcf33aff26336/blocks.md\">original proposal</a>, the overall sentiment is unchanged. Shiels thanks community developers for the feedback on the original guidelines but does not go into detail about the things that changed as a result.</p>



<p>The primary guidelines are mostly expected, run-of-the-mill requirements for blocks. Developers need a <code>block.json</code> file. They should name stuff appropriately. Plugins should contain only a single block. Plugins should only touch the block editor. Blocks should work seamlessly once activated.</p>



<p>The remaining guidelines are certain to be a disappointment or point of contention for some developers.</p>



<h2>Monetization Still Not Allowed</h2>



<p class=\"has-drop-cap\">The largest <a href=\"https://wptavern.com/can-the-block-directory-and-business-interests-coexist\">feedback on the guidelines</a> we received here at the Tavern surrounded what is essentially a blanket ban on commercial interests for block developers. Blocks still cannot hook into a paid service or advertise within the admin. This limitation will obviously turn away many businesses that may have been looking forward to the block directory as a potential avenue for profit. Right now, one-off blocks will need to be built by those with altruistic interests, giving back to the community simply out of the kindness of their hearts.</p>



<p>While there is nothing inherently wrong with wanting to do that, it is not attractive to developers who are primarily focused on putting food on the table. Hobbyists and larger businesses with the resources to give back will be well-suited to add blocks to the directory. However, it will give a lot of developers pause because it is unlikely a good return on investment. Instead, those developers are more likely to submit their blocks to the normal plugin directory with their normal upsell methods. This will only serve to make block discoverability harder for end-users.</p>



<p>This is a missed opportunity to build a well-rounded system that is fair to both users and developers who need to make a living. Whether it is through the plugin tag system or specific guidelines on monetization, we could have built something that made everyone a little happy and a little mad, a compromise that merged a good user interface and experience.</p>



<p>It is not like there have been no proposals. In January, Luke Carbis wrote a detailed outline of <a href=\"https://carb.is/2020/01/block-business/\">how WordPress could provide a middle ground</a> between sustainability (business models) and accessibility (free options) with the upcoming block directory. His fear was that the block directory would be full of blocks without updates in a few years because the completely free model is unsustainable. His proposal was a badge-based system that let users know if a block contained ads, used a freemium model, or required a sign-in to a third-party service.</p>



<p>The current guideline is not set in stone. This is the first version of the block directory. It is not out of the question that the team could change things as the directory grows over time.</p>



<h2>No Love for Server-Side Blocks</h2>



<p class=\"has-drop-cap\">The block directory guidelines are still heavily geared toward static blocks. PHP must be kept at a minimum and primarily be used to load any necessary scripts and stylesheets. Server-side blocks are not getting much attention at the moment, which may be a limitation of the software.</p>



<p>It would be great to see a way for some server-side blocks to be included in the block directory. For example, a breadcrumbs block would need to rely heavily on PHP to render its output. It is a dynamic block rather than static. This particular block would not be useful until full-site editing lands in WordPress, which is still several months away. However, I am getting the itch to turn an old breadcrumbs plugin of mine into a block. It would be neat to see it listed in the block directory.</p>



<p>There are countless other scenarios. Post lists, product grids, and data pulled from external APIs are all good use cases for one-off blocks.</p>



<h2>Dependencies Are Not Allowed</h2>



<p class=\"has-drop-cap\">Given the way that WordPress works, it makes sense to ban dependencies on other plugins for any particular block to function. This is an old limitation that is rearing its head again. Every other modern framework uses some sort of dependency management to address this problem.</p>



<p>The block directory has the potential to exacerbate the problem even further. Because plugins coming from this directory will be single blocks, it will often mean that developers are using the same bits of code across multiple projects. For example, an end-user may activate multiple block plugins that rely on the same JavaScript library. Because there is no 100%, sure-fire way to make sure only one instance of this library is loaded, users may be running multiple instances of it on their sites. It is not a new problem, but smaller block plugins mean that users are more likely to install more plugins. It increases the probability of running into this issue.</p>



<p>If there was any sort of basic dependency management for plugin authors to use in WordPress, it would solve a world of problems. Over the years, developers have created methods to minimize the issues stemming from the lack of such a system. However, nothing is foolproof without a standard to follow.</p>



<p>This has also held developers back from building libraries, scripts, and tools that could benefit the entire development community as a whole. Everyone builds their own things in-house, and the block directory is making a promise for more of the same.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2020 20:38:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"BuddyPress: BuddyPress 6.2.0 beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=312990\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://buddypress.org/2020/07/buddypress-6-2-0-beta/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2350:\"<p>Hi BuddyPress contributors!</p>



<p>We will soon publish a maintenance release (<strong>6.2.0</strong>) to prepare BuddyPress to some changes that will introduce WordPress next major release (5.5.0). WordPress 5.5.0 is slated for August 11, and we&#8217;d love you to help us use the coming days to make sure your favorite community engine is ready to fully enjoy this new version of WordPress.</p>



<p>BuddyPress 6.2.0 will make sure our BP Email feature is using the 6.0 version of PHPMailer when WordPress 5.5.0 is installed on your site and will carry on using its version 5.2 when your WordPress version is lower (4.8 to 5.4 for the supported versions of our 6.0 branch). For more information about it, please have a look to this <a href=\"https://buddypress.trac.wordpress.org/ticket/8322\">ticket</a>.</p>



<p>If you&#8217;re a plugin or a theme developer and are extending our BP Email feature, we strongly advise you to test your code with the latest pre-release of WordPress 5.5.0 (eg: <a href=\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-3/\">5.5.0-beta3</a>) and BuddyPress <a href=\"https://downloads.wordpress.org/plugin/buddypress.6.2.0-beta1.zip\">6.2.0-beta1</a>.</p>



<p>WordPress 5.5.0 will also <a href=\"https://make.wordpress.org/core/2020/06/29/updating-jquery-version-shipped-with-wordpress/\">remove the jQuery Migrate library</a>, as BuddyPress uses a lot jQuery, we&#8217;ve been checking the impact of this removal. We haven&#8217;t found any issue so far, but if you do, please warn us about it commenting this <a href=\"https://buddypress.trac.wordpress.org/ticket/8333\">ticket</a>.</p>



<p>A detailed changelog will be part of our official release notes, but, until then, you can check out this&nbsp;<a href=\"https://buddypress.trac.wordpress.org/query?status=closed&group=resolution&milestone=6.2.0\">report on Trac</a>&nbsp;for the full list of fixes.</p>



<p>You can test the <a href=\"https://downloads.wordpress.org/plugin/buddypress.6.2.0-beta1.zip\">6.2.0-beta1</a> pre-release in 2 ways :</p>



<ul><li>Use the <a href=\"https://wordpress.org/plugins/bp-beta-tester/\">BP Beta Tester</a> plugin.</li><li><a href=\"https://downloads.wordpress.org/plugin/buddypress.6.2.0-beta1.zip\">Download the 6.2.0 beta release here (zip file)</a>.</li></ul>



<p>Thanks in advance for your contributions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2020 00:45:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: Google Delays Mobile-First Indexing Deadline to March 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=102262\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:181:\"https://wptavern.com/google-delays-mobile-first-indexing-deadline-to-march-2021?utm_source=rss&utm_medium=rss&utm_campaign=google-delays-mobile-first-indexing-deadline-to-march-2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3509:\"<p>Google had set September 2020 as the deadline for when it would begin to fully switch over to crawling and indexing sites using mobile-first indexing but announced today that site owners will have more time to prepare. The deadline has been <a href=\"https://webmasters.googleblog.com/2020/07/prepare-for-mobile-first-indexing-with.html\">extended to March 2021</a>. </p>



<p>Mobile-first indexing is a long-term plan that Google began rolling out in July 2019 by enabling it for new domains. The company cited &ldquo;these uncertain times&rdquo; as the reason for delaying the next phase of the rollout. The announcement also referenced further testing that showed a number of common issues sites are having in making the transition. Google urged site owners to pay close attention to several important issues:</p>



<ul><li>Robots meta tags on mobile version should match the desktop version or Google may fail to index or follow links on the page.</li><li>Do not lazy-load primary content based on user interactions (like swiping, clicking, or typing), because the Googlebot doesn&rsquo;t trigger these user interactions.</li><li>Avoid the bad practice of using smaller images on mobile to fit the smaller screen. Small and low quality image will not be favorably indexed.</li><li>Ensure content on the mobile version matches the desktop, since only the mobile version will be used for indexing and ranking in Search. </li><li>Include meaningful alt text for images.</li></ul>



<p>Google also outlined several other tips for image and video markup and placement. The announcement is essentially a tutorial for how to improve common mistakes that can negatively impact mobile ranking and indexing.</p>



<p>Since mobile-first indexing is already enabled for most currently crawled sites, some speculated that the delayed deadline was due to hastily migrated mobile subdomain sites. John Mueller, Webmaster Trends Analyst at Google, confirmed this is the case and advised site owners to avoid this dated approach and update at the nearest opportunity.</p>



<div class=\"wp-block-embed__wrapper\">
<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">That\'s basically the inverse of how it was before, when desktop URLs were sometimes shown in mobile serps. Ideally, you\'d redirect by device type. M-dot sites do make things harder; for new sites I\'d avoid them, for older sites, I\'d fix with the next bigger revamp.</p>&mdash; &#127820; John &#127820; (@JohnMu) <a href=\"https://twitter.com/JohnMu/status/1285877309862563840?ref_src=twsrc%5Etfw\">July 22, 2020</a></blockquote>
</div>



<p>Before the advent of responsive design, many WordPress site owners added plugins that would create a separate mobile site to provide a more mobile-friendly browsing experience. Website visitors soon expected the entire web to be available to them on the devices they carried around in their pockets. This is now the primary way that people interact with the web, and Google&rsquo;s mobile-first indexing is a reflection of this new reality.</p>



<p>If your WordPress site is still relying on a plugin to create a separate mobile site, or if you are using a plugin for lazy loading, make sure that the solution you have in place is following  Google&rsquo;s <a href=\"https://developers.google.com/search/mobile-sites/mobile-first-indexing\">mobile-first indexing best practices</a>. There are still 9 months remaining before Google makes mobile-first indexing and ranking the default for the entire web.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2020 23:20:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: Zero BS CRM Rebrands and Relaunches as Jetpack CRM\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=102138\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:165:\"https://wptavern.com/zero-bs-crm-rebrands-and-relaunches-as-jetpack-crm?utm_source=rss&utm_medium=rss&utm_campaign=zero-bs-crm-rebrands-and-relaunches-as-jetpack-crm\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5649:\"<img />Jetpack CRM welcome screen.



<p class=\"has-drop-cap\">Mike Stott, co-creator of Zero BS CRM, <a href=\"https://jetpack.com/2020/07/20/introducing-jetpack-crm/\">announced the launch of Jetpack CRM</a> on Monday. The news was the seemingly inevitable rebranding of the original plugin that he and Woody Hayday had built. Automattic, the owner of the Jetpack plugin, acquired the project almost a year ago. While <a href=\"https://wordpress.org/plugins/zero-bs-crm/\">Jetpack CRM</a> carries the &ldquo;Jetpack&rdquo; name, it is still a standalone project and has a <a href=\"https://jetpackcrm.com/\">dedicated website</a>.</p>



<p>CRM stands for &ldquo;customer relationship management.&rdquo; Such systems allow businesses to manage relationships through an interface but can vary extensively in user experience. The goal is to manage contacts, sales, and productivity through the software.</p>



<p>The duo of Stott and Hayday have had a bit of a journey in the past year. In August 2019, <a href=\"https://wptavern.com/automattic-acquires-zero-bs-crm-considers-rebranding-it-as-jetpack-crm\">Automattic acquired the project</a> and provided the resources for the team to continue working on Zero BS CRM. The <a href=\"https://wptavern.com/zero-bs-crm-3-0-improves-ui-changes-database-structure-and-becomes-more-extendable\">3.0 launch</a> in December 2019 was a massive undertaking that included a major database change and UI improvements. Since then, they have worked toward rebranding the project. Stott also did this with a newborn in his family.</p>



<p>When version 3.0 of Zero BS CRM launched, Stott said they were still discussing whether to rebrand and bring the plugin under the Jetpack umbrella. They were gathering user feedback at the time, but his primary focus was on developing features. The name was not the foremost thing on his mind. However, branding can make or break even a good project, and Jetpack is as close to a household name as any product coming out of the WordPress ecosystem. It made sense to lean on that branding.</p>



<p>&ldquo;Jetpack&rsquo;s mission is to help entrepreneurs and small businesses succeed by providing tools that keep their sites fast and secure,&rdquo; said Stott. &ldquo;We felt that from within the Automattic family, this was a great match. We created ZBS CRM with the same end goal in mind &mdash; helping you succeed through better customer relationships, so it just made sense.&rdquo;</p>



<p>After nearly a year beyond the acquisition, Stott feels like things are going great within the new environment at Automattic. &ldquo;We&rsquo;ve found the right product fit within Automattic,&rdquo; he said. &ldquo;In Jetpack, we&rsquo;re happy that we can really push the CRM, and it&rsquo;s exciting to be part of the bigger WordPress family and being able to integrate with WooCommerce, etc.&rdquo;</p>



<p>Version 4.0 of the plugin primarily changes the branding in the admin and lightens the UI background. The team has also continued to add small changes.</p>



<p>&ldquo;Looking ahead, we&rsquo;re excited to continue developing the CRM following user feedback,&rdquo; said Stott. &ldquo;We&rsquo;ll be working on our roadmap and, of course, how we can best integrate with the Jetpack family.&rdquo;</p>



<h2>Growing and the Future</h2>



<p class=\"has-drop-cap\">Jetpack CRM currently has 3,000+ active installs. This is up from 2,000 since the launch of version 3.0 last December. It has been a slow road thus far. However, there is room for growth. The leading CRM plugin, Hubspot, has 100,000+ active installs. There should be plenty of room for competing plugins in the CRM market.</p>



<p>&ldquo;There&rsquo;s a massive opportunity for CRM in the WordPress space,&rdquo; said Stott. &ldquo;A CRM is not like installing an SEO plugin on every website you own &mdash; generally you&rsquo;d only have a single CRM for your business &mdash; but it&rsquo;s the core of your business. The fact that 3,000+ users and counting are choosing WordPress to run their CRM is a great start.&rdquo;</p>



<p>The Jetpack brand should help spur some of the growth, particularly if Automattic pushes it as an add-on within the primary Jetpack plugin.</p>



<p>&ldquo;[Jetpack] has substantial reach among website owners who would benefit from a CRM but may not know what a CRM is,&rdquo; said Stott. &ldquo;While we&rsquo;re happy that the plugin is still growing organically, we are just about set up to really push Jetpack CRM with full force.&rdquo;</p>



<p>Stott believes the Hubspot comparison isn&rsquo;t apples-to-apples. Unlike Jetpack CRM, the Hubspot plugin pushes users to an app that is hosted off-site.</p>



<p>&ldquo;While this makes sense for some users, it doesn&rsquo;t really take advantage of the huge benefits that native WordPress plugins offer,&rdquo; he said. &ldquo;Jetpack CRM sits on the user&rsquo;s servers. Users manage and control their own data &mdash; a huge win under the GDPR whereas a site owner you&rsquo;re legally required to know where your data is held. Not to mention that the plugin is also extendable.&rdquo;</p>



<p>Stott said he has always loved the WordPress community&rsquo;s open-source approach and the freedoms that it provides to build something custom or extend what is already there. There should be ample opportunity for developers to extend Jetpack CRM&rsquo;s codebase.</p>



<p>&ldquo;To my mind, there has never been a more exciting time for plugins like Jetpack CRM, which we envision as the &lsquo;business layer&rsquo; for modern entrepreneurs, much like WooCommerce has democratized eCommerce,&rdquo; he said.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2020 19:21:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: Unsplash Launches Official Plugin for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101136\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:159:\"https://wptavern.com/unsplash-launches-official-plugin-for-wordpress?utm_source=rss&utm_medium=rss&utm_campaign=unsplash-launches-official-plugin-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6658:\"<p><a href=\"https://unsplash.com/\">Unsplash</a> has released its own <a href=\"https://wordpress.org/plugins/unsplash/\">official plugin for WordPress</a>, co-developed with the team at <a href=\"https://xwp.co/\">XWP</a>. The plugin seamlessly connects Unsplash&rsquo;s 1 million+ free high-resolution image library with the WordPress editor.</p>



<div class=\"wp-block-embed__wrapper\">
<a href=\"https://cloudup.com/cUQ5pBCD6jD\"><img src=\"https://cldup.com/3UUPV-2ayL.gif\" alt=\"Post usage 1\" width=\"1100\" height=\"612\" /></a>
</div>



<p>Users can easily search Unsplash directly inside the custom block and insert images with attribution and alt description info automatically filled in. The selected images are download and added to the WordPress media library, saving users the trouble of having to leave their dashboards to search, download, and upload images. </p>



<p>Unsplash co-founder Luke Chesser described the project as &ldquo;bringing the internet&rsquo;s image library to the internet&rsquo;s publishing platform.&rdquo; Although the plugin is useful for any type of website &ndash; from small blogs to businesses, it was large publishing organizations that provided the impetus for Unsplash to develop an official integration for WordPress.</p>



<p>&ldquo;We&rsquo;ve been working with a lot of publishers as they integrate Unsplash into their publishing flows to replace legacy solutions,&rdquo; Chesser said. &ldquo;With so many publishers being powered by WordPress, we saw a repeated need for a high quality integration that could be shared by all of the publishers. In order to best serve them, we needed to offer something that we could ensure met their needs both now and in the future.&rdquo;</p>



<p><a href=\"https://wordpress.org/plugins/instant-images/\">Instant Images</a>, a plugin that boasts one-click Unsplash uploads, is currently the largest competitor to the adoption of the official plugin with more than 50,000 active installs. Many other plugins have also added some form of Unsplash integration in the past. Chesser said his team has loved seeing the variety of applications developers have created with their API and they were hesitant to create their own plugin.</p>



<p>&ldquo;We saw a gap between the things big and small publishers were telling us, and the way the existing plugins had been developed,&rdquo; he said. &ldquo;Most existing plugins reupload the image to the WordPress library and then treat it as a standard image, which breaks a handful of things:</p>



<ul><li>Image attribution to the original photographer is usually lost (or is no longer supported past the first usage)</li><li>The time it takes for the server to download the image and then reupload it can be slow</li><li>Out of the box, WordPress&rsquo;s current support for dynamic image URLs that adapt to the device connection and screen size is limited and by using the&nbsp;Unsplash&nbsp;CDN, we could ensure that the right size image is served to better optimize for performance.&rdquo;</li></ul>



<p>When developing the official plugin, Unsplash and XWP took feedback from publishers and aimed to improve on how existing plugins handled images. After testing it, I found the search feature was fast and setup was a breeze. The plugin handles everything for the user invisibly in the background and its integration with the block editor makes it feel like a natural part of WordPress.</p>



<h2>Unsplash Aims to Increase Its Audience by Enhancing the Publishing Workflow for WordPress Publishers</h2>



<p>As Unsplash looks to define a new economic model around photography, WordPress-powered sites are a major consideration, since the platform powers <a href=\"https://w3techs.com/technologies/details/cm-wordpress\">more than 37%</a> of Alexa&rsquo;s&nbsp;top 10 million&nbsp;websites.</p>



<p>Seven years after it started as a Tumblr blog, Unsplash is moving to directly monetize the site by working with brands to create photos that will appear in search results. &ldquo;Unsplash for Brands&rdquo; launched in December 2019 as an answer to the question of how Unsplash will make money. Companies pay to have their branded images show up prominently in search results alongside other organically ranking images that match users&rsquo; queries. </p>



<p>&ldquo;While they serve completely different purposes, I think a lot of brands are growing tired of the state of digital advertising today, with Facebook and Google having a host of problems around privacy, targeting, and negative consequences for culture,&rdquo; Chesser said. &ldquo;Unsplash&nbsp;allows brands to influence the visual mindshare of the internet while having an authentic and positive impact on their audience.&rdquo;&nbsp;</p>



<p>Launching an official WordPress plugin is a strategic move for Unsplash as it puts those branded images in front of a larger audience with users searching directly within the editor. Although the company continues to push out new features to the&nbsp;Unsplash&nbsp;API, many publishers did not have the resources to create their own integrations.</p>



<p>&ldquo;After so many conversations with publishers, both big and small, that want to integrate the&nbsp;Unsplash&nbsp;library but can&rsquo;t due to resources, we felt that we needed to offer something more ready to use than the raw API or SDKs,&rdquo; Chesser said.</p>



<p>&ldquo;We built the current version of the&nbsp;Unsplash&nbsp;for WordPress plugin so that it meets those needs of publishers now, but we know that we can push it a lot further in the future.&rdquo; </p>



<p>The first iteration of the plugin mirrors the flow and features that a user would have while navigating unsplash.com, while keeping the writer inside the editor. Now that Unsplash is integrated into the WordPress publishing flow, Chesser sees the opportunity to add more interesting features. Open sourcing the plugin also has the potential to increase Unsplash&rsquo;s audience as developers extend its core features for use in other plugins.</p>



<p>&ldquo;Using the context of the post, we can help suggest images or prefill a search using natural language processing,&rdquo; Chesser said. &ldquo;We can link together&nbsp;Unsplash&nbsp;images with other WordPress tools to help publishers edit and process images directly in their posts. And with a lot of the work from the plugin being focused on making&nbsp;Unsplash&nbsp;images work natively inside of the WordPress Media Library, we can even open-source the core in such a way that developers can extend and reuse the functionality, avoiding duplication across all of our third party WordPress plugins.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jul 2020 23:33:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: Why Accessibility Matters for WordPress Themes and Their Users\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=102133\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:189:\"https://wptavern.com/why-accessibility-matters-for-wordpress-themes-and-their-users?utm_source=rss&utm_medium=rss&utm_campaign=why-accessibility-matters-for-wordpress-themes-and-their-users\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13307:\"<p>&ldquo;Do you ever read the subtitles on a video so you didn&rsquo;t need to unmute it?&rdquo; asked William Patton, a representative from the WordPress Themes Team. &ldquo;Used the &lsquo;beep&rsquo; from a crosswalk to know when to cross the road? Found yourself reading the info panel at an airport? Those things are considered features, but in reality, they are aids for people with additional needs.&rdquo;</p>



<p>As I talked with Patton and other reps from the Themes Team, it was clear they believed accessibility was a vital piece of the theme-building puzzle. The team has made small moves in the last year to bring more themes up to standards. However, it has been a slow-going process.</p>



<p>Last July, the <a href=\"https://wptavern.com/wordpress-theme-review-team-initiates-new-long-term-plan-to-make-all-wordpress-org-themes-accessible\">team initiated a plan</a> to add a new guideline every two months or so that would address a single accessibility issue. It would become every theme author&rsquo;s responsibility to make sure they were meeting the new guidelines. It would be every reviewer&rsquo;s responsibility to understand how to test guidelines as they were implemented. Thus far, the team has required only that themes have a working skip-to-content link and keyboard-capable navigation menus.</p>



<p>Not every theme author was excited about the move. Some have still shown resistance a year later.</p>



<p>Last week, we covered the Astra theme&rsquo;s news of hitting 1 million active installs. A <a href=\"https://wptavern.com/astra-becomes-the-only-non-default-wordpress-theme-with-1-million-installs#comment-335038\">commenter made a point</a> that the data shows that end-users do not care about accessibility &mdash; the Astra theme makes no mention of being accessibility-ready. The conclusion was that the Themes Team should not be implementing such guidelines based on the success of one of the directory&rsquo;s most popular themes.</p>



<p>While there are several things we could do to pick apart the original comment and the limited view of the situation, we can instead use it as a catalyst to discuss why accessibility is something that should be at the forefront of every theme author&rsquo;s mind. Patton, along with Themes Team representatives Carolina Nymark and Denis &#381;oljom, had a lot to say on the subject.</p>



<p>The overarching theme was that awareness is vital and that theme developers play a crucial role in making the web more accessible.</p>



<h2>Awareness Is Key</h2>



<img />



<p>&#381;oljom likened the awareness of accessibility to that of a cisgender person looking at the world from the perspective of a transgender person. Once he became aware of larger issues, he made sure to address gender-specific pronouns in his code comments, such as replacing instances of &ldquo;he&rdquo; with &ldquo;they.&rdquo; He hopes such small changes spark similar changes from others.</p>



<p>He said the situation was the same with accessibility. &ldquo;It might not mean much to a person who doesn&rsquo;t have any disabilities, but putting yourself in somebody else&rsquo;s shoes changes one&rsquo;s perspective. This is why we started to include things like skip links, keyboard nav, etc.&rdquo;</p>



<p>The team does not hope theme authors will merely become technically proficient at addressing accessibility issues in their themes. While that would be a help from a review standpoint, it addresses only the symptoms rather than root causes of the issues. Instead, by making more developers aware, they will begin to look at development from multiple perspectives. They will ask how a screen-readers will handle their theme. They will ask whether their colors have enough contrast for low-vision users to read. They will wonder if non-mouse users can navigate their users&rsquo; sites.</p>



<p>The technical stuff is the easy part. Changing perspectives and becoming more empathetic toward those who are different is much more difficult. But not impossible.</p>



<p>&ldquo;A lot of us who build for the web are lacking some basic insights into what it is like to have additional needs beyond what is our own normal,&rdquo; said Patton. &ldquo;There is a saying: &lsquo;if you could see it through my eyes, you would see it differently.&rsquo; If you could see through the eyes of someone with color blindness or impaired vision, you quite literally would see things differently.&rdquo;</p>



<p>The trouble with humans, in general, is that it can sometimes be hard to see things through someone else&rsquo;s eyes. Of course, there are tools to simulate accessibility issues for developers, so that helps. However, these tools do not replicate what it is like to walk through life with a particular impairment or disability. Some of us can only partially glimpse the difficulties that others may have when navigating the web. This does not mean that we cannot address the downfalls of the software we build and become more inclusive to all people, especially if we are proactive when issues are raised.</p>



<p>Nymark identified a few areas where the community can improve awareness:</p>



<ul><li>Make sure that all contributors are aware of the WordPress accessibility requirements so that all new features are accessible.</li><li>Highlight accessibility improvements when WordPress is updated.</li><li>Feature more diverse use cases and highlight areas where the accessibility that is built into WordPress has helped people share and access important content.</li></ul>



<p>&ldquo;The themes team hopes that by making theme authors aware of accessibility issues, authors will learn that even small changes to their code and design can have a great positive impact,&rdquo; she said.</p>



<h2>Is Accessibility Important to End-Users?</h2>



<img />



<p>Certainly, accessibility is important for <em>some</em> users. It certainly mattered to Guillermo Robles, a blind man who sued pizza chain Domino&rsquo;s in 2016 for an inaccessible website. The court case was important enough that it moved through the system all the way to the U.S. Supreme Court. Ultimately, the <a href=\"https://wptavern.com/u-s-supreme-court-denies-dominos-appeal-to-determine-whether-websites-must-be-accessible\">higher court denied Domino&rsquo;s appeal</a> of an earlier ruling. The U.S. 9th Circuit court had previously ruled that business websites fall under Title III of the American with Disabilities Act (ADA) and must meet accessibility standards.</p>



<p>This was a landmark case in the U.S. for accessibility advocates last October. It is also worth remembering as we near the upcoming 30th anniversary of the ADA on July 26.</p>



<p>Domino&rsquo;s is a billion-dollar business. The company has enough money to fight such battles for years. They also have the money to hire world-class web developers to correct any accessibility issues.</p>



<p>However, for small business owners, hiring a single developer, much less an entire agency or team, is often a non-starter. Many small businesses are fortunate to break even. WordPress and its ecosystem of free or low-cost solutions have democratized eCommerce on a scale previously unwitnessed. It means that mom-and-pop stores can have an online presence. It means teens can begin selling their custom art and a multitude of others can make money online without the backing of wads of cash.</p>



<p>For these small business owners, many are unaware of accessibility concerns. They pick up a few plugins and find a theme that suitably matches their branding. The possibility of an impending accessibility-related lawsuit is the furthest thing from their mind. This is a major reason that WordPress needs to be a leader in meeting accessibility standards. Themes, which are the part of the site that visitors will interact with, are possibly the most important part of that equation.</p>



<p>Some would argue that small business owners should understand the laws of their jurisdiction. That is true. However, it is also partly the responsibility of the software creators, says the Theme Team representatives.</p>



<p>&ldquo;Yes, the technology should account for additional needs,&rdquo; said Patton. &ldquo;Yes, the tooling should enable people to make good choices with regards to this. Yes, it should be easy to meet a minimum level of accessibility in the things we create with ease. Yes, it should be a fair assumption that the choices available to pick from are accessible.&rdquo;</p>



<p>The web is inherently accessible out of the box. Raw HTML is read and output by web browsers in such a way that the content can be accessed by anyone. Patton says that it is the things that developers do from that point forward that makes that experience better or worse.</p>



<p>&ldquo;Trade-offs are made that are well-intentioned but not always helpful,&rdquo; he said. &ldquo;Design trade-offs are the easiest to point out. Taking text and embedding it into an image means that some of its value is lost in exchange for it looking pretty. Using closely matching colors for text and background might create an interesting effect to some people but for others, it makes it impossible to read. Sometimes it&rsquo;s about balancing those trade-offs with the needs of others, but it is those kinds of trade-offs that most people struggle to give up.&rdquo;</p>



<p>Nymark described some more technical issues that the average end-user should expect to simply be a non-issue. For example, it is reasonable to assume that a theme installed from the official WordPress directory would be free from HTML, PHP, and JavaScript errors. These are items that users should not have to worry about checking before activating the theme on their site. The errors should simply not exist.</p>



<p>It is that level of quality control that end-users should expect in terms of accessibility, an assurance that the theme does all the things it is supposed to do. It is not about whether end-users &ldquo;care&rdquo; about accessibility.</p>



<p>&ldquo;If a form on a shop checkout page is not working, this can lead to loss of income,&rdquo; she said. &ldquo;Users rely on the technical solution provided by plugins and themes and expect everyone to be able to use their shop. Whether or not the site owner recognizes this as an accessibility issue is irrelevant because their page just needs to work.&rdquo;</p>



<h2>Why Theme Authors Should Care</h2>



<img />



<p>&ldquo;If those who choose themes don&rsquo;t consider accessibility and the theme author did not consider it, then the [visitors] of the sites built with those themes are the ones that lose out,&rdquo; said Patton. &ldquo;It&rsquo;s not a huge leap to realize that low accessibility on your site directly equates to a reduction of potential users.&rdquo;</p>



<p>He said that end-users would naturally assume the themes they are picking from do not have accessibility issues. However, that assumption is typically far from accurate.</p>



<p>&ldquo;Theme authors should care about the accessibility of their creations so that the people picking their themes don&rsquo;t need to use it as a deciding factor,&rdquo; he said.</p>



<p>My go-to response is that developers should concern themselves with accessibility because it is for the collective good. Humans should care about making sure that all other humans have the same freedoms that they enjoy, which are often take for granted.</p>



<p>Even those who cannot view it from that perspective should be able to appreciate that it is a smart business decision. It makes little sense to leave money on the table, especially if you are a developer who is selling a theme or upselling additional features on top of a free theme. There is an entire segment of users that represents money lost.</p>



<p>Additionally, more and more countries are implementing laws around web accessibility. Over time, such laws will be commonplace, particularly in the business sector. Inaccessible themes will lose users as such laws are enforced. Now is a good time to get ahead of impending change.</p>



<h2>More Guidelines Ahead</h2>



<p>The WordPress Themes Team has been slow about adopting additional guidelines surrounding accessibility. However, more are expected to land at some point. Team reps want to work with authors and reviewers alike to make the transition as painless as possible.</p>



<p>&ldquo;We have not added anything else because theme authors are still not releasing themes with working implementations of skip links and usable keyboard navigation,&rdquo; said Patton. &ldquo;When those two things become habitual, it will be time to introduce another aspect as a requirement.&rdquo;</p>



<p>The next guideline in line is expected to be underlined links in the post content. This would be an easy win if the team can get past the current stage. Right now, the team reps are unsure when that will happen.</p>



<p>&ldquo;The fact that this has taken so long for authors to get this right probably indicates that we need to do better at guiding them to resources to learn how to do it and why it is important,&rdquo; said Patton. &ldquo;Perhaps that is a better avenue to pursue than looking to implement additional asks of them.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jul 2020 19:48:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 5.5 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8706\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3830:\"<p>WordPress 5.5 Beta 3 is now available!</p>



<p id=\"block-81bd56b9-ea44-43ad-ab36-a5ae78b54375\"><strong>This software is still in development,</strong>so it’s not recommended to run this version on a production site. Consider setting up a test site to play with the new version.</p>



<p id=\"block-7cc1bbc6-17f9-44c5-8f67-da4e3059ad69\">You can test WordPress 5.5 Beta 3 in two ways:</p>



<ul id=\"block-4840af57-f44b-4d9f-aa64-c6a452392e42\"><li>Try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (choose the “bleeding edge nightlies” option)</li><li>Or <a href=\"https://wordpress.org/wordpress-5.5-beta3.zip\">download the beta here</a> (zip).</li></ul>



<p id=\"block-a40528cb-eb3b-4c8a-8f5e-aa700f1ba086\">WordPress 5.5 is slated for release on <a href=\"https://make.wordpress.org/core/5-5/\">August 11th, 2020</a>, and <strong>we need your help to get there</strong>!</p>



<p>Thank you to all of the contributors who tested the <a href=\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-2/\">beta 2</a> development release and gave feedback. Testing for bugs is a critical part of polishing every release and a great way to contribute to WordPress. </p>



<h2 id=\"block-15d6d57f-905d-4a47-9f66-839468a5375a\">Some highlights</h2>



<p id=\"block-85da84ec-c841-42f9-8d3b-1a4537a61d10\">Since <a href=\"https://wordpress.org/news/2020/02/wordpress-5-4-beta-2/\">beta 2</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=07%2F15%2F2020..07%2F21%2F2020&milestone=5.5&group=component&col=id&col=summary&col=owner&col=type&col=priority&col=component&col=version&order=priority\">43 bugs</a> have been fixed. Here are a few changes in beta 3:</p>



<ul><li>Plugin and theme versions are now shared in the emails when automatically updated (see <a href=\"https://core.trac.wordpress.org/ticket/50350\">#50350</a>).</li><li>REST API routes without a <code>permission_callback</code> now trigger a <code>_doing_it_wrong()</code> warning (see <a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/50075\">#50075</a>).</li><li>Over 23 Gutenberg changes and updates (see <a href=\"https://github.com/WordPress/gutenberg/pull/24068\">#24068</a> and <a href=\"https://core.trac.wordpress.org/ticket/50712\">#50712</a>).</li><li>A bug with the new import and export database Dashicons has been fixed (see <a href=\"https://core.trac.wordpress.org/ticket/49913\">#49913</a>).</li></ul>



<h2 id=\"block-76156b2b-0a52-4502-b585-6cbe9481f55b\">Developer notes</h2>



<p id=\"block-3fe5e264-0a95-4f12-9a18-0cb9dc5955d1\">WordPress 5.5 has lots of refinements to polish the developer experience. To keep up, subscribe to the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> and pay special attention to the <a href=\"https://make.wordpress.org/core/tag/5-5+dev-notes/\">developers’ notes</a> for updates on those and other changes that could affect your products.</p>



<h2 id=\"block-bc89fd56-47b0-439f-8e2c-4a642c80a616\">How to Help</h2>



<p id=\"block-3ff83a77-8b54-4061-ae2d-45fc984cbd76\">Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help translate WordPress into more than 100 languages</a>!</p>



<p id=\"block-9d871099-ec49-446c-8322-9e49b7498c10\">If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. We’d love to hear from you!</p>



<p id=\"block-bd71c1d3-39d9-4b2a-8193-3486497b45fd\">If you’re comfortable writing a reproducible bug report, <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>, where you can also find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jul 2020 17:51:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: WordPress 5.5 to Remove Hulu from List of Supported oEmbed Providers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=102148\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:201:\"https://wptavern.com/wordpress-5-5-to-remove-hulu-from-list-of-supported-oembed-providers?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-5-5-to-remove-hulu-from-list-of-supported-oembed-providers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2311:\"<p>WordPress 5.5 will be dropping Hulu oEmbed support after Hulu silently disabled its oEmbed API. This is the API that allows users to copy and paste a link into the editor and have it automatically embed the content, as opposed to copying a chunk of embed code. Documentation contributors <a href=\"https://github.com/WordPress/gutenberg/issues/23920\">discovered that it wasn&rsquo;t working</a> while attempting to document the Hulu Embed block.</p>



<p>Birgit Pauli-Haack confirmed with Hulu that embedding is not currently an option. Hulu support did not elaborate on why it was removed.<a href=\"https://wptavern.com/wp-admin/edit.php?post_type=post\"></a></p>



<div class=\"wp-block-embed__wrapper\">
<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Apologies for any disappointment! This isn\'t an available option at the moment, but we\'ll express your interest. If there\'s anything else we can help out with down the road, please don\'t hesitate to reach back out!</p>&mdash; Hulu Support (@hulu_support) <a href=\"https://twitter.com/hulu_support/status/1283562756726300672?ref_src=twsrc%5Etfw\">July 16, 2020</a></blockquote>
</div>



<p>The block currently displays an error when attempting to embed a Hulu link, stating &ldquo;Sorry, this content could not be embedded.&rdquo; As a result, WordPress contributors have <a href=\"https://core.trac.wordpress.org/changeset/48512\">removed</a> both the block from the editor and the provider from core. </p>



<p>WordPress has included Hulu <a href=\"https://wordpress.org/support/article/embeds/#okay-so-what-sites-can-i-embed-from\">oEmbed support</a> for the past 11 years, since it was first added in <a href=\"https://wordpress.org/support/wordpress-version/version-2-9/\">WordPress 2.9</a> (December 2009). Services are <a href=\"https://wordpress.org/support/article/embeds/#okay-so-what-sites-can-i-embed-from\">logged</a> on WordPress.org as they are added or removed. Hulu was removed as soon as it was discovered that oEmbed support no longer worked, similar to other <a href=\"https://core.trac.wordpress.org/ticket/45399\">previously unsupported providers</a> &ndash; most recently FunnyOrDie and Photobucket. This is a major loss of convenience for users who are trying to embed Hulu links but it lies outside of WordPress&rsquo; control. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Jul 2020 22:48:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: Theme Authors Can Pass Data to Template Files in WordPress 5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=102136\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:189:\"https://wptavern.com/theme-authors-can-pass-data-to-template-files-in-wordpress-5-5?utm_source=rss&utm_medium=rss&utm_campaign=theme-authors-can-pass-data-to-template-files-in-wordpress-5-5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4777:\"<p class=\"has-drop-cap\">Theme developers can finally rejoice. For the first time, it is now possible to pass data to templates via the various core template-loading functions. Enrico Sorcinelli <a href=\"https://make.wordpress.org/core/2020/07/17/passing-arguments-to-template-files-in-wordpress-5-5/\">announced the change</a> on the Make Core blog this past Friday.</p>



<p>The <a href=\"https://core.trac.wordpress.org/ticket/21676\">feature was originally proposed</a> by Scott Kingsley Clark in 2012. Over the years, the ticket has received a dozen patches. It has survived a closure and arguments over why the feature should not go into core. Sorcinelli was a primary driver that kept the ticket alive for the last few years.</p>



<p>WordPress developers have been cleaning up some old-but-useful feature requests for the 5.5 release cycle. A couple of weeks ago, an 11-year-old ticket to allow users to <a href=\"https://wptavern.com/after-11-years-users-will-be-able-to-update-themes-and-plugins-via-a-zip-file\">update themes and plugins via a ZIP file</a> made the cut. Core developers even closed a 9-year-old ticket related to an <a href=\"https://core.trac.wordpress.org/ticket/17232\">Internet Explorer 6 hack</a> &mdash; <em>progress</em>. However, for theme authors, one of the most important additions is control over passing data from one template to another.</p>



<p>Typically, in PHP, variables can be passed from file to file because they remain in the same scope. However, that is not the case if the inclusion of the file is taken out of that scope by including the file from inside of a function. The scope is then limited to the function. That is how the template system works in WordPress. This is not necessarily a bad thing. However, it has meant that theme developers have had no built-in method of passing data from one template to the next.</p>



<p>Imagine creating a variable in one template but needing to access that same variable in a sub-template. There is no shortage of methods to accomplish this, but many are inelegant.</p>



<p>&ldquo;For years, theme developers wishing to pass data to template files have had to use less than ideal workarounds,&rdquo; wrote Sorcinelli in the announcement. The worst solutions typically involved creating a global variable. Others created custom template-loading functions on top of WordPress&rsquo;s existing system. The problem with all methods, regardless of which was ideal, was that no standard existed. Each theme would need to build its own solution, and plugins that touched the front end would often have a competing solution.</p>



<p>All of the WordPress template-loading functions now support an additional parameter of <code>$args</code>, which allows theme authors to pass along an associative array of data to the loaded template. The functions that support this new parameter are:</p>



<ul><li><code>get_header()</code></li><li><code>get_footer()</code></li><li><code>get_sidebar()</code></li><li><code>get_template_part()</code></li><li><code>locate_template()</code></li><li><code>load_template()</code></li></ul>



<p>Any hooks associated with the functions also pass along the data.</p>



<p>The <code>get_search_form()</code> function has supported a similar parameter since WordPress 5.2. In practice, it should work mostly the same, but the function has a couple of default values it sets.</p>



<p>An additional benefit of having a standard method of passing data to templates is that the feature can be built upon in the future. For example, WordPress could eventually offer a hook for filtering the data, which could come in handy with child themes.</p>



<p>The WordPress template system still lacks the robustness of more modern frameworks, but this simple change will allow for a variety of applications.</p>



<p>One question remains: <em>is the arrival of this feature too late?</em> With WordPress on track to revamp the entire theme system to integrate with the upcoming full-site editing feature, will this feature be useful for only the next few months?</p>



<p>Even if most theme developers don&rsquo;t immediately jump on board the block-based themes bandwagon for another year, the feature could come in handy  until they do. Perhaps it will also have some usefulness beyond the current theming paradigm.</p>



<p>Developers still do not have a clear picture of what theming with blocks will look like in the next few years. There may be situations where passing dynamic data is still necessary in the next system. Even if not, it will likely be a long while before there is mass adoption of block-based themes from the existing theme development community. In the meantime, many will be able to drop in-house solutions and use standard functions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Jul 2020 19:44:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Matt: Corner Office Interview\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=51861\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://ma.tt/2020/07/corner-office-interview/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2488:\"<p>If you pick up a print edition of the Sunday New York Times today you&#8217;ll see <a href=\"https://www.nytimes.com/2020/07/12/business/matt-mullenweg-automattic-corner-office.html\">the Corner Office interview with David Gelles in the business section</a>. </p>



<img />(Hat tip to <a href=\"http://www.maryconrad.org/\">Mary Conrad</a> for the picture, I haven&#8217;t seen it in person yet.)



<p>A quote that seems to be resonating with people,</p>



<blockquote class=\"wp-block-quote\"><p>This column is called Corner Office, and most people who choose to have offices are usually the bosses. And I’ve been to the offices of billionaire C.E.O.s that have their own private bathroom, beautiful art and couches. But these are all things that you can have in your house. What I love about distributed organizations is every single employee can have a corner office.</p></blockquote>



<p>Sometimes my corner office has been the corner of an airport floor next to a power outlet! I&#8217;ve also heard from colleagues that feel like their office feels like an unsupervised day care center since the quarantine started. The point I want to make is there&#8217;s a world of possibility that opens up when you move from the finite space of a shared office, and all the politics of dividing up the scarce resource of desirable space, to the <a href=\"https://www.amazon.com/Finite-Infinite-Games-James-Carse/dp/1476731713\">infinite game</a> where people can define their own &#8220;office&#8221; as the place where they will be most productive, and do so however they like with no penalties or restraints.</p>



<p>If you had the best space in the legacy office, you probably liked it and may even have had motivated reasoning around ineffable things that happened in the office like &#8220;culture&#8221; that would be impossible without it, but the average experience of an entry-level worker was not as positive. Now there can be a much more even playing field. At <a href=\"https://automattic.com/\">Automattic</a> we have a home office allowance people can use to buy equipment they need to make their home work area comfortable and productive, and it&#8217;s the same if you&#8217;re leading a team of hundreds or if it&#8217;s your first job.</p>



<p>If you&#8217;d like to hear the entire conversation <a href=\"https://www.youtube.com/watch?v=fFg6YcBB2uI&feature=youtu.be\">they&#8217;ve posted the original audio and interview</a> that was distilled into the print version.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 19 Jul 2020 21:13:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: All in One SEO Pack Plugin Patches XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=102036\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:169:\"https://wptavern.com/all-in-one-seo-pack-plugin-patches-xss-vulnerability?utm_source=rss&utm_medium=rss&utm_campaign=all-in-one-seo-pack-plugin-patches-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1843:\"<p><a href=\"https://wordpress.org/plugins/all-in-one-seo-pack\">All in One SEO Pack</a> patched an XSS vulnerability this week that was <a href=\"https://www.wordfence.com/blog/2020/07/2-million-users-affected-by-vulnerability-in-all-in-one-seo-pack/\">discovered</a> by the security researchers at Wordfence on July 10. The popular plugin has more than 2 million active installs, according to WordPress.org.</p>



<p>Wordfence researchers categorized it as &ldquo;a medium severity security issue&rdquo; that could result in &ldquo;a complete site takeover and other severe consequences:&rdquo;</p>



<blockquote class=\"wp-block-quote\"><p>This flaw allowed authenticated users with contributor level access or above the ability to inject malicious scripts that would be executed if a victim accessed the wp-admin panel&rsquo;s &lsquo;all posts&rsquo; page.</p></blockquote>



<p>Version 3.6.2, released on July 15, 2020, includes the following update in the changelog: &ldquo;Improved the output of SEO meta fields + added additional sanitization for security hardening.&rdquo;</p>



<p>All in One SEO Pack users are strongly recommended to update to the latest version. At the time of publishing, just 12% of the plugin&rsquo;s user base is running versions 3.6.x, which includes the three most recent versions. This leaves more than 1.7 million installations (88% of the plugin&rsquo;s users) vulnerable. </p>



<p>Many users don&rsquo;t log into their WordPress sites often enough to learn about security updates in a timely fashion. Plugin authors often don&rsquo;t advertise the importance of the update on their websites or social media. This is the type of situation that WordPress 5.5 should help to mitigate, as it introduces admin controls in the dashboard that allow users to enable automatic updates for themes and plugins. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jul 2020 21:48:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WPTavern: WPCampus Online 2020 Conference Features Accessibility and Higher Education Topics, July 29-30\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=102003\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:251:\"https://wptavern.com/wpcampus-online-2020-conference-features-accessibility-and-higher-education-topics-july-29-30?utm_source=rss&utm_medium=rss&utm_campaign=wpcampus-online-2020-conference-features-accessibility-and-higher-education-topics-july-29-30\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4948:\"<p><a href=\"https://www.wpcampus.org/\">WPCampus</a>, a community focused on WordPress and higher education, will host its 5th annual in-person conference as a free, <a href=\"https://2020.wpcampus.org/\">online event</a> this year.  The two-day event will feature sessions, lightning talks, sponsor demonstrations, and trivia, July 29-30, 2020. </p>



<p>Although the WPCampus community is no stranger to hosting online events (they usually host a virtual conference in January), current events have forced educational institutions to rely more heavily on those who maintain their digital infrastructure. Many WPCampus members fall into this category and are operating under a great deal more stress as compared to previous years. The community has more than 1,116 members representing 688 institutions.</p>



<p>&ldquo;In higher ed, &lsquo;wearer of many hats&rsquo; is a common saying,&rdquo; WPCampus director Rachel Cherry said. &ldquo;Per usual, most who work in our space are already going above and beyond to cover numerous job roles. For example, I was always a team of one: I designed the site, programmed the site, performed QA, and managed content editors. With the pandemic forcing many universities to increase their online presence, higher ed web professionals are busier than ever, working to help with the transition while bearing the stress of lowered budgets, working from home, and whether or not their physical campus will open for the fall semester.&rdquo; </p>



<p>As many institutions are moving to make their courses available online, Cherry said ensuring that vital resources are accessible has become even more critical.</p>



<p>&ldquo;The pandemic forced a vast majority of our society&rsquo;s processes and interactions to go online, and it&rsquo;s shining a spotlight on how inaccessible a lot of our systems are,&rdquo; she said. &ldquo;For example, online event platforms became a necessity for conferences. But the vast majority of these platforms are inaccessible. Crowdcast, for instance, is nearly impossible to use if you can&rsquo;t use a mouse. Using inaccessible online platforms for your event is no different from denying attendee access at the door because the building doesn&rsquo;t have a wheelchair ramp.&rdquo;</p>



<p><a href=\"https://2020.wpcampus.org/\">WPCampus Online 2020</a> will include a selection of sessions from accessibility experts on topics such as justifying the budget for accessibility initiatives, accessibility for non-developers, Gutenberg accessibility, end-to-end accessibility testing, and mobile site and native app accessibility testing guidelines. If you are looking to deepen your knowledge of accessibility, this conference features more sessions on this topic than most WordCamps.</p>



<p>The event&rsquo;s <a href=\"https://2020.wpcampus.org/speakers/\">schedule</a> also includes other topics of interest to those in higher education with sessions on managing multiple WordPress sites, building a self-publishing platform, extending the WP REST API, automation tools, data visualization for WordPress, and improving website performance.</p>



<p>In lieu of giving away swag for the event, WPCampus is coordinating a fundraising effort for the Black Lives Matter movement and those struggling with COVID-19. The organization will <a href=\"https://2020.wpcampus.org/donate/\">match donations</a> to the following organizations: </p>



<ul id=\"input_10_4\"><li>Black Lives Matter</li><li>The American Civil Liberties Union (ACLU)</li><li>NAACP Legal Defense Fund</li><li>Black Girls Code</li><li>Feeding America</li></ul>



<p>Cherry reports that more than 350 people have registered so far and she anticipates 500-600 attendees online this year. WPCampus will stream the session videos on YouTube and they will be recorded and available after the event. <a href=\"https://2020.wpcampus.org/register/\">Registration</a> is free, thanks the the event&rsquo;s sponsors, which include many WordPress agencies, hosts, and contributing individuals.</p>



<p>Despite the disappointment at not being able to meet in-person in New Orleans this year, Cherry said she is grateful for the &ldquo;more in-depth than usual&rdquo; time the community will have to spend together during the virtual conference. WPCampus members have found camaraderie and encouragement in their community by sharing stories and asking each other for help during this profoundly challenging time. </p>



<p>&ldquo;We&rsquo;ve become a family,&rdquo; Cherry said. &ldquo;And not just with higher ed and other web professionals, but with the vendors that support us and want to invest in our growth. Because of our events and community, we were able to sponsor the Gutenberg accessibility audit and play a huge role in improving the accessibility of the WordPress platform. I am incredibly proud of the ever-increasing focus, education, and advocacy our community has placed on accessibility.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jul 2020 20:44:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Should WordPress Themes Add a Top-Level Admin Menu Item?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101807\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:175:\"https://wptavern.com/should-wordpress-themes-add-a-top-level-admin-menu-item?utm_source=rss&utm_medium=rss&utm_campaign=should-wordpress-themes-add-a-top-level-admin-menu-item\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7349:\"<p class=\"has-drop-cap\">WordPress has almost always provided a top-level admin menu item for themes. It is clearly labeled &ldquo;Appearance.&rdquo; It is the single location that all WordPress users know to visit to modify any appearance-related things for their WordPress site. However, there is a movement within the Themes Team to allow themes to <a href=\"https://make.wordpress.org/themes/2020/07/13/proposal-allow-themes-to-add-a-top-level-admin-menu/\">place an additional top-level menu link</a> in the admin. The big question: <em>should this idea move forward?</em></p>



<p>When the Themes Team (originally called the Theme Review Team) was formed, its members created a set of guidelines that would be shaped and reshaped over the years. They were a set of living guidelines that could always be changed with the times.</p>



<p>One of the oldest guidelines required that themes must place any custom admin pages under the Appearance menu item. It made sense. WordPress provided a standard location for any theme-related pages. The custom header and background features lived under Appearance. Widgets, also defined by the current theme, were housed as a sub-page. Eventually, WordPress&rsquo;s custom nav menu system came along and was &mdash; you guessed it &mdash; situated under Appearance. The core developers even put the customizer link in the same place.</p>



<p>For over a decade, there was a well-defined standard. Sure, commercial themes outside of the official directory would sometimes break the mold. However, themes from the directory followed the pattern.</p>



<p>Now, the Themes Team is proposing that themes should be able to break from tradition.</p>



<p>The discussion arose after a question of whether themes should be able to add a custom panel to the block editor sidebar, which is not allowed.</p>



<p>&ldquo;To keep the editor free from clutter, advertising and upsell, with the customizer being used less, and no dashboard widgets being allowed, can we give theme authors a better place to include their information, and limit upsell to that area?&rdquo; wrote Carolina Nymark in <a href=\"https://make.wordpress.org/themes/2020/07/10/meeting-notes-tuesday-7th-of-july-2020/\">last week&rsquo;s team meeting notes</a>.</p>



<p>The proposal seems to settle on the idea that themes will lose visibility as WordPress moves toward full-site editing and the customizer becomes less important. The customizer is not an ideal place for anything but theme options, but that notion seems to have been overlooked in the discussion. Nevertheless, the original guideline that disallowed themes from creating top-level menu items preceded the advent of the customizer by several years. Advertising, documentation, plugin recommendations, and similar pages were always allowed under the existing Appearance menu. The usefulness of the customizer was never a necessary part of that conversation.</p>



<p>Ultimately, the question should be about what is best for users. There is no data to support making the change or sticking with the status quo. However, we do have a standard that has existed for years.</p>



<h2>The Proposed Guidelines</h2>



<p class=\"has-drop-cap\">The proposal would create several new guidelines for theme authors to follow and reviewers to check, assuming the theme created a top-level admin menu item:</p>



<ul><li>No admin menu priority may be used.</li><li>No UI or color changes are allowed for the menu item.</li><li>The title must be kept short and not include spam.</li><li>No more than three sub-pages.</li><li>Child themes are limited to one sub-page or can remove the parent&rsquo;s pages and add its own.</li></ul>



<p>Some of these make sense and follow along with existing guidelines, such as not spamming or changing the admin UI. However, others could be problematic.</p>



<p>If moving forward with the proposal, setting a menu item priority should be required rather than not allowed. If anything, it would make sense to require a specific priority to place the custom menu item immediately after the existing Appearance item. This would at least group them together by default. If changing the place where users are accustomed to seeing theme-related pages, it is probably best not to break too far from the standard location.</p>



<p><em>No more than three sub-pages?</em> Surely there will be a theme with a top-level admin menu item that needs four sub-pages at some point. If giving theme authors the freedom to take up valuable real estate in the admin, a limit of three sub-pages seems like a rule to fix the mistake of allowing the top-level item in the first place. It is an arbitrary number at best. There would be no reason to cap it once making the guideline change. It also adds one more item that the team will need to police.</p>



<p>The limitation of sub-pages for child themes seems just as arbitrary.  No such limitation exists when placing sub-pages under the standard Appearance screen.</p>



<p>The entire proposal is little more than extra work on a team that is already strained for resources.</p>



<p>Instead of the simple rule that has existed for years, the proposal adds a new rule with several sub-rules. If the team desires the extra work, I suppose this point doesn&rsquo;t matter.</p>



<h2>The Elephant in the Room</h2>



<p class=\"has-drop-cap\">There is one aspect of this discussion that everyone knows about but few are willing to broach. Underneath all the guidelines from the Themes Team and whether most theme authors support a particular decision is how this affects the financial bottom line. When we talk about <em>visibility</em> of a theme&rsquo;s admin pages, we are primarily talking about providing another avenue for commercial upsells.</p>



<p>Some of this discussion on visibility is shrouded in concepts such as surfacing end-user documentation or adding a visible <em>readme</em> for the user&rsquo;s benefit. These are legitimate concerns, especially when theme developers have watched <a href=\"https://meta.trac.wordpress.org/ticket/215\">tickets to address such downfalls</a> seemingly dwindle into obscurity over the years. Whether a top-level admin menu item makes sense for exposing theme documentation might be worth discussing, but there is no world in which this would be the primary use case.</p>



<p>The topic of visibility rests on the idea of upselling the pro version of the theme, add-ons, or other services.</p>



<p>Far too many plugins already go overboard, creating a billboard of the WordPress admin. One of the things users could almost be assured of is that themes from the official directory were constrained enough that they were not the hot mess that plugins have become as of late. However, that could all change.</p>



<p>Do we really want an extra top-level admin menu item that will be, for all intents and purposes, to advertise?</p>



<p>Maybe it doesn&rsquo;t matter in the end. Users are so accustomed to the clutter produced by the dozens of plugins on their sites. One more may not matter at this point.</p>



<p>Or, should we be having a different conversation altogether? If this ultimately boils down to advertising, are there ways we can open this up for theme authors while still creating a user experience that keeps the WordPress admin free of clutter?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Jul 2020 20:03:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Astra Becomes the Only Non-Default WordPress Theme With 1 Million Installs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101924\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:213:\"https://wptavern.com/astra-becomes-the-only-non-default-wordpress-theme-with-1-million-installs?utm_source=rss&utm_medium=rss&utm_campaign=astra-becomes-the-only-non-default-wordpress-theme-with-1-million-installs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5336:\"<p class=\"has-drop-cap\">On Tuesday, Brainstorm Force announced its Astra theme <a href=\"https://wpastra.com/one-million-active-installs/\">passed 1 million active installations</a>. It is the only non-default theme in the official WordPress theme directory to reach such a height.</p>



<p>Popularity breeds popularity. Once the theme broke 50,000 installs in January 2019, it was a quick hop and skip to 500,000 in October and 1 million less than a year later. With the winds of momentum at its back, the theme may become an unstoppable force. It is anyone&rsquo;s guess when growth will begin to plateau.</p>



<p>&ldquo;We recognize that this is not an ordinary feat,&rdquo; wrote Sujay Pawar in the announcement post. He said the team has no plans of resting at this point. &ldquo;1 million is just a milestone in our journey.&rdquo;</p>



<p>Many WordPress plugins have long ago passed the million-install milestone. Several have multi-millions. However, this is a much tougher feat for themes. One of the limiting factors is that users can only activate one of them at a time. There is no limit when it comes to plugins, and users often have dozens running at once. One million active installs is a level of popularity that is almost unheard of in the theming world.</p>



<p>&ldquo;There is a huge gap between Astra and all others,&rdquo; said William Patton, a WordPress Themes Team representative. &ldquo;Hitting 1 million is pretty astounding honestly.&rdquo;</p>



<p>This is not simply a major milestone for the Astra theme. It is huge for WordPress. For a third-party theme creator to reach a number that only the default themes can boast is the sort of thing we should all rejoice in a bit. It is a testament to how much WordPress has grown over the years.</p>



<p>Aside from the default themes that ship with WordPress, there are currently five themes with more than 100,000 active installs:</p>



<ul><li><a href=\"https://wordpress.org/themes/astra/\">Astra</a> &ndash; 1 million</li><li><a href=\"https://wordpress.org/themes/oceanwp/\">OceanWP</a> &ndash; 600,000</li><li><a href=\"https://wordpress.org/themes/generatepress/\">GeneratePress</a> &ndash; 300,000</li><li><a href=\"https://wordpress.org/themes/hello-elementor/\">Hello Elementor</a> &ndash; 300,000</li><li><a href=\"https://wordpress.org/themes/storefront/\">Storefront</a> &ndash; 200,000</li></ul>



<p>Once that first theme passes the 1 million mark, it is only a matter of time before others start breaking the barrier. OceanWP has the shortest striking distance and could be next. However, Hello Elementor is moving fast and earned its install count in a year and a half.</p>



<p>Regardless of the next theme to hit the milestone, this is one of those moments we should look back on in a few years to see how far we have come. Perhaps 1 million active installs will merely be a stepping stone to even greater heights for large numbers of themes.</p>



<h2>What Makes Astra Special?</h2>



<img />



<p class=\"has-drop-cap\">The default Astra theme is not anything particularly revolutionary on the surface. Out of the box, users are given a nearly blank canvas. It seems little more than your run-of-the-mill WordPress theme that would not garner much attention. However, it has one of the easiest setup processes that I have ever experienced with any theme. At the click of a button, end-users can pick from a plethora of starter templates.</p>



<p>There are hundreds of starter templates for Elementor and Beaver Builder. The Brizy page builder gets a little love too. There is even a modest 20 starter templates for Gutenberg. The theme&rsquo;s block editor styling leaves a lot to be desired, but I would wager that Brainstorm Force is serving a primary audience of Elementor users. The team probably won&rsquo;t have a huge incentive to change that anytime soon. And, there is really no need to. Elementor <a href=\"https://elementor.com/blog/5-million-active-installs/\">passed 5 million active installs</a> in May and is showing no signs of slowing down. Smart theme development businesses are making sure they support the plugin. Elementor support is where the money is right now.</p>



<p>Astra&rsquo;s starter templates are not merely templates. The theme will install and activate plugins needed too.</p>



<p>Many of the templates are free, but some are available for purchase. The theme allows users to filter the search between free and &ldquo;agency&rdquo; templates, so there is no trickery going on as is often the case with similar themes from the directory. They clearly label any upsells in the admin. At a time when the WordPress Themes Team struggles with theme authors circumventing advertising guidelines, Astra seems to be hitting a sweet spot that is both user-friendly and within the directory rules.</p>



<p>While good marketing and business plans go a long way toward getting installation numbers up, you cannot keep those numbers without building a product that users will continue using. Its simple import process makes it an easy go-to choice for anyone who doesn&rsquo;t relish the idea of spending hours trying to make their site look like the demo.</p>



<p>The theme&rsquo;s users can probably best answer the question of Astra&rsquo;s popularity.  Brainstorm Force is clearly doing something right.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Jul 2020 19:38:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Blocksy Theme Adds New Charity Starter Site, Pro Version to Launch in 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101884\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"https://wptavern.com/blocksy-theme-adds-new-charity-starter-site-pro-version-to-launch-in-2020?utm_source=rss&utm_medium=rss&utm_campaign=blocksy-theme-adds-new-charity-starter-site-pro-version-to-launch-in-2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4087:\"<p><a href=\"https://wordpress.org/themes/blocksy/\">Blocksy</a> is one of the best free themes available for the block editor right now and is rapidly growing in popularity. CreativeThemes, the Romania-based company behind the theme, released an update to Blocksy this week, along with a new starter site for charities. </p>



<p>The concept of &ldquo;starter sites&rdquo; is an interesting new twist on &ldquo;starter templates,&rdquo; which essentially allow users to import the content from a demo. Theme makers for products like <a href=\"https://creativethemes.com/blocksy/\">Blocksy</a>, <a href=\"https://wpastra.com/\">Astra</a>, and <a href=\"https://github.com/godaddy-wordpress/go\">Go</a> use this approach to help users implement different types of websites by importing the content from a pre-built demo site. The demos use the same base theme but vary widely in how they are customized. </p>



<p>Blocksy&rsquo;s starter sites are a one-click XML demo import that automatically brings in the pages, images, and theme options. This puts all the blocks in the right place so the user needs only to customize the demo, instead of trying to find the right settings to match the demo.</p>



<p>The new <a href=\"https://demo.creativethemes.com/blocksy/charity/\">Charity starter site</a> is built with the <a href=\"https://wordpress.org/plugins/stackable-ultimate-gutenberg-blocks/\">Stackable</a> plugin&rsquo;s page builder blocks. It joins four other <a href=\"https://creativethemes.com/blocksy/starter-sites/\">free starter sites</a> designed specifically for blogs, apps, travel, and e-commerce. The design can be imported under the Blocksy menu in the WordPress admin.</p>



<div class=\"wp-block-image\"><img /></div>



<p>According to the theme&rsquo;s beautifully designed and user friendly <a href=\"https://creativethemes.com/blocksy/changelog/\">changelog</a>, Blocksy can now automatically detect Custom Post Types and add their appropriate options. The update also adds a sizing option for related posts thumbnails, a new Twitch social icon, and improves compatibility with WooCommerce product display and miscellaneous extensions.</p>



<h2>Blocksy Pro Version Coming Soon </h2>



<p>When we first <a href=\"https://wptavern.com/blocksy-wordpress-theme-provides-a-solid-block-editor-experience\">reviewed</a> the theme in January 2020, it had 1,000 active installs and 58 five-star reviews. Over the past six months, the theme&rsquo;s user base has grown to more than 4,000 active installs and a perfect five-star rating on WordPress.org from 191 reviewers. It is currently maintained by a team of two &ndash; Sergiu Radu and Andrei Glingeanu.</p>



<p>Blocksy&rsquo;s creators have been working on custom projects and random jobs to support the time they spend developing the theme but they plan to launch a pro version as early as this summer.</p>



<p>&ldquo;We plan to add more features in the premium version, more demos, and also offer better and faster support,&rdquo; Radu said. &ldquo;I hope after we release the premium version we will be able to take on a few more people in our team to help us, at least with support so we can concentrate better on development.&rdquo;</p>



<p>Radu said the pro version will include some premium starter sites as well as additional functionality for the base theme.  They are aiming to include the following features in the first release:</p>



<ul><li>Multiple conditional headers</li><li>Multiple conditional footers</li><li>Multiple conditional sidebars</li><li>More header elements</li><li>More footer elements</li><li>White labeling</li><li>Custom fonts extension</li><li>Adobe Typekit extension</li><li>Hooks (conditional)</li><li>Sticky header</li></ul>



<p>In a second round of updates for the pro version, Blocksy creators plan to include features like custom color palettes, AMP, LearnDash, and EDD integrations, along with extensions for ads, mega menus, and portfolios. In the meantime, Radu says they do not plan to add more features to the free version &ndash; only improvements and new starter sites. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jul 2020 22:32:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: Eye-Catching Typography and Personality: Blossom Themes Launches Sarada Lite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101933\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:215:\"https://wptavern.com/eye-catching-typography-and-personality-blossom-themes-launches-sarada-lite?utm_source=rss&utm_medium=rss&utm_campaign=eye-catching-typography-and-personality-blossom-themes-launches-sarada-lite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6064:\"<img />Sarada Lite homepage.



<p class=\"has-drop-cap\">Blossom Themes launched <a href=\"https://wordpress.org/themes/sarada-lite/\">Sarada Lite</a>, its 25th theme, on the WordPress theme directory today. The theme is billed as a &ldquo;feminine blog theme&rdquo; specifically for professional bloggers. However, it would work well in a variety of contexts. While it is targeted at fashion, travel, and lifestyle bloggers, it is well-rounded enough for anyone who wants a touch of personality as part of their blogging experience.</p>



<p>I nearly passed over this theme. It had no mention of the block editor or Gutenberg in its description. It was not tagged in the directory as having editor styles (technically, it doesn&rsquo;t have them). There are few themes that I give much attention to if they do not style the latest features and blocks in WordPress. It has to be truly eye-catching otherwise. Sarada Lite is a breathtaking design, so it drew me in. It is the sort of theme that inspires me to write. Plus, its light color scheme along with the author&rsquo;s choice of images in the demo fit perfectly into the summer season. It simply makes me want to sit on the beach with a mojito and my laptop ready to spin up some great content.</p>



<p>What makes this theme stand out is its typography. The status quo with most free themes in the WordPress theme directory is to simply not give any attention to things like font size, characters per line, line height, or vertical rhythm. Long-form content is practically unreadable with such themes. However, long-winded writers need not be fearful of the reader losing interest because of the design. Sarada Lite creates an inviting atmosphere that beckons the visitor to actually read.</p>



<p>The theme supports several plugins, most of which are a part of the Blossom Themes collection. They are unnecessary for a solid blogging experience with this theme. Users should shy away from taking advantage of every bell and whistle the theme or its add-ons provide. The default setup is mostly where the theme shines.</p>



<p>Users who need a shop can also enjoy WooCommerce integration. The theme does not add much in the way of shop-related features, opting to style the default output of the eCommerce plugin instead.</p>



<h2>Design Elements Worth Noting</h2>



<img />Single post view.



<p class=\"has-drop-cap\">When testing and reviewing themes, it is often easy to get lost in the features. However, with Sarada Lite, it&rsquo;s not the theme features that are important. They may even be a detriment to the theme (more on that later). The thing that makes this theme special is the small design elements. The author puts a unique spin on things that give the theme a personality of its own. Designers who want to show off their design chops often go overboard, but Sarada Lite has just enough flair to draw attention to important elements without getting in the way of the content.</p>



<p>In particular, the theme&rsquo;s use of the <a href=\"https://fonts.google.com/specimen/Caveat\">Caveat font</a> gives secondary text just the right amount of pop. It is not a font that lends itself well to long-form content. However, the theme makes use of it for links, captions, quote citations, and a few other elements.</p>



<img />Sarada Lite&rsquo;s blockquote design.



<p>The theme offers various layouts with and without a sidebar. For single posts, I recommend dropping the sidebar and choosing the full-width centered layout to make full use of the block editor&rsquo;s capabilities. This gives enough breathing room for users who like to make liberal use of wide and full-width blocks. The theme has an option to change the layout globally and on a per-post basis.</p>



<h2>Issues</h2>



<p class=\"has-drop-cap\">One of the biggest issues with Sarada Lite is that users do not get a one-to-one match between the editor and the front end. The missing piece is the theme&rsquo;s beautiful typography. It is nowhere to be found while writing a post. The theme&rsquo;s admin-side CSS is bare-bones to the point where there is little use in loading the stylesheet. I hope this is merely something the theme author skipped for version 1.0 with a firm plan to add it in the next release. At worst, it is an extra couple of hours of work that offers a huge benefit to theme users.</p>



<p>The other major downside of Sarada Lite is that it tries to do too much. Its customizer options feel a bit overboard and disorganized. In too many cases, I was left wondering what a particular option was for or searching around for specific options in odd places.</p>



<p>I also found the Instagram feed (available via the Blossom Themes Social Feed add-on) in the header to be a horrendous addition, ruining what is an otherwise open and inviting design. Fortunately, this is an optional feature. Once again, the theme is doing too much here. I understand it is a bullet point on the ol&rsquo; marketing sheet, but it is an eyesore in practice. The Instagram feed works much better in the footer. My advice for theme users: avoid putting this in your header at all costs. Your site visitors should not need to skip over social media images just to get to your content.</p>



<p>As gracefully as the various sliders on the theme&rsquo;s homepage are done, I am now and always anti-slider. They offer no real benefit to the reader and often hide away content that would have otherwise been seen. The theme&rsquo;s slider sections, some of which are optional, are relatively low-key. I have seen far worse, but I would rather not see them at all.</p>



<p>Despite the theme&rsquo;s issues, they are not so detrimental that I wouldn&rsquo;t recommend the theme. Assuming the theme author adds in editor styles that match the front end, the other issues can mostly be avoided by user choice. The theme works well without tinkering with its options and adding extra plugins.</p>



<p>Sarada Lite is best without all the extras. What the user does with the theme will make or break the experience.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jul 2020 20:56:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"HeroPress: Second Chances: How A Trip Back  Into The WordPress Community Saved My Life\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=3229\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:220:\"https://heropress.com/essays/second-chances-how-a-trip-back-into-the-wordpress-community-saved-my-life/#utm_source=rss&utm_medium=rss&utm_campaign=second-chances-how-a-trip-back-into-the-wordpress-community-saved-my-life\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7043:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2021/07/071320-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: The energies received in return for giving back to the WordPress community healed me emotionally, allowing me to contribute creatively.\" /><p>Often, we refuse change and don&#8217;t get a second opportunity to make things right. But for me, June 17, 2017, changed my life forever. A life-threatening heart event forced me to start over and in the short time since WordPress helped me rediscover myself and to do the things I truly love.</p>
<p>At 10 am that morning, I was laid out flat on a cold, hard operating table being poked, prodded, and prepped for a surgical procedure. According to my doctors, this procedure was the only sure way to find out what had been plaguing me for five long years. Within the next sixty minutes, if things go sideways, I could be dead.</p>
<p>As I slowly came to, words floated through a lifting fog of anesthesia. &#8220;You had two 100% blocked arteries,&#8221; my cardiologist said. A flood of concern and questions seemed to flow freely foremost, &#8220;what will happen to me?&#8221;</p>
<h3>Two Paths Lead to WordPress</h3>
<p>Looking back, my WordPress journey has two paths, pre- or post-heart event. When the lead developer and CSS goddess left our public transit agency almost 10 years ago, they left behind a company news blog with the Headway theme. That year we were fortunate to have room in our budget allowing me to attend the WordPress VIP Intensive Developer Workshop in Napa.</p>
<p>At that time my experience was entirely in basic static HTML as a web designer so imagine how lost and out of place I felt being asked to &#8220;spin up a virtual box&#8221; midway through the first day. Surrounded by the best and the brightest distributed Automatticians from around the world, person after person answered my questions or assisted in any way they could. That day I learned what the phrase WordCamp Community really meant.</p>
<h3>Leaving the Past Behind</h3>
<p>What if you got a do-over? A mulligan, a reset button? Imagine being totally free from the stressors of the daily grind, similar to being a young child, with nothing to do but play all day.</p>
<p>Staring at the ceiling from my bed while recovering, I decided to stop the world and get off. I took a leave of absence from work beginning September 11. Looking deep within, I searched to rediscover me and the loves of my life &#8211; giving selflessly to others, picking up a pencil to sketch, storytelling, and WORDPRESS.</p>
<p>Every day for the next ninety days, I resolved to do only the things reconnected me with things dormant in my past that brought me joy:</p>
<ul>
<li>Each morning I&#8217;d pick up a pencil, sketch;</li>
<li>I&#8217;d exercise and practice mindfulness; and</li>
<li>No day would be complete without giving back, doing something with WordPress for others. Like an Agile process, I&#8217;d loop through these tasks, reassess, then repeat, each morning becoming stronger than the previous.</li>
</ul>
<p>Slowly, progress was being made in my recovery. From feeling faint and unable to walk from my bedside to my bathroom; 100 steps turned into 100 yards then one lap at my local park. I set a goal to climb to one of the highest points in our area, the top of Central Park.</p>
<h3>The Journey of 4,890 Miles Begins with One Step</h3>
<p>My second path into WordPress started later that summer. Untethered, I walked into my first-ever official WordPress Meetup in a coworking space located downtown Los Angeles, apprehensive, unsure what to expect. That evening a wonderful speaker on SEO followed the organizers from WordCamp Los Angeles calling for volunteers and I immediately raised my hand. The old me would not have.</p>
<p>From that point through December, I attended almost twenty (20) WordPress Meetups, attended four WordCamps (Grand Rapids, Los Angeles, Riverside, and United States via Livestream) logging almost 5,000 miles in the process. Rebuilding a website for a printing company pro bono while rehabilitating my heart and body. The energies received in return for giving back to the WordPress Community healed me emotionally, allowing me to contribute creatively &#8212; I loved it and wanted to do even more!</p>
<h3>Making a List, Checking It Twice</h3>
<p>Tired of driving home very late nights from area Meetups from all points around SoCal, I decided to start a meetup locally. On January 26, 2018, at 7:30 pm, I reached the last slide of my first presentation at our official WordPress Santa Clarita Valley Meetup. It read, &#8220;host the first annual WordCamp Santa Clarita&#8221;.</p>
<p>The faces in the audience &#8211; Tom, Steve, Matt, and others new to WordPress all looked at me skeptically, seeing someone full of dreams, spouting enthusiasm. But one thing was clear to me &#8212; WordPress had given me a shot at reclaiming something laid dormant and anything seemed possible.</p>
<p>Sixteen (16) months later, the first WordCamp north of Los Angeles and south of Sacramento since 2014 debuted in Santa Clarita. A small, but an incredible team of volunteers bought into my enthusiasm turned around and gave back to our attendees in our WordPress Community.</p>
<h3>Speak On It</h3>
<p>In my pre-heart event life, I began public speaking in a formal setting completing over 40 presentations but had stepped off the stage years earlier in a company club. Back in 2014 while walking through the break room at WordCamp Los Angeles one of the lead organizers handed me a mic and asked me to speak. Afterward, he said, &#8220;you should present at a WordCamp.&#8221;</p>
<p>Four years later, I stood on stage at WordCamp Chicago sharing my WordPress journey and hoping to inspire others to never give up on going after your dreams. Until that weekend in Chicago, I hadn&#8217;t seen any African-American men onstage and felt it important to encourage diversity through my message of rebirth.</p>
<blockquote><p><i>&#8220;Live as if you were to die tomorrow. Learn as if you were to live forever.&#8221; </i></p>
<p><i>Mahatma Gandhi</i></p></blockquote>
<p>I&#8217;ve met the most incredible group of nurturing, giving, and talented people stretching back to Sara (Rosso) in Napa through Angela (Jin) or David (Bisset) on the WordCamp US team. Every time I needed confidence or a word of encouragement Cami (Kaos), Kathy (Drewien), Brandon (Dove), or someone in the Community was that steadying hand on my shoulder.</p>
<p>I think about these words often as inspiration, waking each morning to greet the sunrise full of ideas and promise. How can I give back? What can I do with WordPress today?</p>
<p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/second-chances-how-a-trip-back-into-the-wordpress-community-saved-my-life/\">Second Chances: How A Trip Back  Into The WordPress Community Saved My Life</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jul 2020 11:00:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Joe Simpson Jr.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: WordCamp Europe Goes Virtual for 2021, In-Person Conference to Resume 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101866\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"https://wptavern.com/wordcamp-europe-goes-virtual-for-2021-in-person-conference-to-resume-2022?utm_source=rss&utm_medium=rss&utm_campaign=wordcamp-europe-goes-virtual-for-2021-in-person-conference-to-resume-2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7807:\"<p>While much of the world is currently suspended in the uncertainty caused by the pandemic, WordCamp Europe delivered a surprisingly decisive <a href=\"https://europe.wordcamp.org/2021/wordcamp-europe-2021-will-be-online/\">announcement</a> today regarding the status of the 2021 event in Porto. Organizers moved to make it a virtual conference, 10 months in advance of the planned dates, June 3-5, 2021:</p>



<blockquote class=\"wp-block-quote\"><p>After careful consideration, and following guidance from WordCamp Central, we have agreed to hold WCEU 2021 online.</p><p>Although it was a difficult decision, it also seems the right thing to do. Considering the continuing uncertainty regarding COVID-19, we are hesitant to draw so many individuals from so many different places into one physical space.</p><p>We understand that this decision will come as a disappointment to many. We know that this event is a much-needed social outlet for many in our community and that an online event isn&rsquo;t quite the same as a physical event. We&rsquo;re so sad to not be able to greet you all in person in Porto in June.</p></blockquote>



<p>The announcement cited several positive aspects of going virtual, including eliminating the uncertainty for attendees and their travel arrangements, allowing for a larger global audience without the expense and risk, and having more time for creating a better online experience. The 2020 event had just three months to convert to a virtual conference but was able to reach more than 8,000 attendees.</p>



<p>In the absence of a vaccine ready for mass distribution or any proven commercially available therapeutics specifically designed to target the virus, it is impossible for organizers to nail down a safe timeline for a multinational event in 2021. Hugh Lashbrooke, who is assisting the WCEU organizing team as a mentor from WordCamp Central, identified risk mitigation as one of the primary factors in their decision.</p>



<p>&ldquo;Attendee safety is a primary concern in WordCamp organizing,&rdquo; Lashbrooke said. &ldquo;While the pandemic is progressing differently in different regions of the world, it seems that large in-person events that bring together thousands of people from multiple countries in a single shared space are still a risky proposition &mdash; and it&rsquo;s not clear when this will be safe again.&rdquo; </p>



<p>WordCampers <a href=\"https://twitter.com/WCEurope/status/1283017418261049346\">reacting to the news</a> today seemed to understand the need for such a disruptive change, but most expressed deep disappointment. </p>



<p>&ldquo;I&rsquo;m sure the decision won&rsquo;t have been taken lightly,&rdquo; Simon Dickson said. &ldquo;But WCEU is so important in terms of defining and sustaining the European &ndash; and indeed, global &ndash; WordPress community. With all due respect to online alternatives, two blank years will hit community spirit hard.&rdquo;</p>



<p>The goal for WordCamp Europe is to resume the in-person event in 2022 and organizers have booked the Super Bock Arena (Pavilh&atilde;o Rosa Mota) for June 2 &ndash; June 4, 2022.&nbsp;</p>



<p>If WCEU can resume normal operations in 2022, it will be the first time in three years that the European WordPress community has had the opportunity to gather in-person in one place. One disappointed attendee <a href=\"https://twitter.com/7strel/status/1283102522270507008\">said</a>, &ldquo;Understandable. As we say in Portugal: &Agrave; terceira ser&aacute; de vez! At&eacute; 2022,&rdquo; which roughly translates to the English saying, &ldquo;Third time&rsquo;s a charm.&rdquo;</p>



<h2>WordPress Community Team Is Working Towards Facilitating More Effective Events</h2>



<p>Lashbrooke said adjusting to emerging world events has been hard on all WordCamp organizing teams this year, as well as sponsors, speakers, and attendees. WordCamp Asia was forced to cancel, WordCamp US has gone virtual, and many other smaller camps have gone online or been postponed. The WordPress Community team is <a href=\"https://make.wordpress.org/community/2020/07/13/reimagining-online-events/\">discussing how they can improve online events</a> to provide a better experience for the community. Some of the broader ideas for creating more effective events include the following:</p>



<ul><li>Decouple online events from geography</li><li>Encourage events and workshops defined by topics, languages, etc.</li><li>Explore shorter, &ldquo;snack-sized&rdquo; online events</li><li>Experiment with the frequency of events</li></ul>



<p>A peripheral <a href=\"https://twitter.com/learnwithmattc/status/1282723205728227330\">discussion</a> regarding sponsors is happening on Twitter, after recent online WordCamps failed to deliver a positive experience of virtual sponsor booths.</p>



<p>&ldquo;If you want to offer sponsors a &lsquo;Virtual Booth&rsquo; as a benefit of sponsorship, you&rsquo;re going to have to do something during the main event to make that attractive and easy for attendees to attend &mdash; otherwise it&rsquo;s not a sponsor benefit,&rdquo; Matt Cromwell said.</p>



<p>&ldquo;If attendees have to log off the regular WordCamp platform, then go find some other link to some other virtual platform the experience becomes arduous and full of friction for the attendee making it highly unlikely they&rsquo;ll attend. WordCamps that are switching to virtual should look into more robust platforms like <a href=\"https://hopin.to/\">Hopin</a> which allow for various rooms that are consolidated to the same platform for attendees.&rdquo;</p>



<p>WordCamp Europe 2020 organizer Bernhard Kau said his team looked into using Hopin but found it wasn&rsquo;t fully accessible.</p>



<p>&ldquo;Hopin looked promising at first, not only for sponsors, but also for networking between attendees,&rdquo; Kau said. &ldquo;But it lacks basic accessibility. It&rsquo;s unusable with keyboard only for example. I&rsquo;d love to see it improve, so we could use it in the future.&rdquo; </p>



<p>Lashbrooke said WordCamp Central has also considered Hopin, among other apps, while doing <a href=\"https://docs.google.com/spreadsheets/d/1ym0nuKxhnzyBmNAozSNdviCjmlTq3e2J95usFbpUQrY/edit#gid=0\">extensive research on accessible platforms</a>.</p>



<p>&ldquo;Right now, everyone&rsquo;s still working on a way to make that work for everyone, and we&rsquo;re lucky that our sponsors are so honest with us about their experiences, because it helps us improve,&rdquo; Lashbrooke said. </p>



<p>&ldquo;One thing that is of paramount importance to us as a team is that all WordPress events maintain a high level of accessibility, and unfortunately when it comes to streaming platforms we have very limited options when it comes to accessible streaming services. Zoom is about the only fully-accessible platform, so it&rsquo;s the only option to use for sponsor booths.&rdquo;</p>



<p>With ten months of lead time, WordCamp Europe organizers will have plenty of opportunities to experiment with new ideas to make the event more engaging for both attendees and sponsors. All the other WordCamps on the <a href=\"https://central.wordcamp.org/schedule/\">schedule</a> through the end of the year have already been converted to online events. For the time being, it looks like virtual camps are here to stay.</p>



<p>&ldquo;I really doubt we&rsquo;ll be abandoning online events, after COVID-19 is more under control worldwide,&rdquo; WordPress Community organizer Andrea Middleton <a href=\"https://make.wordpress.org/community/2020/07/13/reimagining-online-events/#comment-28388\">said</a>. &ldquo;I think that we&rsquo;ll need to figure out how in-person events and online events can best coexist, but it seems like we&rsquo;ll have time to figure that out.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Jul 2020 23:55:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Call for Block Plugins: The WordPress Block Directory Is Open for Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101853\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"https://wptavern.com/call-for-block-plugins-the-wordpress-block-directory-is-open-for-business?utm_source=rss&utm_medium=rss&utm_campaign=call-for-block-plugins-the-wordpress-block-directory-is-open-for-business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6029:\"<img />WordPress block directory.



<p class=\"has-drop-cap\">Over the weekend, Alex Shiels announced an open call for plugin authors to <a href=\"https://make.wordpress.org/plugins/2020/07/11/you-can-now-add-your-own-plugins-to-the-block-directory/\">begin submitting one-off block plugins</a> to the official <a href=\"https://wordpress.org/plugins/browse/block/\">block directory</a>. In the upcoming WordPress 5.5 update, slated for release on August 11, end-users will be able to search for, install, and add blocks directly from the editor. With little time left before release, will plugin authors make this a worthwhile feature for users?</p>



<p>&ldquo;The Block Directory is a subset of plugins in the plugin directory that can be instantly and seamlessly installed from the Gutenberg editor with a single click,&rdquo; wrote Shiels in the announcement. &ldquo;We call these new plugins &lsquo;block plugins&rsquo; and have worked hard to make it easier for people to contribute to this new feature coming to WordPress 5.5.&rdquo;</p>



<p>WordPress plugin authors now have a new <a href=\"https://wordpress.org/plugins/developers/block-plugin-validator/\">block validation tool</a> at their disposal. The validator can check an SVN repository URL, Github URL, or plugin slug to determine if it is suitable for inclusion into the WordPress block directory. It is still under development, so plugin authors should report any issues they run into.</p>



<p>For existing plugins in the plugin directory, developers can publish them to the block directory after passing validation with the tool. Plugin authors can also remove their plugins from the block directory at the click of the button.</p>



<p>The block plugin guidelines are still under development. The <a href=\"https://github.com/WordPress/wporg-plugin-guidelines/pull/68\">draft ticket</a> has been open since November 21, 2019. It has seen little activity in the months since. Presumably, there will be a finalized version on WordPress.org rather than GitHub before WordPress 5.5 lands.</p>



<p>Developers who want to begin building block plugins should follow the updated <a href=\"https://developer.wordpress.org/block-editor/tutorials/block-tutorial/\">block development tutorial</a>.</p>



<h2>A Late Rallying Cry</h2>



<p class=\"has-drop-cap\">Technically, plugin authors have been able to submit blocks to the directory for months. It was a bit of a hidden feature that few developers took advantage of. The user base was primarily Gutenberg plugin users who had enabled the experimental block directory search feature. Despite the small user base, it was an ideal time for plugin authors to begin experimenting and building an audience. It could have also been a great opportunity for relatively unknown developers to make their mark upon the WordPress world. There is still some time for that, but the community has not been actively encouraged to create blocks for the directory. With WordPress 5.5 looming ahead, the past few months seem like a missed opportunity.</p>



<p>Nick Hamze, one of the most prolific publishers of one-off blocks, is <a href=\"https://block.garden/taking-a-break/\">taking a break</a>. He originally had plans to release 99 plugins throughout 2020, but the WordPress plugin review team asked him to dial things back a bit. His routine releases were putting a strain on the team. The problem is that he was one of the few plugin authors <a href=\"https://wptavern.com/the-wacky-world-of-sorta-brilliants-sorta-fun-block-plugins\">putting in the work</a> to make the block directory a great thing.</p>



<p>As a former reviewer for the themes team, I understand how easy it is to get overwhelmed with a wave of new projects that need a code review. At the same time, I would be willing to bump Hamze&rsquo;s work to the front of the line, regardless of how often he was releasing new plugins. It may be a bit unfair to other plugin authors, but few others were betting big on what will be one of WordPress 5.5&rsquo;s highlights: a searchable block directory.</p>



<p>&ldquo;If someone would have just given me the barest encouragement I would have kept going, but due to my experience, I stopped submitting blocks and won&rsquo;t do it anymore in the future,&rdquo; said Hamze.</p>



<p>If no one else was putting in the work, there should have been no harm in giving him a bit of priority or a helping hand. That way, when WordPress 5.5 launches, there is something to show for this feature.</p>



<p>Now, we are in the 11th hour, mere weeks before 5.5&rsquo;s official release, with a meager offering of blocks &mdash; instead of hundreds of blocks, we are currently nearing the 60 mark. It is a last-minute rallying call to get plugin authors churning away before the final bell rings. Yet, WordPress just benched what was essentially its star player.</p>



<p>I have no doubt the block directory will continue to grow. More developers will buy into it, especially as full-site editing creates more possibilities in WordPress 5.6 later this year. Some authors will likely produce more blocks than the totality of the current number in the directory.</p>



<p>If the Gutenberg team had managed to squeeze the <a href=\"https://wptavern.com/version-1-prototype-of-the-wordpress-admin-block-directory-announced\">directory and management screens</a> into WordPress 5.5 admin, it would have made for a far bigger splash. It would have been good visibility for block makers. WordPress will support a block directory search for now. However, there is no way for end-users to more casually browse blocks via their admin. There is no way to see the latest block plugin releases or view the most popular blocks. Some of these things may have made one-off block development a bit more enticing to plugin authors. </p>



<p>I am still optimistic that more plugin authors will jump onto the block bandwagon. It will just be a while before we start seeing the wealth of blocks that cover the entire spectrum of what users need.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Jul 2020 20:09:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 5.5 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8681\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4508:\"<p id=\"block-000046ff-d8e6-40a8-9869-2dd39e50f270\"><br />WordPress 5.5 Beta 2 is now available!</p>



<p id=\"block-81bd56b9-ea44-43ad-ab36-a5ae78b54375\"><strong><strong>This software is still in development,</strong>&nbsp;</strong>so it’s not recommended to run this version on a production site. Consider setting up a test site to play with the new version.</p>



<p id=\"block-7cc1bbc6-17f9-44c5-8f67-da4e3059ad69\">You can test WordPress 5.5 beta 2 in two ways:</p>



<ul id=\"block-4840af57-f44b-4d9f-aa64-c6a452392e42\"><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option)</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.5-beta2.zip\">download the beta here</a>&nbsp;(zip).</li></ul>



<p id=\"block-a40528cb-eb3b-4c8a-8f5e-aa700f1ba086\">WordPress 5.5 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-5/\">August 11th, 2020</a>, and <strong>we need your help to get there</strong>!</p>



<p>Thank you to all of the contributors that tested the <a href=\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-1/\">beta 1</a> development release and provided feedback. Testing for bugs is an important part of polishing each release and a great way to contribute to WordPress. Here are some of the changes since beta 1 to pay close attention to while testing.</p>



<h2 id=\"block-15d6d57f-905d-4a47-9f66-839468a5375a\">Some highlights</h2>



<p id=\"block-85da84ec-c841-42f9-8d3b-1a4537a61d10\">Since <a href=\"https://wordpress.org/news/2020/02/wordpress-5-4-beta-1/\">beta 1</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=07%2F08%2F2020..07%2F14%2F2020&milestone=5.5&group=component&col=id&col=summary&col=owner&col=type&col=priority&col=component&col=version&order=priority\">48 bugs</a> have been fixed. Here is a summary of a few changes included in beta 2:</p>



<ul><li>19 additional bugs have been fixed in the block editor (see <a href=\"https://github.com/WordPress/gutenberg/pull/23903\">#23903</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/23905\">#23905</a>).</li><li>The Dashicons icon font has been updated (see <a href=\"https://core.trac.wordpress.org/ticket/49913\">#49913</a>).</li><li>Broken widgets stemming from changes in Beta 1 have been fixed (see <a href=\"https://core.trac.wordpress.org/ticket/50609\">#50609</a>).</li><li>Query handling when counting revisions has been improved (see <a href=\"https://core.trac.wordpress.org/ticket/34560\">#34560</a>).</li><li>An alternate, expanded view was added for <code>wp_list_table</code> (see <a href=\"https://core.trac.wordpress.org/ticket/49715\">#49715</a>).</li><li>Some adjustments were made to the handling of default terms for custom taxonomies (see <a href=\"https://core.trac.wordpress.org/ticket/43517\">#43517</a>)</li></ul>



<p>Several updates have been made to the block editor. For details, see <a href=\"https://github.com/WordPress/gutenberg/pull/23903\">#23903</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/23905\">#23905</a>.</p>



<h2 id=\"block-76156b2b-0a52-4502-b585-6cbe9481f55b\">Developer notes</h2>



<p id=\"block-3fe5e264-0a95-4f12-9a18-0cb9dc5955d1\">WordPress 5.5 has lots of refinements to polish the developer experience. To keep up, subscribe to the&nbsp;<a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>&nbsp;and pay special attention to the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5-5+dev-notes/\">developers’ notes</a>&nbsp;for updates on those and other changes that could affect your products.</p>



<h2 id=\"block-bc89fd56-47b0-439f-8e2c-4a642c80a616\">How to Help</h2>



<p id=\"block-3ff83a77-8b54-4061-ae2d-45fc984cbd76\">Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help us translate WordPress into more than 100 languages</a>!</p>



<p id=\"block-9d871099-ec49-446c-8322-9e49b7498c10\">If you think you’ve found a bug, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you!</p>



<p id=\"block-bd71c1d3-39d9-4b2a-8193-3486497b45fd\">If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>,&nbsp;where you can also find a list of&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Jul 2020 17:24:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Admin 2020 Reimagines WordPress Admin and Media Library\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101275\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:175:\"https://wptavern.com/admin-2020-reimagines-wordpress-admin-and-media-library?utm_source=rss&utm_medium=rss&utm_campaign=admin-2020-reimagines-wordpress-admin-and-media-library\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6102:\"<p>Unless I&rsquo;m trying to be aware of it, I don&rsquo;t see the WordPress admin anymore. When you work inside it every day, it becomes a means to an end, like a subway ride to work. You scan your ticket (log in) and you&rsquo;re on your way to whatever admin business is the order of the day. After awhile, you accept its appearance and no longer spend conscious thoughts critiquing it. </p>



<p>WordPress doesn&rsquo;t overhaul its admin design very often, since it requires a massive effort from contributors. The beauty of this pluggable system is that anyone with the skills can change the design to suit their own aesthetic. That is what WordPress developer Mark Ashton has done with <a href=\"https://admintwentytwenty.com/\">Admin 2020</a>, a plugin that completely reskins the admin to give it a different look.  </p>



<img />



<p>Browsing the Admin 2020 <a href=\"https://demo.ashtonretouch.com/wp-login.php\">demo</a>, you might not even know you were using WordPress. The design is built on top of <a href=\"https://getuikit.com/\">UIkit</a>, a lightweight UI framework that has a softer, rounder look to it. Users can switch between light and dark mode. Admin 2020 features white labeling, allowing users to upload their own logos and brand the dashboard for themselves. The admin area can also be radically simplified based on user role. The plugin allows for admin menu items to be renamed or toggled for visibility.</p>



<div class=\"wp-block-embed__wrapper\">
<a href=\"https://cloudup.com/c7uRS7QtvxU\"><img src=\"https://cldup.com/C4QGUuFG48.gif\" alt=\"Admin 2020 dashboard overview dark mode\" width=\"600\" height=\"336\" /></a>
</div>



<p>Admin 2020 has an Overview page that can sync with Google Analytics to show reports that can be filtered by date, including Users, Page Views, Sessions, and device breakdown. It also displays summaries of recent comments, popular pages, system info, new users, and other content-related data.</p>



<p>The plugin gives WordPress&rsquo; media library a new look, along with folders and filters for an alternative way to organize images. Ashton claims it is up to 50% faster than the classic WordPress media library. The gallery editor also adds filters, free draw, icons/shapes, text and other mask filters for enhancing images.</p>



<div class=\"wp-block-embed__wrapper\">
<a href=\"https://cloudup.com/cMJOcOz4-QQ\"><img src=\"https://cldup.com/hhWJ2HZrFL.gif\" alt=\"Admin 2020 media library\" width=\"800\" height=\"450\" /></a>
</div>



<p>&ldquo;A lot of what admin 2020 does is built on existing WordPress functions, it just uses them in a different way,&rdquo; Ashton said. &ldquo;Instant search for example leverages AJAX and you can search all of your content from one place.&rdquo;</p>



<p>The Admin 2020 plugin started out as a personal passion project. After building everything from plugins to themes to a hospitality reservation management system using WordPress, Ashton thought he would try his hand at making an admin theme he would enjoy using.</p>



<p>&ldquo;It was something I have always wanted and basically got tired of waiting for,&rdquo; he said. &ldquo;I&rsquo;ve been using WordPress for my projects for many years and while I love the platform I have never enjoyed using the backend. I wanted to create something with a strong emphasis on modern UI but also something that brought useful features that would speed up my workflow.&rdquo;</p>



<p>Ashton said supporting third-party extensions is one of the most challenging aspects of maintaining the plugin. Admin 2020 includes<a href=\"https://admintwentytwenty.com/pages/support\"> full support for popular plugins</a> like Jetpack, WooCommerce, Elementor, Yoast SEO, and Divi Builder, but there are thousands of others that have not been tested.</p>



<p>&ldquo;The process of supporting a plugin usually isn&rsquo;t that difficult but it&rsquo;s more the case of there are so many plugins out there,&rdquo; Ashton said. &ldquo;Some plugins rely heavily on their own CSS in which case they usually work fine in light mode but don&rsquo;t look right in dark mode. Then you have plugins that use WP components and they usually work great right out of the box. Some plugins actually disable all custom backend styling, though &ndash; they are a real challenge to get around!&rdquo;</p>



<p>Ashton launched Admin 2020 in April, so it is still relatively new to the commercial plugin scene. It is sold as a single plugin but is built in a modular way so that most parts of it can be disabled. The plugin&rsquo;s tiered pricing begins at $15 for a single site license. He opted to pursue a fully commercial model as opposed to releasing a free plugin with paid upgrades. </p>



<p>&ldquo;In short, I wanted the plugin to stay as streamlined as possible,&rdquo; Ashton said. &ldquo;I didn&rsquo;t want to add yet more plugin notices at the top of admin pages bugging you to upgrade. I wanted people to experience the full version of Admin 2020.&rdquo;</p>



<p>His strategy has been successful so far, as Admin 2020 has become a full-time project after just three months. The London-based company is a one-person effort at the moment, but Ashton is looking to bring another developer on.</p>



<p>&ldquo;Active installs are around 2,000 now, and as a result I am very busy and Admin 2020 is a full time project,&rdquo; he said. &ldquo;I love working on the plugin though, there is a lot of scope on where this can go and the feedback has been great!&rdquo;</p>



<p>When asked if he worries about the name becoming outdated in the coming years, Ashton said he is happy with the name but if he thinks of something more suitable it may change in the future. He believes there is a market for all kinds of different themes to transform the WordPress admin but isn&rsquo;t currently planning to add more designs.</p>



<p>&ldquo;Not everyone is the same, and good design looks different to everybody,&rdquo; Ashton said. &ldquo;I am not looking at other designs at the moment &ndash; more offering the ability to customize the design yourself through Admin 2020.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Jul 2020 23:21:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Copy and Paste Editor Blocks via GutenbergHub’s Block Library\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101455\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:185:\"https://wptavern.com/copy-and-paste-editor-blocks-via-gutenberghubs-block-library?utm_source=rss&utm_medium=rss&utm_campaign=copy-and-paste-editor-blocks-via-gutenberghubs-block-library\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6755:\"<img />GutenbergHub block library.



<p class=\"has-drop-cap\">Spearheaded by Munir Kamal, GutenbergHub <a href=\"https://gutenberghub.com/introducing-gutenberg-blocks-library-more/\">launched a free block library</a> to the WordPress community today. Currently, there are 37 custom-designed blocks that users can copy and paste to their website.</p>



<p>Unlike the block directory on WordPress.org, the blocks available from this project are not plugins.  They are handled through copying and pasting a bit of code.  Technicaly they are blocks that act as a grouping of various core WordPress blocks.   However, in reality, they more closely resemble block patterns.</p>



<p>The one caveat is that users must install Kamal&rsquo;s <a href=\"https://wptavern.com/control-block-design-via-the-editorplus-wordpress-plugin\">recently-launched EditorPlus plugin</a>. It allows end-users to style the core WordPress blocks via a slew of custom design options. Because the plugin neither relies on third-party blocks nor creates its own, all of the block designs in GutenbergHub&rsquo;s library are built directly from the blocks available in WordPress. This makes for a much smaller dependency tree and fewer areas where things could go wrong in the fast-moving world of blocks.</p>



<p>By tying the block designs to the <a href=\"https://wordpress.org/plugins/editorplus/\">EditorPlus </a>plugin, it gives Kamal much more control over the final output. Having cross-theme consistency is still a tough job, but it improves by working within the confines of the design framework from the plugin.</p>



<p>&ldquo;I created [EditorPlus] to fulfill my requirements in bringing easily customizable blocks and templates to Gutenberg users,&rdquo; said Kamal.</p>



<p>He launched a <a href=\"https://wptavern.com/gutenberg-hub-launches-collection-of-100-block-templates\">block template library</a> in March. However, it originally asked users to copy block HTML and CSS code separately. Now, both the block and template libraries require the EditorPlus plugin. This allows Kamal to build everything on top of a sort of framework and remove third-party dependencies. Kamal said the system will help make things easier for users while giving him more control over development and maintenance.</p>



<p>Thus far, most of the projects he has launched on GutenbergHub have built on top of the previous project in some way. They were stepping stones that led him to build a bigger yet more well-rounded system. However, we are likely light-years away from seeing how everything takes shape. The Gutenberg project is moving fast, and GutenbergHub will need to react to upcoming changes. It will need to contend with the inclusion of block patterns in WordPress 5.5, full-site editing later this year, and more design options for blocks down the road. Like the block system itself, all of this is still a bit experimental until we begin to see some sort of settling point. It will be interesting to watch how things unfold. Kamal and his GutenbergHub project are in a good position to ride the waves of constant change.</p>



<p>Watch a short video on how GutenbergHub&rsquo;s block library and EditorPlus plugin work together to create pricing columns:</p>



<div class=\"wp-block-embed__wrapper\">

</div>



<h2>How the Block Library Works</h2>



<p class=\"has-drop-cap\">Currently, users can search the <a href=\"https://gutenberghub.com/blocks/\">GutenbergHub block library</a> to pick and choose the blocks they want. The library is sub-divided by seven categories:</p>



<ul><li>Testimonial</li><li>Team</li><li>Feature</li><li>Card</li><li>Pricing</li><li>Call to Action</li><li>Stats</li></ul>



<p>Users can copy a small bit of JSON code for individual blocks they would like to add to their site. To add a block, installing and activating the EditorPlus plugin is a hard requirement. Once that is done, users can visit the Blocks tab under the EditorPlus settings screen and paste the code.</p>



<img />Adding a block&rsquo;s code via the EditorPlus plugin.



<p>The blocks tab acts as a central hub to manage blocks from the library. Users can add, delete, or deactivate any blocks added from GutenbergHub.</p>



<p>Each active block added to the site is available through the block inserter on the editor. Perhaps the one downside is the blocks do not have a preview image. Some of the blocks have similar names, such as Card 1, Card 2, etc. Having a preview image would help distinguish them &mdash; <em>or just better names</em>.</p>



<img />Inserting a block from GutenbergHub into the editor.



<h2>Future Plans</h2>



<p class=\"has-drop-cap\">Ideally, the EditorPlus plugin could serve up GutenbergHub&rsquo;s blocks and templates over an API, providing users with a simple import solution at the click of a mouse. The copy/paste approach means having to visit a separate website instead of staying in the comfort of one&rsquo;s WordPress admin. Kamal originally went with the copy/paste solution because he wanted everything to be independent of plugins. However, because WordPress did not have the design controls in place, he realized he needed at least one plugin as part of the equation. That is where EditorPlus came in. This should ultimately free him up to build an import feature.</p>



<p>&ldquo;I will possibly include a direct inserter for templates and blocks in the Editor Plus plugin,&rdquo; he said. However, there is no indication of when that will happen. It would make the user experience more seamless and efficient.</p>



<p>Kamal is still mulling over how he will eventually monetize the project. Right now, he has put a lot of time and resources behind it with little return on his investment. At some point, this could become unsustainable unless his other commercial ventures can fund it. In the long run, he will need to have a solid business plan behind the entire GutenbergHub project.</p>



<p>&ldquo;I do plan to monetize the GutenbergHub offering somehow,&rdquo; he said. &ldquo;I&rsquo;ve not yet planned out this, but that could be a premium subscription or offering pro blocks, templates, and an EditorPlus add-on. Another option would be to convert it into a marketplace where designers can create and sell blocks and templates. This is something I&rsquo;ve yet to plan out to be honest. Rest assured, what is free will remain free and will actually improve over time.&rdquo;</p>



<p>Kamal said his most immediate plan is to gather more feedback from users. &ldquo;I ended up creating a <a href=\"https://www.facebook.com/groups/gutenberghub/\">Facebook group</a>,&rdquo; he said. &ldquo;This would be the best and easiest way for anyone to share ideas, suggestions, and feedback about GutenbergHub.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Jul 2020 21:14:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: WordPress Documentation Team Bans Links to Commercial Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101625\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:189:\"https://wptavern.com/wordpress-documentation-team-bans-links-to-commercial-websites?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-documentation-team-bans-links-to-commercial-websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5904:\"<p>This week WordPress&rsquo; Documentation team <a href=\"https://make.wordpress.org/docs/tag/external-linking-policy/\">announced</a> a ban on links to commercial websites in a revision to its external linking policy:</p>



<blockquote class=\"wp-block-quote\"><p>During discussion about external linking policy, we came to conclusion that we won&rsquo;t allow, at least in the beginning and for the time being, any commercial blogs. So before you start arguing that some popular&nbsp;plugin&rsquo;s blogs have valuable information, let me stop you right there.</p><p>Allowing &ldquo;popular plugin&rsquo;s/theme&rsquo;s/services&rsquo; etc blogs&rdquo; and all other commercial blogs will put us in a position to protect documentation from being abused as marketing media, to protect ourselves from accusations of being biased and to defend every decision we make along the way. And still, there will be dissatisfied sides claiming we weren&rsquo;t fair and did them wrong. The idea of allowing external linking will become its own purpose.</p></blockquote>



<p>Despite the announcement&rsquo;s abrasive phrasing discouraging further discussion on the matter, the controversial decision stirred up a heated conversation in the comments. Yoast founder Joost de Valk <a href=\"https://make.wordpress.org/docs/2020/07/06/external-linking-policy-commercial-blogs/#comment-40100\">contends</a> that companies contributing to WordPress might as well receive some promotion as a benefit:</p>



<blockquote class=\"wp-block-quote\"><p>I understand that you want to prevent discussions about bias.</p><p>But I think your premise here is wrong: you&rsquo;re saying you&rsquo;re not &ldquo;biased&rdquo; if you&rsquo;re not linking to commercial companies. I would say we&rsquo;re all inherently biased, because some of those companies do a lot for the WordPress community, while others do not.</p><p>The companies that contribute to WordPress a lot used to get some links, and thus some promotion as benefit from the fact that they&rsquo;re contributing. By removing that from them, you&rsquo;re basically treating those that don&rsquo;t give back the same as companies that do give back, something which I think is simply wrong. So I very heavily disagree with this decision.</p></blockquote>



<p>Milana Cap, the Documentation Team member who penned the announcement, clarified that the policy change does not remove external links to commercial sites from WordPress.org. It only applies to documentation sites, including <a href=\"https://wordpress.org/support/\">HelpHub</a>,&nbsp;<a href=\"https://developer.wordpress.org/reference/\">Code Reference</a>,&nbsp;<a href=\"https://developer.wordpress.org/plugins/\">Plugin</a>&nbsp;and&nbsp;<a href=\"https://developer.wordpress.org/themes/\">Theme</a>&nbsp;Developer Handbook,&nbsp;<a href=\"https://developer.wordpress.org/block-editor/\">Block Editor Handbook</a>,&nbsp;<a href=\"https://developer.wordpress.org/apis/\">Common APIs Handbook</a>.</p>



<p>&ldquo;There is no way to make this fair,&rdquo; Cap said. &ldquo;And we can discuss about many unfair parallels happening in&nbsp;open source&nbsp;communities; such as how many hours per week can be contributed by a freelancer vs paid company contributor, meeting times (where decisions are made) in the middle of the night in your timezone etc.&rdquo;</p>



<p>Timi Wahalahti suggested one solution would be to better utilize the <a href=\"https://wordpress.org/five-for-the-future/pledges/\">Five for the Future pledges</a> page to identify significant contributors to documentation if links to commercial sites are no longer an option.</p>



<p>Several commenters noted the value of linking to additional examples and resources but also recommended WordPress put a version or timestamp in place to give the reader more context.</p>



<p>WordPress agency owner Jon Brown characterized the ban as &ldquo;undesirable gatekeeping,&rdquo; saying that the policy suggests all things commercial are &ldquo;inherently corrupt and not trustworthy nor valuable.&rdquo; </p>



<p>&ldquo;A links value is inherently subjective and ought to be delt with subjectively,&rdquo; Brown said. &ldquo;Trying to create high level objective rules doesn&rsquo;t seem beneficial or realistic. I certainly disagree that all &lsquo;commercial&rsquo; sites should be blanket banned.</p>



<p>&ldquo;I do think there are some low level disqualifiers that could guide authors and moderators in what links are appropriate. Those should be criteria that directly impact the users of docs, and being commercial doesn&rsquo;t. Those are things like, the source being accessible, the source not being pay walled, etc.&rdquo;</p>



<p>Cap responded, saying that the root of the issue is that allowing commercial links puts the documentation team in the unwanted position of having to find a fair way to decide on which links are allowed to be included. She also indicated that the policy may evolve over time but that for now the decision on the ban is final.</p>



<p>&ldquo;Perhaps over time we&rsquo;ll figure that out,&rdquo; Cap said. &ldquo;We&rsquo;ll certainly know more once we start doing it. For now, this is the decision.&rdquo;</p>



<p>External sources can be valuable supplements to documentation, but this conversation underscores the need for better incentives for people to spend time documenting WordPress. As the team is already running on limited resources, they are trying to avoid having to heavily police links to commercial websites.</p>



<p>&ldquo;The bottom line is: we haven&rsquo;t figured out the best way to deal with commercial blogs or sites in a fair manner and thus our focus is going to be on links that don&rsquo;t drop into that grey zone,&rdquo; Cap said. &ldquo;We do expect to eventually get towards discussing how we can safely include commercial blog links (if this even is possible).&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Jul 2020 23:22:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Ariele Lite Is a Fun and Refreshing Theme for WordPress Bloggers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101733\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:193:\"https://wptavern.com/ariele-lite-is-a-fun-and-refreshing-theme-for-wordpress-bloggers?utm_source=rss&utm_medium=rss&utm_campaign=ariele-lite-is-a-fun-and-refreshing-theme-for-wordpress-bloggers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6559:\"<img />



<p class=\"has-drop-cap\">Ariele Lite, the latest theme from Rough Pixels, went live in the <a href=\"https://wordpress.org/themes/ariele-lite/\">WordPress theme directory</a> today. In an ecosystem where designers are dubbing most themes as multipurpose, it is refreshing to see a well-designed theme that is unafraid to cater specifically to bloggers.</p>



<p>It is not often that I get the opportunity to test a brand new theme from the official WordPress theme directory that supports block editor styles. Or, at least it&rsquo;s not often that I test one that lives up to the claim. Despite a couple of trivial issues, Ariele Lite is a theme that will appeal to a wide audience.</p>



<p>Whenever I see the word &ldquo;lite&rdquo; appended to the end of a theme name, it is immediately off-putting. Far too often, I have been burned when activating such themes. My already low expectations are generally met with unfulfilled promises, missing styles for basic features, and a metric ton of advertising for the <em>real</em> product (i.e., the non-lite version that I can buy). However, I was pleasantly surprised by the work that went into Ariele Lite. It was a complete and fully-functioning theme and did not feel like crippleware. Plus, most of the upsell features in the commercial version were not that appealing to me. I can find most of them in plugin form. However, they could be nice additions for the user who wants integrated features that will look and feel like they are a part of the theme without the hassle of hunting down the perfect plugin.</p>



<p>What makes Ariele Lite a great theme is that it has an opinionated style, even if it is merely some subtle flavoring, for nearly every element or block. It never goes overboard into lavishness, which means it doesn&rsquo;t break readability. It is a theme that has fun with its design while being well-groomed enough for professional bloggers.</p>



<p>Even if Ariele Lite is not to your taste, Rough Pixels has a history of releasing <a href=\"https://wordpress.org/themes/author/roughpixels/\">clean, well-designed themes</a>. There is a little something for almost anyone. The company is also one of the few theme-makers with multiple themes that support the block editor in the free directory.</p>



<h2>Theme Design and Features</h2>



<img />Ariele Lite customizer options.



<p class=\"has-drop-cap\">Ariele Lite is not stock full of custom features, but it has enough flexibility to satisfy most people who want to do some customization. More than anything, my favorite thing about the theme is that it does not take much cajoling to achieve the look of the <a href=\"https://demos.roughpixels.com/ariele-lite/\">demo</a> the theme author has put together. <em>There should be a WordPress theme directory filter tag titled &ldquo;what you see in the demo is what you get.&rdquo;</em></p>



<p>The theme comes with a reasonable number of theme design options. Users can change nearly every aspect of their front end. The theme has options for all its colors, several labels, and other theme-specific elements. It stops short of adding font settings, which is likely a good thing given the theme&rsquo;s attention to detail with typography.</p>



<p>The one particular design element that caught my eye was the theme&rsquo;s blockquote style. Some bloggers may want something a bit less pronounced in design, depending on how they want to present quotes. However, I am a sucker for beautiful quote designs, and Ariele Lite did not disappoint.</p>



<img />Ariele Lite&rsquo;s blockquote style.



<p>The quote design is representative of the attention that Rough Pixels has given to other elements in the theme. From the bold headings to the caption design that overlays the featured image, the team has left few stones unturned.</p>



<p>For bloggers, the most important element is the typography. It is one of those elements that too many theme authors overlook, but it is paramount when catering a theme to bloggers. This is one area the theme excels at. However, if selecting the sidebar-less layout option, there are too many characters per line for comfortable reading. Stick with either the left or right sidebar option to stay on point.</p>



<p>The theme comes with Jetpack infinite scrolling support, a custom posts widget with thumbnails, and enough sidebars to put widgets anywhere you might want. I like the default setup well enough, so these features are less important to me. However, they are likely welcome additions for many users.</p>



<h2>Not Without Issues</h2>



<p class=\"has-drop-cap\">I have been building this theme up thus far in the review. Now, it is time to take it down a notch or two. Ariele Lite is by no means perfect. No software is. I hit a few snags.</p>



<p>The biggest issue I ran into was the theme did not handle full-aligned blocks well. Instead of capping them to the width of the content container, they would break out into the sidebar. Even when selecting a layout with no sidebar, the same issue persists.</p>



<img />Full-width image creates a design issue.



<p>This would be an absolute deal-breaker for me as a user. As a developer, I know that it is simply an oversight and can be corrected. The theme author can correct it with a single line of CSS. Users should simply be aware of the problem, at least until the theme author has a chance to address it.</p>



<p>Outside of that, nested lists in sidebars need a little TLC. The spacing is off. It is also missing support for pagination via the <code>&lt;!--nextpage--&gt;</code> quick tag on single post views.</p>



<p>These few items are relatively trivial issues to address. They are worth noting for the 1.0.4 version of the theme and will likely be fixed in future iterations.</p>



<p class=\"is-style-highlight has-gray-100-background-color has-background bg-gray-100\"><strong>Note:</strong> The above issues were quickly addressed by the theme author in version 1.0.5.</p>



<h2>Final Thoughts</h2>



<p class=\"has-drop-cap\">Ariele Lite does not break much new ground. It is simply a solid blogging theme that supports the block editor. Nearly two years in, such themes are still few and far between. It is ideally suited for people who love to write, and it has enough options to keep those who want to do a bit of tweaking happy.</p>



<p>If the theme&rsquo;s development team is proactive about addressing the few minor issues, I would recommend it to anyone who wants a good theme that fully supports the latest version of WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Jul 2020 20:35:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: Open Source Initiative to Host Virtual State of the Source Summit, September 9-10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101622\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:225:\"https://wptavern.com/open-source-initiative-to-host-virtual-state-of-the-source-summit-september-9-10?utm_source=rss&utm_medium=rss&utm_campaign=open-source-initiative-to-host-virtual-state-of-the-source-summit-september-9-10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2787:\"<p>OSI (Open Source Initiative) is hosting a new 24-hour, virtual conference called <a href=\"https://opensource.org/StateOfTheSource\">State of the Source Summit</a>, September 9-10. The non-profit organization plays an important role in the open source ecosystem as stewards of the&nbsp;<a href=\"https://opensource.org/docs/osd\">Open Source Definition (OSD)</a>.&nbsp;OSI is responsible for reviewing and approving licenses as OSD-conformant, which indirectly helps mediate community conflicts.</p>



<p>As part of the organization&rsquo;s overall mission to educate the public on the economic and strategic advantages of open source technologies and licenses, OSI is hosting a global summit to facilitate conversations on the current state of open source software. </p>



<p>&ldquo;We are so very excited to host our first-ever conference, with a global approach,&rdquo; OSI Board President Josh Simmons said. &ldquo;State of the Source provides an opportunity for both the open source software community and the OSI&mdash;all those who have contributed so much&mdash;to reflect on how we got here, why we have succeeded, and what needs to happen now.&rdquo;</p>



<p>The conference will run four tracks with sessions that fall under these general groupings:</p>



<ul><li><a href=\"https://opensource.org/StateOfTheSource#OSLOSI\">Open Source Licenses and the OSI</a></li><li><a href=\"https://opensource.org/StateOfTheSource#Business\">Projects &amp; People</a></li><li><a href=\"https://opensource.org/StateOfTheSource#Principles\">Principles, Policy, &amp; Practices</a></li><li><a href=\"https://opensource.org/StateOfTheSource#HotTopics\">&ldquo;Hot Topics&rdquo;</a></li></ul>



<p>OSI has identified several example topics for each track, to guide potential presenters in writing a proposal. The first track encompasses more OSI-specific topics, such as license proliferation and license enforcement. </p>



<p>Projects &amp; People includes topics that apply more broadly to communities and organizations &ndash; open source business models, sustainability, patents, and trademarks. The Principles, Policy, and Practices track is geared towards application and example topics include things like explaining a license to your peers, learning how to select a license for your project, and compliance, compatibility, and re-licensing.</p>



<p>As more conferences are forced to move to a virtual format, the wider open source community has the opportunity to be more engaged in an event like State of the Source. It&rsquo;s a good venue for addressing non-technical issues related to the challenges facing open source maintainers and the community. The <a href=\"https://forms.gle/CriSN1Ddtjb1GPbX8\">call for proposals</a> ends July 16, and speakers will be announced August 25.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Jul 2020 22:07:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"WPTavern: Gutenberg 8.5 Adds Single Gallery Image Editing, Allows Image Uploads From External Sources, and Improves Drag and Drop\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101676\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:299:\"https://wptavern.com/gutenberg-8-5-adds-single-gallery-image-editing-allows-image-uploads-from-external-sources-and-improves-drag-and-drop?utm_source=rss&utm_medium=rss&utm_campaign=gutenberg-8-5-adds-single-gallery-image-editing-allows-image-uploads-from-external-sources-and-improves-drag-and-drop\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5941:\"<p class=\"has-drop-cap\">On Wednesday, the Gutenberg team <a href=\"https://make.wordpress.org/core/2020/07/08/whats-new-in-gutenberg-8-july/\">released version 8.5</a> of its plugin to the public. This will be the final major plugin release to make its way into the upcoming WordPress 5.5, which has a target release date of August 11. This update does not include any groundbreaking features, but it does offer several enhancements and polishes the product.</p>



<p>Gutenberg 8.5 introduces the ability to upload images from third-party sites instead of simply hotlinking them. It also improves the drag-and-drop experience with blocks, adds an edit button for images in galleries, and moves reusable blocks to their own tab in the inserter.</p>



<p>Users can also now <a href=\"https://github.com/WordPress/gutenberg/pull/23197\">add an HTML anchor/ID</a> to all static blocks. This was a relatively minor change but provides tremendous value. No longer will users need to switch to code editing mode and risk validation issues to add a basic HTML ID.</p>



<h2>Upload External Images</h2>



<img />New upload external image button.



<p class=\"has-drop-cap\">The largest enhancement in Gutenberg 8.5 is an improvement to inserting an image from an external URL. This update allows users to <a href=\"https://github.com/WordPress/gutenberg/pull/23565\">upload the image to their media library</a>.</p>



<p>In past versions, users could insert an image from any URL. However, the image would remain hosted on that external site. The problem was that the end-user had no control over what happened to that image in the future. The third-party site could disappear. The site owner could remove or replace the image. The image shown on users&rsquo; sites may not have been what they intended.</p>



<p>The upload process is manual rather than automatic. After inserting an image via a URL, the editor toolbar will have a new upload icon with an arrow that points up. Users must click it to add the image to their media library.</p>



<p>The additional benefit of self-hosting the image is that the editor&rsquo;s other image tools become available. Users can resize, rotate, or crop the image, options which were added to <a href=\"https://wptavern.com/gutenberg-8-4-adds-image-editing-includes-multi-block-controls-and-enables-block-directory-search\">Gutenberg 8.4</a>.</p>



<h2>Improved Drag and Drop</h2>



<img />Dragging multiple blocks in the editor.



<p class=\"has-drop-cap\">I had forgotten there was even a drag-and-drop feature for the block editor. Since it was introduced, I have never used it outside of testing. It is also not available when using Top Toolbar mode, which is my go-to choice.</p>



<p>The editor now allows dragging and dropping <a href=\"https://github.com/WordPress/gutenberg/pull/23477\">multi-block selections</a>. The dragging-and-scrolling behavior is much approved. Instead of scrolling when reaching the edge of the viewport, the window <a href=\"https://github.com/WordPress/gutenberg/pull/23082\">scrolls almost immediately</a> as you drag.</p>



<p>Despite the improvement, I do not find the drag-and-drop feature efficient in comparison to using the up/down arrows to move a block. However, I have never been much of a fan of dragging and dropping elements. Discoverability suffers because the hand icon that appears when hovering the toolbar is not a great indicator that I can drag the block, especially given its similarity to the normal hand cursor when moving my mouse. Some sort of directional arrow icon would make more sense and distinguish it.</p>



<h2>Edit Single Gallery Images</h2>



<img />Editing an individual gallery image.



<p class=\"has-drop-cap\">Gutenberg 8.5 features a <a href=\"https://github.com/WordPress/gutenberg/pull/23554\">new edit button</a> on the individual images within a gallery block. This allows end-users to replace the image on the spot.</p>



<p>This is one of my favorite features to make it in before the upcoming WordPress 5.5 deadline. It has been one of those minor nit-picks for the past couple of years that I have wanted to see addressed. Overall, the team has done a solid job of making it work.</p>



<p>However, it is not quite perfect yet. The biggest issue comes after clicking the edit button. Suddenly, there is no good way to cancel the edit if I change my mind. I got around this limitation by choosing to add an image from the media library, which automatically had the previous image selected. My first thought was to click the <em>x</em> icon. However, that removes the image from the gallery. A trashcan icon makes more sense for removing the image while the <em>x</em> icon makes more sense for canceling an action.</p>



<h2>Reusable Blocks Tab</h2>



<img />New reusable blocks tab in the inserter.



<p class=\"has-drop-cap\">Reusable blocks are no longer tucked away at the bottom of the normal blocks list in the inserter. The team has <a href=\"https://github.com/WordPress/gutenberg/pull/23296\">moved them to their own tab</a>. The inserter is now separated into Blocks, Patterns, and Reusable tabs. This will be an entirely new experience for users when WordPress 5.5 drops because the patterns feature and its corresponding tab are also new.</p>



<p>Moving the reusable blocks to a separate tab better exposes the feature. The previous location in which they were situated at the bottom of the blocks list hid them from anyone who did not scroll to the end. For far too long, this powerful feature was not getting the exposure that it deserved. Perhaps this new location will correct that.</p>



<p>The next step would be to finally add a reusable blocks menu item that is accessible from anywhere in the WordPress admin. We will likely have to wait for the <a href=\"https://wptavern.com/version-1-prototype-of-the-wordpress-admin-block-directory-announced\">WordPress admin block directory</a> for that to happen.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Jul 2020 21:00:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WPTavern: WordPress University Was Always Online\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101616\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:141:\"https://wptavern.com/wordpress-university-was-always-online?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-university-was-always-online\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7667:\"<p>Did anybody listen to Peter Thiel? In 2011, the billionaire co-founder of PayPal, dubbed &ldquo;<a href=\"https://bits.blogs.nytimes.com/2011/05/25/want-success-in-silicon-valley-drop-out-of-school/\">contrarian investor</a>&rdquo; by the&nbsp;<em>New York Times</em>, created the Thiel Fellowship. A collection of 24 youngsters under the age of 20 were awarded $100,000 in exchange for dropping out of college to start tech companies.</p>



<p>Thiel said:</p>



<blockquote class=\"wp-block-quote\"><p>I believe you have a bubble whenever you have something that&rsquo;s overvalued and intensely believed. In education, you have this clear price escalation without incredible improvement in the product. At the same time you have this incredible intensity of belief that this is what people have to do&hellip;It seems very similar in some ways to the housing bubble and the tech bubble.</p></blockquote>



<p>Thiel had struck a raw cultural nerve. For years, as the world reeled and slowly recovered from a financial crisis, the quality of higher education was rapidly degrading while tuition costs were steadily increasing.</p>



<p>As more colleges make the switch to online only in the response to the pandemic, and the &ldquo;college experience&rdquo; becomes a relic of a bygone era, one wonders what the future of the university might look like.</p>



<img />Peter Thiel and Elon Musk, founders of PayPal. Typical underachievers.



<p>Does a college education still improve economic outcomes in any significant way?</p>



<p>For people interested in tech careers, the answer is probably no. A college education produces minimal, if any, value. In effect, the university model, with American student loan debt amounting to $1.6 trillion, seems to do more harm than good.</p>



<p>COVID-19 has taught the world many harsh lessons and forced us all to reckon with difficult conclusions. But it has also shown us the promise and potential we might have otherwise passed without comment.</p>



<p>According to the&nbsp;<a href=\"https://www.bls.gov/ooh/computer-and-information-technology/web-developers.htm\">U.S. Bureau of Labor Statistics</a>, the 2019 median salary for a web developer comes to $73,760 per year, or $35.46 per hour, with no former work experience in related occupations required. The bureau lists an associate&rsquo;s degree as the typical entry-level education, which, at most colleges, amounts to 5-6 semesters&mdash;considerably smaller investment than a four year degree.</p>



<p>But with readily available&mdash;and free&mdash;online courses in WordPress, HTML, CSS, PHP, and JavaScript, and the ubiquity of certification programs and &ldquo;boot camps,&rdquo; even an associate&rsquo;s degree seems like overkill. When anyone, from any background, can launch a $70,000 per year career with no more experience than a few free courses available through any public library, we have either entered an era of unparalleled prosperity&mdash;or&nbsp;<em>The Twilight Zone</em>.</p>



<p><strong>Should any web developer decide to pick up full stack development skills, or expand into general software engineering, the median salary jumps up to six figures. And this is before we get to the new frontiers of big data and &ldquo;the cloud.&rdquo;</strong></p>



<p>Instead of thinking in monotone sentiments like &ldquo;learn to code,&rdquo; let&rsquo;s imagine a generation raised under the banner of&nbsp;<em>learn how to learn.</em></p>



<p>&ldquo;The computer was a tool,&rdquo; says John Dorner, IT coordinator for a USDA grant program, and WordPress developer. Starting his career as a 4-H program leader and agricultural extension agent for the University of Georgia in the 1980s, Dorner discovered computing as a shortcut to efficiency.</p>



<p>It wasn&rsquo;t so easy to learn computers in those days. Tasks any high-schooler would consider common today required deep knowledge of how hardware and software worked together. There were no hard drives. Dorner had to employ two floppy disks, one with the operating system and application and one with his data, in order to create a spreadsheet.</p>



<p>&ldquo;Writing code without the Internet was&hellip;interesting,&rdquo; Dorner recalls. Learning PHP and MySQL from a recliner, balancing a laptop on his lap, and a book on the arm of the chair, Dorner demonstrates that the will to learn can exist outside of the classroom.</p>



<p>During our conversation over Google Meet, we talked about the alternatives available to people young and old, and from virtually any socio-economic background, who are interested in pursuing careers in IT or development.</p>



<p>Before opting for an associate&rsquo;s degree, there are shorter duration programs available. Boot camps and certification programs provide rigorous course work and leave their students with some experience and a portfolio&mdash;and no student debt.</p>



<p>Dorner says:</p>



<blockquote class=\"wp-block-quote\"><p>Most web agencies would hire people if [they&rsquo;ve] got a certificate, a portfolio, or some way to prove [they] have the skills&hellip;That&rsquo;s more important than a full degree. Now, if you want to work at IBM, they might require a Bachelor&rsquo;s or Master&rsquo;s Degree. And there is a lot you can learn in those [full degree] programs. But somebody coming out of [community college or a boot camp] can get a good job and something starting.</p></blockquote>



<p>In addition to free courses online, Dorner suggests that WordPress can be a powerful accelerant to tackling bigger concepts in web development. The WordPress path to web mastery works in &ldquo;layers.&rdquo;</p>



<p>&ldquo;WordPress is a good starting point,&rdquo; Dorner says. &ldquo;[You] can do a lot in WordPress without knowing any code.&rdquo; Once one has achieved a level of comfort with the WordPress interface, he can start adding custom CSS rules. From there, he can try his hand at child themes. And before long, full themes and plugins.</p>



<p><strong>&ldquo;The more you hack, the more you learn.&rdquo;</strong></p>



<p>In addition to learning the WordPress interface, the learner is being exposed to deeper concepts like web servers, open source philosophy, and version control.</p>



<p>What is left for the universities to cover?</p>



<p>Everybody needs to have some general education, Dorner replies. Basic math, science, and some of the humanities help to round out a liberal education. Beyond the general education, there are life skills and experience that must happen oustide of the classroom.</p>



<p>Dorner not only works in IT, but creates jobs as well. During the hiring process, I asked, what&rsquo;s the most important criteria an applicant must meet?</p>



<blockquote class=\"wp-block-quote\"><p>It&rsquo;s very important to be a self-directed, lifelong learner. I hired someone [recently]&hellip;[She] had the minimum requirements, but she had the initiative to learn something new. She was self-taught, went out and learned the stuff, and was able to solve the problem. That was more important to me than [the credentials].</p></blockquote>



<p>The pathways into the tech field are now baked into society itself. Every kid who learns how to Google for information is building a working knowledge of SEO. Every kid who touches an iPhone learns the fundamentals of UX. And so forth.</p>



<p>The question for the coming years is whether or not the university model will meet these kids on the journey to careers in tech with something unique to offer them, or if the kids can get there well enough on their own.</p>



<p>WordPress university was always online.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Jul 2020 14:36:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Chris Maiorana\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: Jetpack 8.7 Adds New Tweetstorm Unroll Feature, Improves Search Customization\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101628\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:217:\"https://wptavern.com/jetpack-8-7-adds-new-tweetstorm-unroll-feature-improves-search-customization?utm_source=rss&utm_medium=rss&utm_campaign=jetpack-8-7-adds-new-tweetstorm-unroll-feature-improves-search-customization\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3741:\"<p><a href=\"https://jetpack.com/2020/07/07/87-easier-reach-customers/\">Jetpack 8.7</a> was released this week with an exciting new feature that allows users to &ldquo;unroll&rdquo; a tweetstorm and publish it in a post. The feature works inside the Tweet block. After a user embeds a tweet, it will automatically detect a tweetstorm and display a prompt to fetch the rest of the tweets. It functions in a similar way to the <a href=\"https://threadreaderapp.com/\">Thread Reader app</a>, except the unrolled thread is hosted on your WordPress post.</p>



<img />



<p>Tweetstorms remain a controversial way to get a lengthy point across. Twitter users with large followings will often get wider exposure and more traction and interaction on their ideas when they share them in a series of bite-size tweets. Although tweetstorms might be better as a blog, especially for those who are consuming and sharing them, a link to a blog post doesn&rsquo;t carry the same weight as tweets for capturing Twitter users&rsquo; immediate attention.</p>



<div class=\"wp-block-embed__wrapper\">
<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">If your thread is more than 3 tweets it does not belong on Twitter. Don\'t @ me. <a href=\"https://twitter.com/hashtag/longlivetheblog?src=hash&ref_src=twsrc%5Etfw\">#longlivetheblog</a></p>&mdash; Jon Desrosiers (@desrosj) <a href=\"https://twitter.com/desrosj/status/1242442659635048453?ref_src=twsrc%5Etfw\">March 24, 2020</a></blockquote>
</div>



<p>You may not be able to convince people to stop posting tweetstorms, but with Jetpack 8.7 you can make sure that these tweets are available inside a blog post.</p>



<p>Gary Pendergast, who has been working on the unroll feature for several months, tweeted a demo video of how it works.</p>



<div class=\"wp-block-embed__wrapper\">
<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Not particularly controversial opinion: most tweetstorms should be blog posts.<br /><br />Putting my money where my mouth is: <a href=\"https://t.co/HFBbmQtwql\">pic.twitter.com/HFBbmQtwql</a></p>&mdash; Gary (@GaryPendergast) <a href=\"https://twitter.com/GaryPendergast/status/1266201102241853440?ref_src=twsrc%5Etfw\">May 29, 2020</a></blockquote>
</div>



<p>If you&rsquo;re looking to compose and publish tweetstorms from a blog post, with your post as the point of origin, John James Jacoby&rsquo;s <a href=\"https://github.com/JJJ/publishiza\">Publishiza</a> plugin performs the opposite function of Jetpack&rsquo;s new unroll feature. Pendergast said he is also investigating how to add the ability to publish a tweetstorm using the block editor, which seems like an ideal use case for writing content in blocks.</p>



<p>Jetpack 8.7 also brings updates to the recently revamped <a href=\"https://jetpack.com/2020/04/07/re-introducing-jetpack-search-for-wordpress-sites/\">Search feature</a>, adding more customization options for the search overlay:</p>



<ul><li>Choose between minimal and expanded results</li><li>Change the default sorting to options &mdash; like chronological</li><li>Hide the sort option to reduce the size of the interface</li></ul>



<p>This release also gives users easier access to their Google Photos and the free Pexels library. Access to these services was previously integrated with media library but is now also accessible via the block editor.</p>



<p>Version 8.7 introduces a WhatsApp Button block to allow visitors and customers to get in touch easily. The Jetpack team has also added more customization options to the Calendly, Mailchimp, Eventbrite, and Payment blocks. Check out the <a href=\"https://jetpack.com/2020/07/07/87-easier-reach-customers/\">release post</a> for a full list of improvements in this update.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jul 2020 20:48:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: After 11 Years, Users Will Be Able to Update Themes and Plugins via a ZIP File\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101600\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"https://wptavern.com/after-11-years-users-will-be-able-to-update-themes-and-plugins-via-a-zip-file?utm_source=rss&utm_medium=rss&utm_campaign=after-11-years-users-will-be-able-to-update-themes-and-plugins-via-a-zip-file\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4102:\"<p class=\"has-drop-cap\">It has been a long road. Eleven long years. WordPress will finally allow end-users to update an installed plugin or theme by <a href=\"https://core.trac.wordpress.org/changeset/48390\">uploading a ZIP file</a>. After over a decade, most people who had hoped to see this day have likely moved on. However, for those of us still waiting for this long sought after feature, it will land in WordPress 5.5.</p>



<p>A little patience never hurt anyone. Over the years, we have seen plugins crop up to handle this missing feature. There has been a clear and present need for it. <a href=\"https://wordpress.org/plugins/easy-theme-and-plugin-upgrades/\">Easy Theme and Plugin Upgrades</a> by Chris Jean has over 200,000 active installs. <a href=\"https://wordpress.org/plugins/update-theme-and-plugins-from-zip-file/\">Update Theme and Plugins from Zip File</a> by Jeff Sherk has another 20,000.  The community owes the developers of these plugins at least a small bit of thanks for taking on a job that should have long ago been a part of the core experience.</p>



<p>There was a time when this feature would have been one of the most important tools to land in WordPress. This was a time when one-click updates were not a thing. This was long before the idea of automatic theme and plugin updates, <a href=\"https://wptavern.com/automatic-theme-and-plugin-updates-slated-for-wordpress-5-5\">a feature that is also coming in WordPress 5.5</a>, was conceived. While it is still exciting to finally get a feature that has long been on the waiting list, it is far less useful than it once was.</p>



<p>This missing feature has also likely at least partially spurred commercial theme and plugin shops to come up with custom solutions. This represents arguably one of the largest segments of users that still need the feature, at least for those using products from shops that do not provide one-click or automatic updates. </p>



<p>Updating themes via a ZIP file is a bit old-school, but there are scenarios where that is the better or preferred option for some users.</p>



<p>I routinely use a third-party plugin to handle this for various sites I am involved with where I might maintain a custom theme. This is particularly true if I don&rsquo;t have FTP or other access to the server. It is simple to upload a ZIP file in those cases.</p>



<p>Despite less of a need for this feature in 2020 than in 2009, I can still use it. Judging by the download numbers of existing plugins, a couple hundred thousand others can too.</p>



<h2>How Updating via ZIP Works</h2>



<p class=\"has-drop-cap\">The new feature is not immediately apparent. However, it is more of a power-user feature that users will need to know about before attempting to use.</p>



<p>Updating a theme or plugin works in the same fashion as uploading a new one. By visiting the Add New plugin or theme screen in the WordPress admin and clicking the upload button, users can drop the ZIP file from their computer. After clicking the Install Now button, WordPress will direct users to a new screen that compares the currently-installed extension with the uploaded versions. Users can then choose between continuing with the installation or canceling.</p>



<ul><li class=\"blocks-gallery-item\"><img /></li><li class=\"blocks-gallery-item\"><img /></li><li class=\"blocks-gallery-item\"><img /></li></ul>Steps to updating an existing plugin.



<p>After clicking the &ldquo;Upload Plugin&rdquo; button via the new plugin screen, the uploader currently reads, &ldquo;If you have a plugin in a .zip format, you may install it by uploading it here.&rdquo; There is no mention that users may upload a plugin that is already installed. A tweak to the language could help make it clear.</p>



<p>The comparison feature is a welcome addition, which should curb users accidentally uploading something they already have installed or rolling back when they already have a newer version active on the site. Some of the existing solutions from third-party plugins do not handle this feature, so this should make for a good upgrade.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jul 2020 20:09:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: New Gatsby Source WordPress Plugin Now in Beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101091\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:157:\"https://wptavern.com/new-gatsby-source-wordpress-plugin-now-in-beta?utm_source=rss&utm_medium=rss&utm_campaign=new-gatsby-source-wordpress-plugin-now-in-beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4982:\"<div class=\"wp-block-image\"><img /></div>



<p>Gatsby <a href=\"https://www.gatsbyjs.org/blog/2020-07-07-wordpress-source-beta/\">announced</a> its new source plugin (v4) for WordPress is now in beta. The plugin has been completely revamped to improve&nbsp;<a href=\"https://www.gatsbyjs.org/docs/glossary/headless-wordpress\">headless WordPress</a>&nbsp;setups where Gatsby powers the frontend. It also integrates with <a href=\"https://www.gatsbyjs.com/\">Gatsby Cloud</a> to provide real-time previews and incremental builds.</p>



<p>The Gatsby team has had a long journey towards creating an integration for WordPress sites that would satisfy more complex use cases. There are currently three different avenues for using Gatsby with WordPress, each with different benefits and drawbacks:</p>



<ul><li>Gatsby Source WordPress + WP REST API </li><li>Gatsby Source GraphQL + WPGraphQL </li><li>Gatsby Source WordPress (v4) + WPGraphQL</li></ul>



<p>The first approach relies on the WP REST API to fetch all data (posts, terms, media, etc) and cache the data in Gatsby&rsquo;s node cache. The second method allows developers to write GraphQL queries to fetch data from the Gatsby cache and render that data in templates.</p>



<p>According to Gatsby engineer and WPGraphQL creator Jason Bahl, the first two approaches are only adequate for basic use cases.</p>



<p>&ldquo;When you start adding more advanced functionality, such as Advanced Custom Fields Flex Fields, the WP REST API starts to fall apart and become very difficult to use in a decoupled way,&rdquo; Bahl said. &ldquo;The WP REST API has a Schema that can allow plugins and themes to extend the WP REST API and declare what type of data any given endpoint will expose. This is helpful for decoupled applications to know ahead of time what kind of data to expect.</p>



<p>&ldquo;The problem is that plugins and themes can extend the WP REST API without making use of the Schema, or by simply defining field types in the Schema as `object` or `array` Types. This means there&rsquo;s no easy way for decoupled applications, including Gatsby, to know what to expect from those fields. Gatsby relies on consistent data, and the WP REST API isn&rsquo;t consistent. The shape of the data returned from endpoints (especially when plugins extend the REST API) is unpredictable and that is problematic for decoupled applications.&rdquo;</p>



<p>WPGraphQL was created as an alternative to the WP REST API, addressing many of these pain points with its enforced Schema. This benefits decoupled tools like Gatsby because they can introspect the Schema to determine what data is available before requesting any.</p>



<p>&ldquo;So even cases such as Advanced Custom Fields Flex Fields, where the data being returned could be one of many possible Flex Field Layouts, Gatsby can still know what the possible data is before asking for the data,&rdquo; Bahl said. &ldquo;The enforced Schema of WPGraphQL allows decoupled tools to ship with confidence and eliminates entire classes of bugs.&rdquo;</p>



<p>The Gatsby Source GraphQL + WPGraphQL approach has some improvements over using the WP REST API but was limited in that it doesn&rsquo;t cache data to the Gatsby node cache. This prevents WordPress sites from being able to utilize Gatsby&rsquo;s cloud-based commercial offerings for previews and incremental builds. Bahl explained how the new Gatsby Source WordPress plugin (v4) + WPGraphQL is the &ldquo;best of both worlds:&rdquo;</p>



<blockquote class=\"wp-block-quote\"><p>It uses WPGraphQL on the WordPress server to expose WordPress data in a Typed GraphQL Schema. Gatsby Source WordPress v4 uses GraphQL Introspection to read the Schema from the WordPress site and builds a nearly identical Schema in Gatsby. It then fetches data using WPGraphQL and caches the data in Gatsby. Users then use GraphQL to interact with the Gatsby cache and get data to render in Components in their Gatsby site.</p></blockquote>



<p>The new integration gives content creators the ability to click &ldquo;preview&rdquo; to see their changes live in the Gatsby-powered site. Publishing no longer requires a full site rebuild. It will simply push out the changes to the affected pages. Changes will be live in seconds, similar to how users expect WordPress to work without the headless integration. The new plugin, combined with Gatsby Cloud, provide a better marriage of the content creation experience with Gatsby&rsquo;s React + GraphQL developer experience, while delivering fast static pages on the frontend.</p>



<p>If you want to test the beta of the new Gatsby Source WordPress plugin, you can find it (and its dependencies) <a href=\"https://github.com/gatsbyjs/gatsby-source-wordpress-experimental\">on GitHub</a>. The <a href=\"https://docs.wpgraphql.com/getting-started/install-and-activate/\">WPGraphQL</a>&nbsp;and&nbsp;<a href=\"https://wordpress.org/plugins/wp-gatsby/\">WPGatsby</a>&nbsp;plugins are also required. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Jul 2020 22:33:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 5.5 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8624\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2020/07/wordpress-5-5-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9498:\"<p>WordPress 5.5 Beta 1 is now available for testing!</p>



<p><strong>This software is still in development,</strong>&nbsp;so it&#8217;s not recommended to run this version on a production site. Consider setting up a test site to play with the new version.</p>



<p>You can test the WordPress 5.5 beta in two ways:</p>



<ul><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option)</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.5-beta1.zip\">download the beta here&nbsp;(zip)</a>.</li></ul>



<p>The current target for final release is August 11, 2020. This is only <strong>five weeks away</strong>. Your help is needed to ensure this release is tested properly.</p>



<p>Testing for bugs is an important part of polishing the release during the beta stage and a great way to contribute. Here are some of the big changes and features to pay close attention to while testing.</p>



<h2><strong>Block editor: features and improvements</strong></h2>



<p>WordPress 5.5 will include ten releases of the Gutenberg plugin, bringing with it a long list of exciting new features. Here are just a few:</p>



<ul><li><strong>Inline image editing &#8211; </strong>Crop, rotate, and zoom photos inline right from image blocks.</li><li><strong>Block patterns</strong> &#8211; Building elaborate pages can be a breeze with new block patterns. Several are included by default.</li><li><strong>Device previews</strong> &#8211; See how your content will look to users on many different screen sizes. </li><li><strong>End block overwhelm</strong>. The new block inserter panel displays streamlined categories and collections. As a bonus, it supports patterns and integrates with the new block directory right out of the box.</li><li><strong>Discover, install, and insert third-party blocks</strong> from your editor using the new block directory.</li><li>A better, <strong>smoother editing experience </strong>with:&nbsp;<ul><li>Refined drag-and-drop</li><li>Block movers that you can see and grab</li><li>Parent block selection</li><li>Contextual focus highlights</li><li>Multi-select formatting lets you change a bunch of blocks at once&nbsp;</li><li>Ability to copy and relocate blocks easily</li><li>And, better performance</li></ul></li><li><strong>An expanded design toolset for themes.</strong></li><li>Now <strong>add backgrounds and gradients</strong> to more kinds of blocks, like groups, columns, media &amp; text</li><li>And <strong>support for more types of measurements</strong> &#8212; not just pixels. Choose ems, rems, percentages, vh, vw, and more! Plus, adjust line heights while typing, turning writing and typesetting into the seamless act.</li></ul>



<p>In all, WordPress 5.5 brings more than 1,500 useful improvements to the block editor experience.&nbsp;</p>



<p>To see all of the features for each release in detail check out the release posts: <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v7.5.0\">7.5</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v7.6.0\">7.6</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v7.7.0\">7.7</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v7.8.0\">7.8</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v7.9.0\">7.9</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v8.0.0\">8.0</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v8.1.0\">8.1</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v8.2.0\">8.2</a>, <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v8.3.0\">8.3</a>, and <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v8.4.0\">8.4</a>.</p>



<h2><strong>Wait! There’s more!</strong></h2>



<h3><strong>XML sitemaps</strong></h3>



<p><a href=\"https://make.wordpress.org/core/2020/06/10/merge-announcement-extensible-core-sitemaps/\">XML Sitemaps are now included in WordPress</a> and enabled by default. Sitemaps are essential to search engines discovering the content on your website. Your site&#8217;s home page, posts, pages, custom post types, and more will be included to improve your site&#8217;s visibility.</p>



<h3><strong>Auto-updates for plugins and themes</strong></h3>



<p><a href=\"https://make.wordpress.org/core/tag/core-auto-updates/\">WordPress 5.5 also brings auto-updates for plugins and themes</a>. Easily control which plugins and themes keep themselves up to date on their own. It&#8217;s always recommended that you run the latest versions of all plugins and themes. The addition of this feature makes that easier than ever!</p>



<h3><strong>Lazy-loading images</strong></h3>



<p><a href=\"https://make.wordpress.org/core/2020/04/08/lazy-loading-of-images-is-in-core/\">WordPress 5.5 will include native support for lazy-loaded images</a> utilizing new browser standards. With lazy-loading, images will not be sent to users until they approach the viewport. This saves bandwidth for everyone (users, hosts, ISPs), makes it easier for those with slower internet speeds to browse the web, saves electricity, and more.</p>



<h3><strong>Better accessibility</strong></h3>



<p>With every release, WordPress works hard to improve accessibility. Version 5.5 is no different and packs a parcel of accessibility fixes and enhancements. Take a look:</p>



<ul><li>List tables now come with extensive, alternate view modes.</li><li>Link-list widgets can now be converted to HTML5 navigation blocks.</li><li>Copying links in media screens and modal dialogs can now be done with a simple click of a button.</li><li>Disabled buttons now actually look disabled.</li><li>Meta boxes can now be moved with the keyboard.</li><li>A custom logo on the front page no longer links to the front page.</li><li>Assistive devices can now see status messages in the Image Editor.</li><li>The shake animation indicating a login failure now respects the user&#8217;s choices in the <code>prefers-reduced-motion</code> media query.</li><li>Redundant <code>Error:</code> prefixes have been removed from error notices.</li></ul>



<h2><strong>Miscellaneous Changes</strong></h2>



<ul><li>Plugins and themes can now be updated by uploading a ZIP file.</li><li><a href=\"https://make.wordpress.org/core/2020/06/26/wordpress-5-5-better-fine-grained-control-of-redirect_guess_404_permalink/\">More finely grained control of redirect_guess_404_permalink()</a>.</li><li><a href=\"https://make.wordpress.org/core/2020/07/01/external-library-updates-in-wordpress-5-5-call-for-testing/\">Several packaged external libraries have been updated</a>, including PHPMailer, SimplePie, Twemoji, Masonry, and more!</li></ul>



<p>Keep your eyes on the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/5-5+dev-notes/\">5.5-related developer notes</a> in the coming weeks, breaking down these and other changes in greater detail.</p>



<p>So far, contributors have fixed more than <a href=\"https://core.trac.wordpress.org/query?status=closed&milestone=5.5&group=component&max=500&col=id&col=summary&col=owner&col=type&col=priority&col=component&col=version&order=priority\">360 tickets in WordPress 5.5</a>, including <a href=\"https://core.trac.wordpress.org/query?status=closed&status=reopened&type=enhancement&milestone=5.5&or&status=closed&status=reopened&type=feature+request&milestone=5.5&col=id&col=summary&col=type&col=status&col=milestone&col=owner&col=priority&col=changetime&col=keywords&order=changetime\">157 new features and enhancements</a>, and more bug fixes are on the way.</p>



<h2><strong>How You Can Help</strong></h2>



<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help translate WordPress into more than 100 languages</a>!</p>



<p>If you think you’ve found a bug, please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. We would love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. That’s also where you can find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>



<p class=\"has-small-font-size\"><em>Props to <a href=\"https://profiles.wordpress.org/webcommsat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>webcommsat</a>, <a href=\"https://profiles.wordpress.org/yvettesonneveld/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yvettesonneveld</a>, <a href=\"https://profiles.wordpress.org/estelaris/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>estelaris</a>, and <a href=\"https://profiles.wordpress.org/marybaum/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>marybaum</a> for compiling/writing this post, <a href=\"https://profiles.wordpress.org/davidbaumwald/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>davidbaumwald</a> for editing/proof reading, and <a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a>, <a href=\"https://profiles.wordpress.org/desrosj/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>desrosj</a>, and <a href=\"https://profiles.wordpress.org/andreamiddleton/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>andreamiddleton</a> for final review.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Jul 2020 21:49:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: Goodbye, ManageWP.org; Hello, WP Content\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101545\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"https://wptavern.com/goodbye-managewp-org-hello-wp-content?utm_source=rss&utm_medium=rss&utm_campaign=goodbye-managewp-org-hello-wp-content\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3983:\"<p class=\"has-drop-cap\">Yesterday, Iain Poulson and Ashley Rich launched community-curated, news-sharing site <a href=\"https://wpcontent.io/\">WP Content</a>. The launch comes on the heels of <a href=\"https://managewp.org/\">ManageWP.org</a> shutting down its own news-sharing service and the WordPress community losing out on a valuable resource.</p>



<p>Both Poulson and Rich are based in the UK and work for <a href=\"https://deliciousbrains.com/\">Delicious Brains</a>, a development company that focuses on building products for WordPress. Their new venture was met with enthusiasm when Poulson first <a href=\"https://twitter.com/polevaultweb/status/1280061239440408576\">announced it on Twitter</a>.</p>



<img />Homepage of WPContent.io.



<p>Long before I was a writer for WP Tavern and needed to keep an eye out for the latest news, ManageWP.org was one of my go-to sources for catching up with everything happening in the WordPress community. There is always so much going on that even the Tavern cannot stay on top of it all. ManageWP.org helped me become a voracious reader of ideas, tutorials, and other news within the industry. For that, I am certain I owe the team a debt that cannot be repaid.</p>



<p>After shutting the doors, they left us with a message on the site that read, &ldquo;After many years of serving the WordPress community, we&rsquo;ve made the difficult decision to shut down ManageWP.org. Several factors led us here, but it ultimately came down to the team being unable to give ManageWP.org the attention it deserves.&rdquo;</p>



<p>It is only the news-sharing site at ManageWP.org that is shutting down.  The ManageWP.com company and service are still alive and well.</p>



<p><a href=\"https://wptavern.com/managewp-launches-community-curated-wordpress-news-site\">ManageWP.org launched</a> when WordPress held a mere 20% of the web back in 2013. <a href=\"https://wptavern.com/godaddy-acquires-wordpress-site-management-service-managewp\">GoDaddy acquired the ManageWP company</a> in 2016 but allowed it to operate independently, including the news-sharing site. In many ways, ManageWP.org felt as much a part of the identity of the WordPress community as our site. For seven years, users have shared articles, upvoted their favorites, and found a legitimate source to stay informed on a wide range of topics around WordPress.</p>



<p>&ldquo;Thank you to everyone who shared inspiring stories, useful resources, and special announcements with us,&rdquo; read the final message on the site. &ldquo;It&rsquo;s been a treat.&rdquo;</p>



<p>While many of us were disappointed to see the site shut down, sometimes it is time for something new. We can say goodbye to a great service and make room for someone else to take up the mantle. So, goodbye, ManageWP.org. Thanks for all the good years. And, welcome, WP Content.</p>



<p>&ldquo;After @managewp closed down their community news site, we felt there should be a place where the #WordPress community can submit articles and up vote them,&rdquo; <a href=\"https://twitter.com/wpcontent_io/status/1280061061199204352\">tweeted the WP Content team</a>.</p>



<p>The newly-built WP Content site is simple to use. It works similarly to other sharing sites such as Reddit. Users can sign up for an account to share stories themselves or upvote other stories. All visitors are free to follow through and read stories without signing up.</p>



<p>The front page of the site shares the currently trending and most recent stories. The site also breaks stories down into the following categories:</p>



<ul><li>Business</li><li>Community</li><li>Development</li><li>Plugins</li><li>Security</li><li>Tutorials</li></ul>



<p>I welcome the new venture and am glad to see someone filling in what was quickly becoming a missing piece of our community. With luck, WP Content will serve as a great resource for many years to come. The team has some big shoes to fill, but they are off to a great start.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Jul 2020 18:31:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: WordCamp Attendance Badges Could Be a Good Thing, but That’s the Wrong Discussion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101557\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:223:\"https://wptavern.com/wordcamp-attendance-badges-could-be-a-good-thing-but-thats-the-wrong-discussion?utm_source=rss&utm_medium=rss&utm_campaign=wordcamp-attendance-badges-could-be-a-good-thing-but-thats-the-wrong-discussion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7030:\"<img />WordPress  profile badges.



<p class=\"has-drop-cap\">On July 3, Timi Wahalahti <a href=\"https://make.wordpress.org/community/2020/07/03/proposal-recognition-for-event-volunteers-and-attendees-in-wordpress-org-profile/\">opened a discussion on the Community WordPress blog</a> on whether WordCamp volunteers, WordCamp attendees, or Meetup attendees should be awarded a WordPress.org profile badge. The discussion stemmed from a nearly <a href=\"https://meta.trac.wordpress.org/ticket/3878\">two-year-old Meta ticket</a> that was recently resurfaced.</p>



<p>The general consensus from the comments on the post seems to be that volunteers should receive badges because they are making direct contributions to the community. Most argue that merely attending an event is not badge-worthy. There are also some technical concerns. However, they should not be a real issue considering we are a community of programmers and problem solvers.</p>



<p>I see the rationale behind not giving badges to attendees. In one way, it feels like it diminishes the badges that others have earned, quite often, through hours of valuable time freely given back to the project.</p>



<p>I am taking a wild guess here and will say that most people would agree that direct, measurable contributions should be rewarded. Whether it is contributing a patch to core, reviewing code as part of the Themes Team, or handing out sandwiches at your local WordCamp lunch line, you should be recognized for giving back to the community.</p>



<p><em>WordCamp attendance badges would become the participation trophies of the WordPress world.</em></p>



<p>I get the argument. I do. When I first read the community post, my gut reaction was to make that same argument.</p>



<p>In some parts of American culture, at least, <em>participation trophies</em> are often looked upon as something to be ashamed of &mdash; <em>if you don&rsquo;t earn MVP, it&rsquo;s not a real trophy</em>. I have seen the culture change, seemingly overnight, in my local community. Fathers will not allow their sons to accept a trophy for merely being on the football team (anyone deserves a trophy for making it through training camp in Alabama&rsquo;s sweltering August heat). I watch as community members &mdash; grown adults &mdash; tear down others&rsquo; kids on Facebook over the same idea.</p>



<p>The discussion on WordCamp attendance badges feels much the same. However, the argument is valid only because that is how the system is set up. It was created to award based on merit. The awards go to those who put in the time and effort, typically over the long haul.</p>



<p>On the surface, that feels like a good system. However, other systems have benefits that perhaps our community has been overlooking, particularly those that gamify participation. Currently, WordPress profile badges are not being utilized to their full potential. The missing piece is that we are not encouraging more participation. We are not helping the first-time user level up and earn more badges/awards.</p>



<img />NaNoWriMo writing and personal achievement badges.



<p class=\"has-drop-cap\">In 2018, I successfully completed <a href=\"https://nanowrimo.org/\">National Novel Writing Month</a> (NaNoWriMo). It is an event where thousands of people go through the insane process of writing a 50,000-word novel in 30 days. One of the things that pushed me through the month, aside from sheer willpower and encouragement from family and friends, was the encouragement from the NaNoWriMo website itself.</p>



<p>The website has two categories of badges. The first category is its writing badges. These badges are awarded based on actually doing work. They are also awarded in stages. Write for a two-day streak. Earn a badge. Surpass 5,000 words. Earn a badge. Finish the month-long challenge. Earn a badge. Throughout the process of NaNoWriMo, earning these writing badges was a big motivator toward keeping the dream of writing a novel alive. If I wasn&rsquo;t motivated to write on a particular day, I could look at the next badge I would earn by just putting pen to paper for another half hour or so.</p>



<p>The thing about these writing badges that was so important was not that they gave me any bragging rights. The badges were not for showing other people how awesome I was. They were deeply personal. They were things that helped motivate me to continue on. <em>OK, I did brag about them a little bit.</em></p>



<p>At the end of the day, these achievement-based badges were not about other people. They made me feel good about myself, and that is what mattered.</p>



<p>NaNoWriMo&rsquo;s second category was for personal badges. They were not awarded for any achievement. Every user on the site could pick and choose the badges they wanted. They were reflections of the person. It told others a little something about you.</p>



<p>One of my favorite badges was the &ldquo;pantser&rdquo; badge. It let people in the NaNoWriMo community know that I was writing without a novel outline or any real plan &mdash; literally by the seat of my pants. Others would choose the &ldquo;planner&rdquo; or even the combo &ldquo;plantser&rdquo; badge. And, the site had several other badges that simply added to the fun.</p>



<p>We do not have to think about badges as something that must be awarded based on hard work. Sure, we should have those &ldquo;gold level&rdquo; badges that are earned through direct contributions and being on a particular team. Joining the Documentation Team or submitting a plugin to the official plugin directory is a big deal. Those achievements should be shown on your profile. However, they are not the only achievements that matter.</p>



<p>Remember that badges are sometimes personal. Being awarded for even the smallest of things can help build the confidence that some people need to do that second small thing.</p>



<p>Simple badges for asking or answering your first support forum question could be a great motivator to become more involved. Attending a WordCamp for the first time? Get a badge. That might help motivate you to earn the five-time WordCamp attendee badge next.</p>



<p>I would even love to see badges for individual WordCamps. How cool would it be for someone to earn a badge for attending a WordCamp in every corner of the world? Or just on one continent?</p>



<p>There is so much lost potential with the current badge system. We are having the wrong discussion. Whether someone should earn a badge for attending a WordCamp is too narrow of a focus. Let&rsquo;s start looking at how we can gamify participation in the WordPress community and use that system to get more people involved.</p>



<p>If we maintain the current system of giving badges only for contributions and teams, yeah, WordCamp volunteers should get those. Attendees have done nothing to earn a badge in that system. That seems like an easy call to make and not worth much discussion. But, since we are here, let&rsquo;s rethink this whole thing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Jul 2020 18:42:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WordProof Wins €1 Million Grant to Advance Blockchain Timestamping Concept\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101541\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:213:\"https://wptavern.com/wordproof-wins-e1-million-grant-to-advance-blockchain-timestamping-concept?utm_source=rss&utm_medium=rss&utm_campaign=wordproof-wins-e1-million-grant-to-advance-blockchain-timestamping-concept\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2423:\"<p><a href=\"https://wordproof.io/\">WordProof</a>, the company behind the <a rel=\"noreferrer noopener\" href=\"https://wordpress.org/plugins/wordproof-timestamp/\" target=\"_blank\">WordProof Timestamp</a>&nbsp;plugin for WordPress, has received a &euro;1 million grant from the European Commission as the reward for winning a competition called &ldquo;<a href=\"https://ec.europa.eu/research/eic/index.cfm?pg=prizes_blockchains\">Blockchains for Social Good</a>.&rdquo; The Dutch startup beat 175 other participants from around Europe.</p>



<p>The competition was designed to reward developers&rsquo; efforts in exploring decentralized applications of blockchains for social innovation. WordProof was one of five finalists selected to receive &euro;1 million, after submitting its <a href=\"https://wordproof.io/timestamp-ecosystem/\">Timestamp Ecosystem</a> concept, which seeks to increase transparency and accountability by proving authenticity of content on the web. In addition to its WordPress plugin, the timestamping ecosystem aims to provide solutions for other content management platforms, e-commerce, and social media. </p>



<p>WordProof founder Sebastiaan van der Lans said the grant is evidence of the company gaining traction with governments and universities.</p>



<p>&ldquo;With the recognition and financial support from Europe, we can roll out the Timestamp Ecosystem at a higher pace and make WordProof grow even faster as a company,&rdquo; Van der Lans said. &ldquo;This will enable Europe to define the standard for a reliable Internet for consumers and organisations.&rdquo; </p>



<p>Van der Lans said WordProof is still very much &ldquo;a WordPress-focused company&rdquo; and plans to use the funds to extend its timestamping plugin to work with WooCommerce. They also plan to begin working with major publishers and WooCommerce shops to integrate timestamping solutions. The company began working with Yoast two months ago on deeply integrating with Schema.org to provide <a href=\"https://wordproof.io/features/structured-data-for-seo/\">structured data for SEO</a>.</p>



<p>In the coming weeks, van der Lans said the company plans to announce &ldquo;a significant investment from the WordPress space.&rdquo; WordProof is currently focused on advocacy with/at the European Commission to make timestamping an open source standard that would be independent from the control of any single company.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Jul 2020 15:32:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"Akismet: Akismet Blocks Five Hundred Billion Spam and Counting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=2075\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://blog.akismet.com/2020/07/06/akismet-five-hundred-billion-with-a-b-spam/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1165:\"<p><img /></p>
<p>It was happening while you ate dinner. While you were at work. While you were on vacation, going for a walk, or daydreaming. It was certainly happening while you were sleeping. All this time — for nearly 15 years — Akismet has been catching and blocking spam from appearing on websites and forums the world over, and Akismet just reached an important milestone: over 500 billion pieces of spam blocked, <a href=\"https://akismet.com/#countUp\">and counting.</a></p>
<h2>Saving countless hours for you</h2>
<p>Think about that number: five hundred billion spam comments blocked — and not just on WordPress sites! Akismet has been ensnaring spam on other platforms including Drupal, Joomla, <a href=\"https://akismet.com/development/api/#use-a-library\">and more</a>, saving countless hours of moderation time and frustration for millions of people around the world.</p>
<h2>To the future!</h2>
<p>If you need spam protection for your website or forum, Akismet is here to help. Free up time spent tweezing spam comments and allow Akismet to <a href=\"https://akismet.com/plans/\">catch and block it for you</a>. Here’s to the next 500 billion!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Jul 2020 15:12:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Christopher Finke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: New Block-based Navigation and Widgets Screens Sidelined for WordPress 5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101460\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:213:\"https://wptavern.com/new-block-based-navigation-and-widgets-screens-sidelined-for-wordpress-5-5?utm_source=rss&utm_medium=rss&utm_campaign=new-block-based-navigation-and-widgets-screens-sidelined-for-wordpress-5-5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2698:\"<p>The new navigation block and navigation and widget screens that were originally planned for WordPress 5.5 have been <a href=\"https://make.wordpress.org/core/2020/07/02/editor-features-for-wordpress-5-5-update/\">pushed back</a> to the next release. These projects are currently available in the&nbsp;<a href=\"https://make.wordpress.org/core/files/2020/05/experiments.png\">Gutenberg plugin</a>&nbsp;<a href=\"https://make.wordpress.org/core/files/2020/05/experiments.png\">experiments screen</a> but are not yet ready to land in core. </p>



<p>Converting the widget-editing areas and updating the widgets UI to use the block editor is a project that has been under development since <a href=\"https://github.com/WordPress/gutenberg/issues/13204\">January 2019</a>. The issue tracking the project and the dedicated project board seemed to have stalled out for the time being, so <a href=\"https://github.com/WordPress/gutenberg/issues/13204#issuecomment-647171426\">core editor contributors recommended removing it</a> from the priority features for 5.5.</p>



<p>Similarly, the navigation block and screen have several dozen outstanding <a href=\"https://github.com/WordPress/gutenberg/labels/%5BBlock%5D%20Navigation\">issues</a> and discussions that need more time before shipping.</p>



<p>&ldquo;We&rsquo;re still missing a few key components: drag and drop in the block and in the sidebar, a couple of PRs that lag and are important for feature parity (<a href=\"https://github.com/WordPress/gutenberg/pull/22600\">#22600</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/pull/22697\">#22697</a>) and the ongoing work to support more block types in Navigation,&rdquo; WordPress contributor Andrei Draganescu <a href=\"https://github.com/WordPress/gutenberg/issues/22931#issuecomment-645209108\">said</a> regarding the remaining items necessary to ship the navigation screen.</p>



<p>&ldquo;I believe we&rsquo;re in a place where a Gutenberg release after 5.5 will include this new screen, but maybe in the next two weeks some acceleration will occur and prove me wrong.</p>



<p>&ldquo;I believe that it is wiser that this lands as a part of the plugin first, gets some feedback, and then is shipped into core.&rdquo;</p>



<p>Despite the navigation and widgets screens getting removed from the 5.5 milestone, this release is set to deliver an impressive array of new features for the block editor, including block patterns, block directory search, a new block inserter panel, expanded design tools, and improvements to block movement capabilities.  <a href=\"https://make.wordpress.org/core/5-5/\">Beta 1 is expected July 7</a> and the target date for the official release is August 11.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Jul 2020 20:54:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Google Launches Beta of AMP-Powered Web Stories Plugin for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101451\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:201:\"https://wptavern.com/google-launches-beta-of-amp-powered-web-stories-plugin-for-wordpress?utm_source=rss&utm_medium=rss&utm_campaign=google-launches-beta-of-amp-powered-web-stories-plugin-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5921:\"<p class=\"has-drop-cap\">Google announced a public beta of its new Web Stories WordPress plugin this week. The plugin&rsquo;s description aptly reads, &ldquo;Visual storytelling for WordPress.&rdquo; It is essentially a custom editor for creating AMP-powered stories within WordPress.</p>



<p>Users can download the beta plugin directly from the <a href=\"https://google.github.io/web-stories-wp/beta/\">Web Stories beta page</a>. Developers who want to contribute or take a look under the hood can do so from its <a href=\"https://github.com/google/web-stories-wp\">GitHub repository</a>.</p>



<p><a href=\"https://amp.dev/about/stories/\">Web Stories</a> is a story format born out of Google&rsquo;s AMP Project. The goal is to provide visually-rich stories through a mobile-focused format. Stories are used to deliver news and other information in chunks that site visitors can quickly tap through and consume.</p>



<p>With far more users browsing the web via a mobile device in 2020 than just a few short years ago, many no longer engage with content in the same way. People are more likely to quickly browse a lot of content but not be willing to dive quite as deep into the details. The Web Stories format focuses on that user experience by creating bite-sized pieces of content that users can move through without much focus &mdash; <em>whether that is a good thing for society is up for debate</em>.</p>



<ul><li class=\"blocks-gallery-item\"><img /></li><li class=\"blocks-gallery-item\"><img /></li><li class=\"blocks-gallery-item\"><img /></li><li class=\"blocks-gallery-item\"><img /></li></ul>Screenshots from a Story template.



<p>The story format also typically makes more use of visual information than it does text. Each <em>page</em> of a story tends to use images or videos, often in the background with text overlaid, to grab the viewer&rsquo;s attention. However, there are no hard rules on what content a story page can present.</p>



<p>The Web Stories plugin is slated for an official release sometime late this summer. The team is working toward stabilizing the product and focusing on bug and performance fixes, according to the beta launch page.</p>



<p>In late March, the development team removed support for Stories from version 1.5 of the AMP plugin. They were prepping for the release of the new Web Stories plugin. The Stories feature was listed as a beta feature in the AMP plugin before removal.</p>



<p>Stories support was originally <a href=\"https://wptavern.com/wordpress-amp-plugin-version-1-2-introduces-gutenberg-powered-amp-stories-editor\">added to the official AMP plugin</a> in June 2019 as part of its version 1.2 release. It was a direct integration with the WordPress block editor. However, it has since changed drastically. The development team has created a custom system outside of WordPress&rsquo;s primary editor that offers a true what-you-see-is-what-you-get experience.</p>



<h2>Getting to Know the Web Stories Plugin</h2>



<p class=\"has-drop-cap\">Web Stories for WordPress takes an almost completely custom approach to creating content with WordPress. It has its own drag-and-drop editor, a dashboard for editing stories and finding templates, and custom URLs.</p>



<p>The development team decided to register a custom &ldquo;web story&rdquo; post type as the foundation of the plugin. One benefit of this system is that stories can live on their individual pages on the site. This also allows site visitors to subscribe to stories via a feed reader or third-party email system. Instead of pigeon-holing everything into a custom block, the team gained full freedom over the experience by creating a custom story-publishing process on top of the post type system.</p>



<p>In many ways, the editor feels much like working with a simplified version of a photo editor such as Photoshop or GIMP. In the center of the screen is the canvas. Users can work on the current story page, create new pages, or use the arrows to flip through each.</p>



<img />Creating a story with the Web Stories editor in WordPress.



<p>Two boxes are aligned to the right of the screen. The top box holds the Design and Document tabs. The Design tab allows users to edit options for the currently-selected layer, and the Document tab holds the configuration options for publishing. The Layers box sits below. It lets users quickly select a layer to edit.</p>



<p>On the left side of the screen, users have quick access to their media library. Because stories primarily use visually-driven content, it makes sense to keep media a simple mouse movement away.</p>



<p>The only major problem that I ran into when playing around with the story editor was figuring out how to delete a layer. I eventually realized that I could drag a layer off the canvas and it would disappear. That was probably the least intuitive part of the experience.</p>



<p>Web Stories comes with its own Dashboard screen in the admin. While the normal &ldquo;All Stories&rdquo; screen created by the post type exists, the Dashboard provides a visual list of created stories that users can scroll through.</p>



<img />Web Stories Dashboard screen.



<p>For users who are short on ideas or simply need a jumping-off point, the plugin currently supplies eight starter templates to choose from:</p>



<ul><li>Beauty</li><li>Cooking</li><li>DIY</li><li>Entertainment</li><li>Fashion</li><li>Fitness</li><li>Travel</li><li>Wellbeing</li></ul>



<p>The templates offer ample variety to begin learning the system by customizing the various story pages. The editor should be intuitive enough for most users to hit the ground running, but the templates make for some quick inspiration.</p>



<p>Overall, Web Stories looks like it will land with a splash late this summer. It is a showcase of what is possible when you put together a team of top-notch developers and empower them to build something amazing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Jul 2020 18:56:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: WordPress Contributors Seek Sponsorship for Improving Gutenberg Developer Docs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101393\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:221:\"https://wptavern.com/wordpress-contributors-seek-sponsorship-for-improving-gutenberg-developer-docs?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-contributors-seek-sponsorship-for-improving-gutenberg-developer-docs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9083:\"<p>WordPress developers <a href=\"https://developerka.org/\">Milana Cap</a> and <a href=\"https://jonathanbossenger.com/\">Jonathan Bossenger</a> are starting a fundraiser for improving Gutenberg developer documentation. The conversation began yesterday when Cap tweeted about how documentation is often overlooked when companies hire full-time contributors to work on WordPress.</p>



<div class=\"wp-block-embed__wrapper\">
<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">I wish someone pay people to work on Gutenberg Docs. All devs who understand Gutenberg are working on building it and no one has the time to document it. <br /><br />On the other hand, Gutenberg and React are so foreign to WordPress PHP devs that no one is being able to learn it. <a href=\"https://t.co/iFmpd24TwH\">https://t.co/iFmpd24TwH</a></p>&mdash; Milana Cap (@DjevaLoperka) <a href=\"https://twitter.com/DjevaLoperka/status/1277966252623794179?ref_src=twsrc%5Etfw\">June 30, 2020</a></blockquote>
</div>



<p>&ldquo;When your community is unable to learn your software then you have no contributors,&rdquo; Cap said. &ldquo;Documentation and tutorials are far more important for Open Source Software projects than people realize.&rdquo;</p>



<p>The first time Cap began asking for Gutenberg documentation was at the Community Summit in Paris, 2017. She has been trying to direct the community&rsquo;s attention to it since then. </p>



<p>&ldquo;There are many holes in block editor documentation for developers but the most obvious one is how to start,&rdquo; Cap said. &ldquo;The beginning of <a href=\"https://developer.wordpress.org/block-editor/developers/\">documentation for developers</a> doesn&rsquo;t say anything about getting started. &ldquo;It says only what you can do with a block but not _how_. Junior developers, PHP-only developers and anyone for whom is that documentation meant, doesn&rsquo;t know how a block&rsquo;s code looks, where to put it, how to include it, etc, let alone how to build a custom block with custom components and settings.&rdquo;</p>



<p>Part of the challenge of documenting the block editor is that it is under active development. Enhancements and refinements are constantly pushed out to the Gutenberg plugin and keeping track of what is or is not currently available in core is not always easy. As WordPress is imminently <a href=\"https://wptavern.com/gutenberg-8-4-adds-image-editing-includes-multi-block-controls-and-enables-block-directory-search\">introducing block directory search</a>, it is a good time to formalize block creation documentation.</p>



<p>&ldquo;Code examples are alarmingly missing all over docs,&rdquo; Cap said. &ldquo;The most basic examples exist but how to actually build something usable is missing. So, on this first page we are sent to a tutorial but that tutorial is not optimized for people who have never built a block before. Following it, I have and will fail to build the block.&rdquo;</p>



<p>Marcus Kazmierczak and a team of documentation contributors are attempting to rebuild the tutorial in the official block editor handbook. A GitHub <a href=\"https://github.com/WordPress/gutenberg/issues/22151\">issue</a> focused on addressing gaps in the current developer documentation is home to an active discussion about the best way to rewrite the docs for people who are new to block development.</p>



<p>&ldquo;This is a very good start but there&rsquo;s still a lot of work to be done,&rdquo; Cap said. &ldquo;Complete documentation is written by people who know and understand React and Gutenberg but are &lsquo;cursed with knowledge.&rsquo; They don&rsquo;t have much time to spend on understanding just how much others don&rsquo;t know and in what detail documentation should be written. To be honest, I don&rsquo;t think they should spend their time on that. We have a Documentation Team and we are willing to jump in but some sort of bridge is necessary.&rdquo;</p>



<h2>The Problem with Gutenberg Developer Documentation: It&rsquo;s Not Friendly for Newcomers</h2>



<p>&ldquo;The &lsquo;problem&rsquo; as I see it with the block editor documentation is that, unlike other WordPress documentation, it is written for experienced JavaScript developers, and not aimed at beginners,&rdquo; Bossenger said. &ldquo;I should also point out, this is by no means a shot at the folks who have put the current documentation together, and I appreciate any and all work they have done so far, it&rsquo;s just in serious need of a review and some refinement.&rdquo;</p>



<p>Bossenger said in the past WordPress made it very easy for anyone with a limited amount of PHP knowledge to quickly build a plugin or theme using action and filter hooks. It was easy to look at the code and understand what it was supposed to do.</p>



<p>&ldquo;Modern JavaScript, and specifically React, is a very different kettle of fish,&rdquo; Bossenger said. &ldquo;It requires a deeper level of knowledge of how React works, including new terminology and practices. Modern JavaScript can also be very confusing, especially if this is the first time you&rsquo;re seeing things like arrow functions, or less verbose if statements.</p>



<p>&ldquo;If the closest you have come to working with JavaScript in WordPress has been using jQuery, switching to React based Gutenberg development still requires some learning on your part.&rdquo;</p>



<p>After taking two courses before he could build anything for the editor, one on React and one on Gutenberg, Bossenger said the current Block Editor handbook is not written for developers with no experience in React and modern JavaScript. He believes it needs a restructuring to better explain new concepts and fit a pattern that is easier for a newcomer to consume. He highlighted the <a href=\"https://developer.wordpress.org/plugins/\">Plugin Developer handbook</a> as an example where the chapters follow a structure and use terminology that is more like a text book, slowly introducing the reader to new concepts.</p>



<p>&ldquo;I would argue that it would be quite possible for someone with no plugin or PHP knowledge, armed with this handbook and Google, to build a simple plugin to meet their specific requirements quite quickly,&rdquo; Bossenger said. &ldquo;Currently the block editor handbook is not conducive to this.&rdquo;</p>



<p>Bossenger is not alone in his opinion of the current documentation. Peter Tasker at Delicious Brains recently published a tutorial on <a href=\"https://deliciousbrains.com/custom-gutenberg-block/\">creating a custom Gutenberg block</a>. Even after working with React full-time for the past year, he found the official block editor docs to be &ldquo;kind of all over the place&rdquo; and difficult to parse.</p>



<p>After Cap commented about the lack of companies sponsoring full-time work on documentation, Bossenger tested the waters with a tweet asking if the two of them might be able to raise funds for improving Gutenberg docs.</p>



<div class=\"wp-block-embed__wrapper\">
<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Anyone willing to sponsor <a href=\"https://twitter.com/DjevaLoperka?ref_src=twsrc%5Etfw\">@DjevaLoperka</a> or myself improving the Gutenberg docs? Please RT for reach. <a href=\"https://t.co/UzYlFIfNZ8\">https://t.co/UzYlFIfNZ8</a></p>&mdash; Jonathan Bossenger (@jon_bossenger) <a href=\"https://twitter.com/jon_bossenger/status/1278004589334323200?ref_src=twsrc%5Etfw\">June 30, 2020</a></blockquote>
</div>



<p>&ldquo;Just the same as Block Editor Team (and any other Make team), the Documentation Team is understaffed,&rdquo; Cap said. &ldquo;We can&rsquo;t afford to dedicate few members to first learn and then write documentation on developing with block editor. This is the main reason for my tweet. You&rsquo;ll see sponsored contributors all over core but not in documentation and I&rsquo;ll dare to say that both are equally important.&rdquo;</p>



<p>Before launching their fundraiser, Cap and Bossenger plan to go through the existing documentation, pinpoint obvious holes, and identify questions that remain unanswered for those who are new to developing for the block editor.  </p>



<p>&ldquo;Once we have a plan we can predict how much time is needed for each part,&rdquo; she said. &ldquo;With this plan, we will go in search for sponsors. I think there will be an option to donate even before that but nothing is certain at this point.&rdquo;</p>



<p>Blocks are the new frontier of WordPress development. Investing in solid documentation and tutorials for beginners could have a major impact on expanding the block ecosystem. This also indirectly benefits users as they end up with a more diverse directory of blocks to choose from when customizing their WordPress sites.</p>



<p>Bossenger and Cap are currently working on a plan for the docs ahead of announcing their fundraiser. In the meantime, anyone who wants to contribute to improving the block creation documentation can jump in on the GitHub <a href=\"https://github.com/WordPress/gutenberg/issues/22151\">discussion</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Jul 2020 21:07:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Decision Time: What Block Patterns Should Ship With WordPress 5.5?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101416\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:193:\"https://wptavern.com/decision-time-what-block-patterns-should-ship-with-wordpress-5-5?utm_source=rss&utm_medium=rss&utm_campaign=decision-time-what-block-patterns-should-ship-with-wordpress-5-5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6095:\"<img />Inserting the Numbered Features block pattern into the editor.



<p class=\"has-drop-cap\">The first beta release of WordPress 5.5 is mere days away. This test release is expected to ship on July 7, and it carries with it a slew of new features that have primarily been developed between Gutenberg 7.6 and 8.5. One of the more pressing decisions the development team has to make is which block patterns to include in the final release.</p>



<p>For the uninitiated, block patterns are a predefined configuration of multiple blocks. They provide end-users a way to quickly insert more complex layout <em>patterns</em> into the editor. Instead of piecing together multiple blocks, nesting them within the proper group container, and getting everything perfect, the user merely searches the pattern library and selects the pattern they prefer. It is then inserted into the editor where the user can edit the content, such as altering the default text or changing the media.</p>



<p>It is an ingenious solution to an otherwise complicated problem. It also has the potential to move the block editor somewhat in the realm of actual page building.</p>



<p>For end-users, it could mean no longer spending hours learning how to recreate that pretty demo page that sold them on installing a specific theme. No more slogging through tutorials that feel like they were written for people with comp-sci degrees. Just click some buttons and watch the magic happen.</p>



<p>I have said that <a href=\"https://wptavern.com/block-patterns-will-change-everything\">block patterns will change everything</a>. I was patiently enthusiastic about the API when it first landed in <a href=\"https://wptavern.com/gutenberg-6-9-introduces-image-titles-block-patterns-and-new-theme-features\">Gutenberg 6.9</a>. I was downright giddy to play around with the first patterns that shipped with <a href=\"https://wptavern.com/gutenberg-7-7-ships-refreshed-ui-and-first-iteration-of-block-patterns\">Gutenberg 7.7</a>.</p>



<p>Outside of a few that have made their way into Gutenberg in recent versions, I have not been particularly ecstatic about the default patterns the development team has included. In my mind, most were always test cases, patterns meant to iron the bugs out of the system. Then, some of the world-class designers we have in the WordPress ecosystem would design a handful of solid default patterns. I fully expect theme authors to push the limits of the system, but I was hoping that WordPress would use this opportunity to showcase what the block system can really do.</p>



<p>The closest that Gutenberg has come to shipping useful, modern block patterns have been its Testimonials, Numbered Features, and Features and Services patterns. These three were <a href=\"https://github.com/WordPress/gutenberg/pull/23608\">initially set on the chopping block</a> (Testimonials have since been re-added), ready for the ax before WordPress 5.5 goes out to millions of users who could use such features instead of the tired and old solution of theme options. If these go, block patterns will likely land with a thud instead of the flash and bang the feature could make. We need to get users excited. We need to inspire the multitude of theme authors to build something greater &mdash; <em>hey, look what you can do with this feature</em>. Our development community needs to stand upon the shoulders of giants rather than feel like they are building from scratch.</p>



<p>We should not be afraid to be bold with the &ldquo;1.0&rdquo; of block patterns.</p>



<p>For the most part, with the latest patch on a ticket that is currently in flux, the team has nixed all but the least mundane patterns.</p>



<p>Block patterns are meant to represent common design layouts and configurations that we see around the web today. However, the current crop of patterns does not do justice to the idea. From the developer end of things, it is a powerful API. From the user side of things, it will feel like another half-baked plan to push in an unfinished feature before the deadline.</p>



<p>Maybe I am impatient. Maybe I need to get on board the ship-early-and-iterate-often train. But, the API has been in Gutenberg since November 2019. It is hard not to feel a little disappointed at the potential removal of the most opinionated patterns. They were the ones that I was eagerly awaiting to use. We can already easily put two images, columns of text, or buttons next to each other. The proposed patterns to ship with 5.5 do not feel like they will help users build the type of complex layouts the feature was meant to solve.</p>



<p>My rallying call, my plea to include some patterns with a little pizzazz in WordPress 5.5, might be cutting it close to the 11th hour. However, anyone eagerly awaiting this feature may have been as blindsided as I was yesterday when the pull request came down the pipeline to remove all but three basic patterns.</p>



<p>I want the narrator in the upcoming WordPress 5.5 release video to have a bit of pep in his voice instead of trying to give the hard sell on sticking two images next to each other.</p>



<p>I am not asking for complex pricing tables, a restaurant menu, or &mdash; <em>God, forbid</em> &mdash; a slider pattern. Those things are a bit more niche and not suitable for core. There is some middle ground we can meet, offering something of a bit more substance. And, if we cannot meet that middle ground, is the feature ready?</p>



<p>I&rsquo;m the last person to suggest pulling the feature from the release, so I won&rsquo;t venture down that dark path. I want block patterns. I want them now.</p>



<p>I do question whether we should ship such basic patterns with most users having to wait months for anything more useful. That&rsquo;s unless their theme authors are generous enough to push out some new patterns between the major release cycles.</p>



<p>I am just a WordPress user asking to be amazed. Whet our appetites for a future where block patterns are everything.</p>



<p>What patterns would you like to see ship with WordPress 5.5?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Jul 2020 18:33:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WordPress.org blog: The Month in WordPress: June 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=8614\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2020/07/the-month-in-wordpress-june-2020/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7862:\"<p>June was an exciting month for WordPress! Major changes are coming to the Gutenberg plugin, and WordCamp Europe brought the WordPress community closer together. Read on to learn more and to get all the latest updates.&nbsp;</p>



<hr class=\"wp-block-separator\" />



<h2>WordPress 5.4.2 released</h2>



<p>We said hello to WordPress 5.4.2 on June 10. This security and maintenance release features 17 fixes and 4 enhancements, so we recommend that you update your sites immediately. To download WordPress 5.4.2, visit your Dashboard, click on <strong>Updates</strong>, then <strong>Update Now</strong>, or download the latest version directly from WordPress.org. For more information, visit <a href=\"https://wordpress.org/news/2020/06/wordpress-5-4-2-security-and-maintenance-release/\">this post</a>, review the <a href=\"https://core.trac.wordpress.org/query?status=closed&resolution=fixed&milestone=5.4.2&order=priority\">full list of changes on Trac</a>, or check out the <a href=\"https://wordpress.org/support/wordpress-version/version-5-4-2/\">HelpHub documentation page</a> for <a href=\"https://wordpress.org/support/wordpress-version/version-5-4-2/\">version 5.4.2</a>. WordPress 5.4.2 is a short-cycle maintenance release. The next major release will be <a href=\"https://make.wordpress.org/core/5-5/\">version 5.5</a>, <a href=\"https://wordpress.org/about/roadmap/\">planned for August 2020</a>. <br /><br />Want to get involved in building WordPress Core? Follow<a href=\"https://make.wordpress.org/core/\"> the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>



<h2>Gutenberg 8.3 and 8.4</h2>



<p>The core team launched Gutenberg <a href=\"https://make.wordpress.org/core/2020/06/11/whats-new-in-gutenberg-11-june/\">8.3</a> and <a href=\"https://make.wordpress.org/core/2020/06/24/whats-new-in-gutenberg-24-june/\">8.4</a> this month, paving the way for some exciting block editor features. Version 8.3 introduced enhancements like a reorganized, more intuitive set of block categories, a parent block selector, an experimental spacing control, and user-controlled link color options. Version 8.4 comes with new image-editing tools and the ability to edit options for multiple blocks.  The block directory search feature that was previously available as an experimental feature, is now enabled for all Gutenberg installations. For full details on the latest versions on these Gutenberg releases, visit these posts about <a href=\"https://make.wordpress.org/core/2020/06/11/whats-new-in-gutenberg-11-june/\">8.3</a> and <a href=\"https://make.wordpress.org/core/2020/06/24/whats-new-in-gutenberg-24-june/\">8.4</a>.</p>



<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the #core-editor channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>



<h2>WordPress Bumps Minimum Recommended PHP Version to 7.2</h2>



<p>In a major update, WordPress <a href=\"https://meta.trac.wordpress.org/changeset/9959\">has bumped</a> the minimum PHP recommendation to 7.2. The ServeHappy API has been updated to set the minimum acceptable PHP version to 7.2, while the WordPress downloads page recommends 7.3 or newer. Previously, the ServeHappy dashboard widget was showing the upgrade notice to users of PHP 5.6 or lower. This decision comes <a href=\"https://meta.trac.wordpress.org/ticket/5257\">after discussions with the core Site Health team and the Hosting team</a>, both of which recommended that the upgrade notice be shown to users of PHP &lt;=7.1.</p>



<h2>WordCamp Europe 2020 Moved Online</h2>



<p>Following the success of a remote WordCamp Spain, <a href=\"https://2020.europe.wordcamp.org/\">WordCamp Europe</a> was held fully online from June 4 to 6. The event drew a record 8,600 signups from people based in 138 countries, along with 2,500 signups for contributor day. WCEU Online also showcased 33 speakers and 40 sponsors, in addition to a Q&amp;A with Matt Mullenweg. You can find the videos of the event in WordPress.tv by <a href=\"https://wordpress.tv/event/wordcamp-europe-2020/\">following this link</a>, or you can catch the<a href=\"https://www.youtube.com/channel/UCaYQGYDpXpU4A17kxN-AgJQ\"> live stream recording of the entire event from the WP Europe YouTube Channel</a>.</p>



<p>Want to get involved with the Community team? <a href=\"https://make.wordpress.org/community/\">Follow the Community blog here</a>, or join them in the #community-events channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. To organize a Meetup or WordCamp, <a href=\"https://make.wordpress.org/community/handbook/virtual-events/welcome/applying-for-a-virtual-event/\">visit the handbook page</a>.&nbsp;</p>



<hr class=\"wp-block-separator\" />



<h2>Further Reading:</h2>



<ul><li>Josepha Haden (<a href=\"https://profiles.wordpress.org/chanthaboune/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chanthaboune</a>), the executive director of the WordPress project, <a href=\"https://wordpress.org/news/2020/06/equity-and-the-power-of-community/\">published a post </a>that highlights resources on how the global WordPress community can focus on equity to help dismantle racial, societal, and systemic injustice.&nbsp;</li><li>PHP, the primary programming language in which WordPress is written, celebrated its <a href=\"https://wptavern.com/php-marks-25-years\">25th anniversary</a> this month!</li><li>The Community team is<a href=\"https://make.wordpress.org/community/2020/06/18/pending-update-for-the-code-of-conduct/#comment-28294\"> updating the WordCamp code of conduct</a> to address discrimination based on age, caste, social class, and other identifying characteristics.</li><li>The WordPress Core team is promoting more inclusive language by <a href=\"https://make.wordpress.org/core/2020/06/18/proposal-update-all-git-repositories-to-use-main-instead-of-master/\">updating all git repositories to use `trunk` instead of `master`</a>. Additionally, the team proposes to <a href=\"https://make.wordpress.org/core/2020/06/24/proposal-rename-invalid-worksforme-and-wontfix-ticket-resolutions/\">rename&nbsp; “invalid,” “worksforme,” and “wontfix” ticket resolutions </a>to “not-applicable,” “not-reproducible” or “cannot-reproduce,” and “not-implemented,” respectively.&nbsp;</li><li>The Documentation team is working on an external linking policy and has <a href=\"https://make.wordpress.org/docs/2020/06/15/external-linking-policy-trusted-sources/\">started a discussion</a> on how to allow linking to trusted sources to benefit users.&nbsp;</li><li>The Core team has put up a proposal to <a href=\"https://make.wordpress.org/core/2020/06/10/merge-announcement-extensible-core-sitemaps/\">merge extensible core sitemaps to WordPress core</a> in the 5.5 release. The feature is currently available as a <a href=\"https://wordpress.org/plugins/core-sitemaps/\">feature plugin</a>.</li><li><a href=\"https://2020.denver.wordcamp.org/\">WordCamp Denver</a> was held online May 26–27. The event sold over 2,400 tickets and featured 27 speakers and 20 sponsors. You can catch the recorded live stream on the <a href=\"https://2020.denver.wordcamp.org/watch-now/\">event site</a>.</li><li>The Core team is working on <a href=\"https://make.wordpress.org/core/2020/06/29/updating-jquery-version-shipped-with-wordpress/\">updating the version of jQuery</a> used in WordPress core.</li></ul>



<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Jul 2020 05:52:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Build Static or Dynamic Blocks With the WP Block Builder Script\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101391\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:191:\"https://wptavern.com/build-static-or-dynamic-blocks-with-the-wp-block-builder-script?utm_source=rss&utm_medium=rss&utm_campaign=build-static-or-dynamic-blocks-with-the-wp-block-builder-script\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6728:\"<p class=\"has-drop-cap\">Today, Jeffrey Carandang released <a href=\"https://www.npmjs.com/package/wp-block-builder\">WP Block Builder</a>, an npm script for developers to begin building WordPress blocks. It is just one of many such scripts in a sea of block scaffolding tools, but Carandang may just have the experience and clout to rise above the rest. Thus far, developers have downloaded his custom setup over 500 times.</p>



<p>Developers wanting to take a peek under the hood can also check out the <a href=\"https://github.com/phpbits/wp-block-builder\">project on GitHub</a>.</p>



<p>It is almost impossible to dive into building blocks for WordPress without coming across some of Carandang&rsquo;s work in the WordPress block space. He <a href=\"https://wptavern.com/creator-of-editorskit-launches-community-block-sharing-site\">launched the ShareABlock community</a> late last year. He has paved the way for other developers by experimenting with ideas in <a href=\"https://wptavern.com/block-options-plugin-rebrands-to-editorskit-expands-beyond-block-visibility-management\">EditorsKit</a>. He co-founded CoBlocks, which <a href=\"https://wptavern.com/godaddy-acquires-themebeans-coblocks-block-gallery-and-block-unit-tests\">GoDaddy acquired in 2019</a>. And, that&rsquo;s just the tip of the <a href=\"https://wptavern.com/new-iceberg-plugin-brings-a-distraction-free-writing-experience-to-wordpress\">Iceberg</a> &mdash; <em>yeah, he is involved in that too</em>.</p>



<p>Now, he has decided to launch a block-building script in a field that is becoming increasingly crowded. Core WordPress <a href=\"https://www.npmjs.com/package/@wordpress/create-block\">has its own script</a>. WebDevStudios recently <a href=\"https://wptavern.com/webdevstudios-releases-block-scaffolding-tool-for-developers\">launched a custom fork</a> of that, and several others are floating around the WordPress ecosystem, each with slightly different takes on jump-starting the block-building process. However, when one of the experts in the world of WordPress blocks releases his own spin on getting developers set up, it is at least worth looking into.</p>



<p>&ldquo;I initially created this tool for myself because I kept repeating similar processes when creating Gutenberg blocks plugins,&rdquo; said Carandang. &ldquo;Then upon building it out, I thought it would be helpful to others if I release this to the public since, with minimal configuration, it would be easier to just focus on building blocks. Based on my experience, setting up the webpack config takes time and is sometimes frustrating.&rdquo;</p>



<p>Carandang has a plethora of experience in building blocks, so I am certain he has added all the small extras that help speed the development process along.</p>



<p>Unlike many similar scripts, WP Block Builder provides two example blocks by default. One is for handling the typical static content that is common with such scripts. However, the second is a dynamic, server-side block. This gives developers a taste of building two different block types with two sets of requirements to run. Other scripts also tend to be hyper-focused on launching a single-block plugin, which would be typical for releasing to the WordPress block directory. WP Block Builder provides a path to launching a plugin with multiple blocks if desired.</p>



<p>&ldquo;My goal is to make it easy for first-time block developers to create a block, but I&rsquo;ve also created a sample dynamic block for advanced users,&rdquo; said Carandang. &ldquo;This will provide a good playground for experimenting and familiarizing with each section of the block.&rdquo;</p>



<p>Carandang wants developers to be able to dive directly into building blocks. He wants to bring some of the fun back to experimenting without the technology getting in the way, which often means hours wasted just getting the build tools in place.</p>



<p>&ldquo;I&rsquo;m gearing towards that feeling I had when I first started creating a WordPress theme,&rdquo; he said. &ldquo;Those times when I was changing codes to know how they work and confident enough that I could just install it freshly again if I ended messing it up.&rdquo;</p>



<p>Carandang said he has not received any reported issues yet, so launch day is going off without a hitch. He is looking forward to seeing what blocks developers build in the future based on his setup.</p>



<p>&ldquo;It&rsquo;s aimed to be general enough to help developers to get started on creating block plugins immediately,&rdquo; he said. &ldquo;I&rsquo;m still waiting for some feedback to help improve the process, but so far it seems to be doing good.&rdquo;</p>



<h2>Setting Up a Block Plugin</h2>



<img />Dynamic block code from WP Block Builder.



<p class=\"has-drop-cap\">WP Block Builder is a fork of the core WordPress Create Block script. It includes a few extra npm packages, but it is also heavy on installing several PHP packages via Composer. These are primarily for making sure developers are following coding standards.</p>



<p>Setup is simple. Developers merely need to run the <code>npx wp-block-builder</code> command to kick start the process. Upon running the command, WP Block Builder takes developers through a series of questions, which sets up the following fields:</p>



<ul><li>Block slug</li><li>Namespace</li><li>Block title</li><li>Description</li><li>Author name</li><li>Plugin license</li><li>Version number</li></ul>



<p>After installation, the plugin will have two blocks ready for experimentation. The first block is a basic container with text and background color settings. It also supports wide and full alignment. It works similarly to the core WordPress Group block. I prefer this starting point over the standard paragraph block.</p>



<p>The second block is a dynamic posts list. It offers enough complexity to see how dynamic blocks work while using a concept familiar enough for most WordPress developers to grasp:  querying and looping through posts. The block has a single custom option for changing the number of posts.</p>



<p>The goal for making these two blocks available is to get plugin developers jumping head first into the code. Break things. Experiment. Study the code.</p>



<p>Long term, Carandang is hopeful the process will become even better for developers. &ldquo;I&rsquo;m in touch with Grzegorz Zi&oacute;&#322;kowski and Fabian K&auml;gy from the Gutenberg team,&rdquo; he said,&rdquo; and they are creating a better way to support external npm packages directly with <code>@wordpress/create-block</code>. This would be helpful in both Block Builder and Gutenberg, and would help in improving the Gutenberg plugin development ecosystem.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Jul 2020 20:31:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"WPTavern: Flywheel Relaunches Local Pro with Revamped Live Links and New Host-Agnostic Pre-Launch Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101113\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:251:\"https://wptavern.com/flywheel-relaunches-local-pro-with-revamped-live-links-and-new-host-agnostic-pre-launch-tools?utm_source=rss&utm_medium=rss&utm_campaign=flywheel-relaunches-local-pro-with-revamped-live-links-and-new-host-agnostic-pre-launch-tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5072:\"<p>Flywheel has relaunched <a href=\"https://localwp.com/pro/\">Local Pro</a>, the commercial upgrade for its free local WordPress development product. The first version of Local Pro, launched in July 2019, was heavily geared towards Flywheel customers, but the tool has gradually evolved to be more host-agnostic. This major update focuses on pre-launch features that allow developers to check links, optimize images, share a live link, and make changes with live reload.</p>



<p>&ldquo;We saw an opportunity to build new tools into Local that pivot away from focusing on Flywheel customers and towards solving common WordPress developer pain-points,&rdquo; Local product manager Jack Sellwood said.</p>



<p>&ldquo;Our focus from here will be helping developers with pre-launch tasks like gathering feedback, testing, and optimizing their site before they go-live.&rdquo;</p>



<p>More than 300,000 developers have tried Local since it first launched in 2017 and active users are up 90% year over year.</p>



<p>&ldquo;We attribute that increase &nbsp;to Local &lsquo;Lightning&rsquo; which is the more reliable, performant version of Local that we launched last year,&rdquo; Sellwood said.</p>



<p>This update also expands Local&rsquo;s MagicSync capabilities to include both Flywheel and WP Engine. MagicSync allows developers to push or pull the files and/or database from staging and production environments. It gives an overview of which files are different and includes controls for ignoring certain files.</p>



<img />



<p>&ldquo;We&rsquo;d love to bring this to other hosts and we continue to explore how to do that, but the biggest challenge in doing this is maintaining the same, quality experience Local users have come to expect from Local Connect,&rdquo; Sellwood said.</p>



<h2>Live Links Revamped, More Cloud-based Services Coming in 2021</h2>



<p>Local Pro also introduces a completely revamped solution for sharing local sites, built specifically for WordPress. For the past 12 months, the team has been building an alternative to ngrok to power its Live Links feature.</p>



<p>&ldquo;We explored a few ways to improve the existing Live Links experience and found that this was a core technology, and we needed to own the whole stack of technologies involved,&rdquo; Sellwood said. &ldquo;A similar notion pushed us to build Lightning, which gave us better insight and ability to tackle bugs. VirtualBox was a black hole.&rdquo;</p>



<img />



<p>Flywheel launched&nbsp;<a rel=\"noreferrer noopener\" href=\"http://hub.localwp.com/\" target=\"_blank\">hub.localwp.com</a>&nbsp;for users to manage their Local subscription for services like Live Links Pro that require a cloud component to function. The team plans to launch more later this year and in 2021.  The Local Hub is a Laravel project that connects to custom infrastructure on Google Cloud.</p>



<p>&ldquo;Local&rsquo;s tunnel, like Local itself, is written in Node.js,&rdquo; Sellwood said. &ldquo;As a result, Live Links Pro handles 2x the number of HTTP requests in 50% less time. Live Links Pro is also secure by default with SSL and Privacy Mode (aka basic auth).&rdquo;</p>



<p>The image optimizer and live reload features are coming soon to the Pro subscription. Building these pre-launch tools into Local allows users to leverage the power of their local machines, instead of relying on plugins. The image optimizer will be able to work offline and can tap into the user&rsquo;s available computer resources.</p>



<p>Over the past three years, Local&rsquo;s popularity has largely eclipsed that of other local WordPress development apps and packages like DesktopServer and InstantWP. Sellwood said the app&rsquo;s most formidable competitors are advanced developer tools like Laravel Valet or custom Docker/VirtualBox setups.</p>



<p>&ldquo;If you&rsquo;ve invested a lot of time in a custom stack or setup, it&rsquo;s hard to abandon that sunk cost,&rdquo; Sellwood said. &ldquo;Local abandoned virtualization completely in Lightning, and we knew, before we even launched, that some users would miss virtualization, so we&rsquo;re exploring&nbsp;Site Environments powered by Docker&nbsp;as an option for advanced users.&rdquo;</p>



<p>In addition to supporting more advanced development tools, the Local team aims to make advanced parts of WordPress development simpler and more approachable.</p>



<p>&ldquo;Local has always been about providing an elegant UI that helps people dive deeper and level up as developers,&rdquo; Sellwood said. &ldquo;For example, WordPress developers might manage their database or interact with WP-CLI for the first time in Local because these advanced capabilities are available without any configuration. We&rsquo;ll continue to make advanced parts of WordPress development simpler. </p>



<p>&ldquo;Obviously, there&rsquo;s a lot happening in WordPress right now with FSE (Full Site Editing) and headless, so we&rsquo;re working with the other teams at WP Engine and elsewhere to help Local support this new future.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Jun 2020 22:34:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: GiveWP 2.7 Adds Donation Form Templates and Per-Form Stripe Connections\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101343\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:207:\"https://wptavern.com/givewp-2-7-adds-donation-form-templates-and-per-form-stripe-connections?utm_source=rss&utm_medium=rss&utm_campaign=givewp-2-7-adds-donation-form-templates-and-per-form-stripe-connections\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7388:\"<p class=\"has-drop-cap\">Earlier today, Impress.org <a href=\"https://givewp.com/new-givewp-2-7/\">released version 2.7</a> of its popular donation plugin <a href=\"https://wordpress.org/plugins/give/\">GiveWP</a>. The update focuses on laying the foundation for donation form templates, handling per-form Stripe accounts, and allowing users to view fundraising reports in multiple currencies.</p>



<p>&ldquo;GiveWP 2.7 is not just a release,&rdquo; wrote Devin Walker, the co-founder and CEO of GiveWP, in the announcement. &ldquo;It&rsquo;s also the start of even more amazing things to come in future updates. This update paves the way for an even better donation plugin experience with form templates and per-form stripe accounts. We&rsquo;ve also added to our new reporting dashboard so you can toggle your view to show different currencies.&rdquo;</p>



<p>Overall, version 2.7 is a solid update. The new form template system is something the team can build upon and continue improving the user experience over time. The per-form Stripe connections will make the plugin more enticing to organizations with multiple chapters, locations, clubs, and more.</p>



<p>It is turning out to be a good year for the GiveWP team. So far in 2020, people have used the plugin to process over $100 million in donations, which is on par with the <a href=\"https://wptavern.com/givewp-plugin-users-raised-over-100-million-in-donations-in-2019\">numbers for the entirety of 2019</a>.</p>



<p>View a quick video for GiveWP 2.7:</p>



<div>

</div>



<h2>Donation Form Templates</h2>



<ul><li class=\"blocks-gallery-item\"><img />Initial Donation Form</li><li class=\"blocks-gallery-item\"><img />Enter Donation Amount</li><li class=\"blocks-gallery-item\"><img />Complete Donation</li></ul>Multi-step donation form template.



<p class=\"has-drop-cap\">The most exciting thing about the version 2.7 release is the new form template system. Rather than having a single template for all types of donation forms, the team at GiveWP has created the foundation for niche templates in the future.</p>



<p>The current release has merely two template options: a new multi-step donation form and a legacy donation form.</p>



<p>For some, this simple addition may be exciting. For others, they may be wanting to see more. The good news is the team is well on its way to making that happen.</p>



<p>&ldquo;Form Templates was made to pave the way for all kinds of form types,&rdquo; said Matt Cromwell, Partner and COO at Impress.org.  &ldquo;Not just &lsquo;Obama Style&rsquo; forms, or &lsquo;Charity Water&rsquo; forms, but also how forms function, like implementing Event Fundraising, Crowdfunding, Peer-to-Peer fundraising. It&rsquo;s an exciting new feature that we&rsquo;ll be investing into continually going forward.&rdquo;</p>



<p>Form templates do not currently offer a wide range of customization options. That can sometimes be both a good and bad thing. The good is that the development team can add some quality control to the output, making for a better experience in most use cases. However, there are times when a few extra options could go a long way. For example, with a few themes I tested, the multi-step donation template did not expand the width of the content area. With no way to tweak the width via the UI, it meant doing a little code work to get it perfect.</p>



<p>&ldquo;The customization is really focused on the colors, messaging, and media at the moment,&rdquo; said Cromwell. &ldquo;But we are working on ways that templates can be more extensible programmatically, and also more drag-and-droppable. For now, we wanted to get the core user-interest feature out the door for our core users, and then extend it further for more developer-oriented users later.</p>



<p>Thus far, Impress.org and its team working on GiveWP have made smart, calculated moves toward improving their product. Unlike some product-makers, the team did not try to wow everyone with 100+ form templates out of the gate. Instead, they have focused on slowly and methodically creating an underlying system that they can iterate on. It&rsquo;s the <em>quality over quantity</em> mantra that has been a staple in how the team has approached development.</p>



<p>Form templates are a big deal. They are the missing link for potentially frustrated users who want something that better aligns with their organization than the old, legacy design that every plugin user had on their site. We are still a bit away from seeing this potential play out. However, as the team continues to release templates into the future, they will add value to the product.</p>



<p>Right now, some free templates are coming down the pipeline. The team teased upcoming templates specific to events, crowdfunding, and peer-to-peer campaigns. But, the possibilities are limited only by what users need.</p>



<p>Some templates may come as part of paid packages. &ldquo;How we offer more advanced templates is a bit up for grabs at the moment,&rdquo; said Cromwell. &ldquo;We are still very much committed to the add-on model, and not necessarily a marketplace model, but there will be new paid add-ons that have advanced types of form templates for sure.&rdquo;</p>



<h2>Per-Form Stripe Accounts</h2>



<img />Override the global Stripe account on a per-form basis.



<p class=\"has-drop-cap\">GiveWP&rsquo;s second big feature, which may excite some users more than form templates, is the ability to set the Stripe account for each form. By default, forms will connect to the global Stripe account added via the plugin&rsquo;s Stripe gateway settings. However, users can overrule this on individual forms.</p>



<p>Admittedly, I have not seen many plugins that accept payments or donations take this route. It is not something I have ever needed in the past. However, I can now see how it may open up a ton of possibilities for organizations with different chapters or schools with different clubs and fundraisers.</p>



<p>Beyond just GiveWP and donation plugins, I would like to see this become a standard feature for any plugin that accepts payments.</p>



<p>If nothing else, this feature should continue making GiveWP stand out as the top donations plugin for WordPress. This <em>missing</em> feature in the previous version may have been a holdup for charities that needed the more fine-tuned control of multiple account options. Perhaps it will make some reconsider and make the move to GiveWP.</p>



<h2>What Is In the Pipeline?</h2>



<p class=\"has-drop-cap\">In the short term, more form templates are definitely in the works. It will be interesting to keep an eye out for what lands in the coming weeks and months.</p>



<p>Beyond that, the team will primarily focus on adding PayPal Commerce support to the free plugin. That is expected to land in version 2.8.</p>



<p>&ldquo;PayPal has actually done tons of work to improve this new product from all their others (Standard, Express, Pro, Payflow, etc), and it offers a lot to developers specifically,&rdquo; said Cromwell. &ldquo;We think it will be a very in-demand option for donors and organizations as well. PayPal is still a highly recognizable name when it comes to payments and within the nonprofit space. We always intend to be leading when it comes to online donations so we want to offer this to our users quickly and effectively.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Jun 2020 21:37:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"BuddyPress: BuddyPress 6.1.0 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=312607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://buddypress.org/2020/06/buddypress-6-1-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1263:\"<p>Immediately available is <a href=\"https://downloads.wordpress.org/plugin/buddypress.6.1.0.zip\">BuddyPress 6.1.0</a>. This maintenance release fixes 6 bugs related to the 6.0.0 release, and is a recommended upgrade for all BuddyPress installations.</p>



<p>For details on the changes, please read the <a href=\"https://codex.buddypress.org/releases/version-6-1-0/\">6.1.0 release notes</a>.</p>



<p>Update to BuddyPress 6.1.0 today in your WordPress Dashboard, or by&nbsp;<a href=\"https://wordpress.org/plugins/buddypress/\">downloading from the WordPress.org plugin repository</a>.</p>



<h2>Many thanks to 6.1.0 contributors&nbsp;<span class=\"dashicons dashicons-heart\"></span></h2>



<p><a href=\"https://profiles.wordpress.org/r-a-y\">Ray</a>, <a href=\"https://profiles.wordpress.org/n33d/\">N33D</a>, <a href=\"https://profiles.wordpress.org/comminski/\">comminski</a>, <a href=\"https://profiles.wordpress.org/etatus/\">etatus</a>, <a href=\"https://github.com/ExoGeek\">ExoGeek</a>,&nbsp;<a href=\"https://profiles.wordpress.org/espellcaste/\">Renato Alves (espellcaste)</a>,&nbsp;<a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges (boonebgorges)</a>&nbsp;&amp;&nbsp;<a href=\"https://profiles.wordpress.org/imath/\">Mathieu Viet (imath)</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Jun 2020 21:29:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WPTavern: Smash Balloon Joins Awesome Motive\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101298\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"https://wptavern.com/smash-balloon-joins-awesome-motive?utm_source=rss&utm_medium=rss&utm_campaign=smash-balloon-joins-awesome-motive\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5607:\"<p class=\"has-drop-cap\">On June 23, Awesome Motive <a href=\"https://www.wpbeginner.com/news/welcome-smash-balloon-to-the-wpbeginner-family-of-products/\">announced it had acquired Smash Balloon</a>, a company that focuses on a family of social feed plugins for WordPress. John Brackett, the founder of Smash Balloon, is now a partner at Awesome Motive through the deal. His entire team will be staying on as part of the larger company.</p>



<p>Currently, Smash Balloon&rsquo;s plugins are installed and active on around 1.3 million WordPress-powered sites. The team has thus far built social feed plugins for Twitter, YouTube, Facebook, and Instagram. <a href=\"https://wordpress.org/plugins/instagram-feed/\">Smash Balloon Social Photo Feed</a>, its Instagram plugin, is by far the company&rsquo;s most popular plugin with over a million active installations, a feat it <a href=\"https://twitter.com/smashballoon/status/1245779770845077505\">surpassed in April</a>.</p>



<p>Brackett launched Smash Balloon in 2013. Since then, the company has specialized in creating plugins that allow users to display social media content on their websites.</p>



<p>&ldquo;With Awesome Motive&rsquo;s vast resources and deep understanding of the WordPress industry, I know we&rsquo;ll be able to bring even more powerful solutions to the Smash Balloon community,&rdquo; said Brackett in the <a href=\"https://smashballoon.com/smash-balloon-is-now-part-of-the-awesome-motive-family/\">announcement on the Smash Balloon blog</a>.</p>



<p>&ldquo;I&rsquo;m really excited and proud to now be a partner at Awesome Motive,&rdquo; he said.  &ldquo;They have a really great group of partners there and I&rsquo;m really humbled to now be a part of the team. I&rsquo;ll be continuing in my role leading the Smash Balloon business unit.&rdquo;</p>



<p>Brackett said the biggest factor in making the deal was the expertise and experience that Awesome Motive brought to the table in the WordPress plugin space. &ldquo;They&rsquo;ve built a proven model for plugin growth, which is evident from their large user base of 15 million websites,&rdquo; he said. &ldquo;Of course, there were other factors too, such as the AM growth playbooks, back office resources, various operational/marketing processes, etc., which make it easier for us to grow and scale as a business.&rdquo;</p>



<p>Awesome Motive is the company behind WPBeginner, OptinMonster, WPForms, MonsterInsights, and more. It has a history of buying smaller businesses and growing them into larger, more successful endeavors. In February this year, the company <a href=\"https://wptavern.com/awesome-motive-acquires-the-all-in-one-seo-pack-plugin\">acquired the All in One SEO Pack plugin</a>.</p>



<p>&ldquo;Adding social proof is crucial for business websites,&rdquo; said Syed Balkhi, CEO of Awesome Motive. &ldquo;In WPBeginner support, we see many readers asking for ways to display their social media content on their site, especially Instagram and Facebook. Displaying social media content on your site can not only help you grow your social followers, but it can also help you improve your sales conversions on your store.&rdquo;</p>



<p>Balkhi said his team at WPBeginner has been recommending the Smash Balloon plugins all the way back to 2016. &ldquo;When I was presented with the opportunity to join forces with John and the Smash Balloon team, it was a no brainer,&rdquo; he said.</p>



<p>&ldquo;Smash Balloon is the market leader when it comes to creating custom social media feeds in WordPress,&rdquo; said Balkhi. &ldquo;Over 1.3 million website owners use Smash Balloon plugins to display custom Instagram feeds, custom Facebook feeds, custom Twitter feeds, and custom YouTube feeds. The best part is that the plugins are <em>always</em> reliable, and they come with a very smart feed backup / caching which keeps your site loading fast even when the social API is down.&rdquo;</p>



<h2>What Does the Future Hold?</h2>



<p class=\"has-drop-cap\">Awesome Motive is <a href=\"https://awesomemotive.com/career/\">actively hiring</a> developers, support staff, and writers. At least some of those hires will be working on Smash Balloon&rsquo;s product line.</p>



<p>Balkhi doesn&rsquo;t like to talk about team size, remaining humble as ever as the leader of his continually growing company. &ldquo;What&rsquo;s more important for us is to make sure that we adequately serve our growing customer base while continuing to add new features that they&rsquo;re asking for,&rdquo; he said.</p>



<p>He does have big plans for Smash Balloon&rsquo;s products. &ldquo;We&rsquo;re of course going to update the existing plugins to add new features that users are asking for, and we will be adding seamless integrations with our other products such as <a href=\"https://www.monsterinsights.com/\">MonsterInsights</a> (analytics), <a href=\"https://rafflepress.com/\">RafflePress</a> (contests &amp; giveaways), <a href=\"https://www.seedprod.com/\">SeedProd</a> (landing pages), etc.,&rdquo; he said.</p>



<p>A large part of the company&rsquo;s plans is to continue making the process of creating custom social media feeds easier. The team will be doing this through more detailed tutorials and product education going forward.</p>



<p>However, there are no plans at stopping there. New projects are in the pipeline. &ldquo;We&rsquo;re also working on a brand new product that a lot of WPBeginner readers and Smash Balloon customers have been asking for,&rdquo; he said. &ldquo;I can&rsquo;t share too much details, but it&rsquo;s going to be awesome.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Jun 2020 21:09:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: WooCommerce 4.3 to Introduce New Home Screen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101279\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:153:\"https://wptavern.com/woocommerce-4-3-to-introduce-new-home-screen?utm_source=rss&utm_medium=rss&utm_campaign=woocommerce-4-3-to-introduce-new-home-screen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2856:\"<p>As the pandemic and lockdown measures have caused major shifts in consumer behavior, accelerating the trend towards e-commerce, many WooCommerce-powered stores have seen a significant boost in sales. Major retailers like Amazon, Walmart, and Target have strained to meet the increase in consumer demand, creating an unprecedented <a href=\"https://wptavern.com/tectonic-shifts-in-retail-industry-are-creating-unprecedented-opportunities-for-independent-stores\">opportunity for independent stores</a>.</p>



<p>According to the latest <a href=\"https://www.aciworldwide.com/news-and-events/press-releases/2020/june/81-percent-rise-in-may-retail-ecommerce-sales-aci-worldwide-research-reveals\">ACI Worldwide report</a>, e-commerce sales are up 81% year over year in May 2020. Transactional volume has also increased 23 percent compared to May 2019. Despite the pandemic&rsquo;s devastating blow to the hospitality, travel, and entertainment industries, merchants selling products catering to the homebound population are doing more business than ever. This prompted the WooCommerce team to begin publishing tips and resources for store owners who are <a href=\"https://woocommerce.com/posts/prepare-surge-ecommerce-demand/\">managing a sudden surge in sales</a>.</p>



<p>The WooCommerce core development team is also keeping pace with new features that help administrators see store activity at a glance. Version 4.3, expected to be released July 7, will include a new home screen, featuring an inbox, quick access to store management links, and an overview of stats on sales, orders, and visitors. </p>



<img />



<p>WooCommerce plans to enhance the new Home screen with the ability to complete basics tasks, such as fulfilling orders or tweaking settings without having to leave the screen. As WooCommerce is a complex plugin with menus that drill down several levels deep, this screen will become the store owner&rsquo;s command center by simplifying access to important stats and commonly performed actions. It will set as the default screen for new stores when version 4.3 of the plugin is released.</p>



<p>The new Home screen will not be turned on by default for existing store owners. They will need to enable it under the Advanced &gt; Features setting in the plugin.</p>



<p>WooCommerce received positive feedback after sharing a preview of the new Home screen last week. A few users requested that it integrate with third party plugins, such as Woo Bookings, and provide better support for stores primarily selling digital products. If WooCommerce makes it easy to extend, plugin authors can make the screen more useful to a diverse range of stores. Users are encouraged to submit their ideas for core improvements on the <a href=\"https://ideas.woocommerce.com/forums/133476-woocommerce?category_id=36092\">WooCommerce Ideas Board</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Jun 2020 20:12:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: The Best Documentation Is No Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101217\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://wptavern.com/the-best-documentation-is-no-documentation?utm_source=rss&utm_medium=rss&utm_campaign=the-best-documentation-is-no-documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5898:\"<p>Hear me out before telling me how wrong I am.</p>



<p>Over the past couple of weeks, I have read a few different articles on writing good user documentation from a software developer&rsquo;s perspective. It is an area I was always told I excelled at by people who read the docs I wrote through the years. However, by the time I stepped away from my WordPress business of over a decade, I had almost completely stopped writing user documentation. Few users seemed to have noticed or questioned why there were no step-by-step explanations of certain features.</p>



<p>Like many WordPress plugin and theme developers, I am a firm believer in having documentation on hand. As someone who has been fiddling with code since 2003, documentation has been my best friend. I have written at least a few hundred tutorials or pages of docs throughout my career. I have published two development books and was a technical editor on a third. I am fairly certain I have created a plugin or two with more inline documentation than actual code.</p>



<p>However, I also ran support for end-users for over a decade. The one thing I learned with any surety is that many users simply do not read the documentation.  Even if they were reading it, they should not have needed to most of the time.</p>



<p>Despite iterating, redesigning, and trying my hand at everything to lead users to documentation before running to the support forum with every question, repeat questions never failed to land in the support queue every day.</p>



<p>It took me years &mdash; far more than it should have &mdash; to realize that the solution was not in the documentation and the problem was not in the user&rsquo;s ability to read it. The problem was the product. If users were asking repeat questions, it meant there was something wrong with the user experience. Eventually, I shifted my focus. Instead of writing more docs, I focused on addressing the problems that continued to crop up in the software.</p>



<p>The activity that I had failed at was listening.</p>



<p>One of the best skills a developer can obtain is the ability to listen and then translate what users are saying into better code, user interfaces, and user experiences.</p>



<p>In my younger years &mdash; and I suspect many developers were the same when starting &mdash; I felt like I knew the answer to every question and was always right. I was highly skilled, and I knew it. For a young, 20-something developer, that tends to mean trouble. It means that you believe the problem is not with the things you have built. No, the problem was that the user was doing something wrong. These are the types of developers who say, &ldquo;RTFM,&rdquo; and point a user to an overly technical document that does not solve their problems.</p>



<p>Some lessons are learned the hard way, but learn them we must to build better products.</p>



<p>I promise if you do this one activity &mdash; listen, really listen &mdash; to users, you will spend far less time explaining how something works. The question you need to ask yourself is why a piece of documentation needs to exist in the first place. If it takes 500 words to explain a feature, there is a good chance the feature does not make for an ideal user experience.</p>



<p>When building products, we should always strive to build them so that there is no need for documentation. Or, at least build them so that <em>reading the manual</em> is a last resort for addressing problems.</p>



<p>For practical purposes, as a fulltime developer in the past, I kept a simple text file with a list of repeat questions. This could be a more elaborate setup for a team, such as creating GitHub issues. My text file worked fine because I was a one-person show. I would make it a habit to routinely go through the list and ask how I could improve each point. Some items were never scratched off the list. However, more often than not, I learned important lessons about building for end-users first. I could see the things that made sense in my head but were confusing to others.</p>



<p>The biggest improvements were not in finding solutions to existing problems but in recognizing problems within new products that I was building based on past experience.</p>



<p>Over time, most of my documentation became geared toward developers. These were primarily tutorials on using APIs, hooks, and other developer-related features &mdash; things that were not exposed through a plugin&rsquo;s UI. I was writing far less for end-users because I was updating projects based on their feedback and questions. Yes, I absolutely failed from time to time, but I was getting better at being someone who listened to problems and made changes based on what users were telling me in their own way.</p>



<p>When I say that the best documentation is no documentation, I do not mean that you should skip it altogether. I want you to ask the question about why the documentation needs to exist. Are there things you can do to make the user experience easier? Are you actively tracking support questions and addressing those in the product itself?</p>



<p>In development, we often talk about writing &ldquo;self-documenting code.&rdquo; This is a way of saying to write code in a way that you should not have to explain it to another developer via inline documentation. For example, the <code>wp_insert_post()</code> function in WordPress tells you that its purpose is to insert a post. The goal of any software should also be to create <em>self-documenting interfaces</em> and other elements that a user interacts with. Users should be able to automatically understand the purpose of a button, text field, or checkbox without consulting the docs.</p>



<p>The next time you sit down to write a new user-oriented piece of documentation, make sure that you are not using it as a crutch to prop up a poor user experience.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Jun 2020 21:34:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"WPTavern: WordCamp Tulsa 2020 Canceled\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101202\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://wptavern.com/wordcamp-tulsa-2020-canceled?utm_source=rss&utm_medium=rss&utm_campaign=wordcamp-tulsa-2020-canceled\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3231:\"<img />



<p>Tulsa&rsquo;s first ever WordCamp, which was scheduled for August 29-30, 2020, has officially been canceled due to uncertainty surrounding the pandemic. The event would have been the second WordCamp in Oklahoma in four years, following <a href=\"https://wptavern.com/wordcamp-okc-unifies-oklahoma-wordpress-community-introduces-okie-wapuu\">WordCamp OKC in 2016</a>.</p>



<p>&ldquo;We were trying to go for a hybrid event that was live streamed and included an audience,&rdquo; lead organizer James Bullis said. &ldquo;This was something that hadn&rsquo;t been tried before and with Oklahoma opening up it was a possibility.&rdquo;</p>



<p>The six-person organizing team had already selected speakers and were going to notify them but had not yet set the WordCamp schedule. </p>



<p>&ldquo;Unfortunately we were told that due to uncertainty we had to choose to do a virtual event or postpone it,&rdquo; Bullis said. He said WordCamp Central cited a few reasons why a hybrid event would not be possible: social distancing, cleaning requirements throughout the day, the extra cost of a local crew to film, and the quality of the stream with live audience elements.</p>



<p>When presented with the choice to either go full virtual or postpone the event, the organizing team took advice from WordCamp Central&rsquo;s approved streaming company. Having free virtual tickets available would likely limit the in-person ticket sales and put a greater burden on local sponsorships.</p>



<p>&ldquo;Since this was the first WordCamp in Tulsa, the organizing team felt it would be better to postpone until 2021,&rdquo; Bullis said.</p>



<p>Oklahoma is currently in <a href=\"https://www.okcommerce.gov/covid19/ours-plan/\">Phase 3 of reopening</a>, with businesses back to operating normally for the most part. Despite COVID-19 cases steadily rising in Oklahoma, along with hospitalizations, Governor Kevin Stitt, said he has no plans to scale back the reopening process. While there is a chance that Oklahoma would be open at the end of August, the situation is too precarious for WordCampers to pin their hopes on an in-person event.</p>



<p>Although many WordCamps are opting to go virtual and have attracted record numbers of online attendees, it&rsquo;s not easy to measure attendees&rsquo; engagement without comprehensive streaming data broken down by hour/session. Bullis and his team decided against holding Tulsa&rsquo;s inaugural WordCamp as a virtual conference, because they didn&rsquo;t think it would hold the same value without the in-person interaction.</p>



<p>&ldquo;We noticed that other WordCamps had gone virtual,&rdquo; Bullis said. &ldquo;People on our organizing team registered for these virtual WordCamps but didn&rsquo;t go to them, or they left early. We felt like this was a pretty common response. We felt that a virtual WordCamp wouldn&rsquo;t be as effective and would take away from the real value of a WordCamp.&rdquo;</p>



<p>WordCamp Tulsa is technically canceled but the organizers plan to attempt an in-person event next spring. They will have to start the application process over again to plan for 2021 but hope to host the WordCamp on the first weekend in March or May.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Jun 2020 19:13:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Matt: Combating Epidemics With Internet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=51744\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://ma.tt/2020/06/combating-epidemics-with-internet/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1704:\"<p>In 2006 David Eagleman, who wrote one of my favorite books, <a href=\"https://www.amazon.com/dp/B001TKA0VO/\">Sum</a>, <a href=\"https://www.nature.com/articles/441574c\">wrote a letter published in Nature</a>:</p>



<blockquote class=\"wp-block-quote\"><p>Kathleen Morrison, in News &amp; Views (“Failure and how to avoid it” <em>Nature</em> <strong>440</strong>, 752–754; 2006), notes that societies have often prevented collapse by adopting new technological strategies. In today&#8217;s world, where one of the most-talked about prospects for collapse is an epidemic of infectious disease, it is worth remembering that perhaps we already have the technological strategy to avoid it — the Internet.</p><p>Remote working, made possible by the Internet (‘telepresence’), is already a key component of national and business pandemic plans. Telepresence can inhibit viral transmission by reducing human-to-human contact. Prepared organizations can leverage telepresence to allow continued productivity and functioning of supply chains during an outbreak.</p></blockquote>



<p>He explores these ideas as well in his Long Now talk in April 2010, in which he talked about <a href=\"https://www.youtube.com/watch?v=1pPI3cUWeI0\">Six Easy Steps to Avert the Collapse of Civilization</a>. Here&#8217;s an excerpt from that talk covering telepresence and telemedicine. Both videos have had under a thousand views so far. When you watch this remember that it was April, 2010!</p>



<div class=\"wp-block-embed__wrapper\">

</div>



<p>This is the topic of his new book, <a href=\"https://www.amazon.com/dp/B088HHQX67/?tag=photomatt08-20\">The Safety Net: Surviving Pandemics and Other Disasters</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Jun 2020 18:41:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: Add Per-Block Notes and Create Draft Blocks With the Wholesome Publishing Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=101185\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:225:\"https://wptavern.com/add-per-block-notes-and-create-draft-blocks-with-the-wholesome-publishing-plugin?utm_source=rss&utm_medium=rss&utm_campaign=add-per-block-notes-and-create-draft-blocks-with-the-wholesome-publishing-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4522:\"<p class=\"has-drop-cap\">Matt Watson, through his <a href=\"https://wholesomecode.ltd/\">Wholesome Code</a> brand, released a plugin called <a href=\"https://wordpress.org/plugins/wholesome-publishing/\">Wholesome Publishing</a> on the WordPress plugin directory on Tuesday. Version 1.0 of the plugin adds a couple of simple but useful editing features that should help teams of writers or content designers.  The plugin allows users to add nested comments on a per-block basis and mark individual blocks as drafts.</p>



<p>At this point, the plugin is not a fully-fledged pro editing plugin. However, its basic features go a long way toward improving collaborative publishing. It is a good first showing for a version 1.0. I hope that it continues to grow and bring new editing features to the block editor.</p>



<p>The plugin works with both core WordPress and third-party blocks. Overall, it performed well in my tests, but I did find a few minor issues that could be easily addressed in a future update. If you are looking for such a plugin, it is well worth a test run to see if it fits into your publishing workflow. I am seriously considering it for use here on WP Tavern, if that provides an indication of its potential.</p>



<h2>Nested Block Comments</h2>



<img />Adding nested comments to a Cover block.



<p class=\"has-drop-cap\">The primary feature that drew me to this plugin was the ability to leave simple notes via the block editor. Even here on the Tavern, we have an old editorial notes system, but it is no longer a user-friendly option with the block editor. Notes are tucked away at the bottom of the editing screen along with other old-school meta boxes. A new system, particularly one that allowed comments on a per-block basis, was definitely worth exploring.</p>



<p>Block comments &mdash; not to be confused with post comments on the front end &mdash; are simple to add. On the post editing screen, users merely need to click the comment button in the toolbar, which will open a comments sidebar panel.  The panel will show a text box to add a new comment for the currently-selected block.</p>



<p>Comments belong to individual blocks. However, it is not clear in the comments sidebar panel which block a comment is for when there are multiple comments. Clicking on a single comment selects the block in question, which helps, but the user experience would be better with two additions:</p>



<ul><li>The selected block&rsquo;s comments should be highlighted while unrelated comments fade out.</li><li>There should be an indicator in the comments sidebar that points out the block each comment is assigned to.</li></ul>



<p>Unfortunately, it is not possible to see or leave a comment unless you are an administrator. I am unsure if this is intentional or a bug. It is at least a user experience issue because the comments sidebar panel still appears, regardless of whether the user can read the block comments.</p>



<p>Despite the need for a bit of polishing to improve the experience, this feature was reasonably easy to pick up and use right away.</p>



<p>The plugin does clean up after itself. If a user deletes a block, its comments are also deleted.</p>



<p>I do have one big feature request for the plugin author. An opt-in setting for enabling an email system would be a nice touch. The post author and anyone who leaves a comment on the post should be notified when a new comment is made.</p>



<h2>Create Draft Blocks</h2>



<img />Setting a Gallery block to draft status.



<p class=\"has-drop-cap\">The second plugin feature goes hand in hand with the first. Wholesome Publishing allows end-users to mark any block in the post as a draft, which means the block will not appear on the front end of the site. The reason it works well with the comments feature is that users can explain why the block was marked as a draft. This could be particularly useful on teams of multiple writers.</p>



<p>In the block options panel, users should see a new tab titled &ldquo;Publishing.&rdquo; The tab will have a single on/off switch for setting the given block as a draft. Unlike the block comments system, any user can put an individual user into draft mode as long as they have access to edit the post.</p>



<p>I did run into one issue with draft blocks. When clicking the on/off toggle, all of the block options tabs would reset to the default open or closed state. It is a trivial issue that might become irritating for some. Outside of that, the feature worked well.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 25 Jun 2020 20:58:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 24 Jul 2020 16:20:03 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Fri, 24 Jul 2020 16:00:08 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";s:16:\"content-encoding\";s:2:\"br\";}}s:5:\"build\";s:14:\"20130911083210\";}", "no");
INSERT INTO wpy4_options VALUES("243580", "can_compress_scripts", "1", "no");
INSERT INTO wpy4_options VALUES("243681", "recovery_mode_email_last_sent", "1591910983", "yes");
INSERT INTO wpy4_options VALUES("245734", "litespeed.conf.crawler-order_links", "date_desc", "yes");
INSERT INTO wpy4_options VALUES("245735", "litespeed.conf.crawler-usleep", "500", "yes");
INSERT INTO wpy4_options VALUES("245736", "litespeed.conf.crawler-run_duration", "400", "yes");
INSERT INTO wpy4_options VALUES("245737", "litespeed.conf.crawler-run_interval", "600", "yes");
INSERT INTO wpy4_options VALUES("268544", "_transient_timeout_jetpack_file_data_8.6.1", "1596941599", "no");
INSERT INTO wpy4_options VALUES("268545", "_transient_jetpack_file_data_8.6.1", "a:52:{s:32:\"d3576702faeb399eb47ad20f586c3804\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:75:\"Display images and galleries in a gorgeous, full-screen browsing experience\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"55409a5f8388b8d33e2350ef80de3ea3\";a:14:{s:4:\"name\";s:13:\"Comment Likes\";s:11:\"description\";s:64:\"Increase visitor engagement by adding a Like button to comments.\";s:4:\"sort\";s:2:\"39\";s:20:\"recommendation_order\";s:2:\"17\";s:10:\"introduced\";s:3:\"5.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:37:\"like widget, like button, like, likes\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"e914e6d31cb61f5a9ef86e1b9573430e\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:81:\"Let visitors use a WordPress.com, Twitter, Facebook, or Google account to comment\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"f1b8c61705fb18eb8c8584c9f9cdffd9\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:81:\"Add a customizable contact form to any post or page using the Jetpack Form Block.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:214:\"contact, form, grunion, feedback, submission, contact form, email, feedback, contact form plugin, custom form, custom form plugin, form builder, forms, form maker, survey, contact by jetpack, contact us, forms free\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"4fca6eb23a793155d69fdb119a094926\";a:14:{s:4:\"name\";s:9:\"Copy Post\";s:11:\"description\";s:77:\"Enable the option to copy entire posts and pages, including tags and settings\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"7.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:15:\"copy, duplicate\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"cfdac01e3c3c529f93a8f49edef1f5db\";a:14:{s:4:\"name\";s:20:\"Custom content types\";s:11:\"description\";s:74:\"Display different types of content on your site with custom content types.\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"4b9137ecf507290743735fb1f94535df\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:88:\"Adds options for CSS preprocessor use, disabling the theme\'s CSS, or custom image width.\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"95d75b38d76d2ee1b5b537026eadb8ff\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"822f9ef1281dace3fb7cc420c77d24e0\";a:14:{s:4:\"name\";s:16:\"Google Analytics\";s:11:\"description\";s:56:\"Set up Google Analytics without touching a line of code.\";s:4:\"sort\";s:2:\"37\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"4.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:37:\"webmaster, google, analytics, console\";s:12:\"plan_classes\";s:17:\"business, premium\";}s:32:\"c167275f926ef0eefaec9a679bd88d34\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"58cbd4585a74829a1c88aa9c295f3993\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:53:\"Automatically load new content when a visitor scrolls\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"d4a35eabc948caefad71a0d3303b95c8\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:51:\"Allow applications to securely access your content.\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"7b0c670bc3f8209dc83abb8610e23a89\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:74:\"Use the LaTeX markup language to write mathematical equations and formulas\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"b00e4e6c109ce6f77b5c83fbaaaead4c\";a:14:{s:4:\"name\";s:11:\"Lazy Images\";s:11:\"description\";s:137:\"Speed up your site and create a smoother viewing experience by loading images as visitors scroll down the screen, instead of all at once.\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:5:\"5.6.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:23:\"Appearance, Recommended\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:150:\"mobile, theme, fast images, fast image, image, lazy, lazy load, lazyload, images, lazy images, thumbnail, image lazy load, lazy loading, load, loading\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"8e46c72906c928eca634ac2c8b1bc84f\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:63:\"Give visitors an easy way to show they appreciate your content.\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"2df2264a07aff77e0556121e33349dce\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:50:\"Write posts or pages in plain-text Markdown syntax\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"0337eacae47d30c946cb9fc4e5ece649\";a:14:{s:4:\"name\";s:21:\"WordPress.com Toolbar\";s:11:\"description\";s:91:\"Replaces the admin bar with a useful toolbar to quickly manage your site via WordPress.com.\";s:4:\"sort\";s:2:\"38\";s:20:\"recommendation_order\";s:2:\"16\";s:10:\"introduced\";s:3:\"4.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"General\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:19:\"adminbar, masterbar\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"c54bb0a65b39f1316da8632197a88a4e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:118:\"Jetpack’s downtime monitoring will continuously watch your site, and alert you the moment that downtime is detected.\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:123:\"monitor, uptime, downtime, monitoring, maintenance, maintenance mode, offline, site is down, site down, down, repair, error\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"cc013f4c5480c7bdc1e7edb2f410bf3c\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:57:\"Receive instant notifications of site comments and likes.\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"b3b34928b1e549bb52f866accc0450c5\";a:14:{s:4:\"name\";s:9:\"Asset CDN\";s:11:\"description\";s:154:\"Jetpack’s Site Accelerator loads your site faster by optimizing your images and serving your images and static files from our global network of servers.\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"6.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:23:\"Recommended, Appearance\";s:25:\"additional_search_queries\";s:160:\"site accelerator, accelerate, static, assets, javascript, css, files, performance, cdn, bandwidth, content delivery network, pagespeed, combine js, optimize css\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"714284944f56d6936a40f3309900bc8e\";a:14:{s:4:\"name\";s:9:\"Image CDN\";s:11:\"description\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:23:\"Recommended, Appearance\";s:25:\"additional_search_queries\";s:171:\"photon, photo cdn, image cdn, speed, compression, resize, responsive images, responsive, content distribution network, optimize, page speed, image optimize, photon jetpack\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"041704e207c4c59eea93e0499c908bff\";a:14:{s:4:\"name\";s:13:\"Post by email\";s:11:\"description\";s:33:\"Publish posts by sending an email\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"26e6cb3e08a6cfd0811c17e7c633c72c\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:151:\"Enabling brute force protection will prevent bots and hackers from attempting to log in to your website with common username and password combinations.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:173:\"security, jetpack protect, secure, protection, botnet, brute force, protect, login, bot, password, passwords, strong passwords, strong password, wp-login.php,  protect admin\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"915a504082f797395713fd01e0e2e713\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:128:\"Publicize makes it easy to share your site’s posts on several social media networks automatically when you publish a new post.\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:220:\"facebook, jetpack publicize, twitter, tumblr, linkedin, social, tweet, connections, sharing, social media, automated, automated sharing, auto publish, auto tweet and like, auto tweet, facebook auto post, facebook posting\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"9243c1a718566213f4eaf3b44cf14b07\";a:14:{s:4:\"name\";s:13:\"Related posts\";s:11:\"description\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:360:\"related, jetpack related posts, related posts for wordpress, related posts, popular posts, popular, related content, related post, contextual, context, contextual related posts, related articles, similar posts, easy related posts, related page, simple related posts, free related posts, related thumbnails, similar, engagement, yet another related posts plugin\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"583e4cda5596ee1b28a19cde33f438be\";a:14:{s:4:\"name\";s:6:\"Search\";s:11:\"description\";s:102:\"Help visitors quickly find answers with highly relevant instant search results and powerful filtering.\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:6:\"Search\";s:25:\"additional_search_queries\";s:110:\"search, elastic, elastic search, elasticsearch, fast search, search results, search performance, google search\";s:12:\"plan_classes\";s:8:\"business\";}s:32:\"15346c1f7f2a5f29d34378774ecfa830\";a:14:{s:4:\"name\";s:9:\"SEO Tools\";s:11:\"description\";s:50:\"Better results on search engines and social media.\";s:4:\"sort\";s:2:\"35\";s:20:\"recommendation_order\";s:2:\"15\";s:10:\"introduced\";s:3:\"4.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:7:\"Traffic\";s:25:\"additional_search_queries\";s:81:\"search engine optimization, social preview, meta description, custom title format\";s:12:\"plan_classes\";s:17:\"business, premium\";}s:32:\"72a0ff4cfae86074a7cdd2dcd432ef11\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:120:\"Add Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:229:\"share, sharing, sharedaddy, social buttons, buttons, share facebook, share twitter, social media sharing, social media share, social share, icons, email, facebook, twitter, linkedin, pinterest, pocket, social widget, social media\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"bb8c6c190aaec212a7ab6e940165af4d\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:177:\"Shortcodes are WordPress-specific markup that let you add media from popular sites. This feature is no longer necessary as the editor now handles media embeds rather gracefully.\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:236:\"shortcodes, shortcode, embeds, media, bandcamp, dailymotion, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"1abd31fe07ae4fb0f8bb57dc24592219\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:82:\"Generates shorter links so you can have more space to write on social media sites.\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"cae5f097f8d658e0b0ae50733d7c6476\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:50:\"Make it easy for search engines to find your site.\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:11:\"Recommended\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"e9b8318133b2f95e7906cedb3557a87d\";a:14:{s:4:\"name\";s:14:\"Secure Sign On\";s:11:\"description\";s:63:\"Allow users to log in to this site using WordPress.com accounts\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:51:\"sso, single sign on, login, log in, 2fa, two-factor\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"17e66a12031ccf11d8d45ceee0955f05\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:44:\"Collect valuable traffic stats and insights.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"346cf9756e7c1252acecb9a8ca81a21c\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:58:\"Let visitors subscribe to new posts and comments via email\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"ca086af79d0d9dccacc934ccff5b4fd7\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:61:\"Display image galleries in a variety of elegant arrangements.\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"43c24feb7c541c376af93e0251c1a261\";a:14:{s:4:\"name\";s:20:\"Backups and Scanning\";s:11:\"description\";s:100:\"Protect your site with daily or real-time backups and automated virus scanning and threat detection.\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:16:\"Security, Health\";s:25:\"additional_search_queries\";s:386:\"backup, cloud backup, database backup, restore, wordpress backup, backup plugin, wordpress backup plugin, back up, backup wordpress, backwpup, vaultpress, backups, off-site backups, offsite backup, offsite, off-site, antivirus, malware scanner, security, virus, viruses, prevent viruses, scan, anti-virus, antimalware, protection, safe browsing, malware, wp security, wordpress security\";s:12:\"plan_classes\";s:27:\"personal, business, premium\";}s:32:\"b9396d8038fc29140b499098d2294d79\";a:14:{s:4:\"name\";s:17:\"Site verification\";s:11:\"description\";s:58:\"Establish your site\'s authenticity with external services.\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"afe184082e106c1bdfe1ee844f98aef3\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:101:\"Save on hosting storage and bandwidth costs by streaming fast, ad-free video from our global network.\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:118:\"video, videos, videopress, video gallery, video player, videoplayer, mobile video, vimeo, youtube, html5 video, stream\";s:12:\"plan_classes\";s:17:\"business, premium\";}s:32:\"44637d43460370af9a1b31ce3ccec0cd\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:42:\"Control where widgets appear on your site.\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"694c105a5c3b659acfcddad220048d08\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:49:\"Provides additional widgets for use on your site.\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"21b59e7bb3fe0784e7525ad11ad8a8f6\";a:14:{s:4:\"name\";s:21:\"WooCommerce Analytics\";s:11:\"description\";s:53:\"Enhanced analytics for WooCommerce and Jetpack users.\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"8.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Other, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:69:\"woocommerce, analytics, stats, statistics, tracking, analytics, views\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"ae15da72c5802d72f320640bad669561\";a:14:{s:4:\"name\";s:3:\"Ads\";s:11:\"description\";s:60:\"Earn income by allowing Jetpack to display high quality ads.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"4.5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Traffic, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"advertising, ad codes, ads\";s:12:\"plan_classes\";s:17:\"premium, business\";}s:32:\"212a162108f1dc20cc6c768d5b47d4f2\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"f1bb571a95c5de1e6adaf9db8567c039\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"cb5d81445061b89d19cb9c7754697a39\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"ea0fbbd64080c81a90a784924603588c\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"5c53fdb3633ba3232f60180116900273\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"40b97d9ce396339d3e8e46b833a045b5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"0739df64747f2d02c140f23ce6c19cd8\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"348754bc914ee02c72d9af445627784c\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"a7b21cc562ee9ffa357bba19701fe45b\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"4f84d218792a6efa06ed6feae09c4dd5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}}", "no");
INSERT INTO wpy4_options VALUES("245783", "litespeed.conf.optm-css_http2", "", "yes");
INSERT INTO wpy4_options VALUES("245784", "litespeed.conf.optm-css_exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245785", "litespeed.conf.optm-js_min", "", "yes");
INSERT INTO wpy4_options VALUES("243689", "jetpack_sync_settings_term_relationships_full_sync_item_size", "100", "yes");
INSERT INTO wpy4_options VALUES("243690", "jetpack_sync_settings_sync_sender_enabled", "1", "yes");
INSERT INTO wpy4_options VALUES("243691", "jetpack_sync_settings_full_sync_sender_enabled", "1", "yes");
INSERT INTO wpy4_options VALUES("243692", "jetpack_sync_settings_full_sync_send_duration", "9", "yes");
INSERT INTO wpy4_options VALUES("243693", "jetpack_sync_settings_full_sync_limits", "a:5:{s:5:\"users\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}s:5:\"terms\";a:2:{s:10:\"chunk_size\";i:1000;s:10:\"max_chunks\";i:10;}s:5:\"posts\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:1;}s:8:\"comments\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}s:18:\"term_relationships\";a:2:{s:10:\"chunk_size\";i:1000;s:10:\"max_chunks\";i:10;}}", "yes");
INSERT INTO wpy4_options VALUES("245677", "litespeed_messages", "a:3:{i:0;b:0;i:1;s:921:\"<div class=\"notice notice-info lscwp-whm-notice is-dismissible\"><p><h3>LiteSpeed Cache plugin is installed!</h3> This message indicates that the plugin was installed by the server admin. The LiteSpeed Cache plugin is used to cache pages - a simple way to improve the performance of the site. However, there is no way of knowing all the possible customizations that were implemented. For that reason, please test the site to make sure everything still functions properly.<br /><br />Examples of test cases include:<ul><li>Visit the site while logged out.</li><li>Create a post, make sure the front page is accurate.</li></ul>If there are any questions, the team is always happy to answer any questions on the <a href=\"https://wordpress.org/support/plugin/litespeed-cache\" rel=\"noopener noreferrer\" target=\"_blank\">support forum</a>.<br />If you would rather not move at litespeed, you can deactivate this plugin.</p></div>\";i:2;s:94:\"<div class=\"notice notice-success is-dismissible\"><p>Purged all caches successfully.</p></div>\";}", "yes");
INSERT INTO wpy4_options VALUES("245773", "litespeed.conf.img_optm-rm_bkup", "", "yes");
INSERT INTO wpy4_options VALUES("245774", "litespeed.conf.img_optm-webp", "", "yes");
INSERT INTO wpy4_options VALUES("245775", "litespeed.conf.img_optm-lossless", "", "yes");
INSERT INTO wpy4_options VALUES("245776", "litespeed.conf.img_optm-exif", "", "yes");
INSERT INTO wpy4_options VALUES("245777", "litespeed.conf.img_optm-webp_replace", "", "yes");
INSERT INTO wpy4_options VALUES("245778", "litespeed.conf.img_optm-webp_replace_srcset", "", "yes");
INSERT INTO wpy4_options VALUES("245779", "litespeed.conf.optm-css_min", "", "yes");
INSERT INTO wpy4_options VALUES("245780", "litespeed.conf.optm-css_inline_min", "", "yes");
INSERT INTO wpy4_options VALUES("245781", "litespeed.conf.optm-css_comb", "", "yes");
INSERT INTO wpy4_options VALUES("245782", "litespeed.conf.optm-css_comb_priority", "", "yes");
INSERT INTO wpy4_options VALUES("245821", "litespeed.optimize.timestamp_purge_css", "1595618379", "yes");
INSERT INTO wpy4_options VALUES("245696", "litespeed.conf.cache-browser", "", "yes");
INSERT INTO wpy4_options VALUES("245697", "litespeed.conf.cache-ttl_browser", "2592000", "yes");
INSERT INTO wpy4_options VALUES("245698", "litespeed.conf.util-instant_click", "", "yes");
INSERT INTO wpy4_options VALUES("245757", "litespeed.conf.cdn-quic", "", "yes");
INSERT INTO wpy4_options VALUES("245758", "litespeed.conf.cdn-cloudflare", "", "yes");
INSERT INTO wpy4_options VALUES("245759", "litespeed.conf.cdn-cloudflare_email", "", "yes");
INSERT INTO wpy4_options VALUES("245699", "litespeed.conf.util-no_https_vary", "", "yes");
INSERT INTO wpy4_options VALUES("245700", "litespeed.conf.purge-upgrade", "1", "yes");
INSERT INTO wpy4_options VALUES("245701", "litespeed.conf.purge-timed_urls", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245702", "litespeed.conf.purge-timed_urls_time", "", "yes");
INSERT INTO wpy4_options VALUES("245703", "litespeed.conf.cache-priv", "1", "yes");
INSERT INTO wpy4_options VALUES("245704", "litespeed.conf.cache-commenter", "1", "yes");
INSERT INTO wpy4_options VALUES("245705", "litespeed.conf.cache-rest", "1", "yes");
INSERT INTO wpy4_options VALUES("245706", "litespeed.conf.cache-page_login", "1", "yes");
INSERT INTO wpy4_options VALUES("245707", "litespeed.conf.cache-favicon", "1", "yes");
INSERT INTO wpy4_options VALUES("245708", "litespeed.conf.cache-resources", "1", "yes");
INSERT INTO wpy4_options VALUES("245709", "litespeed.conf.cache-mobile", "", "yes");
INSERT INTO wpy4_options VALUES("245710", "litespeed.conf.cache-mobile_rules", "a:7:{i:0;s:6:\"Mobile\";i:1;s:7:\"Android\";i:2;s:5:\"Silk/\";i:3;s:6:\"Kindle\";i:4;s:10:\"BlackBerry\";i:5;s:10:\"Opera Mini\";i:6;s:10:\"Opera Mobi\";}", "yes");
INSERT INTO wpy4_options VALUES("245711", "litespeed.conf.cache-exc_useragents", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245712", "litespeed.conf.cache-exc_cookies", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245713", "litespeed.conf.cache-exc_qs", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245714", "litespeed.conf.cache-exc_cat", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245715", "litespeed.conf.cache-exc_tag", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245716", "litespeed.conf.cache-ttl_pub", "604800", "yes");
INSERT INTO wpy4_options VALUES("245717", "litespeed.conf.cache-ttl_priv", "1800", "yes");
INSERT INTO wpy4_options VALUES("245718", "litespeed.conf.cache-ttl_frontpage", "604800", "yes");
INSERT INTO wpy4_options VALUES("245719", "litespeed.conf.cache-ttl_feed", "1", "yes");
INSERT INTO wpy4_options VALUES("245720", "litespeed.conf.cache-login_cookie", "", "yes");
INSERT INTO wpy4_options VALUES("245721", "litespeed.conf.debug-disable_all", "", "yes");
INSERT INTO wpy4_options VALUES("245722", "litespeed.conf.debug", "0", "yes");
INSERT INTO wpy4_options VALUES("245723", "litespeed.conf.debug-ips", "a:1:{i:0;s:9:\"127.0.0.1\";}", "yes");
INSERT INTO wpy4_options VALUES("245724", "litespeed.conf.debug-level", "", "yes");
INSERT INTO wpy4_options VALUES("245725", "litespeed.conf.debug-filesize", "3", "yes");
INSERT INTO wpy4_options VALUES("245726", "litespeed.conf.debug-cookie", "", "yes");
INSERT INTO wpy4_options VALUES("245727", "litespeed.conf.debug-collaps_qs", "", "yes");
INSERT INTO wpy4_options VALUES("245728", "litespeed.conf.crawler", "", "yes");
INSERT INTO wpy4_options VALUES("245729", "litespeed.conf.crawler-inc_posts", "1", "yes");
INSERT INTO wpy4_options VALUES("245730", "litespeed.conf.crawler-inc_pages", "1", "yes");
INSERT INTO wpy4_options VALUES("245731", "litespeed.conf.crawler-inc_cats", "1", "yes");
INSERT INTO wpy4_options VALUES("244334", "wpdevart_comments_box_order_type", "social", "yes");
INSERT INTO wpy4_options VALUES("244335", "wpdevart_comment_title_text", "Facebook Comments", "yes");
INSERT INTO wpy4_options VALUES("244336", "wpdevart_comment_title_text_color", "#000000", "yes");
INSERT INTO wpy4_options VALUES("244337", "wpdevart_comment_title_text_font_size", "15", "yes");
INSERT INTO wpy4_options VALUES("244338", "wpdevart_comment_title_text_font_famely", "Arial,Helvetica Neue,Helvetica,sans-serif", "yes");
INSERT INTO wpy4_options VALUES("244339", "wpdevart_comment_title_text_position", "left", "yes");
INSERT INTO wpy4_options VALUES("244340", "wpdevart_comments_box_show_in", "{\\\"home\\\":true,\\\"post\\\":true,\\\"page\\\":true}", "yes");
INSERT INTO wpy4_options VALUES("244341", "wpdevart_comments_box_width", "100%", "yes");
INSERT INTO wpy4_options VALUES("244342", "wpdevart_comments_box_count_of_comments", "5", "yes");
INSERT INTO wpy4_options VALUES("244343", "wpdevart_comments_box_locale", "en_US", "yes");
INSERT INTO wpy4_options VALUES("281185", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1595618383;s:7:\"checked\";a:10:{s:39:\"advanced-wp-reset/advanced-wp-reset.php\";s:5:\"1.1.0\";s:19:\"jetpack/jetpack.php\";s:5:\"8.6.1\";s:35:\"litespeed-cache/litespeed-cache.php\";s:5:\"3.2.2\";s:41:\"mega-addons-for-visual-composer/index.php\";s:3:\"4.0\";s:39:\"nativechurch-core/nativechurch-core.php\";s:5:\"1.0.1\";s:41:\"ocean-posts-slider/ocean-posts-slider.php\";s:5:\"1.1.0\";s:33:\"post-slider-wd/post-slider-wd.php\";s:6:\"1.0.59\";s:23:\"wordfence/wordfence.php\";s:5:\"7.4.7\";s:27:\"js_composer/js_composer.php\";s:5:\"5.5.4\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:6:\"2.2.10\";}s:8:\"response\";a:4:{s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"8.7.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.8.7.1.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:60:\"https://ps.w.org/jetpack/assets/icon-256x256.png?rev=1791404\";s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=1791404\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=1791404\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=1791404\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=1791404\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.4.2\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:35:\"litespeed-cache/litespeed-cache.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:29:\"w.org/plugins/litespeed-cache\";s:4:\"slug\";s:15:\"litespeed-cache\";s:6:\"plugin\";s:35:\"litespeed-cache/litespeed-cache.php\";s:11:\"new_version\";s:5:\"3.2.4\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/litespeed-cache/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/litespeed-cache.3.2.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-256x256.png?rev=1574145\";s:2:\"1x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-128x128.png?rev=1574145\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/litespeed-cache/assets/banner-1544x500.png?rev=2031698\";s:2:\"1x\";s:70:\"https://ps.w.org/litespeed-cache/assets/banner-772x250.png?rev=2031698\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.4.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:5:\"7.4.9\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wordfence.7.4.9.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/wordfence/assets/icon-256x256.png?rev=2070855\";s:2:\"1x\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";s:3:\"svg\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.jpg?rev=2124102\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.jpg?rev=2124102\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.4.2\";s:12:\"requires_php\";s:3:\"5.3\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:27:\"js_composer/js_composer.php\";O:8:\"stdClass\":6:{s:4:\"slug\";s:11:\"js_composer\";s:11:\"new_version\";s:3:\"6.2\";s:6:\"plugin\";s:27:\"js_composer/js_composer.php\";s:3:\"url\";s:0:\"\";s:7:\"package\";b:0;s:4:\"name\";s:21:\"WPBakery Page Builder\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:5:{s:39:\"advanced-wp-reset/advanced-wp-reset.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:31:\"w.org/plugins/advanced-wp-reset\";s:4:\"slug\";s:17:\"advanced-wp-reset\";s:6:\"plugin\";s:39:\"advanced-wp-reset/advanced-wp-reset.php\";s:11:\"new_version\";s:5:\"1.1.0\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/advanced-wp-reset/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/advanced-wp-reset.1.1.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/advanced-wp-reset/assets/icon-256x256.png?rev=1375283\";s:2:\"1x\";s:70:\"https://ps.w.org/advanced-wp-reset/assets/icon-128x128.png?rev=1375283\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/advanced-wp-reset/assets/banner-772x250.png?rev=1375273\";}s:11:\"banners_rtl\";a:0:{}}s:41:\"mega-addons-for-visual-composer/index.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:45:\"w.org/plugins/mega-addons-for-visual-composer\";s:4:\"slug\";s:31:\"mega-addons-for-visual-composer\";s:6:\"plugin\";s:41:\"mega-addons-for-visual-composer/index.php\";s:11:\"new_version\";s:3:\"4.0\";s:3:\"url\";s:62:\"https://wordpress.org/plugins/mega-addons-for-visual-composer/\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/plugin/mega-addons-for-visual-composer.4.0.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:84:\"https://ps.w.org/mega-addons-for-visual-composer/assets/icon-128x128.jpg?rev=2205499\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:86:\"https://ps.w.org/mega-addons-for-visual-composer/assets/banner-772x250.png?rev=2339102\";}s:11:\"banners_rtl\";a:0:{}}s:41:\"ocean-posts-slider/ocean-posts-slider.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:32:\"w.org/plugins/ocean-posts-slider\";s:4:\"slug\";s:18:\"ocean-posts-slider\";s:6:\"plugin\";s:41:\"ocean-posts-slider/ocean-posts-slider.php\";s:11:\"new_version\";s:5:\"1.1.0\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/ocean-posts-slider/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/ocean-posts-slider.1.1.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/ocean-posts-slider/assets/icon-256x256.png?rev=1583108\";s:2:\"1x\";s:71:\"https://ps.w.org/ocean-posts-slider/assets/icon-128x128.png?rev=1583108\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/ocean-posts-slider/assets/banner-1544x500.png?rev=1583108\";s:2:\"1x\";s:73:\"https://ps.w.org/ocean-posts-slider/assets/banner-772x250.png?rev=1583108\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"post-slider-wd/post-slider-wd.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/post-slider-wd\";s:4:\"slug\";s:14:\"post-slider-wd\";s:6:\"plugin\";s:33:\"post-slider-wd/post-slider-wd.php\";s:11:\"new_version\";s:6:\"1.0.59\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/post-slider-wd/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/post-slider-wd.1.0.59.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/post-slider-wd/assets/icon-256x256.png?rev=2068863\";s:2:\"1x\";s:67:\"https://ps.w.org/post-slider-wd/assets/icon-128x128.png?rev=2068863\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/post-slider-wd/assets/banner-1544x500.png?rev=2068863\";s:2:\"1x\";s:69:\"https://ps.w.org/post-slider-wd/assets/banner-772x250.png?rev=2068863\";}s:11:\"banners_rtl\";a:0:{}}s:34:\"wp-clone-by-wp-academy/wpclone.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:36:\"w.org/plugins/wp-clone-by-wp-academy\";s:4:\"slug\";s:22:\"wp-clone-by-wp-academy\";s:6:\"plugin\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:11:\"new_version\";s:6:\"2.2.10\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/wp-clone-by-wp-academy/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/wp-clone-by-wp-academy.2.2.10.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:75:\"https://ps.w.org/wp-clone-by-wp-academy/assets/icon-128x128.png?rev=2181280\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:76:\"https://ps.w.org/wp-clone-by-wp-academy/assets/banner-772x250.jpg?rev=706555\";}s:11:\"banners_rtl\";a:0:{}}}}", "no");
INSERT INTO wpy4_options VALUES("245738", "litespeed.conf.crawler-crawl_interval", "302400", "yes");
INSERT INTO wpy4_options VALUES("245739", "litespeed.conf.crawler-threads", "3", "yes");
INSERT INTO wpy4_options VALUES("245740", "litespeed.conf.crawler-load_limit", "1", "yes");
INSERT INTO wpy4_options VALUES("245741", "litespeed.conf.crawler-sitemap", "", "yes");
INSERT INTO wpy4_options VALUES("245742", "litespeed.conf.object", "", "yes");
INSERT INTO wpy4_options VALUES("245743", "litespeed.conf.object-kind", "", "yes");
INSERT INTO wpy4_options VALUES("245744", "litespeed.conf.object-host", "localhost", "yes");
INSERT INTO wpy4_options VALUES("245745", "litespeed.conf.object-port", "11211", "yes");
INSERT INTO wpy4_options VALUES("245746", "litespeed.conf.object-life", "360", "yes");
INSERT INTO wpy4_options VALUES("245747", "litespeed.conf.object-persistent", "1", "yes");
INSERT INTO wpy4_options VALUES("245748", "litespeed.conf.object-admin", "1", "yes");
INSERT INTO wpy4_options VALUES("245749", "litespeed.conf.object-transients", "1", "yes");
INSERT INTO wpy4_options VALUES("245750", "litespeed.conf.object-db_id", "0", "yes");
INSERT INTO wpy4_options VALUES("245751", "litespeed.conf.object-user", "", "yes");
INSERT INTO wpy4_options VALUES("245752", "litespeed.conf.object-psw", "", "yes");
INSERT INTO wpy4_options VALUES("245753", "litespeed.conf.cdn", "", "yes");
INSERT INTO wpy4_options VALUES("245754", "litespeed.conf.cdn-ori", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("244148", "action_scheduler_hybrid_store_demarkation", "196", "yes");
INSERT INTO wpy4_options VALUES("244149", "schema-ActionScheduler_StoreSchema", "3.0.1591919789", "yes");
INSERT INTO wpy4_options VALUES("244150", "schema-ActionScheduler_LoggerSchema", "2.0.1591919789", "yes");
INSERT INTO wpy4_options VALUES("245684", "litespeed.conf.debug-log_no_filters", "a:4:{i:0;s:7:\"gettext\";i:1;s:20:\"gettext_with_context\";i:2;s:13:\"get_the_terms\";i:3;s:8:\"get_term\";}", "yes");
INSERT INTO wpy4_options VALUES("245683", "litespeed.conf.img_optm-webp_attr", "a:5:{i:0;s:7:\"img.src\";i:1;s:14:\"div.data-thumb\";i:2;s:12:\"img.data-src\";i:3;s:20:\"div.data-large_image\";i:4;s:19:\"img.retina_logo_url\";}", "yes");
INSERT INTO wpy4_options VALUES("245695", "litespeed.conf.esi-cache_commform", "1", "yes");
INSERT INTO wpy4_options VALUES("245687", "litespeed.conf.cdn-mapping", "a:1:{i:0;a:5:{s:3:\"url\";b:0;s:7:\"inc_img\";s:1:\"1\";s:7:\"inc_css\";s:1:\"1\";s:6:\"inc_js\";s:1:\"1\";s:8:\"filetype\";s:86:\".aac
.css
.eot
.gif
.jpeg
.js
.jpg
.less
.mp3
.mp4
.ogg
.otf
.pdf
.png
.svg
.ttf
.woff\";}}", "yes");
INSERT INTO wpy4_options VALUES("245690", "litespeed.conf.auto_upgrade", "", "yes");
INSERT INTO wpy4_options VALUES("245691", "litespeed.conf.news", "", "yes");
INSERT INTO wpy4_options VALUES("245692", "litespeed.conf.server_ip", "", "yes");
INSERT INTO wpy4_options VALUES("245693", "litespeed.conf.esi", "", "yes");
INSERT INTO wpy4_options VALUES("245694", "litespeed.conf.esi-cache_admbar", "1", "yes");
INSERT INTO wpy4_options VALUES("245681", "litespeed.conf.object-global_groups", "a:12:{i:0;s:5:\"users\";i:1;s:10:\"userlogins\";i:2;s:8:\"usermeta\";i:3;s:9:\"user_meta\";i:4;s:14:\"site-transient\";i:5;s:12:\"site-options\";i:6;s:11:\"site-lookup\";i:7;s:11:\"blog-lookup\";i:8;s:12:\"blog-details\";i:9;s:3:\"rss\";i:10;s:12:\"global-posts\";i:11;s:13:\"blog-id-cache\";}", "yes");
INSERT INTO wpy4_options VALUES("245685", "litespeed.conf.debug-log_no_part_filters", "a:4:{i:0;s:4:\"i18n\";i:1;s:6:\"locale\";i:2;s:8:\"settings\";i:3;s:6:\"option\";}", "yes");
INSERT INTO wpy4_options VALUES("245964", "litespeed.gui._summary", "a:5:{s:11:\"new_version\";i:1592123782;s:5:\"score\";i:1592469382;s:22:\"new_version.last_check\";i:1595607595;s:13:\"new_version.v\";s:5:\"3.2.4\";s:16:\"score.last_check\";i:1595607595;}", "yes");
INSERT INTO wpy4_options VALUES("245630", "litespeed-gui-summary", "a:2:{s:24:\"banner_promo.new_version\";i:1592121358;s:12:\"banner_promo\";i:1592466958;}", "yes");
INSERT INTO wpy4_options VALUES("281197", "_transient_timeout_jetpack_plugin_api_action_links_refresh", "1595704784", "no");
INSERT INTO wpy4_options VALUES("281198", "_transient_jetpack_plugin_api_action_links_refresh", "1595618384", "no");
INSERT INTO wpy4_options VALUES("281199", "_transient_timeout_jetpack_last_plugin_sync", "1595621983", "no");
INSERT INTO wpy4_options VALUES("281200", "_transient_jetpack_last_plugin_sync", "1595618383", "no");
INSERT INTO wpy4_options VALUES("281233", "_transient_timeout_jetpack_sync_callables_await", "1595619569", "no");
INSERT INTO wpy4_options VALUES("281234", "_transient_jetpack_sync_callables_await", "1595619509.8", "no");
INSERT INTO wpy4_options VALUES("281230", "_transient_timeout_jetpack_jitm_ddffb3a283c20ac4b6d0454a360d9f2", "1595619698", "no");
INSERT INTO wpy4_options VALUES("281231", "_transient_jetpack_jitm_ddffb3a283c20ac4b6d0454a360d9f2", "a:1:{s:18:\"last_response_time\";i:1595619398;}", "no");
INSERT INTO wpy4_options VALUES("244117", "give_cache_give_add_ons_feed_addons-directory", "a:2:{s:4:\"data\";s:41004:\"
<!DOCTYPE html>
<html>
<head lang=\"en\">
	<meta charset=\"UTF-8\">
	<meta name=\"robots\" content=\"noindex\">
	<title>GiveWP Add-ons</title>
</head>
<body>


	<div class=\"post-354 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-must-have download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-must-have edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/recurring-donations/\" title=\"Recurring Donations\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Recurring-Donations-347x215.jpg\" alt=\"Recurring Donations\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/recurring-donations/\" title=\"Recurring Donations\" target=\"_blank\">Recurring Donations</a>
			</h3>
			<p>Create powerful subscription based donations with the GiveWP Recurring Donations add-on.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/recurring-donations/\" title=\"Recurring Donations\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-243 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-must-have download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-must-have edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/form-field-manager/\" title=\"Form Field Manager\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Form-Field-Manager-347x215.jpg\" alt=\"Form Field Manager\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/form-field-manager/\" title=\"Form Field Manager\" target=\"_blank\">Form Field Manager</a>
			</h3>
			<p>Customize donation form fields using an intuitive drag-and-drop custom field creation system.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/form-field-manager/\" title=\"Form Field Manager\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-114816 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-must-have download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-must-have edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/fee-recovery/\" title=\"Fee Recovery\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Fee-Recovery-347x215.jpg\" alt=\"Fee Recovery\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/fee-recovery/\" title=\"Fee Recovery\" target=\"_blank\">Fee Recovery</a>
			</h3>
			<p>Ask your donors to give a little extra to help cover the fees.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/fee-recovery/\" title=\"Fee Recovery\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-141019 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-must-have download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-must-have edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/tributes/\" title=\"Tributes\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Tributes-347x215.jpg\" alt=\"Tributes\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/tributes/\" title=\"Tributes\" target=\"_blank\">Tributes</a>
			</h3>
			<p>Allow donors to give to your Cause via customizable tributes like &#8220;In honor of,&#8221; &#8220;In memory of,&#8221; or any dedication your prefer. </p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/tributes/\" title=\"Tributes\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-196798 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/currency-switcher/\" title=\"Currency Switcher\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Currency-Switcher-347x215.jpg\" alt=\"Currency Switcher\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/currency-switcher/\" title=\"Currency Switcher\" target=\"_blank\">Currency Switcher</a>
			</h3>
			<p>Currency Switcher allows your donors to choose which currency they&#8217;d like to donate with.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/currency-switcher/\" title=\"Currency Switcher\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-438 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-must-have download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-must-have edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/pdf-receipts/\" title=\"PDF Receipts\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/PDF-Recipts-347x215.jpg\" alt=\"PDF Receipts\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/pdf-receipts/\" title=\"PDF Receipts\" target=\"_blank\">PDF Receipts</a>
			</h3>
			<p>Make it easy for your donors to print their tax deductible receipts by emailing receipts as a PDF.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/pdf-receipts/\" title=\"PDF Receipts\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-330663 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/annual-receipts/\" title=\"Annual Receipts\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Annual-Receipts-347x215.jpg\" alt=\"Annual Receipts\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/annual-receipts/\" title=\"Annual Receipts\" target=\"_blank\">Annual Receipts</a>
			</h3>
			<p>Provide your donors with an annual overview of their donations.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/annual-receipts/\" title=\"Annual Receipts\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-245 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/stripe-gateway/\" title=\"Stripe Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Stripe-347x215.jpg\" alt=\"Stripe Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/stripe-gateway/\" title=\"Stripe Gateway\" target=\"_blank\">Stripe Gateway</a>
			</h3>
			<p>Stripe is one of the most popular Gateways for a good reason. Accept credit card donations via Stripe with this add-on.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/stripe-gateway/\" title=\"Stripe Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-244 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/authorize-net-gateway/\" title=\"Authorize.Net Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Authorize.net_-347x215.jpg\" alt=\"Authorize.Net Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/authorize-net-gateway/\" title=\"Authorize.Net Gateway\" target=\"_blank\">Authorize.Net Gateway</a>
			</h3>
			<p>Authorize.Net is a well established payment gateway. This add-on allows you to accept credit card donations via Authorize.Net.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/authorize-net-gateway/\" title=\"Authorize.Net Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-1541 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/gift-aid/\" title=\"Gift Aid\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Gift-Aid-347x215.jpg\" alt=\"Gift Aid\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/gift-aid/\" title=\"Gift Aid\" target=\"_blank\">Gift Aid</a>
			</h3>
			<p>Donors in the UK can &#8220;Gift Aid&#8221; their donations which adds an extra 25% for your charity.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/gift-aid/\" title=\"Gift Aid\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-144226 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/donation-upsells-for-woocommerce/\" title=\"Donation Upsells for WooCommerce\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Donation-Upsells-347x215.jpg\" alt=\"Donation Upsells for WooCommerce\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/donation-upsells-for-woocommerce/\" title=\"Donation Upsells for WooCommerce\" target=\"_blank\">Donation Upsells for WooCommerce</a>
			</h3>
			<p>Add a donation &#8220;upsell&#8221; to your WooCommerce cart or checkout screen to allow your customers to also become donors.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/donation-upsells-for-woocommerce/\" title=\"Donation Upsells for WooCommerce\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-3031 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/google-analytics/\" title=\"Google Analytics Donation Tracking\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Google-Analytics-347x215.jpg\" alt=\"Google Analytics Donation Tracking\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/google-analytics/\" title=\"Google Analytics Donation Tracking\" target=\"_blank\">Google Analytics Donation Tracking</a>
			</h3>
			<p>Track your donations made on your site through Google Analytics Enhanced E-commerce.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/google-analytics/\" title=\"Google Analytics Donation Tracking\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-242 download type-download status-publish has-post-thumbnail hentry download_category-marketing download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-marketing edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/mailchimp/\" title=\"MailChimp\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Mailchimp-347x215.jpg\" alt=\"MailChimp\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/mailchimp/\" title=\"MailChimp\" target=\"_blank\">MailChimp</a>
			</h3>
			<p>Boost your cause marketing by allowing users to subscribe to your MailChimp lists and groups when donating.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/mailchimp/\" title=\"MailChimp\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-46747 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/manual-donations/\" title=\"Manual Donations\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Manual-Donations-347x215.jpg\" alt=\"Manual Donations\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/manual-donations/\" title=\"Manual Donations\" target=\"_blank\">Manual Donations</a>
			</h3>
			<p>Manually create donation payments within Give. Support for Recurring Donations.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/manual-donations/\" title=\"Manual Donations\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-3116 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/zapier/\" title=\"Zapier\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Zapier-347x215.jpg\" alt=\"Zapier\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/zapier/\" title=\"Zapier\" target=\"_blank\">Zapier</a>
			</h3>
			<p>Use Zapier to connect Give to 1,000+ web services like Salesforce, MailChimp, Slack, and more!</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/zapier/\" title=\"Zapier\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-59024 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/email-reports/\" title=\"Email Reports\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Email-Reports-347x215.jpg\" alt=\"Email Reports\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/email-reports/\" title=\"Email Reports\" target=\"_blank\">Email Reports</a>
			</h3>
			<p>Receive comprehensive donation reports via email.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/email-reports/\" title=\"Email Reports\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-59603 download type-download status-publish has-post-thumbnail hentry download_category-tools download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-tools edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/per-form-gateways/\" title=\"Per Form Gateways\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Per-Form-Gateways-347x215.jpg\" alt=\"Per Form Gateways\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/per-form-gateways/\" title=\"Per Form Gateways\" target=\"_blank\">Per Form Gateways</a>
			</h3>
			<p>Choose on a per form basis which payment gateways you would like enabled for donors.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/per-form-gateways/\" title=\"Per Form Gateways\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-1485 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/2checkout-gateway/\" title=\"2Checkout Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/2Checkout-347x215.jpg\" alt=\"2Checkout Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/2checkout-gateway/\" title=\"2Checkout Gateway\" target=\"_blank\">2Checkout Gateway</a>
			</h3>
			<p>2Checkout is an international credit card merchant. It supports over 87 different currencies, 197 countries, and more than 15 languages.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/2checkout-gateway/\" title=\"2Checkout Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-1536 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/iats-gateway/\" title=\"iATS Payment Solutions\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/IATs-347x215.jpg\" alt=\"iATS Payment Solutions\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/iats-gateway/\" title=\"iATS Payment Solutions\" target=\"_blank\">iATS Payment Solutions</a>
			</h3>
			<p>iATS provides merchant account services exclusively for nonprofit organizations.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/iats-gateway/\" title=\"iATS Payment Solutions\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-246 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/paypal-pro-gateway/\" title=\"PayPal Pro Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/PayPal-347x215.jpg\" alt=\"PayPal Pro Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/paypal-pro-gateway/\" title=\"PayPal Pro Gateway\" target=\"_blank\">PayPal Pro Gateway</a>
			</h3>
			<p>Accept credit card donations directly through GiveWP using PayPal Pro.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/paypal-pro-gateway/\" title=\"PayPal Pro Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-107608 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/paytm-gateway/\" title=\"Paytm Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Paytm-347x215.jpg\" alt=\"Paytm Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/paytm-gateway/\" title=\"Paytm Gateway\" target=\"_blank\">Paytm Gateway</a>
			</h3>
			<p>Use the Paytm Gateway to accept online donations with Paytm and GiveWP. </p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/paytm-gateway/\" title=\"Paytm Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-212536 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/payfast-gateway/\" title=\"PayFast\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Payfast-347x215.jpg\" alt=\"PayFast\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/payfast-gateway/\" title=\"PayFast\" target=\"_blank\">PayFast</a>
			</h3>
			<p>PayFast is one of the most popular in South Africa. Accept credit card donations via PayFast with this add-on.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/payfast-gateway/\" title=\"PayFast\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-236949 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/mollie-payment-gateway/\" title=\"Mollie Payment Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Mollie-347x215.jpg\" alt=\"Mollie Payment Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/mollie-payment-gateway/\" title=\"Mollie Payment Gateway\" target=\"_blank\">Mollie Payment Gateway</a>
			</h3>
			<p>Accept donations through the Mollie Payment Gateway using the GiveWP WordPress donation plugin. </p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/mollie-payment-gateway/\" title=\"Mollie Payment Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-336539 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/moneris-gateway/\" title=\"Moneris Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Moneris-347x215.jpg\" alt=\"Moneris Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/moneris-gateway/\" title=\"Moneris Gateway\" target=\"_blank\">Moneris Gateway</a>
			</h3>
			<p>Accept donations quickly and easily through Canada&#8217;s leading payment processor, Moneris. Accept online donations using Moneris Moneris processes more than 3 billion credit and debit card transactions a year for more than 350,000 users throughout North America. Why use Moneris? Accept online donations in Canadian dollars Supports eFraud tools / address and card verification Accepts [&hellip;]</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/moneris-gateway/\" title=\"Moneris Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-328060 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/square-gateway/\" title=\"Square Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Square-347x215.jpg\" alt=\"Square Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/square-gateway/\" title=\"Square Gateway\" target=\"_blank\">Square Gateway</a>
			</h3>
			<p>Accept credit card donations directly on your website using the Square payment gateway add-on for GiveWP.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/square-gateway/\" title=\"Square Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-144603 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/sofort/\" title=\"Sofort\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Sofort-347x215.jpg\" alt=\"Sofort\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/sofort/\" title=\"Sofort\" target=\"_blank\">Sofort</a>
			</h3>
			<p>Accept direct bank payments online via Sofort. Popular in Europe and Germany.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/sofort/\" title=\"Sofort\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-88556 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/payumoney-gateway/\" title=\"PayUmoney Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/PayU-347x215.jpg\" alt=\"PayUmoney Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/payumoney-gateway/\" title=\"PayUmoney Gateway\" target=\"_blank\">PayUmoney Gateway</a>
			</h3>
			<p>Accept donation payments in India with the top-rated PayUmoney gateway. Quick and easy setup, fully supported and documented. </p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/payumoney-gateway/\" title=\"PayUmoney Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-339 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/paymill-gateway/\" title=\"Paymill Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Paymill-347x215.jpg\" alt=\"Paymill Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/paymill-gateway/\" title=\"Paymill Gateway\" target=\"_blank\">Paymill Gateway</a>
			</h3>
			<p>Accept credit card donations directly through GiveWP using Paymill.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/paymill-gateway/\" title=\"Paymill Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-105271 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/gocardless-gateway/\" title=\"GoCardless Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/GoCardless-347x215.jpg\" alt=\"GoCardless Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/gocardless-gateway/\" title=\"GoCardless Gateway\" target=\"_blank\">GoCardless Gateway</a>
			</h3>
			<p>GoCardless is a popular gateway that offers a low-cost Direct Debit solution for accepting online donations. The gateway is built atop a modern platform and also supports recurring donations. About the GoCardless Gateway The GiveWP GoCardless gateway provides a turnkey solution for accepting Direct Debit donations on your website. This allows you to offer your [&hellip;]</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/gocardless-gateway/\" title=\"GoCardless Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-107886 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/americloud-payments/\" title=\"AmeriCloud Payments\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Americloud-347x215.jpg\" alt=\"AmeriCloud Payments\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/americloud-payments/\" title=\"AmeriCloud Payments\" target=\"_blank\">AmeriCloud Payments</a>
			</h3>
			<p>This GiveWP add-on allows you to accept credit cards directly on your site via AmeriCloud Payments. When donors give through the AmeriCloud Payments gateway, users enter their credit card details during the donation process and never leave your site, resulting in a better experience for the user and more successful conversions for you. Why AmeriCloud [&hellip;]</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/americloud-payments/\" title=\"AmeriCloud Payments\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-1680 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/braintree-payment-gateway/\" title=\"Braintree Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Braintree-347x215.jpg\" alt=\"Braintree Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/braintree-payment-gateway/\" title=\"Braintree Gateway\" target=\"_blank\">Braintree Gateway</a>
			</h3>
			<p>Collect donations directly on your website via Braintree. Pay zero fees before reaching $50,000 in donations.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/braintree-payment-gateway/\" title=\"Braintree Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-60430 download type-download status-publish has-post-thumbnail hentry download_category-marketing download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-marketing edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/aweber/\" title=\"AWeber\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/AWeber-347x215.jpg\" alt=\"AWeber\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/aweber/\" title=\"AWeber\" target=\"_blank\">AWeber</a>
			</h3>
			<p>Level up your email marketing lists by allowing donors to subscribe to your AWeber lists during the giving process.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/aweber/\" title=\"AWeber\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-64612 download type-download status-publish has-post-thumbnail hentry download_category-marketing download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-marketing edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/convertkit/\" title=\"ConvertKit\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Convert-Kit-347x215.jpg\" alt=\"ConvertKit\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/convertkit/\" title=\"ConvertKit\" target=\"_blank\">ConvertKit</a>
			</h3>
			<p>Allow donors to subscribe to your ConvertKit forms and tags during the giving process to help further your email marketing.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/convertkit/\" title=\"ConvertKit\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-1832 download type-download status-publish has-post-thumbnail hentry download_category-marketing download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-marketing edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/constant-contact/\" title=\"Constant Contact\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Constant-Contact-347x215.jpg\" alt=\"Constant Contact\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/constant-contact/\" title=\"Constant Contact\" target=\"_blank\">Constant Contact</a>
			</h3>
			<p>Integrate Constant Contact with your donation forms. Subscribe donors to email lists when they donate to your Cause.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/constant-contact/\" title=\"Constant Contact\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-91724 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/razorpay-gateway/\" title=\"Razorpay Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/Razorpay-347x215.jpg\" alt=\"Razorpay Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/razorpay-gateway/\" title=\"Razorpay Gateway\" target=\"_blank\">Razorpay Gateway</a>
			</h3>
			<p>Accept online donation payments with Razorpay.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/razorpay-gateway/\" title=\"Razorpay Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

	<div class=\"post-2060 download type-download status-publish has-post-thumbnail hentry download_category-payment-gateways download_category-basic download_category-plus download_category-pro edd-download edd-download-cat-payment-gateways edd-download-cat-basic edd-download-cat-plus edd-download-cat-pro\">

		<div class=\"featured-img\">

			
				<a href=\"https://givewp.com/addons/ccavenue-gateway/\" title=\"CCAvenue Gateway\" target=\"_blank\"><img src=\"https://givewp.com/wp-content/uploads/2020/03/CCAvenue-347x215.jpg\" alt=\"CCAvenue Gateway\"></a>

			
		</div>

		<div class=\"addon-content\">
			<h3 class=\"addon-heading\">
				<a href=\"https://givewp.com/addons/ccavenue-gateway/\" title=\"CCAvenue Gateway\" target=\"_blank\">CCAvenue Gateway</a>
			</h3>
			<p>CCAvenue is a popular India gateway for accepting donations in in 27+ major foreign currencies.</p>
		</div>

		<div class=\"addon-footer-wrap give-clearfix\">
			<a href=\"https://givewp.com/addons/ccavenue-gateway/\" title=\"CCAvenue Gateway\" class=\"button-secondary\" target=\"_blank\">Learn More				<span class=\"dashicons dashicons-external\"></span></a>
		</div>

	</div>

</body>
</html>\";s:10:\"expiration\";i:1592006099;}", "no");
INSERT INTO wpy4_options VALUES("243708", "jp_sync_lock_full_sync", "1595619524.91", "yes");
INSERT INTO wpy4_options VALUES("245786", "litespeed.conf.optm-js_inline_min", "", "yes");
INSERT INTO wpy4_options VALUES("245787", "litespeed.conf.optm-js_comb", "", "yes");
INSERT INTO wpy4_options VALUES("245788", "litespeed.conf.optm-js_comb_priority", "", "yes");
INSERT INTO wpy4_options VALUES("245789", "litespeed.conf.optm-js_http2", "", "yes");
INSERT INTO wpy4_options VALUES("245790", "litespeed.conf.optm-js_exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245791", "litespeed.conf.optm-ttl", "604800", "yes");
INSERT INTO wpy4_options VALUES("245792", "litespeed.conf.optm-html_min", "", "yes");
INSERT INTO wpy4_options VALUES("245793", "litespeed.conf.optm-qs_rm", "", "yes");
INSERT INTO wpy4_options VALUES("245794", "litespeed.conf.optm-ggfonts_rm", "", "yes");
INSERT INTO wpy4_options VALUES("245795", "litespeed.conf.optm-css_async", "", "yes");
INSERT INTO wpy4_options VALUES("245796", "litespeed.conf.optm-ccss_gen", "1", "yes");
INSERT INTO wpy4_options VALUES("245797", "litespeed.conf.optm-ccss_async", "1", "yes");
INSERT INTO wpy4_options VALUES("245798", "litespeed.conf.optm-css_async_inline", "1", "yes");
INSERT INTO wpy4_options VALUES("245799", "litespeed.conf.optm-js_defer", "", "yes");
INSERT INTO wpy4_options VALUES("245800", "litespeed.conf.optm-emoji_rm", "", "yes");
INSERT INTO wpy4_options VALUES("245801", "litespeed.conf.optm-exc_jq", "1", "yes");
INSERT INTO wpy4_options VALUES("245802", "litespeed.conf.optm-ggfonts_async", "", "yes");
INSERT INTO wpy4_options VALUES("245803", "litespeed.conf.optm-max_size", "1.2", "yes");
INSERT INTO wpy4_options VALUES("245804", "litespeed.conf.optm-rm_comment", "", "yes");
INSERT INTO wpy4_options VALUES("245805", "litespeed.conf.purge-post_all", "", "yes");
INSERT INTO wpy4_options VALUES("245806", "litespeed.conf.purge-post_f", "1", "yes");
INSERT INTO wpy4_options VALUES("245807", "litespeed.conf.purge-post_h", "1", "yes");
INSERT INTO wpy4_options VALUES("245808", "litespeed.conf.purge-post_p", "1", "yes");
INSERT INTO wpy4_options VALUES("245809", "litespeed.conf.purge-post_pwrp", "1", "yes");
INSERT INTO wpy4_options VALUES("245810", "litespeed.conf.purge-post_a", "1", "yes");
INSERT INTO wpy4_options VALUES("245811", "litespeed.conf.purge-post_y", "", "yes");
INSERT INTO wpy4_options VALUES("245812", "litespeed.conf.purge-post_m", "1", "yes");
INSERT INTO wpy4_options VALUES("245813", "litespeed.conf.purge-post_d", "", "yes");
INSERT INTO wpy4_options VALUES("245814", "litespeed.conf.purge-post_t", "1", "yes");
INSERT INTO wpy4_options VALUES("245815", "litespeed.conf.purge-post_pt", "1", "yes");
INSERT INTO wpy4_options VALUES("245816", "litespeed.conf.cache-ttl_status", "a:3:{i:0;s:8:\"403 3600\";i:1;s:8:\"404 3600\";i:2;s:8:\"500 3600\";}", "yes");
INSERT INTO wpy4_options VALUES("245820", "litespeed.conf._version", "3.2.2", "yes");
INSERT INTO wpy4_options VALUES("245823", "litespeed.cloud._summary", "a:2:{s:19:\"curr_request.wp/ver\";i:0;s:19:\"last_request.wp/ver\";i:1595607595;}", "yes");
INSERT INTO wpy4_options VALUES("245824", "litespeed.conf.api_key", "", "yes");
INSERT INTO wpy4_options VALUES("245825", "litespeed.conf.cache-force_uri", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245826", "litespeed.conf.cache-force_pub_uri", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245827", "litespeed.conf.cache-priv_uri", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245828", "litespeed.conf.cache-exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245829", "litespeed.conf.cache-exc_roles", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245830", "litespeed.conf.cache-drop_qs", "a:4:{i:0;s:6:\"fbclid\";i:1;s:5:\"gclid\";i:2;s:4:\"utm*\";i:3;s:3:\"_ga\";}", "yes");
INSERT INTO wpy4_options VALUES("245831", "litespeed.conf.cache-ttl_rest", "604800", "yes");
INSERT INTO wpy4_options VALUES("245832", "litespeed.conf.cache-vary_group", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245833", "litespeed.conf.purge-stale", "", "yes");
INSERT INTO wpy4_options VALUES("245834", "litespeed.conf.esi-nonce", "a:2:{i:0;s:11:\"stats_nonce\";i:1;s:15:\"subscribe_nonce\";}", "yes");
INSERT INTO wpy4_options VALUES("245835", "litespeed.conf.debug-inc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245836", "litespeed.conf.debug-exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245837", "litespeed.conf.db_optm-revisions_max", "0", "yes");
INSERT INTO wpy4_options VALUES("245838", "litespeed.conf.db_optm-revisions_age", "0", "yes");
INSERT INTO wpy4_options VALUES("245839", "litespeed.conf.optm-css_font_display", "", "yes");
INSERT INTO wpy4_options VALUES("245840", "litespeed.conf.optm-js_inline_defer", "", "yes");
INSERT INTO wpy4_options VALUES("245841", "litespeed.conf.optm-exc_roles", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245842", "litespeed.conf.optm-ccss_con", "", "yes");
INSERT INTO wpy4_options VALUES("245843", "litespeed.conf.optm-js_defer_exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245844", "litespeed.conf.optm-dns_prefetch", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245845", "litespeed.conf.optm-dns_prefetch_ctrl", "", "yes");
INSERT INTO wpy4_options VALUES("245846", "litespeed.conf.optm-exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245847", "litespeed.conf.optm-ccss_sep_posttype", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245848", "litespeed.conf.optm-ccss_sep_uri", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245849", "litespeed.conf.object-pswd", "", "yes");
INSERT INTO wpy4_options VALUES("245850", "litespeed.conf.discuss-avatar_cache", "", "yes");
INSERT INTO wpy4_options VALUES("245851", "litespeed.conf.discuss-avatar_cron", "", "yes");
INSERT INTO wpy4_options VALUES("245852", "litespeed.conf.discuss-avatar_cache_ttl", "604800", "yes");
INSERT INTO wpy4_options VALUES("245853", "litespeed.conf.media-placeholder_resp_svg", "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" fill=\"{color}\"/></svg>", "yes");
INSERT INTO wpy4_options VALUES("245854", "litespeed.conf.media-lqip", "", "yes");
INSERT INTO wpy4_options VALUES("245855", "litespeed.conf.media-lqip_qual", "4", "yes");
INSERT INTO wpy4_options VALUES("245856", "litespeed.conf.media-lqip_min_w", "150", "yes");
INSERT INTO wpy4_options VALUES("245857", "litespeed.conf.media-lqip_min_h", "150", "yes");
INSERT INTO wpy4_options VALUES("245858", "litespeed.conf.media-lazy_exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245859", "litespeed.conf.media-lazy_cls_exc", "a:1:{i:0;s:15:\"wmu-preview-img\";}", "yes");
INSERT INTO wpy4_options VALUES("245860", "litespeed.conf.media-lazy_parent_cls_exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245861", "litespeed.conf.media-iframe_lazy_cls_exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245862", "litespeed.conf.media-iframe_lazy_parent_cls_exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245863", "litespeed.conf.media-lazy_uri_exc", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245864", "litespeed.conf.img_optm-jpg_quality", "82", "yes");
INSERT INTO wpy4_options VALUES("245865", "litespeed.conf.crawler-timeout", "30", "yes");
INSERT INTO wpy4_options VALUES("245866", "litespeed.conf.crawler-drop_domain", "1", "yes");
INSERT INTO wpy4_options VALUES("245867", "litespeed.conf.crawler-map_timeout", "120", "yes");
INSERT INTO wpy4_options VALUES("245868", "litespeed.conf.crawler-roles", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245869", "litespeed.conf.crawler-cookies", "a:0:{}", "yes");
INSERT INTO wpy4_options VALUES("245870", "litespeed.conf.misc-htaccess_front", "", "yes");
INSERT INTO wpy4_options VALUES("245871", "litespeed.conf.misc-htaccess_back", "", "yes");
INSERT INTO wpy4_options VALUES("245872", "litespeed.conf.misc-heartbeat_front", "", "yes");
INSERT INTO wpy4_options VALUES("245873", "litespeed.conf.misc-heartbeat_front_ttl", "60", "yes");
INSERT INTO wpy4_options VALUES("245874", "litespeed.conf.misc-heartbeat_back", "", "yes");
INSERT INTO wpy4_options VALUES("245875", "litespeed.conf.misc-heartbeat_back_ttl", "60", "yes");
INSERT INTO wpy4_options VALUES("245876", "litespeed.conf.misc-heartbeat_editor", "", "yes");
INSERT INTO wpy4_options VALUES("245877", "litespeed.conf.misc-heartbeat_editor_ttl", "15", "yes");
INSERT INTO wpy4_options VALUES("245878", "litespeed.conf.cdn-attr", "a:5:{i:0;s:4:\".src\";i:1;s:9:\".data-src\";i:2;s:5:\".href\";i:3;s:7:\".poster\";i:4;s:13:\"source.srcset\";}", "yes");
INSERT INTO wpy4_options VALUES("245885", "litespeed-timestamp-purge-css", "1592035376", "yes");
INSERT INTO wpy4_options VALUES("280850", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1595618380;s:7:\"checked\";a:9:{s:12:\"NativeChurch\";s:5:\"3.2.1\";s:16:\"accesspress-lite\";s:4:\"2.83\";s:5:\"alone\";s:3:\"5.3\";s:5:\"deeds\";s:5:\"5.8.1\";s:11:\"free-church\";s:3:\"1.2\";s:7:\"oceanwp\";s:5:\"1.7.1\";s:14:\"twentynineteen\";s:3:\"1.5\";s:15:\"twentyseventeen\";s:3:\"2.3\";s:13:\"twentysixteen\";s:3:\"2.0\";}s:8:\"response\";a:3:{s:7:\"oceanwp\";a:6:{s:5:\"theme\";s:7:\"oceanwp\";s:11:\"new_version\";s:5:\"1.8.6\";s:3:\"url\";s:37:\"https://wordpress.org/themes/oceanwp/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/theme/oceanwp.1.8.6.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"7.0\";}s:14:\"twentynineteen\";a:6:{s:5:\"theme\";s:14:\"twentynineteen\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentynineteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentynineteen.1.6.zip\";s:8:\"requires\";s:5:\"4.9.6\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:13:\"twentysixteen\";a:6:{s:5:\"theme\";s:13:\"twentysixteen\";s:11:\"new_version\";s:3:\"2.1\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentysixteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentysixteen.2.1.zip\";s:8:\"requires\";s:3:\"4.4\";s:12:\"requires_php\";s:5:\"5.2.4\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO wpy4_options VALUES("281188", "analyst_cache", "s:78:\"a:1:{s:43:\"account_email_confirmation_9zdex5mar85kmgya\";s:13:\"5f1b357571dd3\";}\";", "yes");
INSERT INTO wpy4_options VALUES("281211", "analyst_notices", "s:374:\"O:29:\"Analyst\\Notices\\NoticeFactory\":1:{s:10:\"\0*\0notices\";a:1:{i:0;O:22:\"Analyst\\Notices\\Notice\":4:{s:5:\"\0*\0id\";s:13:\"5f1b357571dd3\";s:7:\"\0*\0body\";s:120:\"Please confirm your email by clicking on the link we sent to alldaywow247@gmail.com. This makes sure you’re not a bot.\";s:12:\"\0*\0accountId\";s:16:\"9zdex5mar85kmgya\";s:13:\"\0*\0pluginName\";s:22:\"WP Clone by WP Academy\";}}}\";", "yes");
INSERT INTO wpy4_options VALUES("281212", "analyst_accounts_data", "s:409:\"O:26:\"Account\\AccountDataFactory\":1:{s:11:\"\0*\0accounts\";a:1:{i:0;O:19:\"Account\\AccountData\":7:{s:5:\"\0*\0id\";s:16:\"9zdex5mar85kmgya\";s:9:\"\0*\0secret\";s:40:\"d5702a59d32c01c211316717493096485d5156e8\";s:7:\"\0*\0path\";s:84:\"/home/oheifer1/heavenlykey.org/wp-content/plugins/wp-clone-by-wp-academy/wpclone.php\";s:14:\"\0*\0isInstalled\";b:0;s:12:\"\0*\0isOptedIn\";b:1;s:11:\"\0*\0isSigned\";b:1;s:20:\"\0*\0isInstallResolved\";b:1;}}}\";", "yes");
INSERT INTO wpy4_options VALUES("281201", "_transient_timeout_jetpack_jitm_b8bdb25c9b8debac08187b35d1f7e40", "1595618687", "no");
INSERT INTO wpy4_options VALUES("281202", "_transient_jetpack_jitm_b8bdb25c9b8debac08187b35d1f7e40", "a:1:{s:18:\"last_response_time\";i:1595618387;}", "no");
INSERT INTO wpy4_options VALUES("281203", "wpclone_directory_scan", "a:4:{s:6:\"dbsize\";s:7:\"7.22 MB\";s:4:\"size\";s:9:\"538.11 MB\";s:5:\"files\";i:19390;s:4:\"time\";i:1595619380;}", "yes");

DROP TABLE IF EXISTS wpy4_postmeta;

CREATE TABLE `wpy4_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=679 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wpy4_postmeta VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO wpy4_postmeta VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO wpy4_postmeta VALUES("239", "58", "_menu_item_type", "taxonomy");
INSERT INTO wpy4_postmeta VALUES("353", "85", "_edit_lock", "1571960061:1");
INSERT INTO wpy4_postmeta VALUES("25", "8", "_wp_attached_file", "2019/09/cropped-logo.jpg");
INSERT INTO wpy4_postmeta VALUES("26", "8", "_wp_attachment_context", "custom-header");
INSERT INTO wpy4_postmeta VALUES("27", "8", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:719;s:6:\"height\";i:730;s:4:\"file\";s:24:\"2019/09/cropped-logo.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"cropped-logo-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"cropped-logo-295x300.jpg\";s:5:\"width\";i:295;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:24:\"cropped-logo-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:24:\"cropped-logo-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:24:\"cropped-logo-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:24:\"cropped-logo-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:17:\"attachment_parent\";i:8;}");
INSERT INTO wpy4_postmeta VALUES("28", "8", "_wp_attachment_is_custom_header", "accesspress-lite");
INSERT INTO wpy4_postmeta VALUES("29", "9", "_wp_attached_file", "2019/09/logo.jpg");
INSERT INTO wpy4_postmeta VALUES("30", "9", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:719;s:6:\"height\";i:730;s:4:\"file\";s:16:\"2019/09/logo.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"logo-295x300.jpg\";s:5:\"width\";i:295;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:16:\"logo-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("31", "11", "_wp_attached_file", "2019/09/cropped-logo-1.jpg");
INSERT INTO wpy4_postmeta VALUES("32", "11", "_wp_attachment_context", "site-icon");
INSERT INTO wpy4_postmeta VALUES("33", "11", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:26:\"2019/09/cropped-logo-1.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"cropped-logo-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"cropped-logo-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:26:\"cropped-logo-1-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:26:\"cropped-logo-1-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:26:\"cropped-logo-1-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:26:\"cropped-logo-1-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"site_icon-270\";a:4:{s:4:\"file\";s:26:\"cropped-logo-1-270x270.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"site_icon-192\";a:4:{s:4:\"file\";s:26:\"cropped-logo-1-192x192.jpg\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"site_icon-180\";a:4:{s:4:\"file\";s:26:\"cropped-logo-1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"site_icon-32\";a:4:{s:4:\"file\";s:24:\"cropped-logo-1-32x32.jpg\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("42", "2", "_edit_lock", "1567648027:1");
INSERT INTO wpy4_postmeta VALUES("43", "2", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("44", "2", "accesspresslite_sidebar_layout", "no-sidebar");
INSERT INTO wpy4_postmeta VALUES("45", "2", "_wpb_vc_js_status", "true");
INSERT INTO wpy4_postmeta VALUES("46", "17", "_edit_lock", "1567716733:1");
INSERT INTO wpy4_postmeta VALUES("47", "17", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("48", "17", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("49", "17", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("500", "148", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:993;s:6:\"height\";i:280;s:4:\"file\";s:25:\"2019/10/worldflag-pix.gif\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"worldflag-pix-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"worldflag-pix-300x85.gif\";s:5:\"width\";i:300;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/gif\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"worldflag-pix-768x217.gif\";s:5:\"width\";i:768;s:6:\"height\";i:217;s:9:\"mime-type\";s:9:\"image/gif\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:25:\"worldflag-pix-135x100.gif\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/gif\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:25:\"worldflag-pix-350x245.gif\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:9:\"image/gif\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:25:\"worldflag-pix-400x280.gif\";s:5:\"width\";i:400;s:6:\"height\";i:280;s:9:\"mime-type\";s:9:\"image/gif\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:25:\"worldflag-pix-273x235.gif\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("498", "147", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("499", "148", "_wp_attached_file", "2019/10/worldflag-pix.gif");
INSERT INTO wpy4_postmeta VALUES("496", "146", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("495", "146", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("494", "146", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("493", "146", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("492", "146", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("491", "146", "_menu_item_object_id", "85");
INSERT INTO wpy4_postmeta VALUES("490", "146", "_menu_item_menu_item_parent", "53");
INSERT INTO wpy4_postmeta VALUES("489", "146", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("331", "75", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("352", "81", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("84", "24", "_edit_lock", "1571965505:1");
INSERT INTO wpy4_postmeta VALUES("85", "24", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("86", "24", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("87", "24", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("88", "26", "_edit_lock", "1567647896:1");
INSERT INTO wpy4_postmeta VALUES("89", "26", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("90", "26", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("91", "26", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("92", "28", "_edit_lock", "1567713863:1");
INSERT INTO wpy4_postmeta VALUES("93", "28", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("94", "28", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("95", "28", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("96", "30", "_edit_lock", "1567714036:1");
INSERT INTO wpy4_postmeta VALUES("97", "32", "_edit_lock", "1567648054:1");
INSERT INTO wpy4_postmeta VALUES("98", "32", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("99", "32", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("100", "32", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("101", "34", "_edit_lock", "1594079904:2");
INSERT INTO wpy4_postmeta VALUES("102", "34", "_edit_last", "2");
INSERT INTO wpy4_postmeta VALUES("103", "34", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("104", "34", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("105", "36", "_edit_lock", "1569907853:1");
INSERT INTO wpy4_postmeta VALUES("106", "36", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("107", "36", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("108", "36", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("109", "38", "_edit_lock", "1571975775:1");
INSERT INTO wpy4_postmeta VALUES("110", "38", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("111", "38", "accesspresslite_sidebar_layout", "no-sidebar");
INSERT INTO wpy4_postmeta VALUES("112", "38", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("113", "40", "_edit_lock", "1569906975:1");
INSERT INTO wpy4_postmeta VALUES("114", "40", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("115", "40", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("116", "40", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("117", "42", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("118", "42", "_menu_item_menu_item_parent", "0");
INSERT INTO wpy4_postmeta VALUES("119", "42", "_menu_item_object_id", "40");
INSERT INTO wpy4_postmeta VALUES("120", "42", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("121", "42", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("122", "42", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("123", "42", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("124", "42", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("225", "54", "_edit_lock", "1571965209:1");
INSERT INTO wpy4_postmeta VALUES("244", "58", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("243", "58", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("242", "58", "_menu_item_object", "category");
INSERT INTO wpy4_postmeta VALUES("241", "58", "_menu_item_object_id", "10");
INSERT INTO wpy4_postmeta VALUES("240", "58", "_menu_item_menu_item_parent", "46");
INSERT INTO wpy4_postmeta VALUES("226", "54", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("135", "44", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("136", "44", "_menu_item_menu_item_parent", "0");
INSERT INTO wpy4_postmeta VALUES("137", "44", "_menu_item_object_id", "36");
INSERT INTO wpy4_postmeta VALUES("138", "44", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("139", "44", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("140", "44", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("141", "44", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("142", "44", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("223", "53", "_menu_item_url", "#");
INSERT INTO wpy4_postmeta VALUES("144", "45", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("145", "45", "_menu_item_menu_item_parent", "219");
INSERT INTO wpy4_postmeta VALUES("146", "45", "_menu_item_object_id", "34");
INSERT INTO wpy4_postmeta VALUES("147", "45", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("148", "45", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("149", "45", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("150", "45", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("151", "45", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("222", "53", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("153", "46", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("154", "46", "_menu_item_menu_item_parent", "0");
INSERT INTO wpy4_postmeta VALUES("155", "46", "_menu_item_object_id", "32");
INSERT INTO wpy4_postmeta VALUES("156", "46", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("157", "46", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("158", "46", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("159", "46", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("160", "46", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("162", "47", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("163", "47", "_menu_item_menu_item_parent", "0");
INSERT INTO wpy4_postmeta VALUES("164", "47", "_menu_item_object_id", "30");
INSERT INTO wpy4_postmeta VALUES("165", "47", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("166", "47", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("167", "47", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("168", "47", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("169", "47", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("221", "53", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("171", "48", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("172", "48", "_menu_item_menu_item_parent", "53");
INSERT INTO wpy4_postmeta VALUES("173", "48", "_menu_item_object_id", "28");
INSERT INTO wpy4_postmeta VALUES("174", "48", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("175", "48", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("176", "48", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("177", "48", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("178", "48", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("220", "53", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("234", "56", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("233", "56", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("232", "56", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("231", "56", "_menu_item_object_id", "54");
INSERT INTO wpy4_postmeta VALUES("230", "56", "_menu_item_menu_item_parent", "53");
INSERT INTO wpy4_postmeta VALUES("229", "56", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("219", "53", "_menu_item_object", "custom");
INSERT INTO wpy4_postmeta VALUES("189", "50", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("190", "50", "_menu_item_menu_item_parent", "53");
INSERT INTO wpy4_postmeta VALUES("191", "50", "_menu_item_object_id", "24");
INSERT INTO wpy4_postmeta VALUES("192", "50", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("193", "50", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("194", "50", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("195", "50", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("196", "50", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("218", "53", "_menu_item_object_id", "53");
INSERT INTO wpy4_postmeta VALUES("198", "51", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("199", "51", "_menu_item_menu_item_parent", "0");
INSERT INTO wpy4_postmeta VALUES("200", "51", "_menu_item_object_id", "17");
INSERT INTO wpy4_postmeta VALUES("201", "51", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("202", "51", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("203", "51", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("204", "51", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("205", "51", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("217", "53", "_menu_item_menu_item_parent", "0");
INSERT INTO wpy4_postmeta VALUES("250", "59", "_menu_item_object_id", "9");
INSERT INTO wpy4_postmeta VALUES("249", "59", "_menu_item_menu_item_parent", "46");
INSERT INTO wpy4_postmeta VALUES("248", "59", "_menu_item_type", "taxonomy");
INSERT INTO wpy4_postmeta VALUES("321", "30", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("246", "58", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("245", "58", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("216", "53", "_menu_item_type", "custom");
INSERT INTO wpy4_postmeta VALUES("227", "54", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("228", "54", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("235", "56", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("236", "56", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("251", "59", "_menu_item_object", "category");
INSERT INTO wpy4_postmeta VALUES("252", "59", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("253", "59", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("254", "59", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("255", "59", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("257", "60", "_menu_item_type", "taxonomy");
INSERT INTO wpy4_postmeta VALUES("258", "60", "_menu_item_menu_item_parent", "46");
INSERT INTO wpy4_postmeta VALUES("259", "60", "_menu_item_object_id", "7");
INSERT INTO wpy4_postmeta VALUES("260", "60", "_menu_item_object", "category");
INSERT INTO wpy4_postmeta VALUES("261", "60", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("262", "60", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("263", "60", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("264", "60", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("483", "141", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:480;s:4:\"file\";s:33:\"2019/10/finger-pointing-gif-7.gif\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"finger-pointing-gif-7-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"finger-pointing-gif-7-300x300.gif\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/gif\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:33:\"finger-pointing-gif-7-135x100.gif\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/gif\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:33:\"finger-pointing-gif-7-350x245.gif\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:9:\"image/gif\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:33:\"finger-pointing-gif-7-400x450.gif\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/gif\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:33:\"finger-pointing-gif-7-273x235.gif\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("266", "61", "_menu_item_type", "taxonomy");
INSERT INTO wpy4_postmeta VALUES("267", "61", "_menu_item_menu_item_parent", "46");
INSERT INTO wpy4_postmeta VALUES("268", "61", "_menu_item_object_id", "1");
INSERT INTO wpy4_postmeta VALUES("269", "61", "_menu_item_object", "category");
INSERT INTO wpy4_postmeta VALUES("270", "61", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("271", "61", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("272", "61", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("273", "61", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("320", "30", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("275", "62", "_menu_item_type", "taxonomy");
INSERT INTO wpy4_postmeta VALUES("276", "62", "_menu_item_menu_item_parent", "46");
INSERT INTO wpy4_postmeta VALUES("277", "62", "_menu_item_object_id", "8");
INSERT INTO wpy4_postmeta VALUES("278", "62", "_menu_item_object", "category");
INSERT INTO wpy4_postmeta VALUES("279", "62", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("280", "62", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("281", "62", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("282", "62", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("322", "30", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("284", "63", "_menu_item_type", "taxonomy");
INSERT INTO wpy4_postmeta VALUES("285", "63", "_menu_item_menu_item_parent", "46");
INSERT INTO wpy4_postmeta VALUES("286", "63", "_menu_item_object_id", "6");
INSERT INTO wpy4_postmeta VALUES("287", "63", "_menu_item_object", "category");
INSERT INTO wpy4_postmeta VALUES("288", "63", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("289", "63", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("290", "63", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("291", "63", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("293", "64", "_menu_item_type", "taxonomy");
INSERT INTO wpy4_postmeta VALUES("294", "64", "_menu_item_menu_item_parent", "46");
INSERT INTO wpy4_postmeta VALUES("295", "64", "_menu_item_object_id", "3");
INSERT INTO wpy4_postmeta VALUES("296", "64", "_menu_item_object", "category");
INSERT INTO wpy4_postmeta VALUES("297", "64", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("298", "64", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("299", "64", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("300", "64", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("328", "75", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("302", "65", "_menu_item_type", "taxonomy");
INSERT INTO wpy4_postmeta VALUES("303", "65", "_menu_item_menu_item_parent", "46");
INSERT INTO wpy4_postmeta VALUES("304", "65", "_menu_item_object_id", "4");
INSERT INTO wpy4_postmeta VALUES("305", "65", "_menu_item_object", "category");
INSERT INTO wpy4_postmeta VALUES("306", "65", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("307", "65", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("308", "65", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("309", "65", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("345", "79", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("311", "66", "_menu_item_type", "taxonomy");
INSERT INTO wpy4_postmeta VALUES("312", "66", "_menu_item_menu_item_parent", "46");
INSERT INTO wpy4_postmeta VALUES("313", "66", "_menu_item_object_id", "5");
INSERT INTO wpy4_postmeta VALUES("314", "66", "_menu_item_object", "category");
INSERT INTO wpy4_postmeta VALUES("315", "66", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("316", "66", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("317", "66", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("318", "66", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("325", "75", "_edit_lock", "1567716950:1");
INSERT INTO wpy4_postmeta VALUES("332", "77", "_edit_lock", "1574159709:1");
INSERT INTO wpy4_postmeta VALUES("335", "77", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("338", "77", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("339", "79", "_edit_lock", "1567717391:1");
INSERT INTO wpy4_postmeta VALUES("398", "108", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("342", "79", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("346", "81", "_edit_lock", "1567718005:1");
INSERT INTO wpy4_postmeta VALUES("349", "81", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("354", "86", "_wp_attached_file", "2019/09/index_signs-end-times.jpg");
INSERT INTO wpy4_postmeta VALUES("355", "86", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1030;s:6:\"height\";i:125;s:4:\"file\";s:33:\"2019/09/index_signs-end-times.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"index_signs-end-times-150x125.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"index_signs-end-times-300x36.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"index_signs-end-times-768x93.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"index_signs-end-times-1024x124.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:124;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:33:\"index_signs-end-times-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:33:\"index_signs-end-times-350x125.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:33:\"index_signs-end-times-400x125.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:33:\"index_signs-end-times-273x125.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("356", "87", "_wp_attached_file", "2019/09/cropped-index_signs-end-times.jpg");
INSERT INTO wpy4_postmeta VALUES("357", "87", "_wp_attachment_context", "custom-header");
INSERT INTO wpy4_postmeta VALUES("358", "87", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1030;s:6:\"height\";i:125;s:4:\"file\";s:41:\"2019/09/cropped-index_signs-end-times.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"cropped-index_signs-end-times-150x125.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"cropped-index_signs-end-times-300x36.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:40:\"cropped-index_signs-end-times-768x93.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"cropped-index_signs-end-times-1024x124.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:124;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:41:\"cropped-index_signs-end-times-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:41:\"cropped-index_signs-end-times-350x125.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:41:\"cropped-index_signs-end-times-400x125.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:41:\"cropped-index_signs-end-times-273x125.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:17:\"attachment_parent\";i:86;}");
INSERT INTO wpy4_postmeta VALUES("359", "87", "_wp_attachment_custom_header_last_used_accesspress-lite", "1569887556");
INSERT INTO wpy4_postmeta VALUES("360", "87", "_wp_attachment_is_custom_header", "accesspress-lite");
INSERT INTO wpy4_postmeta VALUES("365", "85", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("366", "85", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("367", "85", "_wpb_vc_js_status", "false");
INSERT INTO wpy4_postmeta VALUES("368", "92", "_wp_attached_file", "2019/10/43278445_1877005322388379_5364780706687877120_n.jpg");
INSERT INTO wpy4_postmeta VALUES("369", "92", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:606;s:6:\"height\";i:606;s:4:\"file\";s:59:\"2019/10/43278445_1877005322388379_5364780706687877120_n.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:59:\"43278445_1877005322388379_5364780706687877120_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:59:\"43278445_1877005322388379_5364780706687877120_n-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:59:\"43278445_1877005322388379_5364780706687877120_n-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:59:\"43278445_1877005322388379_5364780706687877120_n-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:59:\"43278445_1877005322388379_5364780706687877120_n-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:59:\"43278445_1877005322388379_5364780706687877120_n-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("370", "94", "_wp_attached_file", "2019/10/12074654_887507834671471_3230046876956505481_n.jpg");
INSERT INTO wpy4_postmeta VALUES("371", "94", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:720;s:6:\"height\";i:720;s:4:\"file\";s:58:\"2019/10/12074654_887507834671471_3230046876956505481_n.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:58:\"12074654_887507834671471_3230046876956505481_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:58:\"12074654_887507834671471_3230046876956505481_n-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:58:\"12074654_887507834671471_3230046876956505481_n-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:58:\"12074654_887507834671471_3230046876956505481_n-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:58:\"12074654_887507834671471_3230046876956505481_n-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:58:\"12074654_887507834671471_3230046876956505481_n-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("372", "101", "_wp_attached_file", "2019/10/724aef_d0b3ac04f4f345cfbc8d247ddbee2533.gif");
INSERT INTO wpy4_postmeta VALUES("373", "101", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:268;s:6:\"height\";i:244;s:4:\"file\";s:51:\"2019/10/724aef_d0b3ac04f4f345cfbc8d247ddbee2533.gif\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:51:\"724aef_d0b3ac04f4f345cfbc8d247ddbee2533-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:51:\"724aef_d0b3ac04f4f345cfbc8d247ddbee2533-135x100.gif\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/gif\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:51:\"724aef_d0b3ac04f4f345cfbc8d247ddbee2533-268x235.gif\";s:5:\"width\";i:268;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("374", "102", "_wp_attached_file", "2019/10/images-1.jpg");
INSERT INTO wpy4_postmeta VALUES("375", "102", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:322;s:6:\"height\";i:156;s:4:\"file\";s:20:\"2019/10/images-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"images-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"images-1-300x145.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:145;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:20:\"images-1-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:20:\"images-1-273x156.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:156;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("376", "103", "_wp_attached_file", "2019/10/Join-us-on-Facebook.png");
INSERT INTO wpy4_postmeta VALUES("377", "103", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:871;s:6:\"height\";i:252;s:4:\"file\";s:31:\"2019/10/Join-us-on-Facebook.png\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Join-us-on-Facebook-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"Join-us-on-Facebook-300x87.png\";s:5:\"width\";i:300;s:6:\"height\";i:87;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"Join-us-on-Facebook-768x222.png\";s:5:\"width\";i:768;s:6:\"height\";i:222;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:31:\"Join-us-on-Facebook-135x100.png\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:31:\"Join-us-on-Facebook-350x245.png\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:31:\"Join-us-on-Facebook-400x252.png\";s:5:\"width\";i:400;s:6:\"height\";i:252;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:31:\"Join-us-on-Facebook-273x235.png\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("378", "104", "_wp_attached_file", "2019/10/Join-us-on-Facebook-1.png");
INSERT INTO wpy4_postmeta VALUES("379", "104", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:831;s:6:\"height\";i:121;s:4:\"file\";s:33:\"2019/10/Join-us-on-Facebook-1.png\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Join-us-on-Facebook-1-150x121.png\";s:5:\"width\";i:150;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Join-us-on-Facebook-1-300x44.png\";s:5:\"width\";i:300;s:6:\"height\";i:44;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"Join-us-on-Facebook-1-768x112.png\";s:5:\"width\";i:768;s:6:\"height\";i:112;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:33:\"Join-us-on-Facebook-1-135x100.png\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:33:\"Join-us-on-Facebook-1-350x121.png\";s:5:\"width\";i:350;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:33:\"Join-us-on-Facebook-1-400x121.png\";s:5:\"width\";i:400;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:33:\"Join-us-on-Facebook-1-273x121.png\";s:5:\"width\";i:273;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("380", "105", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("381", "17", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("382", "106", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("482", "141", "_wp_attached_file", "2019/10/finger-pointing-gif-7.gif");
INSERT INTO wpy4_postmeta VALUES("481", "30", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("385", "108", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("386", "108", "_edit_lock", "1569903067:1");
INSERT INTO wpy4_postmeta VALUES("387", "109", "_wp_attached_file", "2019/10/all-have-sin1.png");
INSERT INTO wpy4_postmeta VALUES("388", "109", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:770;s:6:\"height\";i:310;s:4:\"file\";s:25:\"2019/10/all-have-sin1.png\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"all-have-sin1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"all-have-sin1-300x121.png\";s:5:\"width\";i:300;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"all-have-sin1-768x309.png\";s:5:\"width\";i:768;s:6:\"height\";i:309;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:25:\"all-have-sin1-135x100.png\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:25:\"all-have-sin1-350x245.png\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:25:\"all-have-sin1-400x310.png\";s:5:\"width\";i:400;s:6:\"height\";i:310;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:25:\"all-have-sin1-273x235.png\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("393", "108", "_wpas_done_all", "1");
INSERT INTO wpy4_postmeta VALUES("424", "118", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("395", "108", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("392", "110", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("394", "108", "_thumbnail_id", "109");
INSERT INTO wpy4_postmeta VALUES("399", "111", "_wp_attached_file", "2019/10/for-all-have-sin.jpg");
INSERT INTO wpy4_postmeta VALUES("400", "111", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:602;s:6:\"height\";i:602;s:4:\"file\";s:28:\"2019/10/for-all-have-sin.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"for-all-have-sin-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"for-all-have-sin-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:28:\"for-all-have-sin-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:28:\"for-all-have-sin-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:28:\"for-all-have-sin-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:28:\"for-all-have-sin-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("401", "112", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("480", "140", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("404", "114", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("405", "114", "_edit_lock", "1569903417:1");
INSERT INTO wpy4_postmeta VALUES("406", "115", "_wp_attached_file", "2019/10/signs.jpg");
INSERT INTO wpy4_postmeta VALUES("407", "115", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2116;s:6:\"height\";i:916;s:4:\"file\";s:17:\"2019/10/signs.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"signs-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"signs-300x130.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:130;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"signs-768x332.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:332;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"signs-1024x443.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:443;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:17:\"signs-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:17:\"signs-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:17:\"signs-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:17:\"signs-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("408", "116", "_wp_attached_file", "2019/10/signs-of-the-times-1-1-638.jpg");
INSERT INTO wpy4_postmeta VALUES("409", "116", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:638;s:6:\"height\";i:479;s:4:\"file\";s:38:\"2019/10/signs-of-the-times-1-1-638.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"signs-of-the-times-1-1-638-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"signs-of-the-times-1-1-638-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:38:\"signs-of-the-times-1-1-638-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:38:\"signs-of-the-times-1-1-638-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:38:\"signs-of-the-times-1-1-638-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:38:\"signs-of-the-times-1-1-638-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("414", "114", "_wpas_done_all", "1");
INSERT INTO wpy4_postmeta VALUES("454", "126", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("413", "117", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("415", "114", "_thumbnail_id", "116");
INSERT INTO wpy4_postmeta VALUES("416", "114", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("425", "119", "_wp_attached_file", "2019/10/signs-of-the-times-300x300.png");
INSERT INTO wpy4_postmeta VALUES("419", "114", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("426", "119", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:300;s:4:\"file\";s:38:\"2019/10/signs-of-the-times-300x300.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"signs-of-the-times-300x300-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:38:\"signs-of-the-times-300x300-135x100.png\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:38:\"signs-of-the-times-300x300-300x245.png\";s:5:\"width\";i:300;s:6:\"height\";i:245;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:38:\"signs-of-the-times-300x300-273x235.png\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("427", "120", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("428", "121", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("429", "121", "_edit_lock", "1569902720:1");
INSERT INTO wpy4_postmeta VALUES("430", "122", "_wp_attached_file", "2019/10/Where-will-you-spend-eternity.png");
INSERT INTO wpy4_postmeta VALUES("431", "122", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1235;s:6:\"height\";i:456;s:4:\"file\";s:41:\"2019/10/Where-will-you-spend-eternity.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"Where-will-you-spend-eternity-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"Where-will-you-spend-eternity-300x111.png\";s:5:\"width\";i:300;s:6:\"height\";i:111;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:41:\"Where-will-you-spend-eternity-768x284.png\";s:5:\"width\";i:768;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"Where-will-you-spend-eternity-1024x378.png\";s:5:\"width\";i:1024;s:6:\"height\";i:378;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:41:\"Where-will-you-spend-eternity-135x100.png\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:41:\"Where-will-you-spend-eternity-350x245.png\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:41:\"Where-will-you-spend-eternity-400x450.png\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:41:\"Where-will-you-spend-eternity-273x235.png\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("432", "123", "_wp_attached_file", "2019/10/eternity.jpg");
INSERT INTO wpy4_postmeta VALUES("433", "123", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:542;s:6:\"height\";i:543;s:4:\"file\";s:20:\"2019/10/eternity.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"eternity-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"eternity-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:20:\"eternity-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:20:\"eternity-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:20:\"eternity-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:20:\"eternity-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("438", "121", "_wpas_done_all", "1");
INSERT INTO wpy4_postmeta VALUES("440", "121", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("437", "124", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("439", "121", "_thumbnail_id", "122");
INSERT INTO wpy4_postmeta VALUES("443", "121", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("444", "125", "_wp_attached_file", "2019/10/eternity-1.jpg");
INSERT INTO wpy4_postmeta VALUES("445", "125", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:542;s:6:\"height\";i:543;s:4:\"file\";s:22:\"2019/10/eternity-1.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"eternity-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"eternity-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:22:\"eternity-1-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:22:\"eternity-1-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:22:\"eternity-1-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:22:\"eternity-1-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("571", "183", "_edit_lock", "1574158618:1");
INSERT INTO wpy4_postmeta VALUES("572", "184", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("570", "183", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("464", "128", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("465", "129", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("466", "130", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("467", "131", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("471", "134", "_wp_attached_file", "2019/10/Eternity-1.jpg");
INSERT INTO wpy4_postmeta VALUES("469", "133", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("470", "40", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("472", "134", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:797;s:6:\"height\";i:315;s:4:\"file\";s:22:\"2019/10/Eternity-1.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Eternity-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Eternity-1-300x119.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:119;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"Eternity-1-768x304.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:304;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:22:\"Eternity-1-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:22:\"Eternity-1-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:22:\"Eternity-1-400x315.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:315;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:22:\"Eternity-1-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("473", "135", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("474", "136", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("475", "36", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("476", "137", "_wp_attached_file", "2019/10/tenor.gif");
INSERT INTO wpy4_postmeta VALUES("477", "137", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:488;s:6:\"height\";i:364;s:4:\"file\";s:17:\"2019/10/tenor.gif\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"tenor-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"tenor-300x224.gif\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:9:\"image/gif\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:17:\"tenor-135x100.gif\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/gif\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:17:\"tenor-350x245.gif\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:9:\"image/gif\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:17:\"tenor-400x364.gif\";s:5:\"width\";i:400;s:6:\"height\";i:364;s:9:\"mime-type\";s:9:\"image/gif\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:17:\"tenor-273x235.gif\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("478", "138", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("484", "142", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("485", "143", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("486", "144", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("487", "85", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("488", "145", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("501", "149", "_wp_attached_file", "2019/10/kumuyi.jpg");
INSERT INTO wpy4_postmeta VALUES("502", "149", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:238;s:6:\"height\";i:178;s:4:\"file\";s:18:\"2019/10/kumuyi.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"kumuyi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:18:\"kumuyi-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("503", "150", "_wp_attached_file", "2019/10/images-2.jpg");
INSERT INTO wpy4_postmeta VALUES("504", "150", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:524;s:6:\"height\";i:585;s:4:\"file\";s:20:\"2019/10/images-2.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"images-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"images-2-269x300.jpg\";s:5:\"width\";i:269;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:20:\"images-2-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:20:\"images-2-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:20:\"images-2-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:20:\"images-2-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("505", "151", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("506", "28", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("507", "152", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("511", "155", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("509", "154", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("510", "54", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("512", "24", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("513", "156", "_wp_attached_file", "2019/10/43134411_1877043199051258_1968911135604211712_n.jpg");
INSERT INTO wpy4_postmeta VALUES("514", "156", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:713;s:6:\"height\";i:725;s:4:\"file\";s:59:\"2019/10/43134411_1877043199051258_1968911135604211712_n.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:59:\"43134411_1877043199051258_1968911135604211712_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:59:\"43134411_1877043199051258_1968911135604211712_n-295x300.jpg\";s:5:\"width\";i:295;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:59:\"43134411_1877043199051258_1968911135604211712_n-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:59:\"43134411_1877043199051258_1968911135604211712_n-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:59:\"43134411_1877043199051258_1968911135604211712_n-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:59:\"43134411_1877043199051258_1968911135604211712_n-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("515", "157", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("516", "158", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("517", "159", "_wp_attached_file", "2019/10/gtb.jpg");
INSERT INTO wpy4_postmeta VALUES("518", "159", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:225;s:6:\"height\";i:225;s:4:\"file\";s:15:\"2019/10/gtb.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"gtb-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:15:\"gtb-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("519", "160", "_wp_attached_file", "2019/10/access.png");
INSERT INTO wpy4_postmeta VALUES("520", "160", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:18:\"2019/10/access.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"access-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"access-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:18:\"access-135x100.png\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:18:\"access-350x245.png\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:18:\"access-400x400.png\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:18:\"access-273x235.png\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("521", "161", "_wp_attached_file", "2019/10/western.jpg");
INSERT INTO wpy4_postmeta VALUES("522", "161", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:518;s:6:\"height\";i:250;s:4:\"file\";s:19:\"2019/10/western.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"western-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"western-300x145.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:145;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:19:\"western-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:19:\"western-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:19:\"western-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:19:\"western-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("523", "162", "_wp_attached_file", "2019/10/money-gram.jpg");
INSERT INTO wpy4_postmeta VALUES("524", "162", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:728;s:6:\"height\";i:421;s:4:\"file\";s:22:\"2019/10/money-gram.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"money-gram-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"money-gram-300x173.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:173;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:22:\"money-gram-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:22:\"money-gram-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:22:\"money-gram-400x421.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:421;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:22:\"money-gram-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("525", "163", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("526", "164", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("527", "165", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("528", "166", "_wp_attached_file", "2019/10/FB-Page-Like-logo-300x192.jpg");
INSERT INTO wpy4_postmeta VALUES("529", "166", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:192;s:4:\"file\";s:37:\"2019/10/FB-Page-Like-logo-300x192.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"FB-Page-Like-logo-300x192-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"FB-Page-Like-logo-300x192-300x192.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:37:\"FB-Page-Like-logo-300x192-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:37:\"FB-Page-Like-logo-300x192-273x192.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("530", "167", "_wp_attached_file", "2019/10/a.jpg");
INSERT INTO wpy4_postmeta VALUES("531", "167", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:464;s:6:\"height\";i:317;s:4:\"file\";s:13:\"2019/10/a.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"a-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"a-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:13:\"a-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:13:\"a-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:13:\"a-400x317.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:317;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:13:\"a-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("532", "168", "_wp_attached_file", "2019/10/b.jpg");
INSERT INTO wpy4_postmeta VALUES("533", "168", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:620;s:6:\"height\";i:400;s:4:\"file\";s:13:\"2019/10/b.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"b-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"b-300x194.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:194;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:13:\"b-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:13:\"b-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:13:\"b-400x400.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:13:\"b-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("534", "169", "_wp_attached_file", "2019/10/c.jpg");
INSERT INTO wpy4_postmeta VALUES("535", "169", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:225;s:6:\"height\";i:225;s:4:\"file\";s:13:\"2019/10/c.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"c-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:13:\"c-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("536", "170", "_wp_attached_file", "2019/10/d.jpg");
INSERT INTO wpy4_postmeta VALUES("537", "170", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:640;s:4:\"file\";s:13:\"2019/10/d.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"d-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"d-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:13:\"d-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:13:\"d-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:13:\"d-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:13:\"d-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("538", "171", "_wp_attached_file", "2019/10/Onlinve-Giving.jpg");
INSERT INTO wpy4_postmeta VALUES("539", "171", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:480;s:4:\"file\";s:26:\"2019/10/Onlinve-Giving.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Onlinve-Giving-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Onlinve-Giving-300x144.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:144;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"Onlinve-Giving-768x369.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:369;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:26:\"Onlinve-Giving-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:26:\"Onlinve-Giving-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:26:\"Onlinve-Giving-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:26:\"Onlinve-Giving-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("540", "172", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("541", "173", "_menu_item_type", "post_type");
INSERT INTO wpy4_postmeta VALUES("542", "173", "_menu_item_menu_item_parent", "0");
INSERT INTO wpy4_postmeta VALUES("543", "173", "_menu_item_object_id", "38");
INSERT INTO wpy4_postmeta VALUES("544", "173", "_menu_item_object", "page");
INSERT INTO wpy4_postmeta VALUES("545", "173", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("546", "173", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("547", "173", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("548", "173", "_menu_item_url", "");
INSERT INTO wpy4_postmeta VALUES("550", "38", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("628", "208", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("629", "209", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("630", "210", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("631", "210", "_edit_lock", "1592046645:2");
INSERT INTO wpy4_postmeta VALUES("632", "211", "_wp_attached_file", "2020/06/a.jpg");
INSERT INTO wpy4_postmeta VALUES("661", "219", "_menu_item_object", "custom");
INSERT INTO wpy4_postmeta VALUES("660", "219", "_menu_item_object_id", "219");
INSERT INTO wpy4_postmeta VALUES("621", "203", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("622", "203", "_edit_lock", "1591925520:1");
INSERT INTO wpy4_postmeta VALUES("659", "219", "_menu_item_menu_item_parent", "0");
INSERT INTO wpy4_postmeta VALUES("658", "219", "_menu_item_type", "custom");
INSERT INTO wpy4_postmeta VALUES("678", "222", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("626", "206", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("627", "207", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("615", "199", "_wpas_done_all", "1");
INSERT INTO wpy4_postmeta VALUES("612", "199", "_pingme", "1");
INSERT INTO wpy4_postmeta VALUES("613", "199", "_encloseme", "1");
INSERT INTO wpy4_postmeta VALUES("614", "201", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("616", "199", "_thumbnail_id", "200");
INSERT INTO wpy4_postmeta VALUES("617", "199", "_edit_last", "1");
INSERT INTO wpy4_postmeta VALUES("597", "196", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("557", "175", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("558", "176", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("559", "177", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("560", "178", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("618", "199", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("607", "199", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("608", "199", "_edit_lock", "1591922022:1");
INSERT INTO wpy4_postmeta VALUES("609", "200", "_wp_attached_file", "2020/06/k.jpg");
INSERT INTO wpy4_postmeta VALUES("610", "200", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:720;s:6:\"height\";i:720;s:4:\"file\";s:13:\"2020/06/k.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"k-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"k-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:13:\"k-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:13:\"k-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:13:\"k-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:13:\"k-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("562", "179", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("563", "180", "_wp_attached_file", "2019/10/whatsapp-button.png");
INSERT INTO wpy4_postmeta VALUES("564", "180", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:738;s:6:\"height\";i:256;s:4:\"file\";s:27:\"2019/10/whatsapp-button.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"whatsapp-button-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"whatsapp-button-300x104.png\";s:5:\"width\";i:300;s:6:\"height\";i:104;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:27:\"whatsapp-button-135x100.png\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:27:\"whatsapp-button-350x245.png\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:9:\"image/png\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:27:\"whatsapp-button-400x256.png\";s:5:\"width\";i:400;s:6:\"height\";i:256;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:27:\"whatsapp-button-273x235.png\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("565", "181", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("566", "11", "_oembed_69098a7173546330af07b4218125fdb9", "{{unknown}}");
INSERT INTO wpy4_postmeta VALUES("594", "193", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:752;s:6:\"height\";i:251;s:4:\"file\";s:19:\"2020/06/payment.gif\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"payment-300x100.gif\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/gif\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"payment-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:19:\"payment-135x100.gif\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/gif\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:19:\"payment-350x245.gif\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:9:\"image/gif\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:19:\"payment-400x251.gif\";s:5:\"width\";i:400;s:6:\"height\";i:251;s:9:\"mime-type\";s:9:\"image/gif\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:19:\"payment-273x235.gif\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("593", "193", "_wp_attached_file", "2020/06/payment.gif");
INSERT INTO wpy4_postmeta VALUES("662", "219", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("584", "187", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("585", "188", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("586", "189", "_wp_attached_file", "2019/11/FB_IMG_1573740030668.jpg");
INSERT INTO wpy4_postmeta VALUES("587", "189", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:480;s:4:\"file\";s:32:\"2019/11/FB_IMG_1573740030668.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"FB_IMG_1573740030668-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"FB_IMG_1573740030668-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:32:\"FB_IMG_1573740030668-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:32:\"FB_IMG_1573740030668-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:32:\"FB_IMG_1573740030668-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:32:\"FB_IMG_1573740030668-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("590", "190", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("595", "194", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("596", "195", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("633", "211", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:464;s:6:\"height\";i:317;s:4:\"file\";s:13:\"2020/06/a.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"a-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"a-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:13:\"a-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:13:\"a-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:13:\"a-400x317.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:317;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:13:\"a-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("638", "210", "_wpas_done_all", "1");
INSERT INTO wpy4_postmeta VALUES("635", "210", "_pingme", "1");
INSERT INTO wpy4_postmeta VALUES("636", "210", "_encloseme", "1");
INSERT INTO wpy4_postmeta VALUES("637", "212", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("639", "210", "_thumbnail_id", "211");
INSERT INTO wpy4_postmeta VALUES("640", "210", "_edit_last", "2");
INSERT INTO wpy4_postmeta VALUES("641", "210", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("642", "213", "_wp_attached_file", "2020/06/a-1.jpg");
INSERT INTO wpy4_postmeta VALUES("643", "213", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:464;s:6:\"height\";i:317;s:4:\"file\";s:15:\"2020/06/a-1.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"a-1-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"a-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:15:\"a-1-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:15:\"a-1-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:15:\"a-1-400x317.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:317;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:15:\"a-1-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("644", "214", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("645", "215", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("646", "215", "_edit_lock", "1592052044:2");
INSERT INTO wpy4_postmeta VALUES("647", "216", "_wp_attached_file", "2020/06/crying.jpg");
INSERT INTO wpy4_postmeta VALUES("648", "216", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:394;s:4:\"file\";s:18:\"2020/06/crying.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"crying-300x263.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:263;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"crying-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"event-thumbnail\";a:4:{s:4:\"file\";s:18:\"crying-135x100.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"featured-thumbnail\";a:4:{s:4:\"file\";s:18:\"crying-350x245.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:245;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"portfolio-thumbnail\";a:4:{s:4:\"file\";s:18:\"crying-400x394.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:394;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"template_two_event_home\";a:4:{s:4:\"file\";s:18:\"crying-273x235.jpg\";s:5:\"width\";i:273;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpy4_postmeta VALUES("653", "215", "_wpas_done_all", "1");
INSERT INTO wpy4_postmeta VALUES("650", "215", "_pingme", "1");
INSERT INTO wpy4_postmeta VALUES("651", "215", "_encloseme", "1");
INSERT INTO wpy4_postmeta VALUES("652", "217", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("654", "215", "_thumbnail_id", "216");
INSERT INTO wpy4_postmeta VALUES("655", "215", "_edit_last", "2");
INSERT INTO wpy4_postmeta VALUES("656", "215", "accesspresslite_sidebar_layout", "right-sidebar");
INSERT INTO wpy4_postmeta VALUES("663", "219", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("664", "219", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("665", "219", "_menu_item_url", "#");
INSERT INTO wpy4_postmeta VALUES("677", "34", "_wpcom_is_markdown", "1");
INSERT INTO wpy4_postmeta VALUES("667", "220", "_menu_item_type", "custom");
INSERT INTO wpy4_postmeta VALUES("668", "220", "_menu_item_menu_item_parent", "219");
INSERT INTO wpy4_postmeta VALUES("669", "220", "_menu_item_object_id", "220");
INSERT INTO wpy4_postmeta VALUES("670", "220", "_menu_item_object", "custom");
INSERT INTO wpy4_postmeta VALUES("671", "220", "_menu_item_target", "");
INSERT INTO wpy4_postmeta VALUES("672", "220", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpy4_postmeta VALUES("673", "220", "_menu_item_xfn", "");
INSERT INTO wpy4_postmeta VALUES("674", "220", "_menu_item_url", "https://www.facebook.com/heavenlykey/videos");
INSERT INTO wpy4_postmeta VALUES("676", "221", "_wpcom_is_markdown", "1");

DROP TABLE IF EXISTS wpy4_posts;

CREATE TABLE `wpy4_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=223 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wpy4_posts VALUES("2", "1", "2019-09-04 23:01:48", "2019-09-04 23:01:48", "<!-- wp:paragraph -->
<p>This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:</p>
<!-- /wp:paragraph -->

<!-- wp:quote -->
<blockquote class=\"wp-block-quote\"><p>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like piña coladas. (And gettin\' caught in the rain.)</p></blockquote>
<!-- /wp:quote -->

<!-- wp:paragraph -->
<p>...or something like this:</p>
<!-- /wp:paragraph -->

<!-- wp:quote -->
<blockquote class=\"wp-block-quote\"><p>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</p></blockquote>
<!-- /wp:quote -->

<!-- wp:paragraph -->
<p>As a new WordPress user, you should go to <a href=\"http://www.heavenlykey.org/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!</p>
<!-- /wp:paragraph -->", "Sample Page", "", "publish", "closed", "open", "", "sample-page", "", "", "2019-09-05 01:33:42", "2019-09-05 01:33:42", "", "0", "http://www.heavenlykey.org/?page_id=2", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("3", "1", "2019-09-04 23:01:48", "2019-09-04 23:01:48", "<!-- wp:heading --><h2>Who we are</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Our website address is: http://www.heavenlykey.org.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>What personal data we collect and why we collect it</h2><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>Comments</h3><!-- /wp:heading --><!-- wp:paragraph --><p>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>Media</h3><!-- /wp:heading --><!-- wp:paragraph --><p>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>Contact forms</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>Cookies</h3><!-- /wp:heading --><!-- wp:paragraph --><p>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>Embedded content from other websites</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>Analytics</h3><!-- /wp:heading --><!-- wp:heading --><h2>Who we share your data with</h2><!-- /wp:heading --><!-- wp:heading --><h2>How long we retain your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>What rights you have over your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Where we send your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Visitor comments may be checked through an automated spam detection service.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Your contact information</h2><!-- /wp:heading --><!-- wp:heading --><h2>Additional information</h2><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>How we protect your data</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>What data breach procedures we have in place</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>What third parties we receive data from</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>What automated decision making and/or profiling we do with user data</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>Industry regulatory disclosure requirements</h3><!-- /wp:heading -->", "Privacy Policy", "", "draft", "closed", "open", "", "privacy-policy", "", "", "2019-09-04 23:01:48", "2019-09-04 23:01:48", "", "0", "http://www.heavenlykey.org/?page_id=3", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("58", "1", "2019-09-05 02:12:59", "2019-09-05 02:12:59", " ", "", "", "publish", "closed", "closed", "", "58", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=58", "16", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("8", "1", "2019-09-05 00:53:09", "2019-09-05 00:53:09", "", "cropped-logo.jpg", "", "inherit", "closed", "closed", "", "logo-jpg", "", "", "2019-09-05 00:53:09", "2019-09-05 00:53:09", "", "0", "http://www.heavenlykey.org/wp-content/uploads/2019/09/logo.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpy4_posts VALUES("9", "1", "2019-09-05 01:05:18", "2019-09-05 01:05:18", "", "logo", "", "inherit", "open", "closed", "", "logo", "", "", "2019-09-05 01:05:18", "2019-09-05 01:05:18", "", "0", "http://www.heavenlykey.org/wp-content/uploads/2019/09/logo.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpy4_posts VALUES("85", "1", "2019-10-01 00:06:43", "2019-10-01 00:06:43", "<p>[vc_row][vc_column][vc_column_text]</p>
<p><!-- wp:paragraph --><strong>Acts 2:42; I Timothy 4:16; Titus 1:9</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Beloved, when I gave all diligence to write unto you of the common salvation, it was needful for me to write unto you, and exhort [you] that ye should earnestly contend for the faith which was once delivered unto the saints” <strong>(Jude 3).</strong></p>
<p>Take heed unto thyself, and unto the doctrine; continue in them: for in doing this thou shalt both save thyself, and them that hear thee”<strong>(I Timothy 4:16).</strong></p>
<p>Now I beseech you, brethren, mark them which cause divisions and offences contrary to the doctrine which ye have learned; and avoid them” <strong>(Romans 16:17).</strong></p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":1} -->
<h1>2 John 7-11</h1>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>7</strong>  For many deceivers are entered into the world, who confess not that Jesus Christ is come in the flesh. This is a deceiver and an antichrist.                                                                                                   </p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --> <strong>8</strong>  Look to yourselves, that we lose not those things which we have wrought, but that we receive a full reward.                                                                                            </p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong> 9</strong> Whosoever transgresseth, and abideth not in the doctrine of Christ, hath not God. He that abideth in the doctrine of Christ, he hath both the Father and the Son.</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph --><strong>10</strong> If there come any unto you, and bring not this doctrine, receive him not into your house, neither bid him God speed:<br /><!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>11</strong> for he that biddeth him God speed is partaker of his evil deeds.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>2 Corinthians 11:4</strong></p>
<!-- /wp:paragraph -->
<!-- wp:paragraph -->For if he that cometh preacheth another Jesus, whom we have not preached, or if ye receive another spirit, which ye have not received, or another gospel, which ye have not accepted, ye might well bear with him.<br /><!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>Galatians 1:8</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->But should we, or an angel from Heaven, preach any other gospel unto you than that which we have preached to you, let him be accursed.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>We</strong> believe that the Bible is truly the inspired Word of God and that it is the SOLE authority on which we should place our faith and doctrines. God’s Word in the Bible is above any “church” or world leader and should be used for all teaching, doctrines, correction and instruction. We believe that Christ Jesus is revealed as the Creator through the Bible and that He is self existent and eternal. We believe that Christ Jesus gave up His high position in the heavenly kingdom and came to this world as fully man, born into sinful flesh to pay the price for our past sins, and it is only through true repentance and believing on the sacrifice of Christ that our sins can be forgiven. And because Christ lived a perfect life of obedience to His Father in heaven, we are able to come to the Father through Christ Jesus, His only Begotten Son. We believe that we are only saved by the free gift of grace that God has bestowed upon us, and not by our own works. But, We believe that Jesus rising from the death, We believe that a true believer in Christ will produce obedience to God’s commandments and His Word and a true believer will do good works out of love for Him. We believe that if we walk with Jesus each day, then He will send His Holy Spirit to guide us and help us walk in His footsteps and live a holy consecrated life.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->We Believe  in  the  BIBLE  from Genesis – Revelation,  And that the greatest events of Bible prophecy are soon to take place.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>God’s infallible WORD teaches and we believe:</strong></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE HOLY BIBLE</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Holy Bible, consisting of 39 books of the Old Testament and 27 books of the New Testament, is the inspired Word of God. We take the Bible as final authority in all matters concerning Christian conduct and work.<br /><em>(2 Timothy 3:16,17; Proverbs 30:5,6; Revelation 22:18,19.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE GODHEAD</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Godhead consists of three separate, distinct, and recognisable personalities and qualities, perfectly united in one. The Father, the Son, and the Holy Ghost are different Persons in the Godhead, not merely three names for one Person.<br /><em>(Matthew 3:16,17; 2 Corinthians 13:14; Matthew 28:19,20.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE VIRGIN BIRTH OF JESUS</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->The virgin birth of Jesus, the only begotten Son of God as well as His crucifixion, death, burial and bodily resurrection.<br /><em>(Isaiah 7:14; Matthew 1:18-25; Romans 1:4; I Corinthians 15:3,4.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>TOTAL DEPRAVITY, SINFULNESS AND GUILT OF ALL MEN</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->The total depravity, sinfulness and guilt of all men since the Fall, rendering them subject to God’s wrath and condemnation.<br /><em>(Psalm 51:5; Job 14:4; Romans 3:23; 5:12-17; Mark 7:21-23; Ephesians 2:1.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>REPENTANCE</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Repentance is a complete turning away from all sins and its deceitful pleasures and that it is required from every sinner before he can truly and effectively believe in Jesus with saving faith.<br /><em>(Proverbs 28:13; Isaiah 55:7; Ezekiel 18:21-23; Mark 1:15; Luke 24:46,47; Acts 2:38; 3:19; 20:20,21; 2 Corinthians 7:10; Hebrews 6:1-3.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>RESTITUTION</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Restitution is making amends for wrongs done against our fellow-men, restoring stolen things to their rightful owners, paying debts, giving back where one has defrauded, making confessions to the offended and apologizing to those slandered so as to have a conscience void of offence toward God and man.<br /><em>(Genesis 20:1-8,14-18; Exodus 22:1-7; Leviticus 6:1-7; Numbers 5:6-8; 2 Samuel 12:1-6; Proverbs 6:30,31; Ezekiel 33:14-16; Matthew 5:23,24; Luke 19:8,9; Acts 23:1-5; 24:16; James 4:17.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>JUSTIFICATION</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Justification is God’s grace through which one receives forgiveness and remission of sins and is counted righteous before God, through faith in the atoning blood of Jesus. Having thus been cleared of every guilt of sin, the regenerated stands before God as though he had never sinned, not on the basis of any personal merit but in the light of what Christ had accomplished for mankind by His substitutionary death on the cross at Calvary.<br /><em>(Psalm 32:1,2; Isaiah 1:18; Micah 7:19; Acts 13:38.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>WATER BAPTISM</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That water Baptism is essential to our obedience after reconciliation with God. Water Baptism is one immersion (not three) “In the name of the Father, and of the Son, and of the Holy Ghost”, as Jesus commanded.<br /><em>(Matthew 28:19; 3:13-17; Mark 16:15,16; Acts 2:38;8:38,39; 19:1-5; Romans 6:4,5.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE LORD’S SUPPER</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Lord’s supper was instituted by Jesus Christ so that all believers (all members of the family of God) might partake thereof regularly, to “shew the Lord’s death till he come”. The emblems used are “unleavened bread” and the juice of “fruit of the vine”. Anyone who eats and drinks unworthily brings “damnation”, punishment and chastisement upon himself.<br /><em>(Matthew 26:29; Luke 22:17-20; I Corinthians 11:23-30.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>ENTIRE SANCTIFICATION</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Entire Sanctification is a definite act of God’s grace, subsequent to the New Birth, by which the believer’s heart is purified and made holy. It cannot be attained progressively by works, struggle or suppression, but it is obtained by faith in the sanctifying blood of Jesus Christ. Holiness of life and purity of heart are central to Christian living.<br /><em>(Luke 1:74,75; John 17:15-17; I Thessalonians 4:3,7,8; 5:22-24; Ephesians 5:25-27; Hebrews 2:11; 10:10,14; 13:11,12; Titus 2:11-14; I John 1:7; Hebrews 12:14; I Peter 1:14-16.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>HOLY GHOST BAPTISM</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Baptism in the Holy Ghost is the enduement of power from on High upon the sanctified believer. It is “the promise of the Father” and when one receives this “gift of the Holy Ghost”, it is accompanied by the initial evidence of speaking a language unlearned previously, referred to as speaking in tongues as the Spirit gives utterance. We do not teach or instruct people how to speak in tongues: the Holy Spirit gives utterance. We also stress the necessity of purity before power. The Gifts of the Spirit are for believers today.<br /><em>(Matthew 3:11; Acts 1:8; Luke 3:16; 24:49; John 1:30-33; 7:37-39; 14:16,17,26; 15:26; 16:12-15; Acts 1:5-8; Mark 16:17; Acts 2:1-18; 10:44-46; Acts 19:1-6; I Corinthians 12:1-31; 14:1-40.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>REDEMPTION, HEALING AND HEALTH</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Redemption from the curse of the law, Healing of sickness and disease as well as continued Health are provided for all people through the sacrificial death of Jesus Christ.<br /><em>(Exodus 15:26; Deuteronomy 7:15; Psalm 103:1-5; Proverbs 4:20-22; Isaiah 53:4,5; Matthew 8:16,17; I Peter 2:24; Mark 16;15-18; Luke 13:16; John 14:12-14; 10:10; Acts 10:38; James 5:14-16; 3 John 2 Galatians 3:13,14.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>PERSONAL EVANGELISM</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Personal Evangelism is a God-given and God-ordained ministry for every believer. Jesus commanded and God requires every believer to be a compassionate and fruitful soulwinner, bringing others to Christ.<br /><em>(Matthew 28:19,20; Mark 16:15; Luke 24:46-49; John 17:18; Acts 1:8; 1-4; Psalm 126:5,6; Proverbs 11:30; Daniel 12:3; Ezekiel 3:17-21.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>MARRIAGE</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Marriage is binding for life. Monogamy is the uniform teaching of the Bible. Polygamy is contrary to God’s perfect will and institution. Also, under the New Testament dispensation, no one has a right to divorce and remarry while the first companion lives. When a person becomes converted, necessary restitution, on this line, must be done without delay if he has married wrongly.<br /><em>(Genesis 2:24; Deuteronomy 7:1-4; Job 23:11-13; 2 Corinthians 6:14-18; Proverbs 31:10-31; Malachi 2:14,15; Romans 7:2,3; Ephesians 5:31-33; Matthew 5;31,32; 19:3-9; Mark 10:2-12; Luke 16:18; John 4:15-19; Genesis 20:3-7.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE RAPTURE</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Rapture (commonly referred to as the first phase or stage of the SECOND COMING OF CHRIST) is the catching away from the earth, of all living saints and all who died in the Lord. The Rapture will take place before the Great Tribulation and can happen any time from now. “In a twinkling of an eye” without a moment’s warning, “the trumpet shall sound” “and the dead in Christ shall rise first; then we which are alive and remain shall be caught up together with them in the clouds, to meet the Lord in the air: and so shall we ever be with the Lord.”<br /><em>(John 14:1-3; Luke 21:34-36; I Corinthians 15:51-58; I Thessalonians 4:13-18; 5:4-9; 2 Thessalonians 2:5-7; Philippians 3:11,20,21; I John 3:1-3.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE RESURRECTION OF THE DEAD</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Resurrection of the dead is taught in the Bible as clearly as the immortality of the soul. Every individual who has ever lived will be resurrected, some to honour and glory and others to everlasting shame and contempt.<br /><em>(Job 19:25-27; Psalm 71:20; Isaiah 26:19; Daniel 12:2; John 5:28,29; I Corinthians 15:12-57; I Thessalonians 4:13-16; Hebrews 6:1,2; Philippians 3:8-11; Revelation 20:4,6,12,13.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE GREAT TRIBULATION</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Great Tribulation will occur after the Rapture and will be a time of terrible suffering on earth. It is also referred to as the time of “Jacob’s trouble”. During this time, the Antichrist will take possession of this world for a reign of terror. He will not be a system or organization but a person – a supernatural, diabolical being, in the form of a man who will blaspheme and proclaim himself to be God. The Marriage Supper of the Lamb will take place above while the Tribulation continues on earth.<br /><em>(Matthew 24:21,22,29; Revelation 9:16; Mark 13:19; 2 Thessalonians 2:3-12; Revelation 13. Daniel 8:23-25; 2 Thessalonians 2:7-12; Revelation 13:1-10. Revelation 19:1-10.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE SECOND COMING OF CHRIST</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Second Coming of Christ will be just as literal and visible as His going away, and He is coming to execute judgement upon the ungodly. He will also, then, set up His Kingdom and reign on this present earth for a thousand years.<br /><em>(Zechariah 14:3,4; Matthew 25:31-46; 26:64; Mark 13:24-37; 2 Thessalonians 1:7-10; 2:8; Jude 14,15.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>CHRIST’S MILLENNIAL REIGN</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Christ’s Millennial Reign is the 1,000 years literal reign of Jesus on earth, which will be ushered in by the coming of Jesus back to earth with ten thousands of His saints. At this time He will judge the nations that dwell upon the face of the earth. During this time, the devil will be bound. It will be a reign of peace and blessing.<br /><em>(Jude 14,15; 2 Thessalonians 1:7-10. Revelation 20:2,3. Isaiah 11:6-9; 65:25; Hosea 2:18; Zechariah 14:9-20; Isaiah 2:2-4.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE GREAT WHITE THRONE JUDGEMENT</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Great White Throne Judgement is when God finally judges all (the living and the dead, small and great) who have ever lived on the face of the earth, according to their works. This is after the Millennium. At this time, the final Judgement known as the Great White Throne Judgement will be held. All those, from all ages, who have not yet been judged (believers’ judgement for sin, borne and accomplished by Christ on the Cross will stand before God at this time. The devil and his angels are judged at this time also and sent to the lake of fire forever.<br /><em>(John 5:24; 3:17-19. Daniel 12:2,3; Matthew 10:15; 11:21-24,12:41,42; John 5:28,29; Romans 2:15,16; 14:12; 2 Peter 2:9; Jude 6; I Corinthians 6:1-4; Acts 10:42; Revelation 20:11-15.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE NEW HEAVEN AND THE NEW EARTH</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the New Heaven and the New Earth “wherein dwelleth righteousness” will be made by God and the redeemed shall dwell therein with God forever. This present earth which has been polluted by sin will pass away after the Great White Throne Judgement. No unclean thing will be there. There, we shall know each other, our knowledge having been perfected. There will be no more curse upon anything. There will be no more night; the glory of the Lord will be the light thereof.<br /><em>(Psalm 102:25,26; Isaiah 51:6; 65:17; Matthew 5:18; 24:35; 2 Peter 3:10-13; Revelation 21:1- Isaiah 66:22; 2 Peter 3:12,13; I Corinthians 13:12; I John 3:2,3; Revelation 21:1-7; 22:1-5.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>HELL</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Hell fire is a place of everlasting punishment where sinners (all who do not have their names in the book of life) will suffer torments for ever and ever. It was prepared for the devil and his angels (Matthew 25:41) but God has decreed that the wicked and those who forget Him and reject Christ will also be cast there because of their sin and neglect of His salvation.<br /><em>(Psalm 9:17; Matthew 25:46; Luke 12:4,5; 16:19-31; Matthew 5:22,30; Mark 9:43-47; Revelation 14:10,11; 20:10,12,15.)</em></p>
<!-- /wp:paragraph -->
<p>&nbsp;</p>
<p>[/vc_column_text][/vc_column][/vc_row]</p>
", "What We Believe", "", "publish", "closed", "closed", "", "what-we-believe", "", "", "2019-10-24 23:40:15", "2019-10-24 23:40:15", "<p>[vc_row][vc_column][vc_column_text]</p>
<p><!-- wp:paragraph --><strong>Acts 2:42; I Timothy 4:16; Titus 1:9</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Beloved, when I gave all diligence to write unto you of the common salvation, it was needful for me to write unto you, and exhort [you] that ye should earnestly contend for the faith which was once delivered unto the saints” <strong>(Jude 3).</strong></p>
<p>Take heed unto thyself, and unto the doctrine; continue in them: for in doing this thou shalt both save thyself, and them that hear thee”<strong>(I Timothy 4:16).</strong></p>
<p>Now I beseech you, brethren, mark them which cause divisions and offences contrary to the doctrine which ye have learned; and avoid them” <strong>(Romans 16:17).</strong></p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":1} -->
<h1>2 John 7-11</h1>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>7</strong>  For many deceivers are entered into the world, who confess not that Jesus Christ is come in the flesh. This is a deceiver and an antichrist.                                                                                                   </p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --> <strong>8</strong>  Look to yourselves, that we lose not those things which we have wrought, but that we receive a full reward.                                                                                            </p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong> 9</strong> Whosoever transgresseth, and abideth not in the doctrine of Christ, hath not God. He that abideth in the doctrine of Christ, he hath both the Father and the Son.</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph --><strong>10</strong> If there come any unto you, and bring not this doctrine, receive him not into your house, neither bid him God speed:<br /><!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>11</strong> for he that biddeth him God speed is partaker of his evil deeds.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>2 Corinthians 11:4</strong></p>
<!-- /wp:paragraph -->
<!-- wp:paragraph -->For if he that cometh preacheth another Jesus, whom we have not preached, or if ye receive another spirit, which ye have not received, or another gospel, which ye have not accepted, ye might well bear with him.<br /><!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>Galatians 1:8</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->But should we, or an angel from Heaven, preach any other gospel unto you than that which we have preached to you, let him be accursed.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>We</strong> believe that the Bible is truly the inspired Word of God and that it is the SOLE authority on which we should place our faith and doctrines. God’s Word in the Bible is above any “church” or world leader and should be used for all teaching, doctrines, correction and instruction. We believe that Christ Jesus is revealed as the Creator through the Bible and that He is self existent and eternal. We believe that Christ Jesus gave up His high position in the heavenly kingdom and came to this world as fully man, born into sinful flesh to pay the price for our past sins, and it is only through true repentance and believing on the sacrifice of Christ that our sins can be forgiven. And because Christ lived a perfect life of obedience to His Father in heaven, we are able to come to the Father through Christ Jesus, His only Begotten Son. We believe that we are only saved by the free gift of grace that God has bestowed upon us, and not by our own works. But, We believe that Jesus rising from the death, We believe that a true believer in Christ will produce obedience to God’s commandments and His Word and a true believer will do good works out of love for Him. We believe that if we walk with Jesus each day, then He will send His Holy Spirit to guide us and help us walk in His footsteps and live a holy consecrated life.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->We Believe  in  the  BIBLE  from Genesis – Revelation,  And that the greatest events of Bible prophecy are soon to take place.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>God’s infallible WORD teaches and we believe:</strong></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE HOLY BIBLE</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Holy Bible, consisting of 39 books of the Old Testament and 27 books of the New Testament, is the inspired Word of God. We take the Bible as final authority in all matters concerning Christian conduct and work.<br /><em>(2 Timothy 3:16,17; Proverbs 30:5,6; Revelation 22:18,19.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE GODHEAD</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Godhead consists of three separate, distinct, and recognisable personalities and qualities, perfectly united in one. The Father, the Son, and the Holy Ghost are different Persons in the Godhead, not merely three names for one Person.<br /><em>(Matthew 3:16,17; 2 Corinthians 13:14; Matthew 28:19,20.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE VIRGIN BIRTH OF JESUS</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->The virgin birth of Jesus, the only begotten Son of God as well as His crucifixion, death, burial and bodily resurrection.<br /><em>(Isaiah 7:14; Matthew 1:18-25; Romans 1:4; I Corinthians 15:3,4.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>TOTAL DEPRAVITY, SINFULNESS AND GUILT OF ALL MEN</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->The total depravity, sinfulness and guilt of all men since the Fall, rendering them subject to God’s wrath and condemnation.<br /><em>(Psalm 51:5; Job 14:4; Romans 3:23; 5:12-17; Mark 7:21-23; Ephesians 2:1.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>REPENTANCE</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Repentance is a complete turning away from all sins and its deceitful pleasures and that it is required from every sinner before he can truly and effectively believe in Jesus with saving faith.<br /><em>(Proverbs 28:13; Isaiah 55:7; Ezekiel 18:21-23; Mark 1:15; Luke 24:46,47; Acts 2:38; 3:19; 20:20,21; 2 Corinthians 7:10; Hebrews 6:1-3.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>RESTITUTION</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Restitution is making amends for wrongs done against our fellow-men, restoring stolen things to their rightful owners, paying debts, giving back where one has defrauded, making confessions to the offended and apologizing to those slandered so as to have a conscience void of offence toward God and man.<br /><em>(Genesis 20:1-8,14-18; Exodus 22:1-7; Leviticus 6:1-7; Numbers 5:6-8; 2 Samuel 12:1-6; Proverbs 6:30,31; Ezekiel 33:14-16; Matthew 5:23,24; Luke 19:8,9; Acts 23:1-5; 24:16; James 4:17.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>JUSTIFICATION</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Justification is God’s grace through which one receives forgiveness and remission of sins and is counted righteous before God, through faith in the atoning blood of Jesus. Having thus been cleared of every guilt of sin, the regenerated stands before God as though he had never sinned, not on the basis of any personal merit but in the light of what Christ had accomplished for mankind by His substitutionary death on the cross at Calvary.<br /><em>(Psalm 32:1,2; Isaiah 1:18; Micah 7:19; Acts 13:38.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>WATER BAPTISM</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That water Baptism is essential to our obedience after reconciliation with God. Water Baptism is one immersion (not three) “In the name of the Father, and of the Son, and of the Holy Ghost”, as Jesus commanded.<br /><em>(Matthew 28:19; 3:13-17; Mark 16:15,16; Acts 2:38;8:38,39; 19:1-5; Romans 6:4,5.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE LORD’S SUPPER</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Lord’s supper was instituted by Jesus Christ so that all believers (all members of the family of God) might partake thereof regularly, to “shew the Lord’s death till he come”. The emblems used are “unleavened bread” and the juice of “fruit of the vine”. Anyone who eats and drinks unworthily brings “damnation”, punishment and chastisement upon himself.<br /><em>(Matthew 26:29; Luke 22:17-20; I Corinthians 11:23-30.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>ENTIRE SANCTIFICATION</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Entire Sanctification is a definite act of God’s grace, subsequent to the New Birth, by which the believer’s heart is purified and made holy. It cannot be attained progressively by works, struggle or suppression, but it is obtained by faith in the sanctifying blood of Jesus Christ. Holiness of life and purity of heart are central to Christian living.<br /><em>(Luke 1:74,75; John 17:15-17; I Thessalonians 4:3,7,8; 5:22-24; Ephesians 5:25-27; Hebrews 2:11; 10:10,14; 13:11,12; Titus 2:11-14; I John 1:7; Hebrews 12:14; I Peter 1:14-16.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>HOLY GHOST BAPTISM</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Baptism in the Holy Ghost is the enduement of power from on High upon the sanctified believer. It is “the promise of the Father” and when one receives this “gift of the Holy Ghost”, it is accompanied by the initial evidence of speaking a language unlearned previously, referred to as speaking in tongues as the Spirit gives utterance. We do not teach or instruct people how to speak in tongues: the Holy Spirit gives utterance. We also stress the necessity of purity before power. The Gifts of the Spirit are for believers today.<br /><em>(Matthew 3:11; Acts 1:8; Luke 3:16; 24:49; John 1:30-33; 7:37-39; 14:16,17,26; 15:26; 16:12-15; Acts 1:5-8; Mark 16:17; Acts 2:1-18; 10:44-46; Acts 19:1-6; I Corinthians 12:1-31; 14:1-40.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>REDEMPTION, HEALING AND HEALTH</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Redemption from the curse of the law, Healing of sickness and disease as well as continued Health are provided for all people through the sacrificial death of Jesus Christ.<br /><em>(Exodus 15:26; Deuteronomy 7:15; Psalm 103:1-5; Proverbs 4:20-22; Isaiah 53:4,5; Matthew 8:16,17; I Peter 2:24; Mark 16;15-18; Luke 13:16; John 14:12-14; 10:10; Acts 10:38; James 5:14-16; 3 John 2 Galatians 3:13,14.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>PERSONAL EVANGELISM</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Personal Evangelism is a God-given and God-ordained ministry for every believer. Jesus commanded and God requires every believer to be a compassionate and fruitful soulwinner, bringing others to Christ.<br /><em>(Matthew 28:19,20; Mark 16:15; Luke 24:46-49; John 17:18; Acts 1:8; 1-4; Psalm 126:5,6; Proverbs 11:30; Daniel 12:3; Ezekiel 3:17-21.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>MARRIAGE</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Marriage is binding for life. Monogamy is the uniform teaching of the Bible. Polygamy is contrary to God’s perfect will and institution. Also, under the New Testament dispensation, no one has a right to divorce and remarry while the first companion lives. When a person becomes converted, necessary restitution, on this line, must be done without delay if he has married wrongly.<br /><em>(Genesis 2:24; Deuteronomy 7:1-4; Job 23:11-13; 2 Corinthians 6:14-18; Proverbs 31:10-31; Malachi 2:14,15; Romans 7:2,3; Ephesians 5:31-33; Matthew 5;31,32; 19:3-9; Mark 10:2-12; Luke 16:18; John 4:15-19; Genesis 20:3-7.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE RAPTURE</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Rapture (commonly referred to as the first phase or stage of the SECOND COMING OF CHRIST) is the catching away from the earth, of all living saints and all who died in the Lord. The Rapture will take place before the Great Tribulation and can happen any time from now. “In a twinkling of an eye” without a moment’s warning, “the trumpet shall sound” “and the dead in Christ shall rise first; then we which are alive and remain shall be caught up together with them in the clouds, to meet the Lord in the air: and so shall we ever be with the Lord.”<br /><em>(John 14:1-3; Luke 21:34-36; I Corinthians 15:51-58; I Thessalonians 4:13-18; 5:4-9; 2 Thessalonians 2:5-7; Philippians 3:11,20,21; I John 3:1-3.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE RESURRECTION OF THE DEAD</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Resurrection of the dead is taught in the Bible as clearly as the immortality of the soul. Every individual who has ever lived will be resurrected, some to honour and glory and others to everlasting shame and contempt.<br /><em>(Job 19:25-27; Psalm 71:20; Isaiah 26:19; Daniel 12:2; John 5:28,29; I Corinthians 15:12-57; I Thessalonians 4:13-16; Hebrews 6:1,2; Philippians 3:8-11; Revelation 20:4,6,12,13.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE GREAT TRIBULATION</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Great Tribulation will occur after the Rapture and will be a time of terrible suffering on earth. It is also referred to as the time of “Jacob’s trouble”. During this time, the Antichrist will take possession of this world for a reign of terror. He will not be a system or organization but a person – a supernatural, diabolical being, in the form of a man who will blaspheme and proclaim himself to be God. The Marriage Supper of the Lamb will take place above while the Tribulation continues on earth.<br /><em>(Matthew 24:21,22,29; Revelation 9:16; Mark 13:19; 2 Thessalonians 2:3-12; Revelation 13. Daniel 8:23-25; 2 Thessalonians 2:7-12; Revelation 13:1-10. Revelation 19:1-10.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE SECOND COMING OF CHRIST</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Second Coming of Christ will be just as literal and visible as His going away, and He is coming to execute judgement upon the ungodly. He will also, then, set up His Kingdom and reign on this present earth for a thousand years.<br /><em>(Zechariah 14:3,4; Matthew 25:31-46; 26:64; Mark 13:24-37; 2 Thessalonians 1:7-10; 2:8; Jude 14,15.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>CHRIST’S MILLENNIAL REIGN</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Christ’s Millennial Reign is the 1,000 years literal reign of Jesus on earth, which will be ushered in by the coming of Jesus back to earth with ten thousands of His saints. At this time He will judge the nations that dwell upon the face of the earth. During this time, the devil will be bound. It will be a reign of peace and blessing.<br /><em>(Jude 14,15; 2 Thessalonians 1:7-10. Revelation 20:2,3. Isaiah 11:6-9; 65:25; Hosea 2:18; Zechariah 14:9-20; Isaiah 2:2-4.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE GREAT WHITE THRONE JUDGEMENT</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the Great White Throne Judgement is when God finally judges all (the living and the dead, small and great) who have ever lived on the face of the earth, according to their works. This is after the Millennium. At this time, the final Judgement known as the Great White Throne Judgement will be held. All those, from all ages, who have not yet been judged (believers’ judgement for sin, borne and accomplished by Christ on the Cross will stand before God at this time. The devil and his angels are judged at this time also and sent to the lake of fire forever.<br /><em>(John 5:24; 3:17-19. Daniel 12:2,3; Matthew 10:15; 11:21-24,12:41,42; John 5:28,29; Romans 2:15,16; 14:12; 2 Peter 2:9; Jude 6; I Corinthians 6:1-4; Acts 10:42; Revelation 20:11-15.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>THE NEW HEAVEN AND THE NEW EARTH</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That the New Heaven and the New Earth “wherein dwelleth righteousness” will be made by God and the redeemed shall dwell therein with God forever. This present earth which has been polluted by sin will pass away after the Great White Throne Judgement. No unclean thing will be there. There, we shall know each other, our knowledge having been perfected. There will be no more curse upon anything. There will be no more night; the glory of the Lord will be the light thereof.<br /><em>(Psalm 102:25,26; Isaiah 51:6; 65:17; Matthew 5:18; 24:35; 2 Peter 3:10-13; Revelation 21:1- Isaiah 66:22; 2 Peter 3:12,13; I Corinthians 13:12; I John 3:2,3; Revelation 21:1-7; 22:1-5.)</em></p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>HELL</h2>
<!-- /wp:heading -->
<p><!-- wp:paragraph -->That Hell fire is a place of everlasting punishment where sinners (all who do not have their names in the book of life) will suffer torments for ever and ever. It was prepared for the devil and his angels (Matthew 25:41) but God has decreed that the wicked and those who forget Him and reject Christ will also be cast there because of their sin and neglect of His salvation.<br /><em>(Psalm 9:17; Matthew 25:46; Luke 12:4,5; 16:19-31; Matthew 5:22,30; Mark 9:43-47; Revelation 14:10,11; 20:10,12,15.)</em></p>
<!-- /wp:paragraph -->
<p>&nbsp;</p>
<p>[/vc_column_text][/vc_column][/vc_row]</p>
", "0", "http://www.heavenlykey.org/?page_id=85", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("11", "1", "2019-09-05 01:15:22", "2019-09-05 01:15:22", "http://www.heavenlykey.org/wp-content/uploads/2019/09/cropped-logo-1.jpg", "cropped-logo-1.jpg", "", "inherit", "open", "closed", "", "cropped-logo-1-jpg", "", "", "2019-09-05 01:15:22", "2019-09-05 01:15:22", "", "0", "http://www.heavenlykey.org/wp-content/uploads/2019/09/cropped-logo-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpy4_posts VALUES("16", "1", "2019-09-05 01:33:24", "2019-09-05 01:33:24", "<!-- wp:paragraph -->
<p>This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:</p>
<!-- /wp:paragraph -->

<!-- wp:quote -->
<blockquote class=\"wp-block-quote\"><p>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like piña coladas. (And gettin\' caught in the rain.)</p></blockquote>
<!-- /wp:quote -->

<!-- wp:paragraph -->
<p>...or something like this:</p>
<!-- /wp:paragraph -->

<!-- wp:quote -->
<blockquote class=\"wp-block-quote\"><p>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</p></blockquote>
<!-- /wp:quote -->

<!-- wp:paragraph -->
<p>As a new WordPress user, you should go to <a href=\"http://www.heavenlykey.org/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!</p>
<!-- /wp:paragraph -->", "Sample Page", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2019-09-05 01:33:24", "2019-09-05 01:33:24", "", "2", "http://www.heavenlykey.org/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("17", "1", "2019-09-05 01:37:29", "2019-09-05 01:37:29", "<p>[vc_row][vc_column][vc_gallery interval=\"3\" images=\"109,115,134,122\" img_size=\"large\"][vc_column_text]</p>
<h2><strong><img class=\"alignnone wp-image-94\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/12074654_887507834671471_3230046876956505481_n-300x300.jpg\" alt=\"\" width=\"244\" height=\"244\" /></strong></h2>
<h2><strong>Dearly beloved,</strong></h2>
<!-- /wp:paragraph -->
<h3><!-- wp:paragraph -->I am delighted to warmly welcome you to our homepage. You have come to the right place at the right time. Here, we are very passionate about your eternal destiny and committed to your spiritual welfare.  This is a website that has a lot to offer you</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph -->It is now my greatest delight to invite you to commit the rest of your life to the Great Saviour, Jesus Christ, who died for our sins- to accept Him as your personal Lord and Saviour; to enjoy the warmth of our fellowship, and then travel along with us on this highway of holiness to our eternal home in heaven.</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph -->Once again, I welcome you to a lifetime of unforgettable and eternally-beneficial experience of walking with God. This is an End-Time Non-Denominational Evangelistic Movement, Preachers of Holiness, Networking with other Believers/Evangelistic Ministry &amp; True Bible Believing Churches to bring the true word of God. With a mission of bring Sinners to Christ, Uniting &amp; Equipping the Saints to be Ready  for the soon coming Rapture</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph -->Our prayer is that you would be blessed and strengthened by the power of Jesus Christ and that you will live a life of abundance in fellowship, Holiness, joy and liberty.   We study the Word,  practice what we learn and in the process grow together.  May God richly bless you!</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph -->We pray you will join us on this journey and we hope to provide you with meaningful opportunities to connect with others true Christians who share this vision.  If you’re just beginning to explore how God may be relevant in your life, we want to meet you on that path. If you’re a committed Christian who wants to grow deeper in your faith, we want to support and nurture that desire. May your encounters here serve to draw you nearer to Christ, and may you be blessed by a sense of God’s presence in this community. We trust you’ll find Heavenly Key Evangelistic Movement   to be a place you can call people of Holiness &amp; God Chosen People.</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph -->I want to personally Thank &amp; Congratulate others true Believers/Bible Believing Churches who have been preaching this true word of God’s Righteousness  across the Globe, Contending for the Faith that was once delivered unto the Saints, Practicing Holiness &amp; Living by the word, its my earnest Prayer that  the good Lord should give us all the last grace to enter his kingdom at last in Jesus Name (Amen)</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph --> – Evangelist Emmanuel Ogheneochuko Adiohwo</h3>
<h3><!-- /wp:paragraph --></h3>
<h3></h3>
<p>[/vc_column_text][vc_headings borderclr=\"#1e73be\" title=\"Do You Understand the Signs of the Times?\" titlesize=\"30\" titleclr=\"#000000\"]</p>
<p class=\"style1 style46 style19\" align=\"center\"><strong><u><img class=\"alignnone wp-image-86 size-full\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/09/index_signs-end-times.jpg\" alt=\"\" width=\"1030\" height=\"125\" /></u></strong></p>
<p class=\"style1 style46 style19\" align=\"center\"><strong><u>END-TIME HAS COME, WHERE WILL YOU SPEND ETERNITY? HEAVEN OR HELL</u></strong></p>
<h3 class=\"style35\" align=\"center\"></h3>
<p>[/vc_headings][vc_message message_box_color=\"juicy_pink\"]</p>
<h3 class=\"style35\" align=\"center\"><span class=\"style23\"> <strong><span class=\"style26\">Pray Hard,</span></strong></span> <span class=\"style4\">Keep Watch,</span><span class=\"style27\"> <strong>Stand Firm;</strong></span><span class=\"style4\"> Love God,</span> <strong><span class=\"style24\">Praise Jesus,</span></strong> <span class=\"style27\">Live Crucified; </span><span class=\"style26\"><strong><span class=\"style19\">Serve Others, </span></strong></span><span class=\"style24\">Share Christ,</span> <strong><span class=\"style20\">Show Grace;</span></strong><span class=\"style26\"> <span class=\"style36\">Be Humble,</span> <span class=\"style21\"><strong>Bear Fruit,</strong><span class=\"style37\"> Obey Christ;  </span></span><strong><span class=\"style19\">Fear God,</span></strong></span><strong> </strong><span class=\"style24\">Fight darkness,</span><span class=\"style20\"><strong>Shun evil,</strong></span> <span class=\"style24\">Stay Pure; </span><span class=\"style24\">Finish Strong &amp; <strong>Overcome.</strong></span><span class=\"style26\"><br />
<span class=\"style19\">Win Souls, <strong>Souls,</strong> Souls for <strong>Jesus</strong></span></span><strong><span class=\"style38\"> Christ</span></strong></h3>
<p>[/vc_message][vc_row_inner][vc_column_inner width=\"1/3\"][vc_column_text]</p>
<h3 style=\"text-align: center;\">FOR ALL HAVE SINNED..<a href=\"http://www.heavenlykey.org/total-depravity-sinfulness-and-guilt-of-all-men/\" target=\"_blank\" rel=\"noopener noreferrer\"><br />
<img class=\"size-medium wp-image-111 aligncenter\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/for-all-have-sin-300x300.jpg\" alt=\"\" width=\"300\" height=\"300\" /></a><a href=\"http://www.heavenlykey.org/total-depravity-sinfulness-and-guilt-of-all-men/\" target=\"_blank\" rel=\"noopener noreferrer\">Read</a></h3>
<p>[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text]</p>
<h3 style=\"text-align: center;\">END-TIME EVENTS..</h3>
<h3 style=\"text-align: center;\"><a href=\"http://www.heavenlykey.org/learn-about-end-time-events/\" target=\"_blank\" rel=\"noopener noreferrer\"><img class=\"alignnone size-full wp-image-119\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/signs-of-the-times-300x300.png\" alt=\"\" width=\"300\" height=\"300\" /></a><a href=\"http://www.heavenlykey.org/learn-about-end-time-events/\" target=\"_blank\" rel=\"noopener noreferrer\">Read</a></h3>
<p>[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text]</p>
<h3 style=\"text-align: center;\">HAVE YOU CONSIDER YOUR END?<a href=\"http://www.heavenlykey.org/total-depravity-sinfulness-and-guilt-of-all-men/\" target=\"_blank\" rel=\"noopener noreferrer\"><br />
</a><a href=\"http://www.heavenlykey.org/where-will-you-spend-eternity/\" target=\"_blank\" rel=\"noopener noreferrer\"><img class=\"alignnone size-medium wp-image-125\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/eternity-1-300x300.jpg\" alt=\"\" width=\"300\" height=\"300\" />Read</a></h3>
<p>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_posts_slider type=\"flexslider_slide\" count=\"3\" interval=\"5\" slides_content=\"teaser\" slides_title=\"1\" order=\"ASC\" posttypes=\"post\" title=\"RECENT POST\" categories=\"general,Bible Stories and Questions,Eschatology, False Prophets and Teachers,Faith and Prayer,Miracles, Signs, and Wonders,Restitution and Encouragement,Salvation, Deliverance & Freedom from Sin,Sanctification, Holiness & Righteousness,The Baptism of the Holy Ghost & Fire\"][/vc_column][/vc_row]</p>
", "", "", "publish", "closed", "closed", "", "home", "", "", "2019-11-19 10:48:52", "2019-11-19 10:48:52", "<p>[vc_row][vc_column][vc_gallery interval=\"3\" images=\"109,115,134,122\" img_size=\"large\"][vc_column_text]</p>
<h2><strong><img class=\"alignnone wp-image-94\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/12074654_887507834671471_3230046876956505481_n-300x300.jpg\" alt=\"\" width=\"244\" height=\"244\" /></strong></h2>
<h2><strong>Dearly beloved,</strong></h2>
<!-- /wp:paragraph -->
<h3><!-- wp:paragraph -->I am delighted to warmly welcome you to our homepage. You have come to the right place at the right time. Here, we are very passionate about your eternal destiny and committed to your spiritual welfare.  This is a website that has a lot to offer you</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph -->It is now my greatest delight to invite you to commit the rest of your life to the Great Saviour, Jesus Christ, who died for our sins- to accept Him as your personal Lord and Saviour; to enjoy the warmth of our fellowship, and then travel along with us on this highway of holiness to our eternal home in heaven.</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph -->Once again, I welcome you to a lifetime of unforgettable and eternally-beneficial experience of walking with God. This is an End-Time Non-Denominational Evangelistic Movement, Preachers of Holiness, Networking with other Believers/Evangelistic Ministry &amp; True Bible Believing Churches to bring the true word of God. With a mission of bring Sinners to Christ, Uniting &amp; Equipping the Saints to be Ready  for the soon coming Rapture</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph -->Our prayer is that you would be blessed and strengthened by the power of Jesus Christ and that you will live a life of abundance in fellowship, Holiness, joy and liberty.   We study the Word,  practice what we learn and in the process grow together.  May God richly bless you!</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph -->We pray you will join us on this journey and we hope to provide you with meaningful opportunities to connect with others true Christians who share this vision.  If you’re just beginning to explore how God may be relevant in your life, we want to meet you on that path. If you’re a committed Christian who wants to grow deeper in your faith, we want to support and nurture that desire. May your encounters here serve to draw you nearer to Christ, and may you be blessed by a sense of God’s presence in this community. We trust you’ll find Heavenly Key Evangelistic Movement   to be a place you can call people of Holiness &amp; God Chosen People.</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph -->I want to personally Thank &amp; Congratulate others true Believers/Bible Believing Churches who have been preaching this true word of God’s Righteousness  across the Globe, Contending for the Faith that was once delivered unto the Saints, Practicing Holiness &amp; Living by the word, its my earnest Prayer that  the good Lord should give us all the last grace to enter his kingdom at last in Jesus Name (Amen)</h3>
<h3><!-- /wp:paragraph --></h3>
<h3><!-- wp:paragraph --> – Evangelist Emmanuel Ogheneochuko Adiohwo</h3>
<h3><!-- /wp:paragraph --></h3>
<h3></h3>
<p>[/vc_column_text][vc_headings borderclr=\"#1e73be\" title=\"Do You Understand the Signs of the Times?\" titlesize=\"30\" titleclr=\"#000000\"]</p>
<p class=\"style1 style46 style19\" align=\"center\"><strong><u><img class=\"alignnone wp-image-86 size-full\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/09/index_signs-end-times.jpg\" alt=\"\" width=\"1030\" height=\"125\" /></u></strong></p>
<p class=\"style1 style46 style19\" align=\"center\"><strong><u>END-TIME HAS COME, WHERE WILL YOU SPEND ETERNITY? HEAVEN OR HELL</u></strong></p>
<h3 class=\"style35\" align=\"center\"></h3>
<p>[/vc_headings][vc_message message_box_color=\"juicy_pink\"]</p>
<h3 class=\"style35\" align=\"center\"><span class=\"style23\"> <strong><span class=\"style26\">Pray Hard,</span></strong></span> <span class=\"style4\">Keep Watch,</span><span class=\"style27\"> <strong>Stand Firm;</strong></span><span class=\"style4\"> Love God,</span> <strong><span class=\"style24\">Praise Jesus,</span></strong> <span class=\"style27\">Live Crucified; </span><span class=\"style26\"><strong><span class=\"style19\">Serve Others, </span></strong></span><span class=\"style24\">Share Christ,</span> <strong><span class=\"style20\">Show Grace;</span></strong><span class=\"style26\"> <span class=\"style36\">Be Humble,</span> <span class=\"style21\"><strong>Bear Fruit,</strong><span class=\"style37\"> Obey Christ;  </span></span><strong><span class=\"style19\">Fear God,</span></strong></span><strong> </strong><span class=\"style24\">Fight darkness,</span><span class=\"style20\"><strong>Shun evil,</strong></span> <span class=\"style24\">Stay Pure; </span><span class=\"style24\">Finish Strong &amp; <strong>Overcome.</strong></span><span class=\"style26\"><br />
<span class=\"style19\">Win Souls, <strong>Souls,</strong> Souls for <strong>Jesus</strong></span></span><strong><span class=\"style38\"> Christ</span></strong></h3>
<p>[/vc_message][vc_row_inner][vc_column_inner width=\"1/3\"][vc_column_text]</p>
<h3 style=\"text-align: center;\">FOR ALL HAVE SINNED..<a href=\"http://www.heavenlykey.org/total-depravity-sinfulness-and-guilt-of-all-men/\" target=\"_blank\" rel=\"noopener noreferrer\"><br />
<img class=\"size-medium wp-image-111 aligncenter\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/for-all-have-sin-300x300.jpg\" alt=\"\" width=\"300\" height=\"300\" /></a><a href=\"http://www.heavenlykey.org/total-depravity-sinfulness-and-guilt-of-all-men/\" target=\"_blank\" rel=\"noopener noreferrer\">Read</a></h3>
<p>[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text]</p>
<h3 style=\"text-align: center;\">END-TIME EVENTS..</h3>
<h3 style=\"text-align: center;\"><a href=\"http://www.heavenlykey.org/learn-about-end-time-events/\" target=\"_blank\" rel=\"noopener noreferrer\"><img class=\"alignnone size-full wp-image-119\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/signs-of-the-times-300x300.png\" alt=\"\" width=\"300\" height=\"300\" /></a><a href=\"http://www.heavenlykey.org/learn-about-end-time-events/\" target=\"_blank\" rel=\"noopener noreferrer\">Read</a></h3>
<p>[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_column_text]</p>
<h3 style=\"text-align: center;\">HAVE YOU CONSIDER YOUR END?<a href=\"http://www.heavenlykey.org/total-depravity-sinfulness-and-guilt-of-all-men/\" target=\"_blank\" rel=\"noopener noreferrer\"><br />
</a><a href=\"http://www.heavenlykey.org/where-will-you-spend-eternity/\" target=\"_blank\" rel=\"noopener noreferrer\"><img class=\"alignnone size-medium wp-image-125\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/eternity-1-300x300.jpg\" alt=\"\" width=\"300\" height=\"300\" />Read</a></h3>
<p>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_posts_slider type=\"flexslider_slide\" count=\"3\" interval=\"5\" slides_content=\"teaser\" slides_title=\"1\" order=\"ASC\" posttypes=\"post\" title=\"RECENT POST\" categories=\"general,Bible Stories and Questions,Eschatology, False Prophets and Teachers,Faith and Prayer,Miracles, Signs, and Wonders,Restitution and Encouragement,Salvation, Deliverance & Freedom from Sin,Sanctification, Holiness & Righteousness,The Baptism of the Holy Ghost & Fire\"][/vc_column][/vc_row]</p>
", "0", "http://www.heavenlykey.org/?page_id=17", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("18", "1", "2019-09-05 01:37:29", "2019-09-05 01:37:29", "", "home", "", "inherit", "closed", "closed", "", "17-revision-v1", "", "", "2019-09-05 01:37:29", "2019-09-05 01:37:29", "", "17", "http://www.heavenlykey.org/17-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("146", "1", "2019-10-24 23:35:58", "2019-10-24 23:35:58", " ", "", "", "publish", "closed", "closed", "", "146", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=146", "5", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("24", "1", "2019-09-05 01:43:50", "2019-09-05 01:43:50", "<p>[vc_row][vc_column][vc_column_text]<!-- wp:heading {\"level\":5} --></p>
<h5><strong>Greetings!</strong></h5>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>Welcome</strong> to the Heavenly Key Evangelistic Movement website.  I am delighted that you have chosen to visit with us.  At Heavenly Key Evangelistic Movement, you will find a place where you can be inspired, encouraged, and equipped to meet the practical needs of living in today’s world; a place where you can experience God and become all that God wants you to be.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Heavenly Key Evangelistic Movement is committed to reaching people with the message of God’s love and grace, growing them to maturity in Christ likeness, and sending them forth into the world by the power of the Holy Spirit to join Christ in his work of reconciliation and transformation.  Worship, Crusade, bible study, mission projects, charity,  sunday school, youth ministries, hospital visitation, prison ministry, children’s ministry, and various service opportunities are available to empower and equip you for victorious living in Christ.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->We would be honored to have you join us for any of the activities above as we move toward the vision of glorifying God and transforming humanity by doing justice, living mercy, and walking humbly with God.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Peace and blessings.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->In His Service,</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph --><!-- /wp:paragraph -->
<p><!-- wp:paragraph --><img class=\"alignnone size-medium wp-image-156\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/43134411_1877043199051258_1968911135604211712_n-295x300.jpg\" alt=\"\" width=\"295\" height=\"300\" /></p>
<p>Evangelist Emmanuel O Adiohwo</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3><strong>For </strong> <strong>Counseling</strong> <strong> &amp; </strong> <strong>Prayer Call:</strong> 2347067092254, 2348176443398</h3>
<!-- /wp:heading -->
<p>&nbsp;</p>
<p>[/vc_column_text][/vc_column][/vc_row]</p>
", "Pastor’s Welcome Message", "", "publish", "closed", "closed", "", "welcome-message", "", "", "2019-10-25 01:08:23", "2019-10-25 01:08:23", "<p>[vc_row][vc_column][vc_column_text]<!-- wp:heading {\"level\":5} --></p>
<h5><strong>Greetings!</strong></h5>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>Welcome</strong> to the Heavenly Key Evangelistic Movement website.  I am delighted that you have chosen to visit with us.  At Heavenly Key Evangelistic Movement, you will find a place where you can be inspired, encouraged, and equipped to meet the practical needs of living in today’s world; a place where you can experience God and become all that God wants you to be.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Heavenly Key Evangelistic Movement is committed to reaching people with the message of God’s love and grace, growing them to maturity in Christ likeness, and sending them forth into the world by the power of the Holy Spirit to join Christ in his work of reconciliation and transformation.  Worship, Crusade, bible study, mission projects, charity,  sunday school, youth ministries, hospital visitation, prison ministry, children’s ministry, and various service opportunities are available to empower and equip you for victorious living in Christ.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->We would be honored to have you join us for any of the activities above as we move toward the vision of glorifying God and transforming humanity by doing justice, living mercy, and walking humbly with God.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Peace and blessings.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->In His Service,</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph --><!-- /wp:paragraph -->
<p><!-- wp:paragraph --><img class=\"alignnone size-medium wp-image-156\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/43134411_1877043199051258_1968911135604211712_n-295x300.jpg\" alt=\"\" width=\"295\" height=\"300\" /></p>
<p>Evangelist Emmanuel O Adiohwo</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3><strong>For </strong> <strong>Counseling</strong> <strong> &amp; </strong> <strong>Prayer Call:</strong> 2347067092254, 2348176443398</h3>
<!-- /wp:heading -->
<p>&nbsp;</p>
<p>[/vc_column_text][/vc_column][/vc_row]</p>
", "0", "http://www.heavenlykey.org/?page_id=24", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("25", "1", "2019-09-05 01:43:50", "2019-09-05 01:43:50", "", "Welcome Message", "", "inherit", "closed", "closed", "", "24-revision-v1", "", "", "2019-09-05 01:43:50", "2019-09-05 01:43:50", "", "24", "http://www.heavenlykey.org/24-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("26", "1", "2019-09-05 01:44:42", "2019-09-05 01:44:42", "", "About Us", "", "publish", "closed", "closed", "", "about-us", "", "", "2019-09-05 01:44:43", "2019-09-05 01:44:43", "", "0", "http://www.heavenlykey.org/?page_id=26", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("27", "1", "2019-09-05 01:44:42", "2019-09-05 01:44:42", "", "About Us", "", "inherit", "closed", "closed", "", "26-revision-v1", "", "", "2019-09-05 01:44:42", "2019-09-05 01:44:42", "", "26", "http://www.heavenlykey.org/26-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("28", "1", "2019-09-05 01:45:15", "2019-09-05 01:45:15", "<p>[vc_row][vc_column][vc_column_text]<!-- wp:heading {\"level\":3} --></p>
<h3><img class=\"alignnone wp-image-148 size-full\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/worldflag-pix.gif\" alt=\"\" width=\"993\" height=\"280\" /></h3>
<h1 style=\"text-align: center;\">PASTORING THE NATIONS!</h1>
<!-- /wp:heading -->
<!-- wp:image {\"id\":278,\"align\":\"center\"} -->
<div class=\"wp-block-image\">
<figure class=\"aligncenter\"><img class=\"wp-image-278\" src=\"http://web.archive.org/web/20190216212624im_/https://i0.wp.com/heavenlykey.org/wp-content/uploads/2018/06/global-flags-world-25519312.jpg?resize=175%2C208\" alt=\"\" /></figure>
<figure></figure>
<figure class=\"aligncenter\"><img class=\"alignnone size-medium wp-image-92\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/43278445_1877005322388379_5364780706687877120_n-300x300.jpg\" alt=\"\" width=\"300\" height=\"300\" /></figure>
</div>
<!-- /wp:image -->
<p><!-- wp:paragraph -->Emmanuel Ogheneochuko Adiohwo is a passionate endtime non-denominational Pastor, Evangelist, Teacher and the president of Heavenly Key Evangelistic Movement  in Nigeria, Africa and beyond. He has reached thousands of people with the good news of Jesus Christ through Gospel meetings and online media.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->He studied Theology at Deeper Life Bible School (IBTC – International Bible Training College).</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Emmanuel Ogheneochuko  Adiohwo has been studying intensively the Evangelistic ministry of Evangelist Reinhard Bonnke, <span data-ved=\"2ahUKEwjd0ZKYkrblAhURlFwKHZEuCeUQ2kooAjAfegQIDxAN\">British Evangelist </span>Smith Wigglesworth, <span data-ved=\"2ahUKEwj3nvzYkrblAhWHQkEAHfzhAIMQ2kooAjAgegQIDBAN\">Evangelist </span>Joseph Ayo Babalola, Benson Andrew Idahosa, Pastor W.F Kumuyi, Pastor <em>Benny Hinn and many other anointed men and women of God</em></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->The studying and the help of his theological training specifically prepared him for this End-time Evangelistic Movement  on reaching the whole world for Christ through the power of the Holy Spirit.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Emmanuel Ogheneochuko Adiohwo is opportuned and highly favoured by God almighty to have these anointed men of God as his spiritual mentors.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>Pastor William F. Kumuyi – Founder and General Superintendent of the Deeper Christian Life Ministry.</strong></p>
<!-- /wp:paragraph -->
<!-- wp:image {\"id\":134} --><!-- /wp:image -->
<p><img class=\"alignnone size-full wp-image-149\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/kumuyi.jpg\" alt=\"\" width=\"238\" height=\"178\" /></p>
<p>&nbsp;</p>
<p><!-- wp:paragraph --><strong>Pastor Benny Hinn – Founder, Benny Hinn Ministries and International Evangelist. </strong></p>
<p><!-- wp:paragraph --><img class=\"alignnone wp-image-150\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/images-2-269x300.jpg\" alt=\"\" width=\"225\" height=\"251\" /></p>
<p>Emmanuel Ogheneochuko Adiohwo preaches the gospel in the power of the Holy Spirit and his ministry is accompanied by miracles, signs and wonders. Across media, churches, crusade and revival meetings people have experienced the presence of God and are empowered.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Emmanuel Ogheneochuko Adiohwo is a man with a genuine love for people and a burden to see them saved, sanctified, healed and delivered. He is a true worshiper with a lifestyle of holiness, prayer, fasting and a great love for the word of God.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->​He has a mandate and a passion to train and equip the body of Christ and to help discover, develop and fulfill God given purpose.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>Thanks </strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Evangelist Emmanuel .O Adiohwo</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>Experience the supernatural power of God with Evangelist Emmanuel O Adiohwo. With God all things are possible, His power is mighty to save from sin, give you grace to live a holy life, deliver from every oppression, heal all kinds of sicknesses &amp; diseases, break every yokes, breakthrough, miracles,  signs &amp; wonders.</strong></p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3><strong>For </strong><strong>Counseling</strong> <strong>&amp; </strong><strong>Prayer Call:</strong> 2347067092254, 2348176443398</h3>
<!-- /wp:heading -->
<!-- wp:heading {\"level\":3} --><!-- /wp:heading -->
<!-- wp:heading {\"level\":3} --><!-- /wp:heading -->
<p><!-- wp:paragraph --><!-- /wp:paragraph -->[/vc_column_text][/vc_column][/vc_row]</p>
", "Meet The Pastor", "", "publish", "closed", "closed", "", "meet-the-pastor", "", "", "2019-10-25 00:43:52", "2019-10-25 00:43:52", "<p>[vc_row][vc_column][vc_column_text]<!-- wp:heading {\"level\":3} --></p>
<h3><img class=\"alignnone wp-image-148 size-full\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/worldflag-pix.gif\" alt=\"\" width=\"993\" height=\"280\" /></h3>
<h1 style=\"text-align: center;\">PASTORING THE NATIONS!</h1>
<!-- /wp:heading -->
<!-- wp:image {\"id\":278,\"align\":\"center\"} -->
<div class=\"wp-block-image\">
<figure class=\"aligncenter\"><img class=\"wp-image-278\" src=\"http://web.archive.org/web/20190216212624im_/https://i0.wp.com/heavenlykey.org/wp-content/uploads/2018/06/global-flags-world-25519312.jpg?resize=175%2C208\" alt=\"\" /></figure>
<figure></figure>
<figure class=\"aligncenter\"><img class=\"alignnone size-medium wp-image-92\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/43278445_1877005322388379_5364780706687877120_n-300x300.jpg\" alt=\"\" width=\"300\" height=\"300\" /></figure>
</div>
<!-- /wp:image -->
<p><!-- wp:paragraph -->Emmanuel Ogheneochuko Adiohwo is a passionate endtime non-denominational Pastor, Evangelist, Teacher and the president of Heavenly Key Evangelistic Movement  in Nigeria, Africa and beyond. He has reached thousands of people with the good news of Jesus Christ through Gospel meetings and online media.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->He studied Theology at Deeper Life Bible School (IBTC – International Bible Training College).</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Emmanuel Ogheneochuko  Adiohwo has been studying intensively the Evangelistic ministry of Evangelist Reinhard Bonnke, <span data-ved=\"2ahUKEwjd0ZKYkrblAhURlFwKHZEuCeUQ2kooAjAfegQIDxAN\">British Evangelist </span>Smith Wigglesworth, <span data-ved=\"2ahUKEwj3nvzYkrblAhWHQkEAHfzhAIMQ2kooAjAgegQIDBAN\">Evangelist </span>Joseph Ayo Babalola, Benson Andrew Idahosa, Pastor W.F Kumuyi, Pastor <em>Benny Hinn and many other anointed men and women of God</em></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->The studying and the help of his theological training specifically prepared him for this End-time Evangelistic Movement  on reaching the whole world for Christ through the power of the Holy Spirit.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Emmanuel Ogheneochuko Adiohwo is opportuned and highly favoured by God almighty to have these anointed men of God as his spiritual mentors.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>Pastor William F. Kumuyi – Founder and General Superintendent of the Deeper Christian Life Ministry.</strong></p>
<!-- /wp:paragraph -->
<!-- wp:image {\"id\":134} --><!-- /wp:image -->
<p><img class=\"alignnone size-full wp-image-149\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/kumuyi.jpg\" alt=\"\" width=\"238\" height=\"178\" /></p>
<p>&nbsp;</p>
<p><!-- wp:paragraph --><strong>Pastor Benny Hinn – Founder, Benny Hinn Ministries and International Evangelist. </strong></p>
<p><!-- wp:paragraph --><img class=\"alignnone wp-image-150\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/images-2-269x300.jpg\" alt=\"\" width=\"225\" height=\"251\" /></p>
<p>Emmanuel Ogheneochuko Adiohwo preaches the gospel in the power of the Holy Spirit and his ministry is accompanied by miracles, signs and wonders. Across media, churches, crusade and revival meetings people have experienced the presence of God and are empowered.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Emmanuel Ogheneochuko Adiohwo is a man with a genuine love for people and a burden to see them saved, sanctified, healed and delivered. He is a true worshiper with a lifestyle of holiness, prayer, fasting and a great love for the word of God.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->​He has a mandate and a passion to train and equip the body of Christ and to help discover, develop and fulfill God given purpose.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>Thanks </strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->Evangelist Emmanuel .O Adiohwo</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>Experience the supernatural power of God with Evangelist Emmanuel O Adiohwo. With God all things are possible, His power is mighty to save from sin, give you grace to live a holy life, deliver from every oppression, heal all kinds of sicknesses &amp; diseases, break every yokes, breakthrough, miracles,  signs &amp; wonders.</strong></p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3><strong>For </strong><strong>Counseling</strong> <strong>&amp; </strong><strong>Prayer Call:</strong> 2347067092254, 2348176443398</h3>
<!-- /wp:heading -->
<!-- wp:heading {\"level\":3} --><!-- /wp:heading -->
<!-- wp:heading {\"level\":3} --><!-- /wp:heading -->
<p><!-- wp:paragraph --><!-- /wp:paragraph -->[/vc_column_text][/vc_column][/vc_row]</p>
", "0", "http://www.heavenlykey.org/?page_id=28", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("29", "1", "2019-09-05 01:45:15", "2019-09-05 01:45:15", "", "Meet The Pastor", "", "inherit", "closed", "closed", "", "28-revision-v1", "", "", "2019-09-05 01:45:15", "2019-09-05 01:45:15", "", "28", "http://www.heavenlykey.org/28-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("30", "1", "2019-09-05 01:47:06", "2019-09-05 01:47:06", "<p>[vc_row][vc_column][vc_column_text]<!-- wp:heading {\"level\":5} --></p>
<h5>EXPERIENCE THE LIFE OF JESUS THROUGH THE MANY DIFFERENT MINISTRIES AT HEAVENLY KEY EVANGELISTIC MOVEMENT</h5>
<h6>“So I sought for a man among them who would make a wall, and stand in the gap before Me on behalf of the land, that I should not destroy it; but I found no one”. Ezekiel 22:30.</h6>
<!-- /wp:heading -->
<!-- wp:paragraph -->​<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->The Heavenly Key Evangelistic Movement has a specific mandate to stand in the gap and provide spiritual covering for the Church and the Kingdom of God, gathering spiritual intelligence to bombard and destroy the Kingdom of darkness. It is a strong and vibrant ministry and one that requires a lifestyle of holiness, praying, fasting and complete submission to God.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->We minister in a variety of ways from:</p>
<!-- /wp:paragraph --><br /><!-- wp:heading {\"level\":4} -->
<h2>1.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Internet Ministry...</h2>
<p>&nbsp;</p>
<h2>2.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Radio/Television...</h2>
<p>&nbsp;</p>
<h2>3.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Gospel Crusade...</h2>
<p>&nbsp;</p>
<h2>4.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Van/Motor Campaign Ministry...</h2>
<p>&nbsp;</p>
<h2>5.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Charity Ministry...</h2>
<h2> </h2>
<h2>6.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Print Media Ministry...</h2>
<h2> </h2>
<h2>7.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  School Outreach...</h2>
<h2> </h2>
<h2>8.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Global Minister\'s Program (GMP)...</h2>
<h2> </h2>
<h2>9\'<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Hospital Visitation...</h2>
<h2> </h2>
<h2>10. <img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Prison Visitation...</h2>
<h2><!-- /wp:heading --></h2>
<!-- wp:heading {\"level\":4} -->
<h2> </h2>
<h2>11.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Bible School...</h2>
<h2><!-- /wp:heading --><!-- /wp:heading --></h2>
<!-- wp:heading {\"level\":3} -->
<h2> </h2>
<p>[/vc_column_text][/vc_column][/vc_row]</p>
", "Ministries", "", "publish", "closed", "closed", "", "ministries", "", "", "2020-06-13 08:39:11", "2020-06-13 08:39:11", "<p>[vc_row][vc_column][vc_column_text]<!-- wp:heading {\"level\":5} --></p>
<h5>EXPERIENCE THE LIFE OF JESUS THROUGH THE MANY DIFFERENT MINISTRIES AT HEAVENLY KEY EVANGELISTIC MOVEMENT</h5>
<h6>“So I sought for a man among them who would make a wall, and stand in the gap before Me on behalf of the land, that I should not destroy it; but I found no one”. Ezekiel 22:30.</h6>
<!-- /wp:heading -->
<!-- wp:paragraph -->​<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->The Heavenly Key Evangelistic Movement has a specific mandate to stand in the gap and provide spiritual covering for the Church and the Kingdom of God, gathering spiritual intelligence to bombard and destroy the Kingdom of darkness. It is a strong and vibrant ministry and one that requires a lifestyle of holiness, praying, fasting and complete submission to God.</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->We minister in a variety of ways from:</p>
<!-- /wp:paragraph --><br /><!-- wp:heading {\"level\":4} -->
<h2>1.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Internet Ministry...</h2>
<p>&nbsp;</p>
<h2>2.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Radio/Television...</h2>
<p>&nbsp;</p>
<h2>3.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Gospel Crusade...</h2>
<p>&nbsp;</p>
<h2>4.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Van/Motor Campaign Ministry...</h2>
<p>&nbsp;</p>
<h2>5.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Charity Ministry...</h2>
<h2> </h2>
<h2>6.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Print Media Ministry...</h2>
<h2> </h2>
<h2>7.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  School Outreach...</h2>
<h2> </h2>
<h2>8.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Global Minister\'s Program (GMP)...</h2>
<h2> </h2>
<h2>9\'<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Hospital Visitation...</h2>
<h2> </h2>
<h2>10. <img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Prison Visitation...</h2>
<h2><!-- /wp:heading --></h2>
<!-- wp:heading {\"level\":4} -->
<h2> </h2>
<h2>11.<img class=\"alignnone wp-image-141\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/finger-pointing-gif-7-300x300.gif\" alt=\"\" width=\"32\" height=\"32\" />  Bible School...</h2>
<h2><!-- /wp:heading --><!-- /wp:heading --></h2>
<!-- wp:heading {\"level\":3} -->
<h2> </h2>
<p>[/vc_column_text][/vc_column][/vc_row]</p>
", "0", "http://www.heavenlykey.org/?page_id=30", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("31", "1", "2019-09-05 01:47:06", "2019-09-05 01:47:06", "", "Ministries", "", "inherit", "closed", "closed", "", "30-revision-v1", "", "", "2019-09-05 01:47:06", "2019-09-05 01:47:06", "", "30", "http://www.heavenlykey.org/30-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("32", "1", "2019-09-05 01:47:32", "2019-09-05 01:47:32", "", "Biblical Teachings", "", "publish", "closed", "closed", "", "biblical-teachings", "", "", "2019-09-05 01:47:33", "2019-09-05 01:47:33", "", "0", "http://www.heavenlykey.org/?page_id=32", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("33", "1", "2019-09-05 01:47:32", "2019-09-05 01:47:32", "", "Biblical Teachings", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2019-09-05 01:47:32", "2019-09-05 01:47:32", "", "32", "http://www.heavenlykey.org/32-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("34", "1", "2019-09-05 01:48:03", "2019-09-05 01:48:03", "", "Blog", "", "publish", "closed", "closed", "", "blog", "", "", "2020-07-06 23:59:42", "2020-07-06 23:59:42", "", "0", "http://www.heavenlykey.org/?page_id=34", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("221", "2", "2020-07-06 23:59:42", "2020-07-06 23:59:42", "", "Blog", "", "inherit", "closed", "closed", "", "34-revision-v1", "", "", "2020-07-06 23:59:42", "2020-07-06 23:59:42", "", "34", "http://www.heavenlykey.org/34-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("35", "1", "2019-09-05 01:48:03", "2019-09-05 01:48:03", "", "Resources", "", "inherit", "closed", "closed", "", "34-revision-v1", "", "", "2019-09-05 01:48:03", "2019-09-05 01:48:03", "", "34", "http://www.heavenlykey.org/34-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("36", "1", "2019-09-05 01:48:54", "2019-09-05 01:48:54", "<p>[vc_row][vc_column][vc_column_text]<!-- wp:heading {\"level\":3} --></p>
<h3>1. Acknowledge</h3>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>Admit that you have sinned and need God’s help</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“For all have sinned, and come short of the glory of God” (Romans 3:23)</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“God be merciful to me a sinner” (Luke 18:13)</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3> 2. Confess and Repent</h3>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>Be genuinely sorry for the sins you have committed and ask God to forgive you.</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“If we confess our sins, he is faithful and just to forgive us our sins, and to cleanse us from all unrighteousness” (1 John 1:9)</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“Except ye repent, ye shall all likewise perish” (Luke 13:3)</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“Repent ye therefore, and be converted, that your sins may be blotted out” (Acts 3:19)</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3> 3. Forsake</h3>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>Determine that with God’s help you are going to turn away from all sin in your life.</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“Let the wicked forsake his way, and the unrighteous man his thoughts: and let him return unto the LORD, and he will have mercy upon him; and to our God, for he will abundantly pardon” (Isaiah 55:7)</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3> 4. Believe</h3>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>When you have honestly and sincerely taken the steps above, then believe that God will hear your prayer and save you.</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“For God so loved the world, that he gave his only begotten Son, that whosoever believeth in him should not perish, but have everlasting life” (John 3:16)</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3> 5. Receive</h3>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>God will let you know that the work is done in your heart.</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“The Spirit itself beareth witness with our spirit, that we are the children of God” (Romans 8:16)</p>
<!-- /wp:paragraph -->
<p>&nbsp;</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3><strong>For </strong><strong>Counseling</strong> <strong>&amp; </strong><strong>Prayer Call:</strong> 2347067092254, 2348176443398</h3>
<!-- /wp:heading -->
<p>&nbsp;</p>
<p>[/vc_column_text][/vc_column][/vc_row]</p>
", "Steps to Salvation", "", "publish", "closed", "closed", "", "steps-to-salvation", "", "", "2019-10-25 01:11:10", "2019-10-25 01:11:10", "<p>[vc_row][vc_column][vc_column_text]<!-- wp:heading {\"level\":3} --></p>
<h3>1. Acknowledge</h3>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>Admit that you have sinned and need God’s help</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“For all have sinned, and come short of the glory of God” (Romans 3:23)</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“God be merciful to me a sinner” (Luke 18:13)</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3> 2. Confess and Repent</h3>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>Be genuinely sorry for the sins you have committed and ask God to forgive you.</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“If we confess our sins, he is faithful and just to forgive us our sins, and to cleanse us from all unrighteousness” (1 John 1:9)</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“Except ye repent, ye shall all likewise perish” (Luke 13:3)</p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“Repent ye therefore, and be converted, that your sins may be blotted out” (Acts 3:19)</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3> 3. Forsake</h3>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>Determine that with God’s help you are going to turn away from all sin in your life.</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“Let the wicked forsake his way, and the unrighteous man his thoughts: and let him return unto the LORD, and he will have mercy upon him; and to our God, for he will abundantly pardon” (Isaiah 55:7)</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3> 4. Believe</h3>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>When you have honestly and sincerely taken the steps above, then believe that God will hear your prayer and save you.</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“For God so loved the world, that he gave his only begotten Son, that whosoever believeth in him should not perish, but have everlasting life” (John 3:16)</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3> 5. Receive</h3>
<!-- /wp:heading -->
<p><!-- wp:paragraph --><strong>God will let you know that the work is done in your heart.</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph -->“The Spirit itself beareth witness with our spirit, that we are the children of God” (Romans 8:16)</p>
<!-- /wp:paragraph -->
<p>&nbsp;</p>
<!-- /wp:paragraph -->
<!-- wp:heading {\"level\":3} -->
<h3><strong>For </strong><strong>Counseling</strong> <strong>&amp; </strong><strong>Prayer Call:</strong> 2347067092254, 2348176443398</h3>
<!-- /wp:heading -->
<p>&nbsp;</p>
<p>[/vc_column_text][/vc_column][/vc_row]</p>
", "0", "http://www.heavenlykey.org/?page_id=36", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("37", "1", "2019-09-05 01:48:54", "2019-09-05 01:48:54", "", "Steps to Salvation", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2019-09-05 01:48:54", "2019-09-05 01:48:54", "", "36", "http://www.heavenlykey.org/36-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("38", "1", "2019-09-05 01:50:19", "2019-09-05 01:50:19", "[vc_row][vc_column][vc_message message_box_color=\"pink\" icon_fontawesome=\"fa fa-handshake-o\"]<b><span class=\"st\">Just ask. Get answers. Your questions and feedback  are important to <em>us</em>.</span></b>[/vc_message][/vc_column][/vc_row][vc_row][vc_column width=\"1/4\"][/vc_column][vc_column width=\"1/2\"][vc_column_text]

<h2 class=\"style39\" style=\"text-align: left;\" align=\"center\">Heavenly Key Evangelistic Movement</h2>

&nbsp;

<p class=\"style39\" style=\"text-align: left;\" align=\"center\"><strong>Address:</strong> Road 21 Rumuagholu Town, Port-Harcourt, River State Nigeria.</p>

&nbsp;

<p class=\"style39\" style=\"text-align: left;\" align=\"center\"><strong>Phone Number: +2347067092254 , 2348176443398</strong></p>

&nbsp;

<p style=\"text-align: left;\" align=\"center\"><strong>Email:</strong>  <strong>info@heavenlykey.org , heavenlykeyministry@gmail.com</strong></p>

&nbsp;

<p class=\"style39\" style=\"text-align: left;\" align=\"center\"><strong>Our Facebook Page Facebook: <a href=\"http://www.facebook.com/heavenlykey\" target=\"_blank\" rel=\"noopener noreferrer\">www.facebook.com/heavenlykey</a></strong></p>

&nbsp;

<p class=\"style39\" style=\"text-align: left;\" align=\"center\"><strong>Moment of Miracles with Evangelist Emmanuel O Adiohwo: <a href=\"https://www.facebook.com/evangelistemmanueloadiohwo/\" target=\"_blank\" rel=\"noopener noreferrer\">https://www.facebook.com/evangelistemmanueloadiohwo/</a></strong></p>

[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]<a href=\"https://api.whatsapp.com/send?phone=2348176443398\" target=\"_blank\" rel=\"noopener noreferrer\"><img class=\"alignnone size-medium wp-image-180 aligncenter\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/whatsapp-button-300x104.png\" alt=\"\" width=\"300\" height=\"104\" /></a>[/vc_column_text][/vc_column][/vc_row]", "Contact Us", "", "publish", "closed", "closed", "", "contact-us", "", "", "2019-10-25 05:06:05", "2019-10-25 05:06:05", "<p>[vc_row][vc_column][vc_message message_box_color=\"pink\" icon_fontawesome=\"fa fa-handshake-o\"]<b><span class=\"st\">Just ask. Get answers. Your questions and feedback  are important to <em>us</em>.</span></b>[/vc_message][/vc_column][/vc_row][vc_row][vc_column width=\"1/4\"][/vc_column][vc_column width=\"1/2\"][vc_column_text]</p>
<h2 class=\"style39\" style=\"text-align: left;\" align=\"center\">Heavenly Key Evangelistic Movement</h2>
<p>&nbsp;</p>
<p class=\"style39\" style=\"text-align: left;\" align=\"center\"><strong>Address:</strong> Road 21 Rumuagholu Town, Port-Harcourt, River State Nigeria.</p>
<p>&nbsp;</p>
<p class=\"style39\" style=\"text-align: left;\" align=\"center\"><strong>Phone Number: +2347067092254 , 2348176443398</strong></p>
<p>&nbsp;</p>
<p style=\"text-align: left;\" align=\"center\"><strong>Email:</strong>  <strong>info@heavenlykey.org , heavenlykeyministry@gmail.com</strong></p>
<p>&nbsp;</p>
<p class=\"style39\" style=\"text-align: left;\" align=\"center\"><strong>Our Facebook Page Facebook: <a href=\"http://www.facebook.com/heavenlykey\" target=\"_blank\" rel=\"noopener noreferrer\">www.facebook.com/heavenlykey</a></strong></p>
<p>&nbsp;</p>
<p class=\"style39\" style=\"text-align: left;\" align=\"center\"><strong>Moment of Miracles with Evangelist Emmanuel O Adiohwo: <a href=\"https://www.facebook.com/evangelistemmanueloadiohwo/\" target=\"_blank\" rel=\"noopener noreferrer\">https://www.facebook.com/evangelistemmanueloadiohwo/</a></strong></p>
<p>[/vc_column_text][/vc_column][vc_column width=\"1/4\"][vc_column_text]<a href=\"https://api.whatsapp.com/send?phone=2348176443398\" target=\"_blank\" rel=\"noopener noreferrer\"><img class=\"alignnone size-medium wp-image-180 aligncenter\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/whatsapp-button-300x104.png\" alt=\"\" width=\"300\" height=\"104\" /></a>[/vc_column_text][/vc_column][/vc_row]</p>
", "0", "http://www.heavenlykey.org/?page_id=38", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("39", "1", "2019-09-05 01:50:19", "2019-09-05 01:50:19", "", "Contact Us", "", "inherit", "closed", "closed", "", "38-revision-v1", "", "", "2019-09-05 01:50:19", "2019-09-05 01:50:19", "", "38", "http://www.heavenlykey.org/38-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("40", "1", "2019-09-05 01:51:07", "2019-09-05 01:51:07", "<p>[vc_row][vc_column][vc_column_text]</p>
<h2><strong>PAYING YOUR TITHES, OFFERINGS, AND DONATIONS INTO THIS  MINISTRY</strong></h2>
<h3 class=\"wp-block-image\" style=\"text-align: center;\" data-sr-id=\"2\"><em><strong>“Give and it shall be given back to you…” (Luke 11:35).<br /></strong></em></h3>
<p>&nbsp;</p>
<p><!-- wp:paragraph --><strong>When we give, we are giving to Jesus, your financial support fund is used to support the work of God.</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>Mat.25:40 –</strong> Inasmuch as ye have done it unto one of the least of these My brethren, ye have done it unto Me</p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>Mat.6:4 – Father which seeth in secret shall reward thee openly</h2>
<p><!-- /wp:heading --><br /><!-- wp:paragraph -->IF the Lord puts it in your Heart to support this Evangelistic Movement  in spreading of the true bible teaching, all over the world, to also come off-line in other to win more souls for Christ and to rescue the perishing from Hell Fire and from the bondage of Sin and Satan<br />Whatever the Lord has lay in your heart to support us with, kindly contact us to know how to send it</p>
<!-- /wp:paragraph -->
<h3 style=\"text-align: left;\"><a href=\"https://paystack.com/pay/hekem\" target=\"_blank\" rel=\"noopener noreferrer\">ONLINE CARD PAYMENT/TRANSFER CLICK HERE </a></h3>
<p>O<a href=\"https://paystack.com/pay/hekem\" target=\"_blank\" rel=\"noopener noreferrer\"><img class=\"alignnone wp-image-193 \" src=\"http://www.heavenlykey.org/wp-content/uploads/2020/06/payment.gif\" alt=\"\" width=\"438\" height=\"146\" /></a></p>
<!-- wp:heading {\"level\":1} -->
<h1> </h1>
<h1>OR</h1>
<h1>Bank Deposit/Transfer</h1>
<!-- /wp:heading -->
<!-- wp:heading {\"level\":3} -->
<h3>Account Name: Adiohwo Ogheneochuko Emmanuel</h3>
<!-- /wp:heading --><br /><!-- wp:heading {\"level\":3} -->
<h2><strong><img class=\"alignnone wp-image-159\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/gtb.jpg\" alt=\"\" width=\"95\" height=\"95\" /></strong></h2>
<h2><strong>G.T Bank – 0113937669</strong></h2>
<p>&nbsp;</p>
<h1><strong>International Money Transfer</strong></h1>
<!-- /wp:heading -->
<h2><img class=\"alignnone wp-image-161\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/western-300x145.jpg\" alt=\"\" width=\"186\" height=\"90\" /> - Westen Union</h2>
<h2> </h2>
<h2> <img class=\"alignnone wp-image-162\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/money-gram-300x173.jpg\" alt=\"\" width=\"182\" height=\"105\" /> - Money Gram</h2>
<!-- /wp:paragraph --><!-- /wp:paragraph --><!-- /wp:paragraph -->
<!-- wp:heading {\"level\":5} -->
<h3>Receiver Name: Adiohwo Ogheneochuko Emmanuel</h3>
<!-- /wp:heading -->
<!-- wp:heading -->
<h3>Also if you are a born again Christian with a deep passion to rescue the perishing willing to be a member of Heavenlykey Evangelistic Movement, please Contact Us</h3>
<h3><!-- /wp:heading --></h3>
<p>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]</p>
<h3 style=\"text-align: left;\"><strong><a href=\"https://paystack.com/pay/hekem\" target=\"_blank\" rel=\"noopener noreferrer\">ONLINE CARD PAYMENT/TRANSFER CLICK HERE </a></strong></h3>
<p>[/vc_column_text][/vc_column][/vc_row]</p>
", "Partnership", "", "publish", "closed", "closed", "", "partnership", "", "", "2020-06-12 10:06:56", "2020-06-12 10:06:56", "<p>[vc_row][vc_column][vc_column_text]</p>
<h2><strong>PAYING YOUR TITHES, OFFERINGS, AND DONATIONS INTO THIS  MINISTRY</strong></h2>
<h3 class=\"wp-block-image\" style=\"text-align: center;\" data-sr-id=\"2\"><em><strong>“Give and it shall be given back to you…” (Luke 11:35).<br /></strong></em></h3>
<p>&nbsp;</p>
<p><!-- wp:paragraph --><strong>When we give, we are giving to Jesus, your financial support fund is used to support the work of God.</strong></p>
<!-- /wp:paragraph -->
<p><!-- wp:paragraph --><strong>Mat.25:40 –</strong> Inasmuch as ye have done it unto one of the least of these My brethren, ye have done it unto Me</p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2>Mat.6:4 – Father which seeth in secret shall reward thee openly</h2>
<p><!-- /wp:heading --><br /><!-- wp:paragraph -->IF the Lord puts it in your Heart to support this Evangelistic Movement  in spreading of the true bible teaching, all over the world, to also come off-line in other to win more souls for Christ and to rescue the perishing from Hell Fire and from the bondage of Sin and Satan<br />Whatever the Lord has lay in your heart to support us with, kindly contact us to know how to send it</p>
<!-- /wp:paragraph -->
<h3 style=\"text-align: left;\"><a href=\"https://paystack.com/pay/hekem\" target=\"_blank\" rel=\"noopener noreferrer\">ONLINE CARD PAYMENT/TRANSFER CLICK HERE </a></h3>
<p>O<a href=\"https://paystack.com/pay/hekem\" target=\"_blank\" rel=\"noopener noreferrer\"><img class=\"alignnone wp-image-193 \" src=\"http://www.heavenlykey.org/wp-content/uploads/2020/06/payment.gif\" alt=\"\" width=\"438\" height=\"146\" /></a></p>
<!-- wp:heading {\"level\":1} -->
<h1> </h1>
<h1>OR</h1>
<h1>Bank Deposit/Transfer</h1>
<!-- /wp:heading -->
<!-- wp:heading {\"level\":3} -->
<h3>Account Name: Adiohwo Ogheneochuko Emmanuel</h3>
<!-- /wp:heading --><br /><!-- wp:heading {\"level\":3} -->
<h2><strong><img class=\"alignnone wp-image-159\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/gtb.jpg\" alt=\"\" width=\"95\" height=\"95\" /></strong></h2>
<h2><strong>G.T Bank – 0113937669</strong></h2>
<p>&nbsp;</p>
<h1><strong>International Money Transfer</strong></h1>
<!-- /wp:heading -->
<h2><img class=\"alignnone wp-image-161\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/western-300x145.jpg\" alt=\"\" width=\"186\" height=\"90\" /> - Westen Union</h2>
<h2> </h2>
<h2> <img class=\"alignnone wp-image-162\" src=\"http://www.heavenlykey.org/wp-content/uploads/2019/10/money-gram-300x173.jpg\" alt=\"\" width=\"182\" height=\"105\" /> - Money Gram</h2>
<!-- /wp:paragraph --><!-- /wp:paragraph --><!-- /wp:paragraph -->
<!-- wp:heading {\"level\":5} -->
<h3>Receiver Name: Adiohwo Ogheneochuko Emmanuel</h3>
<!-- /wp:heading -->
<!-- wp:heading -->
<h3>Also if you are a born again Christian with a deep passion to rescue the perishing willing to be a member of Heavenlykey Evangelistic Movement, please Contact Us</h3>
<h3><!-- /wp:heading --></h3>
<p>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]</p>
<h3 style=\"text-align: left;\"><strong><a href=\"https://paystack.com/pay/hekem\" target=\"_blank\" rel=\"noopener noreferrer\">ONLINE CARD PAYMENT/TRANSFER CLICK HERE </a></strong></h3>
<p>[/vc_column_text][/vc_column][/vc_row]</p>
", "0", "http://www.heavenlykey.org/?page_id=40", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("41", "1", "2019-09-05 01:51:07", "2019-09-05 01:51:07", "", "Partnership", "", "inherit", "closed", "closed", "", "40-revision-v1", "", "", "2019-09-05 01:51:07", "2019-09-05 01:51:07", "", "40", "http://www.heavenlykey.org/40-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("42", "1", "2019-09-05 01:52:26", "2019-09-05 01:52:26", "", "Giving", "", "publish", "closed", "closed", "", "42", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=42", "22", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("44", "1", "2019-09-05 01:52:26", "2019-09-05 01:52:26", " ", "", "", "publish", "closed", "closed", "", "44", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=44", "21", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("45", "1", "2019-09-05 01:52:26", "2019-09-05 01:52:26", " ", "", "", "publish", "closed", "closed", "", "45", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=45", "20", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("46", "1", "2019-09-05 01:52:26", "2019-09-05 01:52:26", " ", "", "", "publish", "closed", "closed", "", "46", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=46", "8", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("47", "1", "2019-09-05 01:52:26", "2019-09-05 01:52:26", " ", "", "", "publish", "closed", "closed", "", "47", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=47", "7", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("48", "1", "2019-09-05 01:52:26", "2019-09-05 01:52:26", " ", "", "", "publish", "closed", "closed", "", "48", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=48", "6", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("50", "1", "2019-09-05 01:52:26", "2019-09-05 01:52:26", " ", "", "", "publish", "closed", "closed", "", "50", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=50", "3", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("51", "1", "2019-09-05 01:52:26", "2019-09-05 01:52:26", "", "Home", "", "publish", "closed", "closed", "", "51", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=51", "1", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("59", "1", "2019-09-05 02:12:59", "2019-09-05 02:12:59", " ", "", "", "publish", "closed", "closed", "", "59", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=59", "15", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("56", "1", "2019-09-05 02:00:33", "2019-09-05 02:00:33", " ", "", "", "publish", "closed", "closed", "", "56", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=56", "4", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("60", "1", "2019-09-05 02:12:59", "2019-09-05 02:12:59", " ", "", "", "publish", "closed", "closed", "", "60", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=60", "13", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("53", "1", "2019-09-05 01:55:34", "2019-09-05 01:55:34", "", "About", "", "publish", "closed", "closed", "", "about-us", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=53", "2", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("54", "1", "2019-09-05 01:56:36", "2019-09-05 01:56:36", "<!-- wp:image {\"id\":9} -->
<figure class=\"wp-block-image\"><img src=\"http://www.heavenlykey.org/wp-content/uploads/2019/09/logo-295x300.jpg\" alt=\"\" class=\"wp-image-9\"/></figure>
<!-- /wp:image -->

<!-- wp:heading {\"level\":4} -->
<h4>We are self funding Evangelistic Movement sharing the much needed Bible truths with the world.</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement is preaching the Gospel, teaching the Word, contending for the faith which was once delivered unto the saints, Jude 3.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement&nbsp;is also in the business of networking with Bible believing ministries to bring God’s word to the unreached, distributing of hand bills, tracts and gospel CD, crusade, preaching across churches/fellowships, mission trips, partnering to distribute Bibles to the unreached nations and much more.&nbsp;</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement is out to welcome any one who have been Saved  with a burden to rescue the perishing to partner with us for the good of the gospel, The coming of our Lord and savior Jesus is at hand and also nearer than ever and many are out there unreached and unsaved and here we are sparing our selves and many are perishing, therefore come with us.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>&nbsp;<strong>Evangelism</strong>&nbsp;is the heartbeat of God and that is why He gave a command to take the word to all nations. Our God has given us everything we need to make evangelism a great success. God is looking for men and women who will reach out without fear or favor, below are the commandments our Lord Jesus gave concerning evangelism.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>The Great Commission</strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Jesus said: Occupy till i come!</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Matt 28:19 –&nbsp;</strong>Go ye therefore, and teach all nations, baptizing them in the name of the Father, and of the Son, and of the Holy Ghost.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Mark 16:15 –&nbsp;</strong>And he said unto them, Go ye into all the world, and preach the gospel to every creature.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Acts 1:8&nbsp; –</strong>&nbsp;“in Jerusalem…and unto the uttermost part of the earth.” Philippians 1:27 – “…striving together for the faith of the gospel” Also see Acts 1:28; Philippians 4:3.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement Is out with a burden to reach out without fear or favor. We are calling on all to lend a hand for the end time is here and there is no time. Pray that the lord will give a heart for evangelism.</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":4} -->
<h4>Our mission:</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>We are out with a mission to rescue the perishing from the bandage of <strong>SIN</strong> and <strong>SATAN </strong>and to equip the saints to be ready for the rapture.</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":4} -->
<h4>Our vision:</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Our vision is to help unite the body of Christ in the truth of God\'s word and to spread Revival, Holiness and Power across the church.</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":4} -->
<h4>Our motto:</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p> CHRIST FOR ALL NATIONS</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":3} -->
<h3><strong>For&nbsp;</strong><strong>Counseling</strong>&nbsp;<strong>&amp;&nbsp;</strong><strong>Prayer Call:</strong>&nbsp;2347067092254, 2348176443398</h3>
<!-- /wp:heading -->

<!-- wp:heading {\"level\":3} -->
<h3></h3>
<!-- /wp:heading -->", "The Ministry", "", "publish", "closed", "closed", "", "the-ministry", "", "", "2019-10-25 01:00:07", "2019-10-25 01:00:07", "<!-- wp:image {\"id\":9} -->
<figure class=\"wp-block-image\"><img src=\"http://www.heavenlykey.org/wp-content/uploads/2019/09/logo-295x300.jpg\" alt=\"\" class=\"wp-image-9\"/></figure>
<!-- /wp:image -->

<!-- wp:heading {\"level\":4} -->
<h4>We are self funding Evangelistic Movement sharing the much needed Bible truths with the world.</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement is preaching the Gospel, teaching the Word, contending for the faith which was once delivered unto the saints, Jude 3.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement&nbsp;is also in the business of networking with Bible believing ministries to bring God’s word to the unreached, distributing of hand bills, tracts and gospel CD, crusade, preaching across churches/fellowships, mission trips, partnering to distribute Bibles to the unreached nations and much more.&nbsp;</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement is out to welcome any one who have been Saved  with a burden to rescue the perishing to partner with us for the good of the gospel, The coming of our Lord and savior Jesus is at hand and also nearer than ever and many are out there unreached and unsaved and here we are sparing our selves and many are perishing, therefore come with us.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>&nbsp;<strong>Evangelism</strong>&nbsp;is the heartbeat of God and that is why He gave a command to take the word to all nations. Our God has given us everything we need to make evangelism a great success. God is looking for men and women who will reach out without fear or favor, below are the commandments our Lord Jesus gave concerning evangelism.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>The Great Commission</strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Jesus said: Occupy till i come!</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Matt 28:19 –&nbsp;</strong>Go ye therefore, and teach all nations, baptizing them in the name of the Father, and of the Son, and of the Holy Ghost.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Mark 16:15 –&nbsp;</strong>And he said unto them, Go ye into all the world, and preach the gospel to every creature.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Acts 1:8&nbsp; –</strong>&nbsp;“in Jerusalem…and unto the uttermost part of the earth.” Philippians 1:27 – “…striving together for the faith of the gospel” Also see Acts 1:28; Philippians 4:3.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement Is out with a burden to reach out without fear or favor. We are calling on all to lend a hand for the end time is here and there is no time. Pray that the lord will give a heart for evangelism.</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":4} -->
<h4>Our mission:</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>We are out with a mission to rescue the perishing from the bandage of <strong>SIN</strong> and <strong>SATAN </strong>and to equip the saints to be ready for the rapture.</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":4} -->
<h4>Our vision:</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Our vision is to help unite the body of Christ in the truth of God\'s word and to spread Revival, Holiness and Power across the church.</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":4} -->
<h4>Our motto:</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p> CHRIST FOR ALL NATIONS</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":3} -->
<h3><strong>For&nbsp;</strong><strong>Counseling</strong>&nbsp;<strong>&amp;&nbsp;</strong><strong>Prayer Call:</strong>&nbsp;2347067092254, 2348176443398</h3>
<!-- /wp:heading -->

<!-- wp:heading {\"level\":3} -->
<h3></h3>
<!-- /wp:heading -->", "0", "http://www.heavenlykey.org/?page_id=54", "0", "page", "", "0");
INSERT INTO wpy4_posts VALUES("55", "1", "2019-09-05 01:56:36", "2019-09-05 01:56:36", "", "The Ministry", "", "inherit", "closed", "closed", "", "54-revision-v1", "", "", "2019-09-05 01:56:36", "2019-09-05 01:56:36", "", "54", "http://www.heavenlykey.org/54-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("61", "1", "2019-09-05 02:12:59", "2019-09-05 02:12:59", " ", "", "", "publish", "closed", "closed", "", "61", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=61", "17", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("62", "1", "2019-09-05 02:12:59", "2019-09-05 02:12:59", " ", "", "", "publish", "closed", "closed", "", "62", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=62", "14", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("63", "1", "2019-09-05 02:12:59", "2019-09-05 02:12:59", " ", "", "", "publish", "closed", "closed", "", "63", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=63", "12", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("64", "1", "2019-09-05 02:12:59", "2019-09-05 02:12:59", "", "Salvation, Deliverance & Freedom from Sin", "", "publish", "closed", "closed", "", "salvation-deliverance-freedom-from-sin", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=64", "9", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("65", "1", "2019-09-05 02:12:59", "2019-09-05 02:12:59", "", "Sanctification, Holiness & Righteousness", "", "publish", "closed", "closed", "", "sanctification-holiness-righteousness", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=65", "10", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("66", "1", "2019-09-05 02:12:59", "2019-09-05 02:12:59", "", "The Baptism of the Holy Ghost & Fire", "", "publish", "closed", "closed", "", "the-baptism-of-the-holy-ghost-fire", "", "", "2020-07-06 23:59:55", "2020-07-06 23:59:55", "", "0", "http://www.heavenlykey.org/?p=66", "11", "nav_menu_item", "", "0");
INSERT INTO wpy4_posts VALUES("67", "1", "2019-09-05 19:48:24", "2019-09-05 19:48:24", "<!-- wp:heading {\"level\":1} -->
<h1>Pastor’s Welcome Message</h1>
<!-- /wp:heading -->

<!-- wp:heading {\"level\":5} -->
<h5><strong>Greetings!</strong></h5>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Welcome to the Heavenly Key Evangelistic Movement website.&nbsp; I am delighted that you have chosen to visit with us.&nbsp; At Heavenly Key Evangelistic Movement, you will find a place where you can be inspired, encouraged, and equipped to meet the practical needs of living in today’s world; a place where you can experience God and become all that God wants you to be.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement is committed to reaching people with the message of God’s love and grace, growing them to maturity in Christ likeness, and sending them forth into the world by the power of the Holy Spirit to join Christ in his work of reconciliation and transformation.&nbsp; Worship, Crusade, bible study, mission projects, charity,&nbsp; sunday school, youth ministries, hospital visitation, prison ministry, children’s ministry, and various service opportunities are available to empower and equip you for victorious living in Christ.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>We would be honored to have you join us for any of the activities above as we move toward the vision of glorifying God and transforming humanity by doing justice, living mercy, and walking humbly with God.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Peace and blessings.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>In His Service,</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Evangelist Emmanuel Ogheneochuko Adiohwo</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Experience the supernatural power of God with Evangelist E.O Adiohwo. With God all things are possible, His power is mighty to save from sin, give you grace to live a holy life, deliver from every oppression, heal all kinds of sicknesses &amp; diseases, break every yokes, breakthrough, miracles,&nbsp; signs &amp; wonders.</strong></p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":3} -->
<h3><strong>For </strong> <strong>Counseling</strong> <strong> &amp; </strong> <strong>Prayer  Call:</strong>  2347067092254, 2348176443398 </h3>
<!-- /wp:heading -->

<!-- wp:heading {\"level\":3} -->
<h3><strong></strong></h3>
<!-- /wp:heading -->

<!-- wp:heading {\"level\":3} -->
<h3><strong>OR</strong></h3>
<!-- /wp:heading -->", "Welcome Message", "", "inherit", "closed", "closed", "", "24-revision-v1", "", "", "2019-09-05 19:48:24", "2019-09-05 19:48:24", "", "24", "http://www.heavenlykey.org/24-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("68", "1", "2019-09-05 19:56:10", "2019-09-05 19:56:10", "<!-- wp:image {\"id\":9} -->
<figure class=\"wp-block-image\"><img src=\"http://www.heavenlykey.org/wp-content/uploads/2019/09/logo-295x300.jpg\" alt=\"\" class=\"wp-image-9\"/></figure>
<!-- /wp:image -->

<!-- wp:heading {\"level\":4} -->
<h4>We are self funding Evangelistic Movement sharing the much needed Bible truths with the world.</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement is preaching the Gospel, teaching the Word, contending for the faith which was once delivered unto the saints, Jude 3.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement&nbsp;is also in the business of networking with Bible believing ministries to bring God’s word to the unreached, distributing of hand bills, tracts and gospel CD, crusade, preaching across churches/fellowships, mission trips, partnering to distribute Bibles to the unreached nations and much more.&nbsp;</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement is out to welcome any one who have been Saved, Sanctified and baptized with Holy Ghost and Fire to partner with us for the good of the gospel, The coming of our Lord and savior Jesus is at hand and also nearer than ever and many are out there unreached and unsaved and here we are sparing our selves and many are perishing, therefore come with us.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>&nbsp;<strong>Evangelism</strong>&nbsp;is the heartbeat of God and that is why He gave a command to take the word to all nations. Our God has given us everything we need to make evangelism a great success. God is looking for men and women who will reach out without fear or favor, below are the commandments our Lord Jesus gave concerning evangelism.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>The Great Commission</strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Jesus said: Occupy till i come!</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Matt 28:19 –&nbsp;</strong>Go ye therefore, and teach all nations, baptizing them in the name of the Father, and of the Son, and of the Holy Ghost.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Mark 16:15 –&nbsp;</strong>And he said unto them, Go ye into all the world, and preach the gospel to every creature.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Acts 1:8&nbsp; –</strong>&nbsp;“in Jerusalem…and unto the uttermost part of the earth.” Philippians 1:27 – “…striving together for the faith of the gospel” Also see Acts 1:28; Philippians 4:3.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Heavenly Key Evangelistic Movement Is out with a burden to reach out without fear or favor. We are calling on all to lend a hand for the end time is here and there is no time. Pray that the lord will give a heart for evangelism.</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":4} -->
<h4>What we believe</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>We believe that the Bible is truly the inspired Word of God and that it is the&nbsp;<strong>SOLE authority</strong>&nbsp;on which we should place our faith and doctrines.&nbsp;God’s Word in the Bible is above any “church” or world leader&nbsp;and should be used for all teaching, doctrines, correction and instruction. We believe that Christ Jesus is revealed as the creator through the Bible and that He is self existent and eternal. We believe that Christ Jesus gave up His high position in the heavenly kingdom and came to this world as fully man, born into sinful flesh to pay the price for our past sins, and it is&nbsp;<strong>only</strong>&nbsp;through true repentance and believing on the sacrifice of Christ that our sins can be forgiven. And because Christ lived a perfect life of obedience to His Father in heaven, we are able to come to the Father through Christ Jesus, His only Begotten Son. We believe that we are only saved by the free gift of grace that God has bestowed upon us, and not by our own works. But, We believe that Jesus rising from the death, We believe that a true believer in Christ will produce obedience to God’s commandments and His Word and a true believer will do good works out of love for Him. We believe that if we walk with Jesus each day, then He will send His Holy Spirit to guide us and help us walk in His footsteps and live a holy consecrated life.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>We believe that&nbsp;ALL&nbsp;the signs of the end times given in the Bible are fulfilled in our generation. And that the final events of Bible prophecy are soon to take place, and the second coming of Christ Jesus will take place in our lifetime.</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":4} -->
<h4>Our mission</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>We are with a mission to rescue the perishing from the bandage of&nbsp;<strong>SIN,</strong>&nbsp;<strong>SATAN</strong>&nbsp;AND&nbsp;<strong>HELL FIRE.&nbsp;</strong>and&nbsp;equipping the&nbsp;saints to be ready for the rapture.</p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":4} -->
<h4>Our vision</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Our vision is to help bring the Kingdom of Heaven to Earth and be a part<br>of the greatest revival in the history of the Church.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Experience the supernatural power of God with Evangelist E.O Adiohwo. With God all things are possible, His power is mighty to save from sin, give you grace to live a holy life, deliver from every oppression, heal all kinds of sicknesses &amp; diseases, break every yokes, breakthrough, miracles,&nbsp; signs &amp; wonders.</strong></p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":3} -->
<h3><strong>For&nbsp;</strong><strong>Counseling</strong>&nbsp;<strong>&amp;&nbsp;</strong><strong>Prayer Call:</strong>&nbsp;2347067092254, 2348176443398</h3>
<!-- /wp:heading -->

<!-- wp:heading {\"level\":3} -->
<h3></h3>
<!-- /wp:heading -->

<!-- wp:heading {\"level\":3} -->
<h3><strong>OR</strong></h3>
<!-- /wp:heading -->", "The Ministry", "", "inherit", "closed", "closed", "", "54-revision-v1", "", "", "2019-09-05 19:56:10", "2019-09-05 19:56:10", "", "54", "http://www.heavenlykey.org/54-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpy4_posts VALUES("69", "1", "2019-09-05 20:03:54", "2019-09-05 20:03:54", "<!-- wp:heading {\"level\":3} -->
<h3>PASTORING THE NATIONS!</h3>
<!-- /wp:heading -->

<!-- wp:image {\"id\":278,\"align\":\"center\"} -->
<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img src=\"http://web.archive.org/web/20190216212624im_/https://i0.wp.com/heavenlykey.org/wp-content/uploads/2018/06/global-flags-world-25519312.jpg?resize=175%2C208\" alt=\"\" class=\"wp-image-278\"/></figure></div>
<!-- /wp:image -->

<!-- wp:paragraph -->
<p>Emmanuel Ogheneochuko Adiohwo is a passionate endtime non-denominational Pastor, Evangelist, Teacher and the president of Heavenly Key Evangelistic Movement&nbsp; in Nigeria, Africa and beyond.&nbsp;He has reached thousands of people with the good news of Jesus Christ through Gospel meetings and media.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>He studied Theology at Deeper Life Bible School (IBTC – International Bible Training College).</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>E.O Adiohwo has been studying intensively the Evangelistic ministry of Evangelist Reinhard Bonnke, Pastor W.F Kumuyi, Apostle Paul Ericonda and Pastor&nbsp;<em>Benny Hinn.</em></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>The studying and the help of his theological training specifically prepared him for this Evangelistic Ministry on reaching the whole world for Christ through the power of the Holy Spirit.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>E.O Adiohwo is opportuned and highly favoured by God almighty to have these anointed men of God as his mentors.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Pastor William F. Kumuyi – Founder and General Superintendent of the Deeper Christian Life Ministry.</strong></p>
<!-- /wp:paragraph -->

<!-- wp:image {\"id\":134} -->
<figure class=\"wp-block-image\"><img src=\"http://web.archive.org/web/20190216212624im_/https://i1.wp.com/heavenlykey.org/wp-content/uploads/2018/06/ericonda.jpg?resize=150%2C150\" alt=\"\" class=\"wp-image-134\"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph -->
<p><strong>Pastor Benny Hinn – Founder, Benny Hinn Ministries and International Evangelist. </strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>E.O Adiohwo preaches the gospel in the power of the Holy Spirit and his ministry is accompanied by miracles, signs and wonders. Across media, churches, crusade and revival meetings people have experienced the presence of God and are empowered.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>E.O Adiohwo is a man with a genuine love for people and a burden to see them saved, sanctified, healed and delivered. He is a true worshiper with a lifestyle of holiness, prayer, fasting and a great love for the word of God.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>​He has a mandate and a passion to train and equip the body of Christ and to help discover, develop and fulfill God given purpose.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Thanks&nbsp;</strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Evangelist E.O Adiohwo</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong>Experience the supernatural power of God with Evangelist E.O Adiohwo. With God all things are possible, His power is mighty to save from sin, give you grace to live a holy life, deliver from every oppression, heal all kinds of sicknesses &amp; diseases, break every yokes, breakthrough, miracles,&nbsp; signs &amp; wonders.</strong></p>
<!-- /wp:paragraph -->

<!-- wp:heading {\"level\":3} -->
<h3><strong>For&nbsp;</strong><strong>Counseling</strong>&nbsp;<strong>&amp;&nbsp;</strong><strong>Prayer Call:</strong>&nbsp;2347067092254, 2348176443398</h3>
<!-- /wp:heading -->

<!-- wp:heading {\"level\":3} -->
<h3></h3>
<!-- /wp:heading -->

<!-- wp:heading {\"level\":3} -->
<h3><strong>OR</strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->", "Meet The Pastor", "", "inherit", "closed", "closed", "", "28-revision-v1", "", "", "2019-09-05 20:03:54", "2019-09-05 20:03:54", "", "28", "http://www.heavenlykey.org/28-revision-v